/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.util.ExceptionUtil;
import com.jetbrains.cidr.CidrRunnerBundle;
import com.jetbrains.cidr.execution.ExecutionResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraceableExecutionResult<T>
extends ExecutionResult<T> {
    private String myTrace;

    @Override
    public void set(@Nullable T result) {
        if (super.asCompletableFuture().isDone()) {
            throw new IllegalStateException(this.throwResultAlreadySet());
        }
        super.set(result);
        this.myTrace = TraceableExecutionResult.currentTrace();
    }

    @Override
    public void setException(Throwable e) {
        if (super.asCompletableFuture().isDone()) {
            throw new IllegalStateException(this.throwResultAlreadySet());
        }
        super.setException(e);
        this.myTrace = TraceableExecutionResult.currentTrace();
    }

    @NotNull
    private String throwResultAlreadySet() {
        if (super.asCompletableFuture().isCompletedExceptionally()) {
            Throwable ex = new Exception();
            try {
                this.get();
            }
            catch (ExecutionException e) {
                ex = e;
            }
            String string = CidrRunnerBundle.message("debug.result.already.set.exceptionally", ExceptionUtil.getMessage((Throwable)ex), ExceptionUtil.getThrowableText((Throwable)ex), Thread.currentThread(), this.myTrace);
            if (string == null) {
                TraceableExecutionResult.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (super.asCompletableFuture().isCancelled()) {
            String string = CidrRunnerBundle.message("debug.result.already.cancelled", Thread.currentThread(), this.myTrace);
            if (string == null) {
                TraceableExecutionResult.$$$reportNull$$$0(1);
            }
            return string;
        }
        return "";
    }

    @NotNull
    private static String currentTrace() {
        String string = CidrRunnerBundle.message("debug.current.trace", Thread.currentThread(), DebugUtil.currentStackTrace());
        if (string == null) {
            TraceableExecutionResult.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/cidr/execution/TraceableExecutionResult";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "throwResultAlreadySet";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "currentTrace";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

