/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BuildTargetData {
    @NotNull
    @NlsSafe
    public final String projectName;
    @NotNull
    @NlsSafe
    public final String targetName;
    @Nullable
    @NlsSafe
    public final String folderName;

    public BuildTargetData(@NotNull @NlsSafe String projectName, @NotNull @NlsSafe String targetName) {
        if (projectName == null) {
            BuildTargetData.$$$reportNull$$$0(0);
        }
        if (targetName == null) {
            BuildTargetData.$$$reportNull$$$0(1);
        }
        this.projectName = projectName;
        this.targetName = targetName;
        this.folderName = null;
    }

    public BuildTargetData(@NotNull @NlsSafe String projectName, @NotNull @NlsSafe String targetName, @Nullable @NlsSafe String folderName) {
        if (projectName == null) {
            BuildTargetData.$$$reportNull$$$0(2);
        }
        if (targetName == null) {
            BuildTargetData.$$$reportNull$$$0(3);
        }
        this.projectName = projectName;
        this.targetName = targetName;
        this.folderName = folderName;
    }

    public BuildTargetData(@NotNull CidrBuildTarget target) {
        if (target == null) {
            BuildTargetData.$$$reportNull$$$0(4);
        }
        this(target.getProjectName(), target.getName(), target.getFolder());
    }

    public String toString() {
        return this.getDisplayString();
    }

    @NotNull
    @NlsSafe
    public String getDisplayString() {
        String string = BuildTargetAndConfigurationData.formatDisplayString(this.projectName, this.targetName);
        if (string == null) {
            BuildTargetData.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildTargetData data = (BuildTargetData)o;
        return this.projectName.equals(data.projectName) && this.targetName.equals(data.targetName) && Objects.equals(this.folderName, data.folderName);
    }

    public int hashCode() {
        int result = this.projectName.hashCode();
        result = 31 * result + this.targetName.hashCode();
        result = 31 * result + Objects.hashCode(this.folderName);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectName";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/BuildTargetData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/BuildTargetData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

