/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/cidr/XcodeUtil;", "", "<init>", "()V", "getXcodeSelect", "Ljava/io/File;", "intellij.cidr.core"})
@SourceDebugExtension(value={"SMAP\nXcodeUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XcodeUtil.kt\ncom/jetbrains/cidr/XcodeUtil\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,47:1\n23#2:48\n*S KotlinDebug\n*F\n+ 1 XcodeUtil.kt\ncom/jetbrains/cidr/XcodeUtil\n*L\n42#1:48\n*E\n"})
public final class XcodeUtil {
    @NotNull
    public static final XcodeUtil INSTANCE = new XcodeUtil();

    private XcodeUtil() {
    }

    @JvmStatic
    @Nullable
    public static final File getXcodeSelect() {
        String[] stringArray = new String[]{"-print-path"};
        GeneralCommandLine generalCommandLine = new GeneralCommandLine().withExePath("xcode-select").withParameters(stringArray).withCharset(CharsetToolkit.getDefaultSystemCharset());
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withCharset(...)");
        GeneralCommandLine cl = generalCommandLine;
        try {
            CapturingProcessHandler handler = new CapturingProcessHandler(cl);
            ProcessOutput result = handler.runProcess(1000);
            if (result.isTimeout()) {
                throw new ExecutionException("xcode-select timed out");
            }
            String string = result.getStderr();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStderr(...)");
            String err = ((Object)StringsKt.trim((CharSequence)string)).toString();
            if (!(((CharSequence)err).length() == 0)) {
                throw new ExecutionException(err);
            }
            String string2 = result.getStdout();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStdout(...)");
            String path = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            if (((CharSequence)path).length() == 0 || StringsKt.isBlank((CharSequence)path)) {
                throw new ExecutionException("xcode-select returned an empty path");
            }
            return new File(path);
        }
        catch (ExecutionException e) {
            XcodeUtil $this$thisLogger$iv = INSTANCE;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(XcodeUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("Cannot determine default Xcode version: " + e.getMessage());
            return null;
        }
    }
}

