/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Debug.Renderer(text="toString()", childrenArray="toArray()", hasChildren="!guaranteedToBeEmpty()")
public abstract class PathTreeBase<Self extends PathTreeBase<Self>> {
    @Nullable
    protected Map<String, Self> myChildren;
    private final boolean myResolveSymlinksIfNecessary;

    public PathTreeBase() {
        this(true);
    }

    public PathTreeBase(boolean resolveSymlinksIfNecessary) {
        this.myResolveSymlinksIfNecessary = resolveSymlinksIfNecessary;
    }

    @NotNull
    protected <T> Map<String, T> createChildrenMap(int capacity) {
        Map map = capacity >= 0 ? CollectionFactory.createFilePathMap((int)capacity) : CollectionFactory.createFilePathMap();
        if (map == null) {
            PathTreeBase.$$$reportNull$$$0(0);
        }
        return map;
    }

    @NotNull
    public Collection<Self> getChildren() {
        Collection<Object> collection = this.myChildren == null ? Collections.emptySet() : this.myChildren.values();
        if (collection == null) {
            PathTreeBase.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    protected Self getNotNullSubTree(@NotNull String path) {
        if (path == null) {
            PathTreeBase.$$$reportNull$$$0(2);
        }
        Self Self = this.getSubTree(path, SearchStrategy.BUILD_IF_NOT_FOUND);
        if (Self == null) {
            PathTreeBase.$$$reportNull$$$0(3);
        }
        return Self;
    }

    @Deprecated
    @Nullable
    public Self getSubTree(@NotNull String path, boolean createSubtrees) {
        if (path == null) {
            PathTreeBase.$$$reportNull$$$0(4);
        }
        return this.getSubTree(path, createSubtrees ? SearchStrategy.BUILD_IF_NOT_FOUND : SearchStrategy.NULL_IF_NOT_FOUND);
    }

    @Nullable
    public Self getSubTree(@NotNull String path, @NotNull SearchStrategy strategy) {
        if (path == null) {
            PathTreeBase.$$$reportNull$$$0(5);
        }
        if (strategy == null) {
            PathTreeBase.$$$reportNull$$$0(6);
        }
        return this.getSubTree(PathTreeBase.splitPathInComponents(this.toCanonicalPath(path)), strategy);
    }

    @NotNull
    private static List<String> splitPathInComponents(@NotNull String path) {
        if (path == null) {
            PathTreeBase.$$$reportNull$$$0(7);
        }
        List list = StringUtil.split((String)path, (String)"/", (boolean)true, (boolean)false);
        if (list == null) {
            PathTreeBase.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    private String toCanonicalPath(@NotNull String path) {
        int index;
        if (path == null) {
            PathTreeBase.$$$reportNull$$$0(9);
        }
        if ((index = path.indexOf("://")) < 0) {
            String string = FileUtil.toCanonicalPath((String)path, (boolean)this.myResolveSymlinksIfNecessary);
            if (string == null) {
                PathTreeBase.$$$reportNull$$$0(10);
            }
            return string;
        }
        int split = index + "://".length();
        String string = path.substring(0, split) + FileUtil.toCanonicalPath((String)path.substring(split), (boolean)this.myResolveSymlinksIfNecessary);
        if (string == null) {
            PathTreeBase.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    private Self getSubTree(@NotNull Iterable<String> pathComps, SearchStrategy strategy) {
        if (pathComps == null) {
            PathTreeBase.$$$reportNull$$$0(12);
        }
        Self result = this.self();
        Iterator<String> iterator = pathComps.iterator();
        while (iterator.hasNext()) {
            Self t = result;
            String key = iterator.next();
            Self st = ((PathTreeBase)t).getChild(key);
            if (st != null) {
                result = st;
                continue;
            }
            switch (strategy.ordinal()) {
                case 0: {
                    return null;
                }
                case 2: {
                    return result;
                }
                case 1: {
                    result = ((PathTreeBase)t).createChild(key);
                }
            }
        }
        return result;
    }

    @NotNull
    protected Self self() {
        PathTreeBase pathTreeBase = this;
        if (pathTreeBase == null) {
            PathTreeBase.$$$reportNull$$$0(13);
        }
        return (Self)pathTreeBase;
    }

    @NotNull
    protected abstract Self createNewTree(@Nullable Self var1);

    @Nullable
    private Self getChild(@NotNull String key) {
        if (key == null) {
            PathTreeBase.$$$reportNull$$$0(14);
        }
        if (this.myChildren == null) {
            return null;
        }
        return (Self)((PathTreeBase)this.myChildren.get(key));
    }

    private Self createChild(@NotNull String name) {
        if (name == null) {
            PathTreeBase.$$$reportNull$$$0(15);
        }
        if (this.myChildren == null) {
            this.myChildren = this.createChildrenMap(-1);
        }
        Self tree = this.createNewTree(this.self());
        this.myChildren.put(name, tree);
        return tree;
    }

    Self clone(@Nullable Self parent) {
        Self clone = this.createNewTree(parent);
        Map<String, Self> children = this.myChildren;
        if (children == null) {
            return clone;
        }
        ((PathTreeBase)clone).myChildren = this.createChildrenMap(children.size());
        for (Map.Entry<String, Self> entry : children.entrySet()) {
            ((PathTreeBase)clone).myChildren.put(entry.getKey(), ((PathTreeBase)entry.getValue()).clone(clone));
        }
        return clone;
    }

    @Nullable
    public static <Self extends PathTreeBase<Self>> Self merge(@NotNull @NotNull Collection<@NotNull Self> trees, boolean allowReuse) {
        if (trees == null) {
            PathTreeBase.$$$reportNull$$$0(16);
        }
        return trees.isEmpty() ? null : PathTreeBase.merge(null, trees, allowReuse);
    }

    @NotNull
    private static <Self extends PathTreeBase<Self>> Self merge(@Nullable Self parent, @NotNull @NotNull Collection<@NotNull Self> trees, boolean allowReuse) {
        if (trees == null) {
            PathTreeBase.$$$reportNull$$$0(17);
        }
        Iterator<@NotNull Self> it = trees.iterator();
        assert (it.hasNext());
        PathTreeBase tree = (PathTreeBase)it.next();
        if (!it.hasNext()) {
            PathTreeBase<Self> pathTreeBase = allowReuse ? tree : tree.clone(parent);
            if (pathTreeBase == null) {
                PathTreeBase.$$$reportNull$$$0(18);
            }
            return (Self)pathTreeBase;
        }
        Self mergedTree = tree.createNewTree(parent);
        MultiMap childrenPerKey = new MultiMap(mergedTree.createChildrenMap(trees.size()));
        while (true) {
            tree.mergeInto(mergedTree, childrenPerKey);
            if (!it.hasNext()) break;
            tree = (PathTreeBase)it.next();
        }
        if (childrenPerKey.isEmpty()) {
            Self Self = mergedTree;
            if (Self == null) {
                PathTreeBase.$$$reportNull$$$0(19);
            }
            return Self;
        }
        mergedTree.myChildren = mergedTree.createChildrenMap(childrenPerKey.size());
        for (Map.Entry entry : childrenPerKey.entrySet()) {
            Self mergedChild = PathTreeBase.merge(mergedTree, (Collection)entry.getValue(), allowReuse);
            mergedTree.myChildren.put((String)entry.getKey(), mergedChild);
        }
        Self Self = mergedTree;
        if (Self == null) {
            PathTreeBase.$$$reportNull$$$0(20);
        }
        return Self;
    }

    protected void mergeInto(@NotNull Self mergedTree, @NotNull MultiMap<String, Self> childrenPerKey) {
        Map<String, Self> children;
        if (mergedTree == null) {
            PathTreeBase.$$$reportNull$$$0(21);
        }
        if (childrenPerKey == null) {
            PathTreeBase.$$$reportNull$$$0(22);
        }
        if ((children = this.myChildren) != null) {
            for (Map.Entry<String, Self> entry : children.entrySet()) {
                childrenPerKey.putValue((Object)entry.getKey(), (Object)((PathTreeBase)entry.getValue()));
            }
        }
    }

    public void accept(@NotNull Visitor<Self> visitor) {
        if (visitor == null) {
            PathTreeBase.$$$reportNull$$$0(23);
        }
        this.accept(null, visitor);
    }

    private void accept(@Nullable String path, @NotNull Visitor<Self> visitor) {
        Map<String, Self> children;
        if (visitor == null) {
            PathTreeBase.$$$reportNull$$$0(24);
        }
        visitor.enter();
        if (visitor.visit((String)path, this.self()) && !ContainerUtil.isEmpty(children = this.myChildren)) {
            if (path != null) {
                path = (String)path + "/";
            }
            for (Map.Entry<String, Self> childEntry : children.entrySet()) {
                ProgressManager.checkCanceled();
                PathTreeBase childTree = (PathTreeBase)childEntry.getValue();
                childTree.accept((String)(path != null ? (String)path + childEntry.getKey() : childEntry.getKey()), visitor);
            }
        }
        visitor.exit();
    }

    public String toString() {
        if (this.guaranteedToBeEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(1024).append('[');
        this.accept(new ToStringVisitor(sb));
        return sb.append(']').toString();
    }

    protected abstract boolean isLeaf();

    protected void nodeToString(@NotNull StringBuilder sb, @Nullable String path) {
        if (sb == null) {
            PathTreeBase.$$$reportNull$$$0(25);
        }
        sb.append(PathTreeBase.pathToDebugString(path));
    }

    @NotNull
    protected static String pathToDebugString(@Nullable String path) {
        return path != null ? path : "\u2205";
    }

    final Object[] toArray() {
        if (this.guaranteedToBeEmpty()) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        final ArrayList entries = new ArrayList();
        this.accept(new Visitor<Self>(this){

            @Override
            public boolean visit(@Nullable String path, @NotNull Self subTree) {
                if (subTree == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (((PathTreeBase)subTree).isLeaf()) {
                    entries.add(((PathTreeBase)subTree).nodeDebugRenderer(path));
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subTree", "com/jetbrains/cidr/PathTreeBase$1", "visit"));
            }
        });
        return entries.toArray();
    }

    protected boolean guaranteedToBeEmpty() {
        return ContainerUtil.isEmpty(this.myChildren) && !this.isLeaf();
    }

    @NotNull
    protected Object nodeDebugRenderer(@Nullable String path) {
        return PathTreeBase.pathToDebugString(path);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4, 5, 6, 7, 9, 12, 14, 15, 16, 17, 21, 22, 23, 24, 25 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/PathTreeBase";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathComps";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trees";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergedTree";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childrenPerKey";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildrenMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/PathTreeBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullSubTree";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "splitPathInComponents";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "toCanonicalPath";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "self";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "merge";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNotNullSubTree";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSubTree";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "splitPathInComponents";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "toCanonicalPath";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getChild";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createChild";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "mergeInto";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "nodeToString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4, 5, 6, 7, 9, 12, 14, 15, 16, 17, 21, 22, 23, 24, 25 -> new IllegalArgumentException(string);
        };
    }

    public static enum SearchStrategy {
        NULL_IF_NOT_FOUND,
        BUILD_IF_NOT_FOUND,
        DEEPEST_EXISTING_PREFIX;

    }

    public static interface Visitor<T extends PathTreeBase<?>> {
        default public void enter() {
        }

        public boolean visit(@Nullable String var1, @NotNull T var2);

        default public void exit() {
        }
    }

    protected static final class ToStringVisitor<Self extends PathTreeBase<?>>
    implements Visitor<Self> {
        @NotNull
        private final StringBuilder sb;
        private boolean isFirstElement;

        public ToStringVisitor(@NotNull StringBuilder sb) {
            if (sb == null) {
                ToStringVisitor.$$$reportNull$$$0(0);
            }
            this.isFirstElement = true;
            this.sb = sb;
        }

        @Override
        public boolean visit(@Nullable String path, @NotNull Self subTree) {
            if (subTree == null) {
                ToStringVisitor.$$$reportNull$$$0(1);
            }
            if (!((PathTreeBase)subTree).isLeaf()) {
                return true;
            }
            if (!this.isFirstElement) {
                this.sb.append(',').append(' ');
            }
            ((PathTreeBase)subTree).nodeToString(this.sb, path);
            this.isFirstElement = false;
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "subTree";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/PathTreeBase$ToStringVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visit";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

