/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.idea.AppMode;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.Ref;
import com.intellij.util.PlatformUtils;
import com.intellij.util.system.CpuArch;
import com.intellij.util.system.OS;
import com.jetbrains.cidr.CidrPluginPathMapper;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\f2\b\b\u0002\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u0018H\u0007JB\u0010\u001a\u001a\u00020\n2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\f2\b\u0010\u001d\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\u001e\u001a\u00020\u00182\b\b\u0002\u0010\u001f\u001a\u00020\u0018H\u0007J\"\u0010 \u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\f2\b\u0010!\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\nH\u0002J\u0010\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020\nH\u0002J\b\u0010'\u001a\u00020\u0018H\u0002J\u0016\u0010(\u001a\u0004\u0018\u00010\n2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\bH\u0002J\u0016\u0010)\u001a\u0004\u0018\u00010\f2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\bH\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010\n2\u0006\u0010*\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0006\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000b\u001a\u0016\u0012\u0004\u0012\u00020\f\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u000f\u001a\u00020\n8FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u0014\u0012\u0004\b\u0010\u0010\u0003\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006+"}, d2={"Lcom/jetbrains/cidr/CidrPathManager;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "ourPluginPathsCache", "", "Ljava/lang/Class;", "Lcom/intellij/openapi/util/Ref;", "Ljava/nio/file/Path;", "ourPluginPathsByIdCache", "", "ourFileWithExecutableUpdated", "", "cidrSourcesRoot", "getCidrSourcesRoot$annotations", "getCidrSourcesRoot", "()Ljava/nio/file/Path;", "cidrSourcesRoot$delegate", "Lkotlin/Lazy;", "getPlatformRelativePath", "relativePath", "archSpecific", "", "isCygwin", "getBinPath", "clazz", "inSourcesPath", "relativePathToAdditionalBinaries", "ensureIsExecutable", "forceLookForBinariesInsidePlugin", "getCidrFallbackPathIfResourceNotFound", "basePath", "ensureFilesInDirAreExecutable", "", "dir", "ensureFileIsExecutable", "file", "lookForBinariesInsidePlugin", "getPluginPath", "getMappedPluginId", "pluginId", "intellij.cidr.util.execution"})
@SourceDebugExtension(value={"SMAP\nCidrPathManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrPathManager.kt\ncom/jetbrains/cidr/CidrPathManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,203:1\n23#2:204\n*S KotlinDebug\n*F\n+ 1 CidrPathManager.kt\ncom/jetbrains/cidr/CidrPathManager\n*L\n22#1:204\n*E\n"})
public final class CidrPathManager {
    @NotNull
    public static final CidrPathManager INSTANCE;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Map<Class<?>, Ref<Path>> ourPluginPathsCache;
    @NotNull
    private static final Map<String, Ref<Path>> ourPluginPathsByIdCache;
    @NotNull
    private static final Set<Path> ourFileWithExecutableUpdated;
    @NotNull
    private static final Lazy cidrSourcesRoot$delegate;

    private CidrPathManager() {
    }

    @NotNull
    public static final Path getCidrSourcesRoot() {
        Lazy lazy = cidrSourcesRoot$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Path)object;
    }

    @JvmStatic
    public static /* synthetic */ void getCidrSourcesRoot$annotations() {
    }

    @JvmStatic
    @NotNull
    public static final String getPlatformRelativePath(@NotNull String relativePath, boolean archSpecific, boolean isCygwin) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        String platformPath = isCygwin ? "cygwin" : (OS.CURRENT == OS.Windows ? "win" : (OS.CURRENT == OS.macOS ? "mac" : "linux"));
        String archPath = archSpecific && CpuArch.isArm64() ? "aarch64/" : (archSpecific ? "x64/" : "");
        return platformPath + "/" + archPath + relativePath;
    }

    public static /* synthetic */ String getPlatformRelativePath$default(String string, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return CidrPathManager.getPlatformRelativePath(string, bl, bl2);
    }

    @JvmStatic
    @NotNull
    public static final Path getBinPath(@NotNull Class<?> clazz, @NotNull String inSourcesPath, @NotNull String relativePath, @Nullable String relativePathToAdditionalBinaries, boolean ensureIsExecutable, boolean forceLookForBinariesInsidePlugin) {
        boolean lookForBinariesInsidePlugin;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)inSourcesPath, (String)"inSourcesPath");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Path pluginPath = null;
        boolean bl = lookForBinariesInsidePlugin = forceLookForBinariesInsidePlugin || INSTANCE.lookForBinariesInsidePlugin();
        if (lookForBinariesInsidePlugin) {
            pluginPath = INSTANCE.getPluginPath(clazz);
        }
        Path basePath = null;
        if (pluginPath != null) {
            basePath = pluginPath.resolve("bin");
        } else if (PluginManagerCore.isRunningFromSources() || AppMode.isRunningFromDevBuild()) {
            basePath = CidrPathManager.getCidrSourcesRoot().resolve(inSourcesPath);
        }
        if ((basePath == null || !Files.isDirectory(basePath, new LinkOption[0])) && lookForBinariesInsidePlugin) {
            String pluginId = INSTANCE.getMappedPluginId(clazz);
            if (pluginId != null && (pluginPath = INSTANCE.getPluginPath(pluginId)) != null) {
                basePath = pluginPath.resolve("bin");
            }
            basePath = INSTANCE.getCidrFallbackPathIfResourceNotFound(inSourcesPath, relativePath, basePath);
        }
        if (basePath != null) {
            Path result = basePath.resolve(relativePath);
            if (ensureIsExecutable) {
                Intrinsics.checkNotNull((Object)result);
                INSTANCE.ensureFileIsExecutable(result);
                if (relativePathToAdditionalBinaries != null) {
                    Path path = basePath.resolve(relativePathToAdditionalBinaries);
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                    INSTANCE.ensureFilesInDirAreExecutable(path);
                }
            }
            Intrinsics.checkNotNull((Object)result);
            return result;
        }
        String[] stringArray = new String[]{relativePath};
        Path path = Paths.get(PathManager.getBinPath(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    public static /* synthetic */ Path getBinPath$default(Class clazz, String string, String string2, String string3, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        return CidrPathManager.getBinPath(clazz, string, string2, string3, bl, bl2);
    }

    private final Path getCidrFallbackPathIfResourceNotFound(String inSourcesPath, String relativePath, Path basePath) {
        Path basePath2 = basePath;
        if (basePath2 != null && Files.exists(basePath2.resolve(relativePath), new LinkOption[0])) {
            return basePath2;
        }
        basePath2 = Paths.get(PathManager.getHomePath((boolean)false), new String[0]).resolve("CIDR").resolve(inSourcesPath);
        if (Files.exists(basePath2.resolve(relativePath), new LinkOption[0])) {
            Path path = basePath2;
            Intrinsics.checkNotNull((Object)path);
            return path;
        }
        Path path = CidrPathManager.getCidrSourcesRoot().resolve(inSourcesPath);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void ensureFilesInDirAreExecutable(Path dir) {
        try {
            Closeable closeable = Files.newDirectoryStream(dir);
            Throwable throwable = null;
            try {
                DirectoryStream stream = (DirectoryStream)closeable;
                boolean bl = false;
                Iterator iterator = stream.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator iterator2 = iterator;
                while (iterator2.hasNext()) {
                    Path child = (Path)iterator2.next();
                    Intrinsics.checkNotNull((Object)child);
                    INSTANCE.ensureFileIsExecutable(child);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private final Path ensureFileIsExecutable(Path file) {
        if (ourFileWithExecutableUpdated.contains(file)) {
            return file;
        }
        if (Files.isRegularFile(file, new LinkOption[0]) && !Files.isExecutable(file)) {
            LOG.info("Setting executable flag for " + file);
            PosixFilePermission[] posixFilePermissionArray = new PosixFilePermission[]{PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OTHERS_EXECUTE, PosixFilePermission.GROUP_EXECUTE};
            Set perms = SetsKt.mutableSetOf((Object[])posixFilePermissionArray);
            try {
                Set<PosixFilePermission> set = Files.getPosixFilePermissions(file, new LinkOption[0]);
                Intrinsics.checkNotNullExpressionValue(set, (String)"getPosixFilePermissions(...)");
                perms.addAll((Collection)set);
                Files.setPosixFilePermissions(file, perms);
            }
            catch (IOException e) {
                LOG.warn("Cannot set executable flag for " + file, (Throwable)e);
            }
        }
        ourFileWithExecutableUpdated.add(file);
        return file;
    }

    private final boolean lookForBinariesInsidePlugin() {
        return !PlatformUtils.isCidr() && !PlatformUtils.isRustRover();
    }

    private final Path getPluginPath(Class<?> clazz) {
        Ref result = ourPluginPathsCache.get(clazz);
        if (result == null) {
            result = new Ref();
            ClassLoader loader = clazz.getClassLoader();
            if (loader instanceof PluginAwareClassLoader) {
                PluginId pluginId = ((PluginAwareClassLoader)loader).getPluginId();
                Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getPluginId(...)");
                PluginId id = pluginId;
                IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin((PluginId)id);
                if (plugin != null) {
                    result.set((Object)plugin.getPluginPath());
                }
            }
            ourPluginPathsCache.putIfAbsent(clazz, (Ref<Path>)result);
        }
        return (Path)result.get();
    }

    private final String getMappedPluginId(Class<?> clazz) {
        for (CidrPluginPathMapper mapper : CidrPluginPathMapper.EP_NAME.getExtensionList()) {
            String pluginId = mapper.getPluginId(clazz);
            if (pluginId == null) continue;
            return pluginId;
        }
        return null;
    }

    private final Path getPluginPath(String pluginId) {
        Ref result = ourPluginPathsByIdCache.get(pluginId);
        if (result == null) {
            result = new Ref();
            IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin((PluginId)PluginId.Companion.getId(pluginId));
            if (plugin != null) {
                result.set((Object)plugin.getPluginPath());
            }
            ourPluginPathsByIdCache.putIfAbsent(pluginId, (Ref<Path>)result);
        }
        return (Path)result.get();
    }

    private static final Path cidrSourcesRoot_delegate$lambda$0() {
        String homePath = null;
        if (AppMode.isRunningFromDevBuild()) {
            homePath = AppMode.getDevIdeaProjectDir();
        }
        if (homePath == null) {
            homePath = PathManager.getHomePath();
        }
        String[] stringArray = new String[]{System.getProperty("cidr.root.path", "CIDR")};
        return Paths.get(homePath, stringArray).normalize();
    }

    static {
        CidrPathManager $this$thisLogger$iv = INSTANCE = new CidrPathManager();
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(CidrPathManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        ourPluginPathsCache = new ConcurrentHashMap();
        ourPluginPathsByIdCache = new ConcurrentHashMap();
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"newKeySet(...)");
        ourFileWithExecutableUpdated = keySetView;
        cidrSourcesRoot$delegate = LazyKt.lazy(CidrPathManager::cidrSourcesRoot_delegate$lambda$0);
    }
}

