/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.common.toolbar;

import com.intellij.cwm.plugin.common.BaseCwmNotifications;
import com.intellij.cwm.plugin.common.CodeWithMeCommonBundle;
import com.intellij.cwm.plugin.common.CommonNotifications;
import com.intellij.cwm.plugin.common.toolbar.ClosedToolbarNotification;
import com.intellij.cwm.plugin.common.users.UserManager;
import com.intellij.ide.ui.ToolbarSettings;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.notification.Notification;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ExperimentalUI;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0015\u001a\u00020\tH\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001c"}, d2={"Lcom/intellij/cwm/plugin/common/toolbar/ClosedToolbarNotification;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "prevShowMainToolbar", "", "prevShowNavigationBar", "prevShowNewToolbar", "prevShowNewUIMainToolbar", "listener", "Lcom/intellij/ide/ui/UISettingsListener;", "connection", "Lcom/intellij/util/messages/MessageBusConnection;", "getConnection", "()Lcom/intellij/util/messages/MessageBusConnection;", "setConnection", "(Lcom/intellij/util/messages/MessageBusConnection;)V", "cwmControlsCanBeInNavbar", "rememberToolbarValues", "", "showNotification", "type", "Lcom/intellij/cwm/plugin/common/toolbar/ClosedToolbarNotification$ToolbarType;", "ToolbarType", "intellij.cwm.plugin.common"})
public final class ClosedToolbarNotification
extends LifetimedService {
    @NotNull
    private final Project project;
    private boolean prevShowMainToolbar;
    private boolean prevShowNavigationBar;
    private boolean prevShowNewToolbar;
    private boolean prevShowNewUIMainToolbar;
    @NotNull
    private final UISettingsListener listener;
    @Nullable
    private MessageBusConnection connection;

    public ClosedToolbarNotification(@NotNull Project project, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.project = project;
        this.prevShowMainToolbar = true;
        this.prevShowNavigationBar = true;
        this.prevShowNewToolbar = true;
        this.prevShowNewUIMainToolbar = true;
        this.listener = arg_0 -> ClosedToolbarNotification.listener$lambda$0(this, arg_0);
        BuildersKt.launch$default((CoroutineScope)cs, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ClosedToolbarNotification this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.this$0.rememberToolbarValues();
                        UserManager.Companion.getInstance(this.this$0.project).getSessionEnabled().advise(this.this$0.getServiceLifetime(), arg_0 -> 1.invokeSuspend$lambda$0(this.this$0, arg_0));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            /*
             * WARNING - void declaration
             */
            private static final Unit invokeSuspend$lambda$0(ClosedToolbarNotification this$0, boolean enabled) {
                if (enabled) {
                    void it;
                    MessageBusConnection messageBusConnection;
                    if (!(this$0.cwmControlsCanBeInNavbar() && UISettings.Companion.getInstance().getShowNavigationBar() || UISettings.Companion.getInstance().getShowMainToolbar() || ToolbarSettings.Companion.getInstance().isVisible() || UISettings.Companion.getInstance().getShowNewMainToolbar())) {
                        if (this$0.cwmControlsCanBeInNavbar()) {
                            this$0.showNotification(ToolbarType.NAVIGATION_BAR);
                        } else {
                            this$0.showNotification(ToolbarType.NEW_UI_MAIN_TOOLBAR);
                        }
                    }
                    MessageBusConnection messageBusConnection2 = messageBusConnection = this$0.project.getMessageBus().connect();
                    ClosedToolbarNotification closedToolbarNotification = this$0;
                    boolean bl = false;
                    Topic topic = UISettingsListener.TOPIC;
                    Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
                    it.subscribe(topic, (Object)this$0.listener);
                    closedToolbarNotification.setConnection(messageBusConnection);
                } else {
                    MessageBusConnection messageBusConnection = this$0.getConnection();
                    if (messageBusConnection != null) {
                        messageBusConnection.disconnect();
                    }
                    this$0.setConnection(null);
                }
                return Unit.INSTANCE;
            }
        }), (int)2, null);
    }

    @Nullable
    public final MessageBusConnection getConnection() {
        return this.connection;
    }

    public final void setConnection(@Nullable MessageBusConnection messageBusConnection) {
        this.connection = messageBusConnection;
    }

    private final boolean cwmControlsCanBeInNavbar() {
        return !ExperimentalUI.Companion.isNewUI();
    }

    private final void rememberToolbarValues() {
        this.prevShowMainToolbar = UISettings.Companion.getInstance().getShowMainToolbar();
        this.prevShowNavigationBar = this.cwmControlsCanBeInNavbar() && UISettings.Companion.getInstance().getShowNavigationBar();
        this.prevShowNewToolbar = ToolbarSettings.Companion.getInstance().isVisible();
        this.prevShowNewUIMainToolbar = UISettings.Companion.getInstance().getShowNewMainToolbar();
    }

    private final void showNotification(ToolbarType type) {
        Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
        Intrinsics.checkNotNullExpressionValue((Object)keymap, (String)"getActiveKeymap(...)");
        Keymap keymap2 = keymap;
        Shortcut[] it = keymap2.getShortcuts("CWMHostShowPopupAction");
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        Shortcut[] shortcutArray = it.length == 0 ? keymap2.getShortcuts("CWMThinClientShowPopupAction") : it;
        Intrinsics.checkNotNullExpressionValue((Object)shortcutArray, (String)"let(...)");
        Shortcut shortcut = (Shortcut)ArraysKt.first((Object[])shortcutArray);
        BaseCwmNotifications baseCwmNotifications = CommonNotifications.INSTANCE;
        String string = CommonNotifications.DisplayId.CONTROLS_HIDDEN.getValue();
        String string2 = CodeWithMeCommonBundle.INSTANCE.message("closed.toolbar.notification.name", new Object[0]);
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)KeymapUtil.getShortcutText((Shortcut)shortcut), (String)"getShortcutText(...)");
        Notification notification2 = BaseCwmNotifications.createNotification$default(baseCwmNotifications, string, string2, CodeWithMeCommonBundle.INSTANCE.message("closed.toolbar.notification.description", objectArray), null, null, 24, null);
        String text = switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1, 2, 3 -> CodeWithMeCommonBundle.INSTANCE.message("closed.toolbar.notification.show.toolbar.action", new Object[0]);
            case 4 -> CodeWithMeCommonBundle.INSTANCE.message("closed.toolbar.notification.show.navigation.bar.action", new Object[0]);
            default -> throw new NoWhenBranchMatchedException();
        };
        notification2.addAction(new AnAction(text, type, notification2){
            final /* synthetic */ ToolbarType $type;
            final /* synthetic */ Notification $notification;
            {
                this.$type = $type;
                this.$notification = $notification;
                super($text);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                switch (showNotification.WhenMappings.$EnumSwitchMapping$0[this.$type.ordinal()]) {
                    case 1: {
                        UISettings.Companion.getInstance().setShowMainToolbar(true);
                        break;
                    }
                    case 2: {
                        UISettings.Companion.getInstance().setShowNavigationBar(true);
                        break;
                    }
                    case 3: {
                        ToolbarSettings.Companion.getInstance().setVisible(true);
                        UISettings.Companion.getInstance().fireUISettingsChanged();
                        break;
                    }
                    case 4: {
                        UISettings.Companion.getInstance().setShowNewMainToolbar(true);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                UISettings.Companion.getInstance().fireUISettingsChanged();
                this.$notification.expire();
            }
        });
        notification2.notify(this.project);
    }

    private static final void listener$lambda$0(ClosedToolbarNotification this$0, UISettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!(it.getShowMainToolbar() || this$0.cwmControlsCanBeInNavbar() && it.getShowNavigationBar() || ToolbarSettings.Companion.getInstance().isVisible() || it.getShowNewMainToolbar())) {
            if (this$0.prevShowNewUIMainToolbar) {
                this$0.showNotification(ToolbarType.NEW_UI_MAIN_TOOLBAR);
            } else if (this$0.prevShowNavigationBar) {
                this$0.showNotification(ToolbarType.NAVIGATION_BAR);
            } else if (this$0.prevShowMainToolbar) {
                this$0.showNotification(ToolbarType.MAIN_TOOLBAR);
            } else if (this$0.prevShowNewToolbar) {
                this$0.showNotification(ToolbarType.NEW_MAIN_TOOLBAR);
            }
        }
        this$0.rememberToolbarValues();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/cwm/plugin/common/toolbar/ClosedToolbarNotification$ToolbarType;", "", "<init>", "(Ljava/lang/String;I)V", "MAIN_TOOLBAR", "NAVIGATION_BAR", "NEW_MAIN_TOOLBAR", "NEW_UI_MAIN_TOOLBAR", "intellij.cwm.plugin.common"})
    public static final class ToolbarType
    extends Enum<ToolbarType> {
        public static final /* enum */ ToolbarType MAIN_TOOLBAR = new ToolbarType();
        public static final /* enum */ ToolbarType NAVIGATION_BAR = new ToolbarType();
        public static final /* enum */ ToolbarType NEW_MAIN_TOOLBAR = new ToolbarType();
        public static final /* enum */ ToolbarType NEW_UI_MAIN_TOOLBAR = new ToolbarType();
        private static final /* synthetic */ ToolbarType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ToolbarType[] values() {
            return (ToolbarType[])$VALUES.clone();
        }

        public static ToolbarType valueOf(String value2) {
            return Enum.valueOf(ToolbarType.class, value2);
        }

        @NotNull
        public static EnumEntries<ToolbarType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = toolbarTypeArray = new ToolbarType[]{ToolbarType.MAIN_TOOLBAR, ToolbarType.NAVIGATION_BAR, ToolbarType.NEW_MAIN_TOOLBAR, ToolbarType.NEW_UI_MAIN_TOOLBAR};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ToolbarType.values().length];
            try {
                nArray[ToolbarType.MAIN_TOOLBAR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolbarType.NEW_MAIN_TOOLBAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolbarType.NEW_UI_MAIN_TOOLBAR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolbarType.NAVIGATION_BAR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

