/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;

class ClangdIndexerExecutionPlan {
    @NotNull
    private static final Logger LOG = Logger.getInstance(ClangdIndexerExecutionPlan.class);
    private static final boolean ERASE_AFTER_FIRST_ACCESS = true;
    @NotNull
    private final Map<VirtualFile, List<VirtualFile>> myEntry2Headers = new ConcurrentHashMap<VirtualFile, List<VirtualFile>>();
    @NotNull
    private final Map<VirtualFile, VirtualFile> myHeader2Entry = new ConcurrentHashMap<VirtualFile, VirtualFile>();

    ClangdIndexerExecutionPlan() {
    }

    @NotNull
    List<VirtualFile> getRelatedFiles(@NotNull VirtualFile file) {
        List<VirtualFile> associated;
        if (file == null) {
            ClangdIndexerExecutionPlan.$$$reportNull$$$0(0);
        }
        if ((associated = this.myEntry2Headers.get(file)) != null) {
            this.maybeEraseAssociated(file, associated);
            List<VirtualFile> list = associated;
            if (list == null) {
                ClangdIndexerExecutionPlan.$$$reportNull$$$0(1);
            }
            return list;
        }
        VirtualFile root = this.myHeader2Entry.get(file);
        if (root != null && (associated = this.myEntry2Headers.get(root)) != null) {
            this.maybeEraseAssociated(file, associated);
            List<VirtualFile> list = associated;
            if (list == null) {
                ClangdIndexerExecutionPlan.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<VirtualFile> list = Collections.singletonList(file);
        if (list == null) {
            ClangdIndexerExecutionPlan.$$$reportNull$$$0(3);
        }
        return list;
    }

    void adviseScope(@NotNull Project project, @NotNull ClangIdeFacade facade, @NotNull Collection<VirtualFile> files) {
        if (project == null) {
            ClangdIndexerExecutionPlan.$$$reportNull$$$0(4);
        }
        if (facade == null) {
            ClangdIndexerExecutionPlan.$$$reportNull$$$0(5);
        }
        if (files == null) {
            ClangdIndexerExecutionPlan.$$$reportNull$$$0(6);
        }
        LOG.info("Advising the analysis scope started!");
        files.forEach(file -> {
            if (ClangdBridge.isHeaderFile(project, file)) {
                try {
                    ClangUtils.ResolveInfo resolveInfo = (ClangUtils.ResolveInfo)CidrConcurrentUtilsKt.waitCancelAware(facade.getResolveInfoForFile(project, (VirtualFile)file), (String)"resolve info");
                    if (resolveInfo != null && !resolveInfo.root.equals(file)) {
                        this.myHeader2Entry.put((VirtualFile)file, resolveInfo.root);
                        this.myEntry2Headers.compute(resolveInfo.root, (root, associated) -> {
                            if (associated == null) {
                                associated = new ArrayList<VirtualFile>();
                                associated.add(root);
                            }
                            associated.add(file);
                            return associated;
                        });
                    }
                }
                catch (ExecutionException e) {
                    LOG.warn((Throwable)e);
                }
            }
        });
        LOG.info("Advising the analysis scope finished!");
    }

    private void maybeEraseAssociated(@NotNull VirtualFile file, @NotNull List<VirtualFile> associated) {
        if (file == null) {
            ClangdIndexerExecutionPlan.$$$reportNull$$$0(7);
        }
        if (associated == null) {
            ClangdIndexerExecutionPlan.$$$reportNull$$$0(8);
        }
        this.myEntry2Headers.remove(file);
        for (VirtualFile header : associated) {
            this.myHeader2Entry.remove(header);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/inspections/ClangdIndexerExecutionPlan";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "associated";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/inspections/ClangdIndexerExecutionPlan";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelatedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRelatedFiles";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "adviseScope";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "maybeEraseAssociated";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

