/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInspection.ExternalAnnotatorInspectionVisitor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.ExternalAnnotatorBatchInspection;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotationApplier;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotationApplierProvider;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotator;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotatorExecutionConfig;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.lang.inspections.ClangTidyCheckOption;
import com.jetbrains.cidr.lang.inspections.ClangdIndexerBatchInspectionsCoordinator;
import com.jetbrains.cidr.lang.inspections.ClangdInspectionBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class ClangTidyInspectionBase
extends ClangdInspectionBase
implements ExternalAnnotatorBatchInspection {
    @NotNull
    protected List<ClangTidyCheckOption> myClangTidyCheckOptions = new ArrayList<ClangTidyCheckOption>();

    @NotNull
    public abstract String getMessage(@NotNull String var1, boolean var2);

    @Nls
    @Nullable
    public String getQuickFixMessage() {
        return null;
    }

    public abstract boolean canBeDisabledByClangTidyCheckName(@NotNull VirtualFile var1, @NotNull Project var2);

    public boolean isPreferClangTidyFilesOverIDESettings() {
        return false;
    }

    @NotNull
    public abstract String getSuppressName(@NotNull String var1);

    public void disableGroups(@NotNull List<String> groups) {
        if (groups == null) {
            ClangTidyInspectionBase.$$$reportNull$$$0(0);
        }
        for (String group : groups) {
            this.disableAllChecksInGroup(group);
        }
    }

    public void enableGroups(@NotNull List<String> groups) {
        if (groups == null) {
            ClangTidyInspectionBase.$$$reportNull$$$0(1);
        }
        for (String group : groups) {
            this.enableAllChecksInGroup(group);
        }
    }

    public void disableAllChecksInGroup(@NotNull String group) {
        if (group == null) {
            ClangTidyInspectionBase.$$$reportNull$$$0(2);
        }
    }

    public void enableAllChecksInGroup(@NotNull String group) {
        if (group == null) {
            ClangTidyInspectionBase.$$$reportNull$$$0(3);
        }
    }

    public void enableCheck(@NotNull String check) {
        if (check == null) {
            ClangTidyInspectionBase.$$$reportNull$$$0(4);
        }
    }

    public void disableCheck(@NotNull String check) {
        if (check == null) {
            ClangTidyInspectionBase.$$$reportNull$$$0(5);
        }
    }

    public static boolean isMisraInspection(@NotNull String checkName) {
        if (checkName == null) {
            ClangTidyInspectionBase.$$$reportNull$$$0(6);
        }
        return checkName.startsWith("clion-misra-");
    }

    @NotNull
    public List<ClangTidyCheckOption> getClangTidyCheckOptions() {
        List<ClangTidyCheckOption> list = this.myClangTidyCheckOptions;
        if (list == null) {
            ClangTidyInspectionBase.$$$reportNull$$$0(7);
        }
        return list;
    }

    public void setClangTidyCheckOptions(@NotNull List<ClangTidyCheckOption> clangTidyCheckOptions) {
        if (clangTidyCheckOptions == null) {
            ClangTidyInspectionBase.$$$reportNull$$$0(8);
        }
        this.myClangTidyCheckOptions = clangTidyCheckOptions;
    }

    @Nullable
    public ProblemHighlightType getForcedHighlightType() {
        return null;
    }

    public void addOrReplaceCheckOption(@NotNull String optionName, @NotNull String optionValue) {
        if (optionName == null) {
            ClangTidyInspectionBase.$$$reportNull$$$0(9);
        }
        if (optionValue == null) {
            ClangTidyInspectionBase.$$$reportNull$$$0(10);
        }
        this.removeCheckOption(optionName);
        this.myClangTidyCheckOptions.add(new ClangTidyCheckOption(optionName, optionValue));
    }

    public void removeCheckOption(@NotNull String optionName) {
        if (optionName == null) {
            ClangTidyInspectionBase.$$$reportNull$$$0(11);
        }
        Optional<ClangTidyCheckOption> foundOption = this.myClangTidyCheckOptions.stream().filter(option -> option.getOptionName().equals(optionName)).findFirst();
        foundOption.ifPresent(option -> this.myClangTidyCheckOptions.remove(option));
    }

    public final ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            ClangTidyInspectionBase.$$$reportNull$$$0(12);
        }
        if (manager == null) {
            ClangTidyInspectionBase.$$$reportNull$$$0(13);
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    public ProblemDescriptor @NotNull [] checkFile(@NotNull PsiFile file, @NotNull GlobalInspectionContext context, @NotNull InspectionManager manager) {
        List<ClangTidyDiagnostic> clangTidyDiagnostics;
        ClangTidyAnnotatorExecutionConfig execConfig;
        if (file == null) {
            ClangTidyInspectionBase.$$$reportNull$$$0(14);
        }
        if (context == null) {
            ClangTidyInspectionBase.$$$reportNull$$$0(15);
        }
        if (manager == null) {
            ClangTidyInspectionBase.$$$reportNull$$$0(16);
        }
        if ((execConfig = this.getBatchExecutionConfig(file.getViewProvider().getVirtualFile(), context)) == null) {
            if (ProblemDescriptor.EMPTY_ARRAY == null) {
                ClangTidyInspectionBase.$$$reportNull$$$0(17);
            }
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ClangdIndexerBatchInspectionsCoordinator indexerRunner = this.getIndexerCoordinator(context);
        if (indexerRunner != null && (clangTidyDiagnostics = indexerRunner.getClangTidyDiagnostics(file, this)) != null) {
            return ClangTidyInspectionBase.convertToProblemDescriptors(clangTidyDiagnostics, manager, file);
        }
        ClangTidyAnnotator annotator = new ClangTidyAnnotator(execConfig);
        ProblemDescriptor[] problemDescriptorArray = ExternalAnnotatorInspectionVisitor.checkFileWithExternalAnnotator((PsiFile)file, (InspectionManager)manager, (boolean)false, (ExternalAnnotator)annotator);
        if (problemDescriptorArray == null) {
            ClangTidyInspectionBase.$$$reportNull$$$0(18);
        }
        return problemDescriptorArray;
    }

    @Nullable
    protected abstract ClangTidyAnnotatorExecutionConfig getBatchExecutionConfig(@NotNull VirtualFile var1, @NotNull GlobalInspectionContext var2);

    protected @Unmodifiable @NotNull List<ClangTidyDiagnostic> filterRelevant(@NotNull List<ClangTidyDiagnostic> diagnostics) {
        if (diagnostics == null) {
            ClangTidyInspectionBase.$$$reportNull$$$0(19);
        }
        List<ClangTidyDiagnostic> list = diagnostics;
        if (list == null) {
            ClangTidyInspectionBase.$$$reportNull$$$0(20);
        }
        return list;
    }

    protected static ProblemDescriptor @NotNull [] convertToProblemDescriptors(@Nullable @Unmodifiable List<ClangTidyDiagnostic> diagnostics, @NotNull InspectionManager manager, @NotNull PsiFile file) {
        if (manager == null) {
            ClangTidyInspectionBase.$$$reportNull$$$0(21);
        }
        if (file == null) {
            ClangTidyInspectionBase.$$$reportNull$$$0(22);
        }
        if (diagnostics == null) {
            if (ProblemDescriptor.EMPTY_ARRAY == null) {
                ClangTidyInspectionBase.$$$reportNull$$$0(23);
            }
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ClangTidyAnnotationApplier applier = ClangTidyAnnotationApplierProvider.provide();
        ProblemsHolder problemsHolder = new ProblemsHolder(manager, file, false);
        ReadAction.computeCancellable(() -> {
            applier.annotateSuccess(file, (List<? extends ClangTidyDiagnostic>)diagnostics, problemsHolder);
            return true;
        });
        ProblemDescriptor[] problemDescriptorArray = problemsHolder.getResultsArray();
        if (problemDescriptorArray == null) {
            ClangTidyInspectionBase.$$$reportNull$$$0(24);
        }
        return problemDescriptorArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 17, 18, 20, 23, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "check";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkName";
                break;
            }
            case 7: 
            case 17: 
            case 18: 
            case 20: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/inspections/ClangTidyInspectionBase";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clangTidyCheckOptions";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionValue";
                break;
            }
            case 12: 
            case 14: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnostics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/inspections/ClangTidyInspectionBase";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getClangTidyCheckOptions";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "checkFile";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "filterRelevant";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToProblemDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "disableGroups";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "enableGroups";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "disableAllChecksInGroup";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "enableAllChecksInGroup";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "enableCheck";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "disableCheck";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isMisraInspection";
                break;
            }
            case 7: 
            case 17: 
            case 18: 
            case 20: 
            case 23: 
            case 24: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setClangTidyCheckOptions";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addOrReplaceCheckOption";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeCheckOption";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "filterRelevant";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "convertToProblemDescriptors";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 17, 18, 20, 23, 24 -> new IllegalStateException(string);
        };
    }
}

