/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.cidr.cpp.lexer.OCLexer;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.SuppressableProblemGroup;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotationApplierBase;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyRange;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyReplacement;
import com.jetbrains.cidr.lang.daemon.clang.tidy.SimpleClangTidyIntentionAction;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspection;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspectionBase;
import com.jetbrains.cidr.lang.inspections.MisraInspection;
import com.jetbrains.cidr.lang.inspections.SimpleClangTidyProblemGroup;
import com.jetbrains.cidr.lang.lexer.OCLexerSettings;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class SimpleClangTidyAnnotationApplier
extends ClangTidyAnnotationApplierBase {
    @Override
    @NotNull
    protected SuppressableProblemGroup createProblemGroup(@NotNull PsiFile file, @NotNull TextRange highlightRange, @NotNull String checkName, @NotNull ClangTidyInspectionBase inspection) {
        if (file == null) {
            SimpleClangTidyAnnotationApplier.$$$reportNull$$$0(0);
        }
        if (highlightRange == null) {
            SimpleClangTidyAnnotationApplier.$$$reportNull$$$0(1);
        }
        if (checkName == null) {
            SimpleClangTidyAnnotationApplier.$$$reportNull$$$0(2);
        }
        if (inspection == null) {
            SimpleClangTidyAnnotationApplier.$$$reportNull$$$0(3);
        }
        boolean canDisable = inspection.canBeDisabledByClangTidyCheckName(file.getVirtualFile(), file.getProject());
        boolean canSuppress = ((Object)((Object)inspection)).getClass().equals(ClangTidyInspection.class);
        return new SimpleClangTidyProblemGroup(checkName, canDisable, canSuppress, inspection.getShortName());
    }

    @Override
    @Nullable
    protected TextRange getRangeToHighlight(@NotNull PsiFile file, @NotNull ClangTidyDiagnostic diagnostic, @NotNull ClangTidyInspectionBase sourceInspection) {
        Document document;
        if (file == null) {
            SimpleClangTidyAnnotationApplier.$$$reportNull$$$0(4);
        }
        if (diagnostic == null) {
            SimpleClangTidyAnnotationApplier.$$$reportNull$$$0(5);
        }
        if (sourceInspection == null) {
            SimpleClangTidyAnnotationApplier.$$$reportNull$$$0(6);
        }
        if ((document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file)) == null) {
            return null;
        }
        CharSequence sequence = document.getCharsSequence();
        if (diagnostic.getFileOffset() < 0 || diagnostic.getFileOffset() >= sequence.length()) {
            return null;
        }
        List<ClangTidyRange> clangTidyRanges = diagnostic.getRanges();
        if (sourceInspection instanceof MisraInspection && clangTidyRanges.size() == 1) {
            ClangTidyRange range = clangTidyRanges.get(0);
            return new TextRange(range.getFileOffset(), range.getFileOffset() + Math.max(range.getLength(), 1));
        }
        int startOffset = diagnostic.getFileOffset();
        return SimpleClangTidyAnnotationApplier.getTextRange(document, sequence, startOffset);
    }

    @TestOnly
    @ApiStatus.Internal
    @Nullable
    public TextRange getRangeToHighlightForTests(@NotNull PsiFile file, @NotNull ClangTidyDiagnostic diagnostic, @NotNull ClangTidyInspectionBase sourceInspection) {
        if (file == null) {
            SimpleClangTidyAnnotationApplier.$$$reportNull$$$0(7);
        }
        if (diagnostic == null) {
            SimpleClangTidyAnnotationApplier.$$$reportNull$$$0(8);
        }
        if (sourceInspection == null) {
            SimpleClangTidyAnnotationApplier.$$$reportNull$$$0(9);
        }
        return this.getRangeToHighlight(file, diagnostic, sourceInspection);
    }

    @NotNull
    private static TextRange getTextRange(@NotNull Document document, @NotNull CharSequence sequence, int startOffset) {
        char chatAtOffset;
        if (document == null) {
            SimpleClangTidyAnnotationApplier.$$$reportNull$$$0(10);
        }
        if (sequence == null) {
            SimpleClangTidyAnnotationApplier.$$$reportNull$$$0(11);
        }
        if (((chatAtOffset = sequence.charAt(startOffset)) == '<' || chatAtOffset == '\"') && SimpleClangTidyAnnotationApplier.isPreprocessorDirective(OCLexerTokenTypes.INCLUDE_DIRECTIVE, document, sequence, startOffset)) {
            char endSymbol = chatAtOffset == '<' ? (char)'>' : '\"';
            return SimpleClangTidyAnnotationApplier.getTextRangeUntil(sequence, startOffset + 1, endSymbol, false);
        }
        if (chatAtOffset == '[') {
            return SimpleClangTidyAnnotationApplier.getTextRangeUntil(sequence, startOffset, ']', true);
        }
        if (chatAtOffset == '(') {
            return SimpleClangTidyAnnotationApplier.getTextRangeUntil(sequence, startOffset, ')', true);
        }
        if (chatAtOffset == '\"') {
            return SimpleClangTidyAnnotationApplier.getTextRangeUntil(sequence, startOffset, '\"', true);
        }
        if (chatAtOffset == '\'') {
            return SimpleClangTidyAnnotationApplier.getTextRangeUntil(sequence, startOffset, '\'', true);
        }
        if (SimpleClangTidyAnnotationApplier.isComment(sequence, startOffset)) {
            return SimpleClangTidyAnnotationApplier.getCommentTextRange(sequence, startOffset);
        }
        if (SimpleClangTidyAnnotationApplier.isOperatorSymbol(chatAtOffset)) {
            return SimpleClangTidyAnnotationApplier.getCompositeOperatorSymbolTextRange(sequence, startOffset);
        }
        if (StringUtil.isWhiteSpace((char)chatAtOffset)) {
            return SimpleClangTidyAnnotationApplier.getTextRangeAfterWhitespace(document, sequence, startOffset);
        }
        return SimpleClangTidyAnnotationApplier.getIdentifierTextRange(sequence, startOffset);
    }

    private static boolean isPreprocessorDirective(OCElementType targetElementType, @NotNull Document document, @NotNull CharSequence sequence, int offset) {
        if (document == null) {
            SimpleClangTidyAnnotationApplier.$$$reportNull$$$0(12);
        }
        if (sequence == null) {
            SimpleClangTidyAnnotationApplier.$$$reportNull$$$0(13);
        }
        OCLexer lexer = new OCLexer(OCLexerSettings.forPreprocessor().build());
        int lineNumber = document.getLineNumber(offset);
        lexer.start(sequence.subSequence(document.getLineStartOffset(lineNumber), document.getLineEndOffset(lineNumber)));
        while (OCLexerTokenTypes.WHITESPACES.contains(lexer.getTokenType()) || OCLexerTokenTypes.BLOCK_COMMENT == lexer.getTokenType()) {
            lexer.advance();
        }
        return lexer.getTokenType() == targetElementType;
    }

    @NotNull
    private static TextRange getTextRangeAfterWhitespace(@NotNull Document document, @NotNull CharSequence sequence, int startOffset) {
        int offset;
        if (document == null) {
            SimpleClangTidyAnnotationApplier.$$$reportNull$$$0(14);
        }
        if (sequence == null) {
            SimpleClangTidyAnnotationApplier.$$$reportNull$$$0(15);
        }
        for (offset = startOffset; offset < sequence.length() && StringUtil.isWhiteSpace((char)sequence.charAt(offset)); ++offset) {
        }
        return SimpleClangTidyAnnotationApplier.getTextRange(document, sequence, offset);
    }

    @NotNull
    private static TextRange getCommentTextRange(@NotNull CharSequence sequence, int startOffset) {
        int endOffset;
        if (sequence == null) {
            SimpleClangTidyAnnotationApplier.$$$reportNull$$$0(16);
        }
        if (StringUtil.startsWith((CharSequence)sequence, (int)startOffset, (CharSequence)"//")) {
            return SimpleClangTidyAnnotationApplier.getTextRangeUntil(sequence, startOffset, '\n', false);
        }
        for (endOffset = startOffset + 2; endOffset < sequence.length(); ++endOffset) {
            if (!StringUtil.startsWith((CharSequence)sequence, (int)endOffset, (CharSequence)"*/")) continue;
            endOffset += 2;
            break;
        }
        return new TextRange(startOffset, endOffset);
    }

    private static boolean isComment(@NotNull CharSequence sequence, int startOffset) {
        if (sequence == null) {
            SimpleClangTidyAnnotationApplier.$$$reportNull$$$0(17);
        }
        return StringUtil.startsWith((CharSequence)sequence, (int)startOffset, (CharSequence)"//") || StringUtil.startsWith((CharSequence)sequence, (int)startOffset, (CharSequence)"/*");
    }

    @NotNull
    private static TextRange getTextRangeUntil(@NotNull CharSequence sequence, int startOffset, char endSymbol, boolean includeEndSymbol) {
        int endOffset;
        if (sequence == null) {
            SimpleClangTidyAnnotationApplier.$$$reportNull$$$0(18);
        }
        for (endOffset = startOffset + 1; endOffset < sequence.length(); ++endOffset) {
            if (sequence.charAt(endOffset) != endSymbol) continue;
            if (!includeEndSymbol) break;
            ++endOffset;
            break;
        }
        return new TextRange(startOffset, endOffset);
    }

    private static boolean isOperatorSymbol(char ch) {
        return ch == '+' || ch == '-' || ch == '*' || ch == '/' || ch == '%' || ch == '&' || ch == '|' || ch == '^' || ch == '<' || ch == '>' || ch == '!' || ch == '=';
    }

    @NotNull
    private static TextRange getCompositeOperatorSymbolTextRange(@NotNull CharSequence sequence, int startOffset) {
        int endOffset;
        if (sequence == null) {
            SimpleClangTidyAnnotationApplier.$$$reportNull$$$0(19);
        }
        for (endOffset = startOffset; endOffset < sequence.length() && SimpleClangTidyAnnotationApplier.isOperatorSymbol(sequence.charAt(endOffset)); ++endOffset) {
        }
        return new TextRange(startOffset, endOffset);
    }

    @NotNull
    private static TextRange getIdentifierTextRange(@NotNull CharSequence sequence, int startOffset) {
        int endOffset;
        Predicate<Character> identifierPredicate;
        if (sequence == null) {
            SimpleClangTidyAnnotationApplier.$$$reportNull$$$0(20);
        }
        if ((identifierPredicate = c -> Character.isLetterOrDigit(c.charValue()) || c.charValue() == '_' || c.charValue() == '#' || c.charValue() == '~' || c.charValue() == ':').test(Character.valueOf(sequence.charAt(startOffset)))) {
            for (endOffset = startOffset; endOffset < sequence.length() && identifierPredicate.test(Character.valueOf(sequence.charAt(endOffset))); ++endOffset) {
            }
        } else {
            endOffset = startOffset + 1;
        }
        return new TextRange(startOffset, endOffset);
    }

    @Override
    protected boolean isSuppressed(@NotNull PsiFile file, int offset, @NotNull String suppressName) {
        if (file == null) {
            SimpleClangTidyAnnotationApplier.$$$reportNull$$$0(21);
        }
        if (suppressName == null) {
            SimpleClangTidyAnnotationApplier.$$$reportNull$$$0(22);
        }
        return false;
    }

    @Override
    @NotNull
    protected List<IntentionAction> createQuickFixes(@NotNull PsiFile file, @NotNull @NlsSafe String diagnosticMessage, @NotNull ClangTidyDiagnostic diagnostic, @NotNull ClangTidyInspectionBase sourceInspection, @NotNull ClangUrlConverter urlConverter) {
        List<ClangTidyReplacement> replacements;
        if (file == null) {
            SimpleClangTidyAnnotationApplier.$$$reportNull$$$0(23);
        }
        if (diagnosticMessage == null) {
            SimpleClangTidyAnnotationApplier.$$$reportNull$$$0(24);
        }
        if (diagnostic == null) {
            SimpleClangTidyAnnotationApplier.$$$reportNull$$$0(25);
        }
        if (sourceInspection == null) {
            SimpleClangTidyAnnotationApplier.$$$reportNull$$$0(26);
        }
        if (urlConverter == null) {
            SimpleClangTidyAnnotationApplier.$$$reportNull$$$0(27);
        }
        if ((replacements = diagnostic.getReplacements()).isEmpty()) {
            List<EmptyIntentionAction> list = Collections.singletonList(new EmptyIntentionAction(sourceInspection.getDisplayName()));
            if (list == null) {
                SimpleClangTidyAnnotationApplier.$$$reportNull$$$0(28);
            }
            return list;
        }
        String diagnosticName = diagnostic.getDiagnosticName();
        String quickFixMessage = sourceInspection.getQuickFixMessage() != null ? sourceInspection.getQuickFixMessage() : diagnosticMessage;
        List<IntentionAction> list = Collections.singletonList(new SimpleClangTidyIntentionAction(quickFixMessage, diagnosticName, replacements));
        if (list == null) {
            SimpleClangTidyAnnotationApplier.$$$reportNull$$$0(29);
        }
        return list;
    }

    @Override
    protected boolean shouldIgnoreForFile(@NotNull PsiFile file) {
        if (file == null) {
            SimpleClangTidyAnnotationApplier.$$$reportNull$$$0(30);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 28, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightRange";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspection";
                break;
            }
            case 5: 
            case 8: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnostic";
                break;
            }
            case 6: 
            case 9: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceInspection";
                break;
            }
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suppressName";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnosticMessage";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlConverter";
                break;
            }
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/tidy/SimpleClangTidyAnnotationApplier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/SimpleClangTidyAnnotationApplier";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createProblemGroup";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRangeToHighlight";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRangeToHighlightForTests";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getTextRange";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isPreprocessorDirective";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTextRangeAfterWhitespace";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCommentTextRange";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isComment";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTextRangeUntil";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getCompositeOperatorSymbolTextRange";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getIdentifierTextRange";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressed";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createQuickFixes";
                break;
            }
            case 28: 
            case 29: {
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "shouldIgnoreForFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 28, 29 -> new IllegalStateException(string);
        };
    }
}

