/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.google.gson.stream.JsonWriter;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionManagerBase;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.PluginUtils;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangTidyFilesState;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidySettings;
import com.jetbrains.cidr.lang.daemon.clang.tidy.OverlayMapping;
import com.jetbrains.cidr.lang.inspections.ClangTidyCheckOption;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspection;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspectionBase;
import com.jetbrains.cidr.lang.inspections.ClazyInspection;
import com.jetbrains.cidr.lang.inspections.MisraInspection;
import com.jetbrains.cidr.lang.inspections.OurClangTidyInspection;
import com.jetbrains.cidr.lang.settings.FileExtensionPair;
import com.jetbrains.cidr.lang.settings.NamingConventionStyle;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.yaml.snakeyaml.Yaml;

public final class CommonClangTidyUtil {
    @NlsSafe
    public static final String TOOL_NAME = "Clang-Tidy";
    public static final Pattern CLANG_TIDY_VERSION_PATTERN = Pattern.compile("^.*?([\\d]+\\.[\\d]+\\.?[\\d]*).*", 32);
    @NlsSafe
    public static final String CLANG_TIDY_BASE_WEB_PAGE = "https://clang.llvm.org/extra/clang-tidy";
    @NlsSafe
    public static final String CLANG_TIDY_HOW_TO_USE_WEB_PAGE = "https://clang.llvm.org/extra/clang-tidy/#using-clang-tidy";
    @NlsSafe
    public static final String CLANG_TIDY_CHECKS_WEB_PAGE = "https://clang.llvm.org/extra/clang-tidy/checks";
    private static final HashSet<@NlsSafe String> clangAnalyzerChecksWithDocumentation = ContainerUtil.newHashSet((Object[])new String[]{"clang-analyzer-core.DynamicTypePropagation", "clang-analyzer-core.uninitialized.CapturedBlockVariable", "clang-analyzer-cplusplus.InnerPointer", "clang-analyzer-nullability.NullableReturnedFromNonnull", "clang-analyzer-optin.osx.OSObjectCStyleCast", "clang-analyzer-optin.performance.GCDAntipattern", "clang-analyzer-optin.performance.Padding", "clang-analyzer-optin.portability.UnixAPI", "clang-analyzer-osx.MIG", "clang-analyzer-osx.NumberObjectConversion", "clang-analyzer-osx.OSObjectRetainCount", "clang-analyzer-osx.ObjCProperty", "clang-analyzer-osx.cocoa.AutoreleaseWrite", "clang-analyzer-osx.cocoa.Loops", "clang-analyzer-osx.cocoa.MissingSuperCall", "clang-analyzer-osx.cocoa.NonNilReturnValue", "clang-analyzer-osx.cocoa.RunLoopAutoreleaseLeak", "clang-analyzer-valist.CopyToSelf", "clang-analyzer-valist.Uninitialized", "clang-analyzer-valist.Unterminated"});
    private static final List<FileExtensionPair> defaultFileExtensions = Collections.unmodifiableList(new ArrayList<FileExtensionPair>(3){
        {
            if (PluginUtils.hasAppCode()) {
                this.add(new FileExtensionPair("mm", "h", NamingConventionStyle.NONE));
            }
            this.add(new FileExtensionPair("cpp", "h", NamingConventionStyle.NONE));
            this.add(new FileExtensionPair("c", "h", NamingConventionStyle.NONE));
            if (PluginUtils.hasCLion()) {
                this.add(new FileExtensionPair("cu", "cuh", NamingConventionStyle.NONE));
            }
        }
    });

    @NotNull
    public static List<FileExtensionPair> getDefaultFileExtensions() {
        List<FileExtensionPair> list = defaultFileExtensions;
        if (list == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public static File getClangTidyPath() {
        File clangTidyPath = CommonClangTidyUtil.getCustomClangTidyPath();
        if (clangTidyPath == null) {
            clangTidyPath = CommonClangTidyUtil.getBuiltinClangTidyPath();
        }
        File file = clangTidyPath;
        if (file == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(1);
        }
        return file;
    }

    @Nullable
    public static File getCustomClangTidyPath() {
        return (File)ReadAction.compute(() -> {
            ClangTidySettings settings = ClangTidySettings.getInstance();
            return settings != null && settings.getUseExternalClangTidy() && settings.getExternalClangTidyPath() != null ? new File(settings.getExternalClangTidyPath()) : null;
        });
    }

    @NotNull
    public static String generateVfsOverlay(@NotNull OverlayMapping mapping, @NotNull ClangUrlConverter converter) {
        if (mapping == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(2);
        }
        if (converter == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(3);
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        ArrayList<Map<String, Object[]>> roots = new ArrayList<Map<String, Object[]>>();
        for (File overlayFile : mapping.getOverlayFiles()) {
            File sourceFile = mapping.getSourceFile(overlayFile);
            if (sourceFile == null) continue;
            File parentDirectory = FileUtil.getParentFile((File)sourceFile);
            Map<String, String> contents = Map.of("name", sourceFile.getName(), "type", "file", "external-contents", converter.fixWslPathWhenRequired(overlayFile.getAbsolutePath()));
            roots.add(Map.of("name", parentDirectory != null ? converter.fixWslPathWhenRequired(parentDirectory.getAbsolutePath()) : "", "type", "directory", "contents", new Object[]{contents}));
        }
        data.put("version", "0");
        data.put("roots", roots.toArray());
        Yaml yaml = new Yaml();
        String string = yaml.dump(data);
        if (string == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static void writeCompilationDatabase(@NotNull Writer outputWriter, @NotNull String compilerExecutable, @NotNull String compilerWorkingDirectory, @NotNull List<String> compilerOptions, @NotNull String inputFile) throws IOException {
        if (outputWriter == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(5);
        }
        if (compilerExecutable == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(6);
        }
        if (compilerWorkingDirectory == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(7);
        }
        if (compilerOptions == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(8);
        }
        if (inputFile == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(9);
        }
        try (JsonWriter jsonWriter = new JsonWriter(outputWriter);){
            jsonWriter.beginArray();
            jsonWriter.beginObject();
            jsonWriter.name("directory");
            jsonWriter.value(compilerWorkingDirectory);
            jsonWriter.name("arguments");
            jsonWriter.beginArray();
            jsonWriter.value(compilerExecutable);
            for (String compilerOption : compilerOptions) {
                jsonWriter.value(compilerOption);
            }
            jsonWriter.value(inputFile);
            jsonWriter.endArray();
            jsonWriter.name("file");
            jsonWriter.value(inputFile);
            jsonWriter.endObject();
            jsonWriter.endArray();
        }
    }

    @NotNull
    public static File getBuiltinClangTidyPath() {
        File file = ClangUtils.getBuiltinClangToolPath(SystemInfo.isWindows ? "clang-tidy.exe" : "clang-tidy");
        if (file == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(10);
        }
        return file;
    }

    public static boolean isToolEnabled(LocalInspectionTool inspection, @Nullable PsiFile file, @NotNull Project project) {
        if (project == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(11);
        }
        String currentProfile = ((InspectionManagerBase)InspectionManager.getInstance((Project)project)).getCurrentProfile();
        ProjectInspectionProfileManager profileManager = ProjectInspectionProfileManager.getInstance((Project)project);
        InspectionProfileImpl profile = profileManager.getProfile(currentProfile);
        return profile.isToolEnabled(HighlightDisplayKey.find((String)inspection.getID()), (PsiElement)file);
    }

    @NotNull
    public static List<OurClangTidyInspection> getOurInspections(boolean onlyEnabled, @NotNull PsiFile file, @NotNull Project project) {
        if (file == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(12);
        }
        if (project == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(13);
        }
        List<InspectionToolWrapper<?, ?>> tools = CommonClangTidyUtil.findTools(onlyEnabled, file, project);
        ArrayList<OurClangTidyInspection> list = new ArrayList<OurClangTidyInspection>();
        for (InspectionToolWrapper<?, ?> tool : tools) {
            InspectionProfileEntry inspectionProfileEntry;
            if (tool == null || !((inspectionProfileEntry = tool.getTool()) instanceof OurClangTidyInspection)) continue;
            OurClangTidyInspection toolTool = (OurClangTidyInspection)inspectionProfileEntry;
            list.add(toolTool);
        }
        ArrayList<OurClangTidyInspection> arrayList = list;
        if (arrayList == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @Nullable
    public static MisraInspection getMisraInspection(@NotNull PsiFile file, @NotNull Project project) {
        InspectionProfileEntry tool;
        if (file == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(15);
        }
        if (project == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(16);
        }
        return (tool = CommonClangTidyUtil.findTool(MisraInspection.Companion.getInspectionShortName(), false, file, project)) instanceof MisraInspection ? (MisraInspection)tool : null;
    }

    @Nullable
    public static ClangTidyInspection getClangTidyInspection(@Nullable PsiFile file, @NotNull Project project) {
        InspectionProfileEntry tool;
        if (project == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(17);
        }
        return (tool = CommonClangTidyUtil.findTool(ClangTidyInspection.getInspectionShortName(), false, file, project)) instanceof ClangTidyInspection ? (ClangTidyInspection)tool : null;
    }

    @Nullable
    public static ClangTidyInspectionBase findInspectionFromClangTidyDiagnostic(@NotNull ClangTidyDiagnostic diagnostic, @NotNull PsiFile file, @NotNull Project project) {
        if (diagnostic == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(18);
        }
        if (file == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(19);
        }
        if (project == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(20);
        }
        for (OurClangTidyInspection inspection : CommonClangTidyUtil.getOurInspections(false, file, project)) {
            if (!inspection.getCheckName().equals(diagnostic.getDiagnosticName())) continue;
            return inspection;
        }
        if (CommonClangTidyUtil.isMisraInspection(diagnostic)) {
            return CommonClangTidyUtil.getMisraInspection(file, project);
        }
        if (CommonClangTidyUtil.isClazyInspection(diagnostic)) {
            return CommonClangTidyUtil.getClazyInspection(file, project);
        }
        return CommonClangTidyUtil.getClangTidyInspection(file, project);
    }

    @Nullable
    public static ClazyInspection getClazyInspection(@Nullable PsiFile file, @NotNull Project project) {
        InspectionProfileEntry tool;
        if (project == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(21);
        }
        return (tool = CommonClangTidyUtil.findTool(ClazyInspection.getInspectionShortName(), false, file, project)) instanceof ClazyInspection ? (ClazyInspection)tool : null;
    }

    private static boolean isMisraInspection(@NotNull ClangTidyDiagnostic diagnostic) {
        if (diagnostic == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(22);
        }
        return diagnostic.getDiagnosticName().startsWith("clion-misra-");
    }

    private static boolean isClazyInspection(@NotNull ClangTidyDiagnostic diagnostic) {
        if (diagnostic == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(23);
        }
        return diagnostic.getDiagnosticName().startsWith("-Wclazy") || diagnostic.getDiagnosticName().startsWith("clazy");
    }

    @Nullable
    public static InspectionProfileEntry findTool(@NotNull String inspectionId, boolean onlyEnabled, @Nullable PsiFile file, @NotNull Project project) {
        if (inspectionId == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(24);
        }
        if (project == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(25);
        }
        for (InspectionToolWrapper<?, ?> toolWrapper : CommonClangTidyUtil.findTools(onlyEnabled, file, project)) {
            if (toolWrapper == null || !toolWrapper.getID().equals(inspectionId)) continue;
            return toolWrapper.getTool();
        }
        return null;
    }

    @NotNull
    public static List<InspectionToolWrapper<?, ?>> findTools(boolean onlyEnabled, @Nullable PsiFile file, @NotNull Project project) {
        if (project == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(26);
        }
        String currentProfile = ((InspectionManagerBase)InspectionManager.getInstance((Project)project)).getCurrentProfile();
        ProjectInspectionProfileManager profileManager = ProjectInspectionProfileManager.getInstance((Project)project);
        InspectionProfileImpl profile = profileManager.getProfile(currentProfile);
        List wrappers = profile.getInspectionTools((PsiElement)file);
        if (!onlyEnabled) {
            List list = wrappers;
            if (list == null) {
                CommonClangTidyUtil.$$$reportNull$$$0(27);
            }
            return list;
        }
        ArrayList list = new ArrayList();
        for (InspectionToolWrapper wrapper : wrappers) {
            if (wrapper == null || !profile.isToolEnabled(HighlightDisplayKey.find((String)wrapper.getID()), (PsiElement)file)) continue;
            list.add(wrapper);
        }
        ArrayList arrayList = list;
        if (arrayList == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(28);
        }
        return arrayList;
    }

    @NlsSafe
    @NotNull
    public static String getClangTidyConfig(@NlsSafe @NotNull String checks, @NotNull List<ClangTidyCheckOption> checkOptions) {
        if (checks == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(29);
        }
        if (checkOptions == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(30);
        }
        String string = ClangUtils.getClangTidyConfig(checks, checkOptions);
        if (string == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(31);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public static String concatClangTidyChecks(@NlsSafe @NotNull String checksA, @NlsSafe @NotNull String checksB) {
        if (checksA == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(32);
        }
        if (checksB == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(33);
        }
        List checks = ContainerUtil.concat((List)StringUtil.split((String)checksA, (String)","), (List)StringUtil.split((String)checksB, (String)","));
        String string = StringUtil.join((Collection)checks, (String)",");
        if (string == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(34);
        }
        return string;
    }

    private static @NotNull List<@NlsSafe String> getEnabledChecks(@NlsSafe @NotNull String checks) {
        if (checks == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(35);
        }
        List<String> options = CommonClangTidyUtil.getTrimmedOptions(checks);
        options.removeIf(it -> CommonClangTidyUtil.isDisabled(options, it));
        List<String> list = options;
        if (list == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(36);
        }
        return list;
    }

    @NlsSafe
    @NotNull
    public static String joinChecks(@NlsSafe @NotNull String configA, @NlsSafe @NotNull String configB) {
        if (configA == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(37);
        }
        if (configB == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(38);
        }
        List<String> checksA = CommonClangTidyUtil.getEnabledChecks(configA);
        List<String> checksB = CommonClangTidyUtil.getEnabledChecks(configB);
        String joinedA = StringUtil.join(checksA, (String)",");
        String joinedB = StringUtil.join(checksB, (String)",");
        return CommonClangTidyUtil.concatClangTidyChecks(joinedA, joinedB);
    }

    @NotNull
    public static String enableCheck(@NotNull String configuration, @NotNull String checkName) {
        if (configuration == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(39);
        }
        if (checkName == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(40);
        }
        List<String> options = CommonClangTidyUtil.getTrimmedOptions(configuration);
        options.removeIf(option -> option.equals("-" + checkName));
        if (CommonClangTidyUtil.isDisabled(options, checkName)) {
            options.add(checkName);
        }
        String string = StringUtil.join(options, (String)",");
        if (string == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(41);
        }
        return string;
    }

    @NotNull
    public static String disableCheck(@NotNull String configuration, @NotNull String checkName) {
        if (configuration == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(42);
        }
        if (checkName == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(43);
        }
        List<String> options = CommonClangTidyUtil.getTrimmedOptions(configuration);
        options.removeIf(option -> option.equals(checkName));
        if (!CommonClangTidyUtil.isDisabled(options, checkName)) {
            options.add("-" + checkName);
        }
        String string = StringUtil.join(options, (String)",");
        if (string == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(44);
        }
        return string;
    }

    public static void modifyAllChecksWithSingleGroup(@NotNull Map<String, Boolean> checksState, @NotNull ClangTidyInspectionBase inspection) {
        if (checksState == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(45);
        }
        if (inspection == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(46);
        }
        if (checksState.isEmpty()) {
            return;
        }
        String groupName = CommonClangTidyUtil.getGroupName((String)checksState.keySet().stream().findFirst().get());
        List<String> enabledChecks = checksState.entrySet().stream().filter(e -> (Boolean)e.getValue()).map(e -> (String)e.getKey()).toList();
        List<String> disabledChecks = checksState.entrySet().stream().filter(e -> (Boolean)e.getValue() == false).map(e -> (String)e.getKey()).toList();
        if (enabledChecks.size() <= disabledChecks.size()) {
            inspection.disableAllChecksInGroup(groupName);
            for (String check : enabledChecks) {
                inspection.enableCheck(check);
            }
        } else {
            inspection.enableAllChecksInGroup(groupName);
            for (String check : disabledChecks) {
                inspection.disableCheck(check);
            }
        }
    }

    @NotNull
    public static String getGroupName(@NotNull String option) {
        if (option == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(47);
        }
        if (option.startsWith("clang-analyzer")) {
            return "clang-analyzer";
        }
        if (option.startsWith("clion-misra-c2012")) {
            return "C2012";
        }
        if (option.startsWith("clion-misra-cpp2008")) {
            return "C++2008";
        }
        if (option.startsWith("clion-misra-cpp2023")) {
            return "C++2023";
        }
        List parts = StringUtil.split((String)option, (String)"-");
        return !parts.isEmpty() ? (String)parts.get(0) : "";
    }

    @NotNull
    public static String enableGroup(@NotNull String configuration, @NotNull String groupName) {
        if (configuration == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(48);
        }
        if (groupName == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(49);
        }
        List<String> options = CommonClangTidyUtil.getTrimmedOptions(configuration);
        options.removeIf(option -> option.startsWith(groupName) || option.startsWith("-") && option.substring(1).startsWith(groupName));
        if (CommonClangTidyUtil.isDisabled(options, groupName)) {
            options.add(groupName + "-*");
        }
        String string = StringUtil.join(options, (String)",");
        if (string == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(50);
        }
        return string;
    }

    @NotNull
    public static String disableGroup(@NotNull String configuration, @NotNull String groupName) {
        if (configuration == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(51);
        }
        if (groupName == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(52);
        }
        List<String> options = CommonClangTidyUtil.getTrimmedOptions(configuration);
        options.removeIf(option -> option.startsWith(groupName) || option.startsWith("-") && option.substring(1).startsWith(groupName));
        if (!CommonClangTidyUtil.isDisabled(options, groupName)) {
            options.add("-" + groupName + "-*");
        }
        String string = StringUtil.join(options, (String)",");
        if (string == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(53);
        }
        return string;
    }

    @NotNull
    public static String getCheckNameWithoutGroup(@NotNull String checkName) {
        String groupName;
        if (checkName == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(54);
        }
        String string = checkName.startsWith(groupName = CommonClangTidyUtil.getGroupName(checkName) + "-") ? checkName.substring(groupName.length()) : checkName;
        if (string == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(55);
        }
        return string;
    }

    public static List<String> getTrimmedOptions(@NotNull String configuration) {
        if (configuration == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(56);
        }
        return new ArrayList<String>(ContainerUtil.map((Collection)StringUtil.split((String)configuration, (String)","), String::trim));
    }

    public static boolean isDisabled(@NotNull List<String> options, @NotNull String checkName) {
        if (options == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(57);
        }
        if (checkName == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(58);
        }
        boolean disabled = false;
        for (String option : options) {
            if (option.equals("*")) {
                disabled = false;
                continue;
            }
            if (option.equals("-*")) {
                disabled = true;
                continue;
            }
            if (CommonClangTidyUtil.groupOrCheckEnabled(option, checkName)) {
                disabled = false;
                continue;
            }
            if (!CommonClangTidyUtil.groupOrCheckDisabled(option, checkName)) continue;
            disabled = true;
        }
        return disabled;
    }

    @NotNull
    public static @Unmodifiable Map<String, ClangTidyCheckOption> toCheckOptionsMap(@NotNull List<ClangTidyCheckOption> options) {
        if (options == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(59);
        }
        Map map = ContainerUtil.map2Map(options, option -> Pair.create((Object)option.getOptionName(), (Object)option));
        if (map == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(60);
        }
        return map;
    }

    @NotNull
    public static String buildClangTidyHelpPage(@NotNull String checkName) {
        if (checkName == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(61);
        }
        if (!CommonClangTidyUtil.hasDocumentationPage(checkName)) {
            return "";
        }
        if (StringUtil.split((String)checkName, (String)"-").size() <= 1) {
            return "";
        }
        String groupName = CommonClangTidyUtil.getGroupName(checkName);
        if (StringUtil.isEmpty((String)groupName)) {
            return "";
        }
        String checkNameWithoutGroup = checkName.substring(groupName.length() + 1);
        if (StringUtil.isEmpty((String)checkNameWithoutGroup)) {
            return "";
        }
        if (groupName.equals("linuxkernel") && checkNameWithoutGroup.equals("must-check-errs")) {
            checkNameWithoutGroup = "must-use-errs";
        }
        String string = "https://clang.llvm.org/extra/clang-tidy/checks/" + groupName + "/" + checkNameWithoutGroup + ".html";
        if (string == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(62);
        }
        return string;
    }

    @NotNull
    public static List<String> filterSpecificCLionCommandLineOptions(@NotNull List<String> commandLineOptions) {
        if (commandLineOptions == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(63);
        }
        if (!ClangTidySettings.getInstance().getUseExternalClangTidy()) {
            List<String> list = commandLineOptions;
            if (list == null) {
                CommonClangTidyUtil.$$$reportNull$$$0(64);
            }
            return list;
        }
        ArrayList<String> filteredCommandLineOptions = new ArrayList<String>(commandLineOptions.size());
        HashSet commandLineOptionsToRemove = ContainerUtil.newHashSet((Object[])new String[]{"-ccc-no-implicit-pch-or-pth", "-clion-take-last-input", "-fclion-iar-compatibility", "-fclion-allow-iar-ext", "-fcpp20-module-map-file"});
        for (String option : commandLineOptions) {
            if (commandLineOptionsToRemove.contains(option)) continue;
            filteredCommandLineOptions.add(option);
        }
        ArrayList<String> arrayList = filteredCommandLineOptions;
        if (arrayList == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(65);
        }
        return arrayList;
    }

    public static boolean isClangTidyFile(@NotNull File file) {
        if (file == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(66);
        }
        return file.getName().equals(".clang-tidy");
    }

    public static boolean isClangTidyFile(@NotNull VirtualFile file) {
        if (file == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(67);
        }
        return file.getName().equals(".clang-tidy");
    }

    public static void dumpClangTidyFiles(@NotNull ClangTidyFilesState state, @NotNull Logger logger) {
        if (state == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(68);
        }
        if (logger == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(69);
        }
        logger.debug("Clang-Tidy files in project: [" + StringUtil.join(state.getClangTidyFiles(), (String)",") + "]");
    }

    private static boolean hasDocumentationPage(@NotNull String checkName) {
        if (checkName == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(70);
        }
        return !checkName.startsWith("clang-analyzer") || clangAnalyzerChecksWithDocumentation.contains(checkName);
    }

    private static boolean groupOrCheckEnabled(@NotNull String option, @NotNull String checkName) {
        if (option == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(71);
        }
        if (checkName == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(72);
        }
        return option.equals(checkName) || option.length() > 1 && option.endsWith("*") && checkName.startsWith(option.substring(0, option.length() - 1));
    }

    private static boolean groupOrCheckDisabled(@NotNull String option, @NotNull String checkName) {
        if (option == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(73);
        }
        if (checkName == null) {
            CommonClangTidyUtil.$$$reportNull$$$0(74);
        }
        if (!option.startsWith("-")) {
            return false;
        }
        if (option.endsWith("*")) {
            return option.length() > 2 && checkName.startsWith(option.substring(1, option.length() - 1));
        }
        return option.length() > 1 && checkName.equals(option.substring(1));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 5, 6, 7, 8, 9, 11, 12, 13, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 29, 30, 32, 33, 35, 37, 38, 39, 40, 42, 43, 45, 46, 47, 48, 49, 51, 52, 54, 56, 57, 58, 59, 61, 63, 66, 67, 68, 69, 70, 71, 72, 73, 74 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/tidy/CommonClangTidyUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputWriter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerExecutable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerWorkingDirectory";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerOptions";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputFile";
                break;
            }
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: 
            case 15: 
            case 19: 
            case 66: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnostic";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionId";
                break;
            }
            case 29: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checks";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkOptions";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checksA";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checksB";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configA";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configB";
                break;
            }
            case 39: 
            case 42: 
            case 48: 
            case 51: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 40: 
            case 43: 
            case 54: 
            case 58: 
            case 61: 
            case 70: 
            case 72: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkName";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checksState";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspection";
                break;
            }
            case 47: 
            case 71: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 49: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupName";
                break;
            }
            case 57: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineOptions";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFileExtensions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getClangTidyPath";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 63: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/CommonClangTidyUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "generateVfsOverlay";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuiltinClangTidyPath";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getOurInspections";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "findTools";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getClangTidyConfig";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "concatClangTidyChecks";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledChecks";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "enableCheck";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "disableCheck";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "enableGroup";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "disableGroup";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getCheckNameWithoutGroup";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "toCheckOptionsMap";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "buildClangTidyHelpPage";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "filterSpecificCLionCommandLineOptions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "generateVfsOverlay";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "writeCompilationDatabase";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isToolEnabled";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getOurInspections";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getMisraInspection";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getClangTidyInspection";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findInspectionFromClangTidyDiagnostic";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getClazyInspection";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isMisraInspection";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isClazyInspection";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findTool";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findTools";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getClangTidyConfig";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "concatClangTidyChecks";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getEnabledChecks";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "joinChecks";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "enableCheck";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "disableCheck";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "modifyAllChecksWithSingleGroup";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getGroupName";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "enableGroup";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "disableGroup";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getCheckNameWithoutGroup";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getTrimmedOptions";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isDisabled";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "toCheckOptionsMap";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "buildClangTidyHelpPage";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "filterSpecificCLionCommandLineOptions";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "isClangTidyFile";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "dumpClangTidyFiles";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "hasDocumentationPage";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "groupOrCheckEnabled";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "groupOrCheckDisabled";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 5, 6, 7, 8, 9, 11, 12, 13, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 29, 30, 32, 33, 35, 37, 38, 39, 40, 42, 43, 45, 46, 47, 48, 49, 51, 52, 54, 56, 57, 58, 59, 61, 63, 66, 67, 68, 69, 70, 71, 72, 73, 74 -> new IllegalArgumentException(string);
        };
    }
}

