/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.JavaXmlDocumentKt;
import com.intellij.util.ResourceUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.CidrPathManager;
import com.jetbrains.cidr.lang.daemon.clang.tidy.CommonClangTidyUtil;
import com.jetbrains.cidr.lang.daemon.clang.tidy.InspectionDescriptionProvider;
import com.jetbrains.cidr.lang.editor.colors.OCHighlightingKeys;
import java.awt.Color;
import java.awt.Font;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ClangTidyInspectionDescriptionProvider
extends InspectionDescriptionProvider {
    private static final String CLANG_TIDY_CSS_PLACEHOLDER = "/* CLION CLANG-TIDY DOCUMENTATION CSS PLACEHOLDER */";
    private static final Character[] PUNCTUATORS = new Character[]{Character.valueOf('.'), Character.valueOf('!'), Character.valueOf('?'), Character.valueOf(':'), Character.valueOf(';')};

    @Override
    @Nullable
    public String getTooltip(@NotNull String checkName) throws Exception {
        Document document;
        if (checkName == null) {
            ClangTidyInspectionDescriptionProvider.$$$reportNull$$$0(0);
        }
        if ((document = ClangTidyInspectionDescriptionProvider.buildHtmlDocument(checkName)) == null) {
            return "";
        }
        Node descriptionNode = ClangTidyInspectionDescriptionProvider.findFirstParagraphWithDescription(document.getChildNodes(), checkName);
        if (descriptionNode == null) {
            return "";
        }
        String text = descriptionNode.getTextContent();
        text = ClangTidyInspectionDescriptionProvider.trimWhitespaces(text);
        text = ClangTidyInspectionDescriptionProvider.replaceTrailingPunctuatorsWithDots(text);
        return text;
    }

    @Override
    @Nullable
    public String getHtmlDescription(@NotNull String checkName) throws Exception {
        String descriptionPath;
        if (checkName == null) {
            ClangTidyInspectionDescriptionProvider.$$$reportNull$$$0(1);
        }
        if (!FileUtil.exists((String)(descriptionPath = ClangTidyInspectionDescriptionProvider.getBundledDescriptionPath(checkName)))) {
            return null;
        }
        try (FileInputStream stream = new FileInputStream(descriptionPath);){
            String descriptionText = ResourceUtil.loadText((InputStream)stream);
            String string = descriptionText = ClangTidyInspectionDescriptionProvider.replaceCssPlaceholder(descriptionText);
            return string;
        }
    }

    @Override
    public boolean hasHtmlDescription(@NotNull String checkName) {
        if (checkName == null) {
            ClangTidyInspectionDescriptionProvider.$$$reportNull$$$0(2);
        }
        return FileUtil.exists((String)ClangTidyInspectionDescriptionProvider.getBundledDescriptionPath(checkName));
    }

    @Override
    public boolean hasAnyHtmlDescription() {
        return true;
    }

    @NotNull
    @NlsSafe
    private static String replaceCssPlaceholder(@NotNull String text) throws Exception {
        if (text == null) {
            ClangTidyInspectionDescriptionProvider.$$$reportNull$$$0(3);
        }
        StringBuilder cssTagsBuilder = new StringBuilder();
        for (String cssFile : ClangTidyInspectionDescriptionProvider.getBundledCssFiles()) {
            cssTagsBuilder.append(ClangTidyInspectionDescriptionProvider.createCssLinkElement(cssFile));
        }
        cssTagsBuilder.append(ClangTidyInspectionDescriptionProvider.createInlinePygmentsCssElement());
        String string = text.replace(CLANG_TIDY_CSS_PLACEHOLDER, cssTagsBuilder.toString());
        if (string == null) {
            ClangTidyInspectionDescriptionProvider.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    private static String replaceTrailingPunctuatorsWithDots(@NotNull @NlsSafe String description) {
        int finalEndIndex;
        if (description == null) {
            ClangTidyInspectionDescriptionProvider.$$$reportNull$$$0(5);
        }
        int endIndex = description.length();
        while (endIndex > 0 && ContainerUtil.exists((Object[])PUNCTUATORS, arg_0 -> ClangTidyInspectionDescriptionProvider.lambda$replaceTrailingPunctuatorsWithDots$0(description, finalEndIndex = endIndex--, arg_0))) {
        }
        String string = description.substring(0, endIndex) + "...";
        if (string == null) {
            ClangTidyInspectionDescriptionProvider.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    private static Document buildHtmlDocument(@NotNull String checkName) throws Exception {
        String descriptionPath;
        if (checkName == null) {
            ClangTidyInspectionDescriptionProvider.$$$reportNull$$$0(7);
        }
        if (!FileUtil.exists((String)(descriptionPath = ClangTidyInspectionDescriptionProvider.getBundledDescriptionPath(checkName)))) {
            return null;
        }
        try (FileInputStream stream = new FileInputStream(descriptionPath);){
            Document document = JavaXmlDocumentKt.createDocumentBuilder().parse(new InputSource(stream));
            return document;
        }
    }

    private static Node findFirstParagraphWithDescription(@NotNull NodeList nodes, @NotNull String checkName) {
        if (nodes == null) {
            ClangTidyInspectionDescriptionProvider.$$$reportNull$$$0(8);
        }
        if (checkName == null) {
            ClangTidyInspectionDescriptionProvider.$$$reportNull$$$0(9);
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!node.getNodeName().equals("section") || !ClangTidyInspectionDescriptionProvider.hasAttributes(node, Pair.pair((Object)"id", (Object)checkName))) {
                Node descriptionInChildNodes = ClangTidyInspectionDescriptionProvider.findFirstParagraphWithDescription(node.getChildNodes(), checkName);
                if (descriptionInChildNodes == null) continue;
                return descriptionInChildNodes;
            }
            NodeList childNodes = node.getChildNodes();
            for (int j = 0; j < childNodes.getLength(); ++j) {
                Node childNode = childNodes.item(j);
                if (!childNode.getNodeName().equals("p")) continue;
                return childNode;
            }
        }
        return null;
    }

    private static boolean hasAttributes(@NotNull Node node, Pair<String, String> ... attributes) {
        if (node == null) {
            ClangTidyInspectionDescriptionProvider.$$$reportNull$$$0(10);
        }
        if (!node.hasAttributes()) {
            return false;
        }
        NamedNodeMap nodeAttributes = node.getAttributes();
        for (Pair<String, String> attribute : attributes) {
            String attributeValue;
            Node classNode = nodeAttributes.getNamedItem((String)attribute.first);
            if (classNode == null || StringUtil.isEmpty((String)(attributeValue = classNode.getNodeValue())) || !attributeValue.equals(attribute.second)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static String trimWhitespaces(@NotNull String text) {
        if (text == null) {
            ClangTidyInspectionDescriptionProvider.$$$reportNull$$$0(11);
        }
        String string = text.replaceAll("[ \t]+", " ").replaceAll("\n ", "\n");
        if (string == null) {
            ClangTidyInspectionDescriptionProvider.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    private static String createInlinePygmentsCssElement() {
        String string = "<style>\n" + ClangTidyInspectionDescriptionProvider.getPygmentsCssContent() + "\n</style>";
        if (string == null) {
            ClangTidyInspectionDescriptionProvider.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    private static String createCssLinkElement(@NotNull String cssFilePath) {
        if (cssFilePath == null) {
            ClangTidyInspectionDescriptionProvider.$$$reportNull$$$0(14);
        }
        String string = "<link rel=\"stylesheet\" type=\"text/css\" href=" + StringUtil.wrapWithDoubleQuote((String)cssFilePath) + "/>";
        if (string == null) {
            ClangTidyInspectionDescriptionProvider.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private static String getBundledDescriptionPath(@NotNull String checkName) {
        if (checkName == null) {
            ClangTidyInspectionDescriptionProvider.$$$reportNull$$$0(16);
        }
        String groupName = CommonClangTidyUtil.getGroupName(checkName);
        String checkNameWithoutGroup = CommonClangTidyUtil.getCheckNameWithoutGroup(checkName);
        if (groupName.equals("linuxkernel") && checkNameWithoutGroup.equals("must-check-errs")) {
            checkNameWithoutGroup = "must-use-errs";
        }
        String string = FileUtil.join((String[])new String[]{ClangTidyInspectionDescriptionProvider.getDocumentationBasePath(), groupName, checkNameWithoutGroup + ".html"});
        if (string == null) {
            ClangTidyInspectionDescriptionProvider.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    public static List<String> getBundledCssFiles() {
        String[] cssFileNames = new String[]{"basic.css", "haiku.css", "clang-tools-extra-styles.css"};
        ArrayList<String> cssFilePaths = new ArrayList<String>(cssFileNames.length);
        String basePath = ClangTidyInspectionDescriptionProvider.getDocumentationBasePath();
        for (String cssFileName : cssFileNames) {
            cssFilePaths.add(FileUtil.join((String[])new String[]{basePath, cssFileName}));
        }
        ArrayList<String> arrayList = cssFilePaths;
        if (arrayList == null) {
            ClangTidyInspectionDescriptionProvider.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    @NotNull
    @NlsSafe
    private static String getPygmentsCssContent() {
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getSchemeForCurrentUITheme();
        Map highlightClassesToColor = Map.ofEntries(Map.entry(new String[]{".o", ".nc", ".nf", ".nn", ".vm", ".vi", ".vg", ".vc", ".nv", ".nn", ".nl", ".ne", ".no"}, ClangTidyInspectionDescriptionProvider.toRgbColor(UIUtil.getLabelForeground())), Map.entry(new String[]{".c", ".c1", ".cm", ".ch"}, ClangTidyInspectionDescriptionProvider.toForegroundRgbColor(scheme.getAttributes(OCHighlightingKeys.OC_LINE_COMMENT))), Map.entry(new String[]{".k", ".kt", ".nb", ".kr", ".sa", ".kn", ".kd", ".kc", ".bp"}, ClangTidyInspectionDescriptionProvider.toForegroundRgbColor(scheme.getAttributes(OCHighlightingKeys.OC_KEYWORD))), Map.entry(new String[]{".mi", ".il", ".mo", ".mh", ".mb", ".mf"}, ClangTidyInspectionDescriptionProvider.toForegroundRgbColor(scheme.getAttributes(OCHighlightingKeys.OC_NUMBER))), Map.entry(new String[]{".cp", ".cpf"}, ClangTidyInspectionDescriptionProvider.toForegroundRgbColor(scheme.getAttributes(OCHighlightingKeys.OC_DIRECTIVE))), Map.entry(new String[]{".sc", ".s"}, ClangTidyInspectionDescriptionProvider.toForegroundRgbColor(scheme.getAttributes(OCHighlightingKeys.OC_STRING))));
        String[] labelCssClasses = new String[]{"p", "h1", "h2", "h3", "dt", "pre", ".pre", ".line"};
        String[] panelBackgroundCssClasses = new String[]{"body", "code", ".highlight"};
        String[] italicFontStyles = new String[]{".c", ".ch", ".cm", ".cpf", ".c1", ".si", ".sd"};
        ArrayList<String> cssStyles = new ArrayList<String>();
        cssStyles.add(ClangTidyInspectionDescriptionProvider.createCssStyle("pre", "line-height", "125%"));
        cssStyles.add(ClangTidyInspectionDescriptionProvider.createCssStyle("dt:target, span.highlighted", "background-color", "transparent"));
        for (Map.Entry highlightClassToColor : highlightClassesToColor.entrySet()) {
            for (String highlightClass : (String[])highlightClassToColor.getKey()) {
                cssStyles.add(ClangTidyInspectionDescriptionProvider.createHighlightForegroundCssStyle(highlightClass, (String)highlightClassToColor.getValue()));
            }
        }
        for (String labelCssClass : labelCssClasses) {
            cssStyles.add(ClangTidyInspectionDescriptionProvider.createCssStyle(labelCssClass, "color", ClangTidyInspectionDescriptionProvider.toRgbColor(UIUtil.getLabelForeground())));
        }
        for (String panelBackgroundCssClass : panelBackgroundCssClasses) {
            cssStyles.add(ClangTidyInspectionDescriptionProvider.createCssStyle(panelBackgroundCssClass, "background", ClangTidyInspectionDescriptionProvider.toRgbColor(UIUtil.getPanelBackground())));
        }
        for (String italicFontStyle : italicFontStyles) {
            cssStyles.add(ClangTidyInspectionDescriptionProvider.createCssStyle(italicFontStyle, "font-style", "italic"));
        }
        cssStyles.add(ClangTidyInspectionDescriptionProvider.createCssStyle("a:link, a:visited, a:active, a .pre", "color", ClangTidyInspectionDescriptionProvider.toRgbColor(JBUI.CurrentTheme.Link.Foreground.ENABLED)));
        Font ideFont = StartupUiUtil.getLabelFont();
        String[] familyFonts = new String[]{StringUtil.wrapWithDoubleQuote((String)ideFont.getName()), StringUtil.wrapWithDoubleQuote((String)"DejaVu Sans"), "Arial", "Helvetica", "sans-serif"};
        cssStyles.add(ClangTidyInspectionDescriptionProvider.createCssStyle("body", "font-family", StringUtil.join((String[])familyFonts, (String)",")));
        cssStyles.add(ClangTidyInspectionDescriptionProvider.createCssStyle("body", "font-size", ideFont.getSize() + "px"));
        cssStyles.add(ClangTidyInspectionDescriptionProvider.createCssStyle("pre", "font-family", "monospace"));
        String string = StringUtil.join(cssStyles, (String)"\n");
        if (string == null) {
            ClangTidyInspectionDescriptionProvider.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    private static String createHighlightForegroundCssStyle(@NotNull String childCssClass, @NotNull String value) {
        if (childCssClass == null) {
            ClangTidyInspectionDescriptionProvider.$$$reportNull$$$0(20);
        }
        if (value == null) {
            ClangTidyInspectionDescriptionProvider.$$$reportNull$$$0(21);
        }
        return ClangTidyInspectionDescriptionProvider.createCssStyle(".highlight " + childCssClass, "color", value);
    }

    @NotNull
    private static String createCssStyle(@NotNull String elementsOrClasses, @NotNull String property, @NotNull String value) {
        if (elementsOrClasses == null) {
            ClangTidyInspectionDescriptionProvider.$$$reportNull$$$0(22);
        }
        if (property == null) {
            ClangTidyInspectionDescriptionProvider.$$$reportNull$$$0(23);
        }
        if (value == null) {
            ClangTidyInspectionDescriptionProvider.$$$reportNull$$$0(24);
        }
        String string = elementsOrClasses + " {" + property + ": " + value + "; }";
        if (string == null) {
            ClangTidyInspectionDescriptionProvider.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    private static String toForegroundRgbColor(@NotNull TextAttributes attributes) {
        if (attributes == null) {
            ClangTidyInspectionDescriptionProvider.$$$reportNull$$$0(26);
        }
        return ClangTidyInspectionDescriptionProvider.toRgbColor(attributes.getForegroundColor());
    }

    @NotNull
    private static String toRgbColor(@NotNull Color color) {
        if (color == null) {
            ClangTidyInspectionDescriptionProvider.$$$reportNull$$$0(27);
        }
        String string = "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
        if (string == null) {
            ClangTidyInspectionDescriptionProvider.$$$reportNull$$$0(28);
        }
        return string;
    }

    @NotNull
    private static String getDocumentationBasePath() {
        String string = CidrPathManager.getBinPath(ClangTidyInspectionDescriptionProvider.class, (String)"cidr-lang/bin", (String)"clang/clangTidyDoc", null, (boolean)false, (boolean)false).toString();
        if (string == null) {
            ClangTidyInspectionDescriptionProvider.$$$reportNull$$$0(29);
        }
        return string;
    }

    private static /* synthetic */ boolean lambda$replaceTrailingPunctuatorsWithDots$0(String description, int finalEndIndex, Character p) {
        return description.charAt(finalEndIndex - 1) == p.charValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 12, 13, 15, 17, 18, 19, 25, 28, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkName";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 6: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 25: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyInspectionDescriptionProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cssFilePath";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childCssClass";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsOrClasses";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyInspectionDescriptionProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceCssPlaceholder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceTrailingPunctuatorsWithDots";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "trimWhitespaces";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createInlinePygmentsCssElement";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createCssLinkElement";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundledDescriptionPath";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundledCssFiles";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getPygmentsCssContent";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createCssStyle";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "toRgbColor";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentationBasePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTooltip";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getHtmlDescription";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasHtmlDescription";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "replaceCssPlaceholder";
                break;
            }
            case 4: 
            case 6: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 25: 
            case 28: 
            case 29: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "replaceTrailingPunctuatorsWithDots";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildHtmlDocument";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findFirstParagraphWithDescription";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasAttributes";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "trimWhitespaces";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createCssLinkElement";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getBundledDescriptionPath";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createHighlightForegroundCssStyle";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createCssStyle";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "toForegroundRgbColor";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "toRgbColor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 12, 13, 15, 17, 18, 19, 25, 28, 29 -> new IllegalStateException(string);
        };
    }
}

