/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.google.common.base.Charsets;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangToolsWslService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ThrowableFunction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.WslContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdCompilationCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Cpp20ModulesContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponse;
import com.jetbrains.cidr.lang.daemon.clang.clangd.reparsing.OCLanguageServiceReparsingPassListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangTidyFilesState;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.ClangProjectScanStartupActivity;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.ClangTraverseUtil;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotationApplier;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotationApplierProvider;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotationHolder;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotatorDebugInfoBuilder;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotatorExecutionConfig;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotatorInfo;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDocumentListener;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyResolveInfoProvider;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyYamlLoader;
import com.jetbrains.cidr.lang.daemon.clang.tidy.CommonClangTidyUtil;
import com.jetbrains.cidr.lang.daemon.clang.tidy.DefaultClangTidyAnnotatorConfig;
import com.jetbrains.cidr.lang.daemon.clang.tidy.OverlayMapping;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspection;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspectionAnnotatorExecutionConfig;
import com.jetbrains.cidr.lang.inspections.MisraInspection;
import com.jetbrains.cidr.lang.inspections.MisraInspectionAnnotatorExecutionConfig;
import com.jetbrains.cidr.lang.psi.OCFragmentVirtualFile;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.compiler.AppleClangCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.ClangClCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.ClangCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.yaml.snakeyaml.error.YAMLException;

public class ClangTidyAnnotator
extends ExternalAnnotator<ClangTidyAnnotatorInfo, ClangTidyAnnotationHolder> {
    public static final Key<Boolean> RUN_IN_UNIT_TEST_MODE = Key.create((String)"CLANG_TIDY_ANNOTATOR_RUN_IN_UNIT_TEST_MODE");
    public static final Key<Boolean> TAKE_CLION_CONFIG = Key.create((String)"CLANG_TIDY_ANNOTATOR_TAKE_CLION_CONFIG");
    public static final Key<Boolean> TAKE_TIDY_CONFIG = Key.create((String)"CLANG_TIDY_ANNOTATOR_TAKE_TIDY_CONFIG");
    public static final Key<Boolean> COLLECT_DEBUG_INFORMATION = Key.create((String)"CLANG_TIDY_COLLECT_DEBUG_INFORMATION");
    public static final Key<String> DEBUG_INFORMATION = Key.create((String)"CLANG_TIDY_DEBUG_INFORMATION");
    public static final Key<AtomicBoolean> HAS_DOCUMENT_LISTENER = Key.create((String)"CLANG_TIDY_HAS_DOCUMENT_LISTENER");
    public static final Key<MyMasterReparsingPassListener> REPARSING_PASS_LISTENER = Key.create((String)"CLANG_TIDY_REPARSING_PASS_LISTENER");
    private static final Logger LOG = Logger.getInstance(ClangTidyAnnotator.class);
    private static final ClangTidyDocumentListener DOCUMENT_LISTENER = new ClangTidyDocumentListener();
    private final ClangTidyResolveInfoProvider myResolveInfoProvider;
    private final ClangTidyAnnotatorExecutionConfig myExecutionConfig;

    public ClangTidyAnnotator() {
        this(new DefaultClangTidyAnnotatorConfig());
    }

    @TestOnly
    public ClangTidyAnnotator(@Nullable ClangTidyInspection inspection) {
        this(inspection != null ? new ClangTidyInspectionAnnotatorExecutionConfig(inspection) : new DefaultClangTidyAnnotatorConfig());
    }

    @TestOnly
    public ClangTidyAnnotator(@NotNull MisraInspection inspection) {
        if (inspection == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(0);
        }
        this(new MisraInspectionAnnotatorExecutionConfig(inspection));
    }

    public ClangTidyAnnotator(@NotNull ClangTidyAnnotatorExecutionConfig executionConfig) {
        if (executionConfig == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(1);
        }
        this.myResolveInfoProvider = ClangTidyResolveInfoProvider.getInstance();
        this.myExecutionConfig = executionConfig;
    }

    @Nullable
    public ClangTidyAnnotatorInfo collectInformation(@NotNull PsiFile psiFile, @NotNull Editor editor, boolean hasErrors) {
        if (psiFile == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(3);
        }
        return this.collectInformationImpl(psiFile, editor);
    }

    @Nullable
    public ClangTidyAnnotatorInfo collectInformation(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(4);
        }
        return this.collectInformationImpl(psiFile, null);
    }

    @Nullable
    private ClangTidyAnnotatorInfo collectInformationImpl(@NotNull PsiFile file, @Nullable Editor editor) {
        if (file == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(5);
        }
        Project project = file.getProject();
        if (ApplicationManager.getApplication().isUnitTestMode() && project.getUserData(RUN_IN_UNIT_TEST_MODE) != Boolean.TRUE) {
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null || virtualFile instanceof OCFragmentVirtualFile) {
            return null;
        }
        String inputFileName = PathUtil.getFileName((String)virtualFile.getPath());
        if (!this.myResolveInfoProvider.isInProjectSources(file)) {
            return null;
        }
        ClangUtils.ResolveInfo resolveInfo = this.myResolveInfoProvider.getResolveInfo(file, project);
        if (resolveInfo == null) {
            return null;
        }
        OCResolveConfiguration configuration = resolveInfo.configuration;
        VirtualFile rootVirtualFile = resolveInfo.root;
        OCLanguageKind languageKind = resolveInfo.languageKind;
        OCCompilerSettings compilerSettings = configuration.getCompilerSettings(languageKind, virtualFile);
        OCCompilerKind compiler = compilerSettings.getCompilerKind();
        File compilerExecutable = compilerSettings.getCompilerExecutable();
        File compilerWorkingDir = compilerSettings.getCompilerWorkingDir();
        CidrCompilerSwitches compilerSwitches = compilerSettings.getCompilerSwitches();
        if (compiler == null || compilerExecutable == null || compilerWorkingDir == null || compilerSwitches == null) {
            return null;
        }
        List headerPaths = configuration.getCompilerSettings(languageKind, rootVirtualFile).getHeadersSearchPaths();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        if (document == null) {
            return null;
        }
        return new ClangTidyAnnotatorInfo(inputFileName, project, file, languageKind, configuration, compilerSettings, compiler, compilerExecutable, compilerWorkingDir, compilerSwitches, rootVirtualFile, headerPaths, document, editor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ClangTidyAnnotationHolder doAnnotate(@Nullable ClangTidyAnnotatorInfo info) {
        ClangTidyAnnotationHolder clangTidyAnnotationHolder;
        block6: {
            if (info == null) {
                return null;
            }
            ClangTidyAnnotator.tryRegisterDocumentListener(info);
            File workingDirectory = null;
            try {
                ClangTidyAnnotator.prepareClangTidyFiles(info);
                workingDirectory = FileUtil.createTempDirectory((String)"clion-clang-tidy", null, (boolean)true);
                clangTidyAnnotationHolder = this.executeClangTidy(info, workingDirectory);
                if (workingDirectory == null) break block6;
            }
            catch (com.intellij.execution.ExecutionException | IOException | YAMLException exc) {
                ClangTidyAnnotationHolder clangTidyAnnotationHolder2;
                block7: {
                    try {
                        LOG.warn(exc);
                        clangTidyAnnotationHolder2 = ClangTidyAnnotationHolder.error(exc.getMessage());
                        if (workingDirectory == null) break block7;
                    }
                    catch (Throwable throwable) {
                        if (workingDirectory != null) {
                            FileUtil.delete(workingDirectory);
                        }
                        throw throwable;
                    }
                    FileUtil.delete((File)workingDirectory);
                }
                return clangTidyAnnotationHolder2;
            }
            FileUtil.delete((File)workingDirectory);
        }
        return clangTidyAnnotationHolder;
    }

    public static boolean isAvailable() {
        return ClangTidyAnnotator.isAvailable((File)ClangUtils.getClangdPath().first) || ClangTidyAnnotator.isAvailable(CommonClangTidyUtil.getBuiltinClangTidyPath());
    }

    private static void prepareClangTidyFiles(ClangTidyAnnotatorInfo info) {
        ClangLanguageService languageService;
        FileDocumentManager manager = FileDocumentManager.getInstance();
        Application application = ApplicationManager.getApplication();
        Document[] unsavedDocuments = (Document[])ReadAction.compute(() -> manager.getUnsavedDocuments());
        boolean forceReparseRequired = false;
        for (Document document : unsavedDocuments) {
            VirtualFile file = manager.getFile(document);
            if (file == null || !file.getName().equals(".clang-tidy")) continue;
            application.invokeAndWait(() -> application.runWriteAction(() -> manager.saveDocument(document)));
            forceReparseRequired = true;
        }
        if (forceReparseRequired && (languageService = ClangLanguageServiceProvider.getIfStarted(info.getProject())) != null) {
            application.invokeAndWait(() -> languageService.notifyReparseRequired(info.getFile().getVirtualFile()));
        }
    }

    @Nullable
    private ClangTidyAnnotationHolder executeClangTidy(@NotNull ClangTidyAnnotatorInfo info, @NotNull File workingDirectory) throws IOException, com.intellij.execution.ExecutionException {
        if (info == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(6);
        }
        if (workingDirectory == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(7);
        }
        return ClangTidyAnnotator.useLanguageService(info) ? this.executeClangTidyViaClangd(info) : this.executeStandaloneClangTidy(info, workingDirectory);
    }

    @Nullable
    private ClangTidyAnnotationHolder executeStandaloneClangTidy(@NotNull ClangTidyAnnotatorInfo info, @NotNull File workingDirectory) throws IOException, com.intellij.execution.ExecutionException {
        ProcessOutput processOutput2;
        WSLDistribution wslDistribution;
        File clangTidyPath;
        if (info == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(8);
        }
        if (workingDirectory == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(9);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Executing standalone clang-tidy for " + info.getFile().getViewProvider().getVirtualFile().getPath());
        }
        if (!ClangTidyAnnotator.isAvailable(clangTidyPath = CommonClangTidyUtil.getClangTidyPath())) {
            return ClangTidyAnnotationHolder.error(ClangdBundle.message("inspection.clangTidy.not.found", new Object[0]));
        }
        boolean isBuiltinClangTidyUsed = FileUtil.filesEqual((File)clangTidyPath, (File)CommonClangTidyUtil.getBuiltinClangTidyPath());
        WslContext wslCtx = isBuiltinClangTidyUsed ? ClangToolsWslService.Companion.getInstance(info.getProject()).getWslContext() : null;
        String wslMsId = wslCtx != null ? wslCtx.getId() : null;
        ClangUrlConverter converter = new ClangUrlConverter();
        WSLDistribution wSLDistribution = wslDistribution = wslCtx != null ? wslCtx.getDistribution() : null;
        if (wslMsId != null) {
            converter.setWslMsId(wslMsId);
            converter.setWslMntRoot(wslCtx.getMountRoot());
        }
        Document document = info.getDocument();
        long modificationStampOnStart = document.getModificationStamp();
        File inputFile = new File(info.getFile().getVirtualFile().getPath());
        OverlayMapping overlayMapping = ClangTidyAnnotator.generateVfsOverlays(workingDirectory);
        File vfsOverlay = ClangTidyAnnotator.generateVfsOverlay(overlayMapping, workingDirectory, converter);
        File outputFile = new File(workingDirectory, "output.yaml");
        ClangTidyAnnotatorDebugInfoBuilder debugInfoBuilder = new ClangTidyAnnotatorDebugInfoBuilder();
        File compilationDatabase = ClangTidyAnnotator.createCompilationDatabase(info, workingDirectory, inputFile, debugInfoBuilder, converter);
        if (ClangTidyAnnotator.collectDebugInformation(info)) {
            debugInfoBuilder.setCompilationDatabase(FileUtil.loadFile((File)compilationDatabase));
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        if (converter.isWslMode()) {
            commandLine.setExePath(ClangUtils.getWslClangdDirPath(info.getProject()) + "/clang-tidy");
        } else {
            commandLine.setExePath(clangTidyPath.getAbsolutePath());
        }
        ClangTidyFilesState clangTidyFilesState = (ClangTidyFilesState)info.getProject().getService(ClangTidyFilesState.class);
        if (!this.myExecutionConfig.isPreferClangTidyFilesOverIDESettings(info.getProject()) || !ClangTidyAnnotator.hasClangTidyFilesInPath(inputFile, clangTidyFilesState)) {
            commandLine.addParameter("-config=" + this.myExecutionConfig.getConfig(info.getProject()));
        } else {
            commandLine.addParameter("-checks=-clion-*");
        }
        commandLine.addParameter("-p=" + ClangTidyAnnotator.fixWslPathIfRequired(workingDirectory.getPath(), converter));
        commandLine.addParameter("-vfsoverlay=" + ClangTidyAnnotator.fixWslPathIfRequired(vfsOverlay.getPath(), converter));
        commandLine.addParameter("-export-fixes=" + ClangTidyAnnotator.fixWslPathIfRequired(outputFile.getPath(), converter));
        commandLine.addParameter(ClangTidyAnnotator.fixWslPathIfRequired(inputFile.getAbsolutePath(), converter));
        if (converter.isWslMode() && wslDistribution != null) {
            commandLine = wslDistribution.patchCommandLine(commandLine, info.getProject(), new WSLCommandLineOptions());
        }
        if (ClangTidyAnnotator.collectDebugInformation(info)) {
            debugInfoBuilder.setCommandLine(commandLine.toString());
        }
        CapturingProcessHandler processHandler = ClangTidyAnnotator.createCapturedProcessHandler(commandLine);
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (modificationStampOnStart != document.getModificationStamp()) {
            return null;
        }
        ProcessOutput processOutput3 = processOutput2 = progressIndicator != null ? processHandler.runProcessWithProgressIndicator(progressIndicator) : processHandler.runProcess();
        if (processOutput2.getExitCode() != 0) {
            LOG.debug("Clang-Tidy finished with error: " + processOutput2.getStderr());
        }
        if (ClangTidyAnnotator.collectDebugInformation(info)) {
            debugInfoBuilder.setOutput(outputFile.exists() ? FileUtil.loadFile((File)outputFile) : "");
            info.getFile().putUserData(DEBUG_INFORMATION, (Object)debugInfoBuilder.build());
        }
        List diagnostics = outputFile.exists() ? ClangTidyAnnotator.loadDiagnosticsFromYaml(outputFile, inputFile, overlayMapping, converter) : Collections.emptyList();
        return ClangTidyAnnotationHolder.success(diagnostics);
    }

    private static boolean hasClangTidyFilesInPath(File inputFile, ClangTidyFilesState clangTidyFilesState) {
        ClangProjectScanStartupActivity projectScanStartupActivity = (ClangProjectScanStartupActivity)StartupActivity.Companion.getPOST_STARTUP_ACTIVITY().findExtension(ClangProjectScanStartupActivity.class);
        if (projectScanStartupActivity != null && projectScanStartupActivity.isInitialScanFinished()) {
            return clangTidyFilesState.hasClangTidyFilesInPath(inputFile);
        }
        File directory = inputFile.getParentFile();
        Ref hasClangTidyFiles = Ref.create((Object)false);
        ClangTraverseUtil.traverseFiles(directory, false, true, (Processor<? super File>)((Processor)file -> {
            if (CommonClangTidyUtil.isClangTidyFile(file)) {
                hasClangTidyFiles.set((Object)true);
                return false;
            }
            return true;
        }));
        return (Boolean)hasClangTidyFiles.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ClangTidyAnnotationHolder executeClangTidyViaClangd(@NotNull ClangTidyAnnotatorInfo info) {
        ProgressIndicator currentIndicator;
        if (info == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(10);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Executing clang-tidy via clangd for " + info.getFile().getViewProvider().getVirtualFile().getPath());
        }
        SensitiveProgressWrapper newIndicator = (currentIndicator = ProgressManager.getInstance().getProgressIndicator()) != null ? new SensitiveProgressWrapper(currentIndicator) : new ProgressIndicatorBase();
        Ref result = Ref.create();
        MyMasterReparsingPassListener masterListener = ClangTidyAnnotator.trySubscribeForClangReparsingPass(info.getProject());
        MySlaveReparsingPassListener slaveListener = new MySlaveReparsingPassListener((ProgressIndicator)newIndicator, info.getFile());
        try {
            masterListener.addListener(slaveListener);
            ProgressManager.getInstance().runProcess(() -> {
                Boolean isFileValid = (Boolean)ReadAction.compute(() -> info.getFile().isValid());
                if (!isFileValid.booleanValue()) {
                    return;
                }
                ClangLanguageService languageService = ClangLanguageServiceProvider.getOrStart(info.getProject());
                if (languageService == null) {
                    return;
                }
                result.set((Object)this.doExecuteClangTidyViaClangd(info, response -> {
                    if (response == null) {
                        return null;
                    }
                    try {
                        ArrayList diagnostics = new ArrayList();
                        for (Future<Supplier<List<ClangTidyDiagnostic>>> future : this.myExecutionConfig.getTidyDiagnosticsFutures((ClangParseResponse)response, info.getProject())) {
                            Supplier supplier = (Supplier)CidrConcurrentUtilsKt.waitCancelAndWriteActionAware(future, (long)Long.MAX_VALUE, (String)"Clang-tidy diagnostics");
                            if (supplier != null) {
                                List diags = (List)supplier.get();
                                if (diags != null) {
                                    diagnostics.addAll(diags);
                                    continue;
                                }
                                return null;
                            }
                            return null;
                        }
                        return ClangTidyAnnotationHolder.success(diagnostics);
                    }
                    catch (ExecutionException | TimeoutException exception) {
                        return null;
                    }
                }));
            }, (ProgressIndicator)newIndicator);
        }
        finally {
            masterListener.removeListener(slaveListener);
        }
        return (ClangTidyAnnotationHolder)result.get();
    }

    private ClangTidyAnnotationHolder doExecuteClangTidyViaClangd(@NotNull ClangTidyAnnotatorInfo info, @NotNull ThrowableFunction<ClangParseResponse, ClangTidyAnnotationHolder, RuntimeException> consumer) {
        ClangLanguageService languageService;
        if (info == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(11);
        }
        if (consumer == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(12);
        }
        if ((languageService = ClangLanguageServiceProvider.getOrStart(info.getProject())) == null) {
            return null;
        }
        if (this.myExecutionConfig.isCustomChecksConfiguration(info.getProject())) {
            return languageService.computeWithOpenedAndCustomParsed(info.getFile().getVirtualFile(), params -> this.myExecutionConfig.transformReparseParams(params, info.getProject()), consumer);
        }
        return languageService.computeWithOpenedAndParsed(info.getFile().getVirtualFile(), consumer);
    }

    protected static OverlayMapping generateVfsOverlays(@NotNull File workingDirectory) throws IOException {
        if (workingDirectory == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(13);
        }
        OverlayMapping overlayMapping = new OverlayMapping();
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        for (Document unsavedDocument : documentManager.getUnsavedDocuments()) {
            VirtualFile virtualFile = documentManager.getFile(unsavedDocument);
            if (virtualFile == null) continue;
            File sourceFile = new File(virtualFile.getPath());
            File overlayFile = ClangTidyAnnotator.generateMappingFile(sourceFile.getName(), unsavedDocument, workingDirectory);
            overlayMapping.addOverlay(sourceFile, overlayFile);
        }
        return overlayMapping;
    }

    protected static File generateMappingFile(@NotNull String fileName, @NotNull Document document, @NotNull File workingDirectory) throws IOException {
        if (fileName == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(14);
        }
        if (document == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(15);
        }
        if (workingDirectory == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(16);
        }
        File mappingFile = new File(workingDirectory, fileName);
        FileUtil.writeToFile((File)mappingFile, (String)document.getText());
        return mappingFile;
    }

    protected static File generateVfsOverlay(@NotNull OverlayMapping overlayMapping, @NotNull File workingDirectory, @NotNull ClangUrlConverter converter) throws IOException {
        if (overlayMapping == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(17);
        }
        if (workingDirectory == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(18);
        }
        if (converter == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(19);
        }
        File vfsOverlay = new File(workingDirectory, "overlay.yaml");
        FileUtil.writeToFile((File)vfsOverlay, (String)CommonClangTidyUtil.generateVfsOverlay(overlayMapping, converter));
        return vfsOverlay;
    }

    public void apply(@NotNull PsiFile psiFile, @Nullable ClangTidyAnnotationHolder annotationHolder, @NotNull AnnotationHolder holder) {
        if (psiFile == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(20);
        }
        if (holder == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(21);
        }
        Document document = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(psiFile);
        if (annotationHolder == null || document == null) {
            return;
        }
        ClangTidyAnnotationApplier applier = ClangTidyAnnotationApplierProvider.provide();
        if (annotationHolder.isSuccess()) {
            applier.annotateSuccess(psiFile, annotationHolder.getDiagnostics(), holder);
        } else {
            HighlightSeverity severity = annotationHolder.isError() ? HighlightSeverity.ERROR : HighlightSeverity.WARNING;
            applier.annotateFail(psiFile, annotationHolder.getFailReason(), severity, holder);
        }
    }

    @NotNull
    protected static File createCompilationDatabase(@NotNull ClangTidyAnnotatorInfo info, @NotNull File workingDirectory, @NotNull File inputFile, @NotNull ClangTidyAnnotatorDebugInfoBuilder debugInfoBuilder, @NotNull ClangUrlConverter converter) throws IOException {
        if (info == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(22);
        }
        if (workingDirectory == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(23);
        }
        if (inputFile == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(24);
        }
        if (debugInfoBuilder == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(25);
        }
        if (converter == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(26);
        }
        ArrayList<String> commandLine = new ArrayList<String>();
        Ref compilerExecutableRef = Ref.create();
        Ref preprocessorDefinesRef = Ref.create();
        File macrosFile = new File(workingDirectory, "macros");
        ReadAction.compute(() -> {
            @NotNull PsiFile ocFile = info.getFile();
            VirtualFile file = ocFile.getVirtualFile();
            Cpp20ModulesContext cpp20Paths = new Cpp20ModulesContext("", "", "");
            ClangUtils.ResolveInfo resolveInfo = new ClangUtils.ResolveInfo(info.getConfiguration(), info.getRootVirtualFile(), info.getLanguageKind(), info.isGuessed());
            @Nullable ClangdCompilationCommand command = ClangUtils.getCompilationCommand(converter, info.getProject(), file, macrosFile.getPath(), cpp20Paths, resolveInfo);
            if (command == null) {
                return null;
            }
            List<String> cmdLine = command.ccParams.getCommandLine();
            cmdLine = CommonClangTidyUtil.filterSpecificCLionCommandLineOptions(cmdLine);
            cmdLine.remove(cmdLine.size() - 1);
            compilerExecutableRef.set((Object)cmdLine.remove(0));
            @NotNull OCCompilerKind compilerKind = info.getCompilerKind();
            if (compilerKind != ClangClCompilerKind.INSTANCE && compilerKind != ClangCompilerKind.INSTANCE && compilerKind != AppleClangCompilerKind.INSTANCE) {
                String resourceDir = ClangUtils.getClangHeaderDir(converter.isWslMode(), info.getProject());
                commandLine.add("-I" + resourceDir);
            }
            commandLine.addAll(cmdLine);
            preprocessorDefinesRef.set((Object)command.ppDefines);
            return null;
        });
        if (!preprocessorDefinesRef.isNull()) {
            FileUtil.writeToFile((File)macrosFile, (String)((String)preprocessorDefinesRef.get()));
            if (ClangTidyAnnotator.collectDebugInformation(info)) {
                debugInfoBuilder.setMacros((String)preprocessorDefinesRef.get());
            }
        }
        File compilationDatabase = new File(workingDirectory, "compile_commands.json");
        FileWriter writer = new FileWriter(compilationDatabase, Charsets.UTF_8);
        CommonClangTidyUtil.writeCompilationDatabase(writer, ClangTidyAnnotator.fixWslPathIfRequired((String)compilerExecutableRef.get(), converter), ClangTidyAnnotator.fixWslPathIfRequired(workingDirectory.getAbsolutePath(), converter), commandLine, ClangTidyAnnotator.fixWslPathIfRequired(inputFile.getAbsolutePath(), converter));
        File file = compilationDatabase;
        if (file == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(27);
        }
        return file;
    }

    @NotNull
    protected static String fixWslPathIfRequired(@NotNull String path, @NotNull ClangUrlConverter converter) {
        if (path == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(28);
        }
        if (converter == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(29);
        }
        String string = converter.isWslMode() ? converter.fixWslPathWhenRequired(StringUtil.replace((String)path, (String)"\\", (String)"/")) : path;
        if (string == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(30);
        }
        return string;
    }

    protected static boolean isAvailable(@Nullable File clangTidyPath) {
        try {
            return clangTidyPath != null && clangTidyPath.exists() && clangTidyPath.canExecute();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    @NotNull
    protected static List<ClangTidyDiagnostic> loadDiagnosticsFromYaml(@NotNull File outputFile, @NotNull File sourceFile, @NotNull OverlayMapping overlayMapping, @NotNull ClangUrlConverter converter) throws IOException {
        if (outputFile == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(31);
        }
        if (sourceFile == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(32);
        }
        if (overlayMapping == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(33);
        }
        if (converter == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(34);
        }
        String yamlContent = FileUtil.loadFile((File)outputFile);
        ClangTidyYamlLoader yamlLoader = new ClangTidyYamlLoader();
        List<ClangTidyDiagnostic> list = yamlLoader.load(yamlContent, sourceFile.getPath(), overlayMapping, converter);
        if (list == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(35);
        }
        return list;
    }

    protected static void tryRegisterDocumentListener(@NotNull ClangTidyAnnotatorInfo info) {
        Document document;
        if (info == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(36);
        }
        if (!((document = info.getDocument()) instanceof UserDataHolderEx)) {
            return;
        }
        UserDataHolderEx dataHolder = (UserDataHolderEx)document;
        AtomicBoolean hasDocumentListener = (AtomicBoolean)ConcurrencyUtil.computeIfAbsent((UserDataHolder)dataHolder, HAS_DOCUMENT_LISTENER, () -> new AtomicBoolean());
        if (hasDocumentListener.compareAndSet(false, true)) {
            document.addDocumentListener((DocumentListener)DOCUMENT_LISTENER);
        }
    }

    @NotNull
    protected static MyMasterReparsingPassListener trySubscribeForClangReparsingPass(@NotNull Project project) {
        if (project == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(37);
        }
        if (!(project instanceof UserDataHolderEx)) {
            LOG.warn("Unexpected project type: " + project.getClass().getSimpleName());
            return new MyMasterReparsingPassListener();
        }
        UserDataHolderEx dataHolderEx = (UserDataHolderEx)project;
        MyMasterReparsingPassListener existing = (MyMasterReparsingPassListener)project.getUserData(REPARSING_PASS_LISTENER);
        if (existing != null) {
            MyMasterReparsingPassListener myMasterReparsingPassListener = existing;
            if (myMasterReparsingPassListener == null) {
                ClangTidyAnnotator.$$$reportNull$$$0(38);
            }
            return myMasterReparsingPassListener;
        }
        MyMasterReparsingPassListener newMasterListener = new MyMasterReparsingPassListener();
        MyMasterReparsingPassListener existing2 = (MyMasterReparsingPassListener)dataHolderEx.putUserDataIfAbsent(REPARSING_PASS_LISTENER, (Object)newMasterListener);
        if (existing2 == newMasterListener) {
            project.getMessageBus().connect().subscribe(OCLanguageServiceReparsingPassListener.TOPIC, (Object)newMasterListener);
        }
        MyMasterReparsingPassListener myMasterReparsingPassListener = existing2;
        if (myMasterReparsingPassListener == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(39);
        }
        return myMasterReparsingPassListener;
    }

    public String getPairedBatchInspectionShortName() {
        return ClangTidyInspection.getInspectionShortName();
    }

    @NotNull
    protected static CapturingProcessHandler createCapturedProcessHandler(@NotNull GeneralCommandLine commandLine) throws com.intellij.execution.ExecutionException {
        if (commandLine == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(40);
        }
        return new CapturingProcessHandler(commandLine){

            protected CapturingProcessAdapter createProcessAdapter(ProcessOutput processOutput2) {
                return new CapturingProcessAdapter(this, processOutput2){

                    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (outputType == null) {
                            1.$$$reportNull$$$0(1);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "event";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "outputType";
                                break;
                            }
                        }
                        objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyAnnotator$1$1";
                        objectArray[2] = "onTextAvailable";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
            }
        };
    }

    private static boolean useLanguageService(@NotNull ClangTidyAnnotatorInfo info) {
        Project project;
        if (info == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(41);
        }
        if (!ClangUtils.isClangdOn(project = info.getProject()) || !ClangUtils.isClangTidyViaClangdOn(project)) {
            return false;
        }
        if (info.getFile().getVirtualFile() == null) {
            return false;
        }
        if (ClangUtils.isClangTidyViaClangdForced(project)) {
            return true;
        }
        return CommonClangTidyUtil.getCustomClangTidyPath() == null;
    }

    protected static boolean collectDebugInformation(ClangTidyAnnotatorInfo info) {
        return info.getFile().getUserData(COLLECT_DEBUG_INFORMATION) == Boolean.TRUE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 27, 30, 35, 38, 39 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionConfig";
                break;
            }
            case 2: 
            case 4: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 22: 
            case 36: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 7: 
            case 9: 
            case 13: 
            case 16: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 17: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overlayMapping";
                break;
            }
            case 19: 
            case 26: 
            case 29: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputFile";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugInfoBuilder";
                break;
            }
            case 27: 
            case 30: 
            case 35: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyAnnotator";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyAnnotator";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompilationDatabase";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "fixWslPathIfRequired";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDiagnosticsFromYaml";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "trySubscribeForClangReparsingPass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectInformation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectInformationImpl";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "executeClangTidy";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "executeStandaloneClangTidy";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "executeClangTidyViaClangd";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doExecuteClangTidyViaClangd";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "generateVfsOverlays";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "generateMappingFile";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "generateVfsOverlay";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createCompilationDatabase";
                break;
            }
            case 27: 
            case 30: 
            case 35: 
            case 38: 
            case 39: {
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "fixWslPathIfRequired";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "loadDiagnosticsFromYaml";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "tryRegisterDocumentListener";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "trySubscribeForClangReparsingPass";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createCapturedProcessHandler";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "useLanguageService";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 27, 30, 35, 38, 39 -> new IllegalStateException(string);
        };
    }

    public static class MyMasterReparsingPassListener
    implements OCLanguageServiceReparsingPassListener {
        @NotNull
        private final Set<MySlaveReparsingPassListener> mySlaveListeners = Collections.newSetFromMap(new IdentityHashMap());

        @Override
        public synchronized void onReparsing(@NotNull PsiFile file) {
            if (file == null) {
                MyMasterReparsingPassListener.$$$reportNull$$$0(0);
            }
            for (MySlaveReparsingPassListener slave : this.mySlaveListeners) {
                slave.onReparsing(file);
            }
        }

        public synchronized void addListener(@NotNull MySlaveReparsingPassListener slave) {
            if (slave == null) {
                MyMasterReparsingPassListener.$$$reportNull$$$0(1);
            }
            this.mySlaveListeners.add(slave);
        }

        public synchronized void removeListener(@NotNull MySlaveReparsingPassListener slave) {
            if (slave == null) {
                MyMasterReparsingPassListener.$$$reportNull$$$0(2);
            }
            this.mySlaveListeners.remove(slave);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "slave";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyAnnotator$MyMasterReparsingPassListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onReparsing";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addListener";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeListener";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static final class MySlaveReparsingPassListener {
        @NotNull
        private final ProgressIndicator myIndicator;
        @NotNull
        private final PsiFile myFile;

        public MySlaveReparsingPassListener(@NotNull ProgressIndicator indicator, @NotNull PsiFile file) {
            if (indicator == null) {
                MySlaveReparsingPassListener.$$$reportNull$$$0(0);
            }
            if (file == null) {
                MySlaveReparsingPassListener.$$$reportNull$$$0(1);
            }
            this.myIndicator = indicator;
            this.myFile = file;
        }

        public void onReparsing(@NotNull PsiFile file) {
            if (file == null) {
                MySlaveReparsingPassListener.$$$reportNull$$$0(2);
            }
            if (file == this.myFile) {
                this.myIndicator.cancel();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyAnnotator$MySlaveReparsingPassListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onReparsing";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

