/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.startup.scan.events;

import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Cpp20Module;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionCompileCommandParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.CppModulesStateUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.scan.events.ClangScanEvent;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\tH\u0094@\u00a2\u0006\u0002\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/startup/scan/events/ScanDocumentEvent;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/startup/scan/events/ClangScanEvent;", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/editor/event/DocumentEvent;Lcom/intellij/openapi/project/Project;)V", "doScan", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.cidr.clangd"})
public final class ScanDocumentEvent
extends ClangScanEvent {
    @NotNull
    private final DocumentEvent event;

    public ScanDocumentEvent(@NotNull DocumentEvent event, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.event = event;
    }

    @Override
    @Nullable
    protected Object doScan(@NotNull Continuation<? super Unit> $completion) {
        if (!CppModulesStateUtil.areCpp20ModulesEnabled()) {
            return Unit.INSTANCE;
        }
        VirtualFile file = FileDocumentManager.getInstance().getFile(this.event.getDocument());
        if (file == null) {
            return Unit.INSTANCE;
        }
        if (CppModulesStateUtil.maybeCpp20ModuleFile(file.getName())) {
            VirtualFile origFile;
            VirtualFile virtualFile = origFile = file instanceof LightVirtualFile ? ((LightVirtualFile)file).getOriginalFile() : file;
            if (origFile == null) {
                return Unit.INSTANCE;
            }
            Cpp20Module module = this.myModulesState.byPath(arg_0 -> ScanDocumentEvent.doScan$lambda$0(origFile, arg_0));
            Ref isImpl = new Ref();
            String modName = CppModulesStateUtil.getModuleName(this.event, (Ref<Boolean>)isImpl);
            if (modName == null) {
                if (module != null) {
                    this.myModulesState.removeCppModuleByPath(module.getSourcePath());
                    CppModulesStateUtil.updateModuleMap(this.myModulesState, this.getProject());
                }
            } else if (!StringsKt.contains$default((CharSequence)modName, (CharSequence)"CIDR_RULE_ZZZ", (boolean)false, (int)2, null)) {
                if (module != null) {
                    if (!Intrinsics.areEqual((Object)module.getName(), (Object)modName)) {
                        ClionCompileCommandParams clionCompileCommandParams = module.getCompileCommand();
                        String string = module.getPPDefines();
                        String string2 = module.getSourcePath();
                        Object object = isImpl.get();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                        this.myModulesState.addCppModule(new Cpp20Module(modName, clionCompileCommandParams, string, string2, (Boolean)object));
                        CppModulesStateUtil.updateModuleMap(this.myModulesState, this.getProject());
                    }
                } else {
                    String string = origFile.getPath();
                    Object object = isImpl.get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                    this.myModulesState.addCppModule(new Cpp20Module(modName, null, null, string, (Boolean)object));
                    CppModulesStateUtil.updateModuleMap(this.myModulesState, this.getProject());
                }
            }
        }
        return Unit.INSTANCE;
    }

    private static final Cpp20Module doScan$lambda$0(VirtualFile $origFile, Map it) {
        return (Cpp20Module)it.get($origFile.getPath());
    }
}

