/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.registry;

import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponse;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponseImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.PendingParseListener;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class PendingRequestsStorage {
    public static final int FILES_STORAGE_SIZE = 64;
    @NotNull
    private final PendingParseListener myListener;
    @NotNull
    private final ArrayDeque<ClangParseResponseImpl> myPending;
    @NotNull
    private final AtomicBoolean myIterating;
    @NotNull
    private final List<ClangParseResponse> myDelayedPending;
    private final int myOverflowSize;
    private volatile ClangParseResponseImpl myLast;

    PendingRequestsStorage(@NotNull PendingParseListener listener) {
        if (listener == null) {
            PendingRequestsStorage.$$$reportNull$$$0(0);
        }
        this(listener, 64);
    }

    PendingRequestsStorage(@NotNull PendingParseListener listener, int size) {
        if (listener == null) {
            PendingRequestsStorage.$$$reportNull$$$0(1);
        }
        this.myIterating = new AtomicBoolean(false);
        this.myDelayedPending = new ArrayList<ClangParseResponse>(4);
        this.myListener = listener;
        this.myPending = new ArrayDeque(size);
        this.myOverflowSize = size;
        assert (this.myOverflowSize > 0);
    }

    public ClangParseResponseImpl getLast() {
        return this.myLast;
    }

    public synchronized void clearLast() {
        this.myLast = null;
    }

    public synchronized void onParse(@NotNull ClangParseResponseImpl t) {
        if (t == null) {
            PendingRequestsStorage.$$$reportNull$$$0(2);
        }
        this.myLast = t;
        if (this.myOverflowSize <= this.myPending.size()) {
            ClangParseResponseImpl oldest = this.myPending.peekFirst();
            assert (oldest != null);
            this.myListener.onOverflow(oldest);
        }
        this.myPending.addLast(t);
        CompletableFuture.allOf(ClangParseResponse.getAllAnswers(t)).whenComplete((data, ex) -> this.removeWhenDone(t));
    }

    private synchronized void removeWhenDone(@NotNull ClangParseResponse t) {
        if (t == null) {
            PendingRequestsStorage.$$$reportNull$$$0(3);
        }
        if (this.myIterating.get()) {
            this.myDelayedPending.add(t);
            return;
        }
        if (this.myPending.peekLast() == t) {
            this.myPending.removeLast();
        } else {
            this.myPending.removeFirstOccurrence(t);
        }
    }

    public synchronized int sizeOfPending() {
        return this.myPending.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void forEachPending(@NotNull Predicate<ClangParseResponse> consumer) {
        if (consumer == null) {
            PendingRequestsStorage.$$$reportNull$$$0(4);
        }
        this.myIterating.set(true);
        try {
            for (ClangParseResponse clangParseResponse : this.myPending) {
                if (consumer.test(clangParseResponse)) continue;
                return;
            }
        }
        finally {
            this.myIterating.set(false);
            for (ClangParseResponse pending : this.myDelayedPending) {
                this.myPending.removeFirstOccurrence(pending);
            }
            this.myDelayedPending.clear();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/registry/PendingRequestsStorage";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "onParse";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "removeWhenDone";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "forEachPending";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

