/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.registry;

import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdCanceledException;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponse;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponseImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.LocalWorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.PendingParseListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.PendingRequestsStorage;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.WorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.WorkspaceFileImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.WorkspaceFileListener;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalWorkspaceFileImpl
extends WorkspaceFileImpl
implements LocalWorkspaceFile {
    private static final int FILE_INITIAL_VERSION = 2;
    @NotNull
    private static final WorkspaceFile.Key<Integer> VERSION = new WorkspaceFile.Key<Integer>("WorkspaceFileVersion", () -> -1);
    @NotNull
    private static final WorkspaceFile.Key<Integer> PREAMBLE_VERSION = new WorkspaceFile.Key<Integer>("WorkspaceFilePreambleVersion", () -> -1);
    @NotNull
    private static final WorkspaceFile.Key<Integer> PREAMBLE_BOUNDS = new WorkspaceFile.Key<Integer>("WorkspaceFilePreambleBounds", () -> 0);
    @NotNull
    private static final WorkspaceFile.Key<Boolean> IS_OPENED = new WorkspaceFile.Key<Boolean>("WorkspaceFileIsOpened", () -> false);
    @NotNull
    static final WorkspaceFile.Key<PendingRequestsStorage> REQUESTS_STORAGE = new WorkspaceFile.Key("REQUESTS_STORAGE");
    @NotNull
    private final AtomicLong myGlobalVersionCounter;
    @NotNull
    private final ClangUrlConverter myConverter;
    private int myMaxSizeOfPending;

    LocalWorkspaceFileImpl(@NotNull String url, @NotNull AtomicLong globalVersionCounter, @NotNull ClangUrlConverter converter, @NotNull WorkspaceFileListener wfListener, @NotNull PendingParseListener ppListener) {
        if (url == null) {
            LocalWorkspaceFileImpl.$$$reportNull$$$0(0);
        }
        if (globalVersionCounter == null) {
            LocalWorkspaceFileImpl.$$$reportNull$$$0(1);
        }
        if (converter == null) {
            LocalWorkspaceFileImpl.$$$reportNull$$$0(2);
        }
        if (wfListener == null) {
            LocalWorkspaceFileImpl.$$$reportNull$$$0(3);
        }
        if (ppListener == null) {
            LocalWorkspaceFileImpl.$$$reportNull$$$0(4);
        }
        super(url, wfListener);
        this.myGlobalVersionCounter = globalVersionCounter;
        this.myConverter = converter;
        this.put(REQUESTS_STORAGE, new PendingRequestsStorage(ppListener));
    }

    @Override
    public int getVersion() {
        return this.getOrDefault(VERSION);
    }

    @Override
    public int getPreambleVersion() {
        return this.getOrDefault(PREAMBLE_VERSION);
    }

    @Override
    public int getPreambleBounds() {
        return this.getOrDefault(PREAMBLE_BOUNDS);
    }

    @Override
    public int preambleChanged(int preambleBounds) {
        int nextPreambleVersion = LocalWorkspaceFileImpl.incVersion(this.getOrDefault(PREAMBLE_VERSION));
        this.put(PREAMBLE_VERSION, nextPreambleVersion);
        this.put(PREAMBLE_BOUNDS, preambleBounds);
        return nextPreambleVersion;
    }

    @Override
    public int nextOpen() {
        this.put(IS_OPENED, true);
        return this.nextVersionImpl();
    }

    @Override
    public int nextChange() {
        return this.nextVersionImpl();
    }

    @Override
    public int nextClose() {
        PendingRequestsStorage files = this.getOrDefault(REQUESTS_STORAGE);
        files.clearLast();
        this.put(IS_OPENED, false);
        return this.nextVersionImpl();
    }

    @Override
    public int nextDelete() {
        PendingRequestsStorage files = this.getOrDefault(REQUESTS_STORAGE);
        files.clearLast();
        this.put(IS_OPENED, false);
        return this.nextVersionImpl();
    }

    @Override
    @NotNull
    public ClangParseResponse nextParse(@Nullable VirtualFile virtualFile, boolean cancellable) {
        PendingRequestsStorage files = this.getOrDefault(REQUESTS_STORAGE);
        ClangParseResponseImpl nextFile = this.createNextParseRequest(files, this.getUrl(), cancellable);
        if (virtualFile != null) {
            nextFile.putUserData(ClangParseResponse.MODIFICATION_STAMP, virtualFile.getModificationStamp());
            nextFile.putUserData(ClangParseResponse.MODIFICATION_COUNT, virtualFile.getModificationCount());
        }
        ClangParseResponseImpl clangParseResponseImpl = nextFile;
        if (clangParseResponseImpl == null) {
            LocalWorkspaceFileImpl.$$$reportNull$$$0(5);
        }
        return clangParseResponseImpl;
    }

    private int nextVersionImpl() {
        int newVersion = LocalWorkspaceFileImpl.incVersion(this.getOrDefault(VERSION));
        this.put(VERSION, newVersion);
        return newVersion;
    }

    @Override
    public boolean isOpened() {
        return this.getOrDefault(IS_OPENED);
    }

    @Override
    @Nullable
    public ClangParseResponse getLastParseResponse() {
        return this.getOrDefault(REQUESTS_STORAGE).getLast();
    }

    @Override
    @Nullable
    public ClangParseResponse getPendingParseResponse(int version) {
        PendingRequestsStorage files = this.getOrDefault(REQUESTS_STORAGE);
        ClangParseResponseImpl lastResponse = files.getLast();
        if (lastResponse != null && lastResponse.getVersion() == version) {
            return lastResponse;
        }
        Ref found = Ref.create();
        files.forEachPending(pending -> {
            if (pending.getVersion() == version) {
                found.set(pending);
                return false;
            }
            return true;
        });
        return (ClangParseResponse)found.get();
    }

    @Override
    public int getMaxSizeOfPendingParsesQueue() {
        return this.myMaxSizeOfPending;
    }

    @Override
    public void forEachPendingParse(@NotNull Predicate<ClangParseResponse> consumer) {
        if (consumer == null) {
            LocalWorkspaceFileImpl.$$$reportNull$$$0(6);
        }
        PendingRequestsStorage parses = this.getOrDefault(REQUESTS_STORAGE);
        parses.forEachPending(consumer);
    }

    @Override
    public void cancelPendingParses(@NotNull String reason) {
        if (reason == null) {
            LocalWorkspaceFileImpl.$$$reportNull$$$0(7);
        }
        this.forEachPendingParse(parse -> {
            ClangParseResponse.completeAnswersExceptionally(parse, (Throwable)((Object)new ClangdCanceledException(reason)));
            return true;
        });
    }

    @NotNull
    private ClangParseResponseImpl createNextParseRequest(@NotNull PendingRequestsStorage files, @NotNull String url, boolean cancellable) {
        if (files == null) {
            LocalWorkspaceFileImpl.$$$reportNull$$$0(8);
        }
        if (url == null) {
            LocalWorkspaceFileImpl.$$$reportNull$$$0(9);
        }
        ClangParseResponseImpl nextFile = new ClangParseResponseImpl(url, VfsUtilCore.urlToPath((String)url), this.nextVersionImpl(), this.getPreambleVersion(), cancellable);
        files.onParse(nextFile);
        int newSize = files.sizeOfPending();
        if (this.myMaxSizeOfPending < newSize) {
            this.myMaxSizeOfPending = newSize;
        }
        ClangParseResponseImpl clangParseResponseImpl = nextFile;
        if (clangParseResponseImpl == null) {
            LocalWorkspaceFileImpl.$$$reportNull$$$0(10);
        }
        return clangParseResponseImpl;
    }

    private static int incVersion(int version) {
        if (version == -1) {
            return 2;
        }
        return version + 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalVersionCounter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wfListener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ppListener";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/registry/LocalWorkspaceFileImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/registry/LocalWorkspaceFileImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "nextParse";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createNextParseRequest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "forEachPendingParse";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "cancelPendingParses";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createNextParseRequest";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 10 -> new IllegalStateException(string);
        };
    }
}

