/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.registry;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionModuleMappingParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionReparseTextDocumentParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionSetCDBParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.RemoteWorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.RemoteWorkspaceFileImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.AbstractClangWorkspace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.WorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.WorkspaceFileListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangRemoteWorkspaceImpl
extends AbstractClangWorkspace<RemoteWorkspaceFile>
implements ClangRemoteWorkspace,
WorkspaceFileListener {
    @NotNull
    private final Set<String> myUnsavedFiles = ConcurrentCollectionFactory.createConcurrentSet();
    @Nullable
    private volatile String myIndexUri = null;
    @Nullable
    private volatile CLionModuleMappingParams myCpp20ModuleMapping = null;
    @Nullable
    private volatile String myLoadedGraphUri = null;
    @NotNull
    private final List<CompressedCDBBatch> myCompressedCDBs = Collections.synchronizedList(new ArrayList());
    private volatile boolean myIsPaused = false;

    @Override
    @NotNull
    public Set<String> getUnsavedFiles() {
        Set<String> set = Collections.unmodifiableSet(new HashSet<String>(this.myUnsavedFiles));
        if (set == null) {
            ClangRemoteWorkspaceImpl.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Override
    @Nullable
    public String getLoadedIndexParams() {
        return this.myIndexUri;
    }

    @Override
    public void setLoadedIndexParams(@NotNull String uri) {
        if (uri == null) {
            ClangRemoteWorkspaceImpl.$$$reportNull$$$0(1);
        }
        this.myIndexUri = uri;
    }

    @Override
    @Nullable
    public CLionModuleMappingParams getCpp20ModuleMapping() {
        return this.myCpp20ModuleMapping;
    }

    @Override
    public void setCpp20ModuleMapping(@Nullable CLionModuleMappingParams params) {
        this.myCpp20ModuleMapping = params;
    }

    @Override
    @Nullable
    public String getLoadedGraphUri() {
        return this.myLoadedGraphUri;
    }

    @Override
    public void setLoadedGraphUri(@NotNull String uri) {
        if (uri == null) {
            ClangRemoteWorkspaceImpl.$$$reportNull$$$0(2);
        }
        this.myLoadedGraphUri = uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Iterable<ClionSetCDBParams> getCDBs() {
        ArrayList<CompressedCDBBatch> copy;
        List<CompressedCDBBatch> list = this.myCompressedCDBs;
        synchronized (list) {
            copy = new ArrayList<CompressedCDBBatch>(this.myCompressedCDBs);
        }
        return new Iterable<ClionSetCDBParams>(this){

            @Override
            @NotNull
            public Iterator<ClionSetCDBParams> iterator() {
                return new MappingIterator<CompressedCDBBatch, ClionSetCDBParams>(copy.iterator(), batch -> ClangLanguageServiceUtils.extract(batch.data, TypeToken.get(ClionSetCDBParams.class), null));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOrSetCDB(@NotNull ClionSetCDBParams params) {
        if (params == null) {
            ClangRemoteWorkspaceImpl.$$$reportNull$$$0(3);
        }
        List<CompressedCDBBatch> list = this.myCompressedCDBs;
        synchronized (list) {
            if (!this.myCompressedCDBs.isEmpty() && this.myCompressedCDBs.get(this.myCompressedCDBs.size() - 1).isLastBatch()) {
                this.myCompressedCDBs.clear();
            }
            String serializedParams = new Gson().toJson((Object)params);
            this.myCompressedCDBs.add(new CompressedCDBBatch(ClangLanguageServiceUtils.compress(serializedParams), params.isLastBatch()));
        }
    }

    @Override
    public boolean isOpenedRemotely(@NotNull String url) {
        if (url == null) {
            ClangRemoteWorkspaceImpl.$$$reportNull$$$0(4);
        }
        return this.apply(url, (WF wf) -> wf.getOrDefault(RemoteWorkspaceFile.IS_OPENED));
    }

    @Override
    public boolean isClosedRemotely(@NotNull String url) {
        if (url == null) {
            ClangRemoteWorkspaceImpl.$$$reportNull$$$0(5);
        }
        return this.apply(url, (WF wf) -> wf.getOrDefault(RemoteWorkspaceFile.IS_OPENED) == false);
    }

    @Override
    public boolean isParsed(@NotNull String url) {
        if (url == null) {
            ClangRemoteWorkspaceImpl.$$$reportNull$$$0(6);
        }
        return this.apply(url, (WF wf) -> wf.getOrDefault(RemoteWorkspaceFile.IS_PARSED));
    }

    @Override
    public ClionReparseTextDocumentParams getReparseParams(@NotNull String url) {
        if (url == null) {
            ClangRemoteWorkspaceImpl.$$$reportNull$$$0(7);
        }
        return this.apply(url, (WF wf) -> wf.getReparseParams());
    }

    @Override
    public String getContent(@NotNull String url) {
        if (url == null) {
            ClangRemoteWorkspaceImpl.$$$reportNull$$$0(8);
        }
        return this.apply(url, (WF wf) -> wf.getContent());
    }

    @Override
    public boolean isPaused() {
        return this.myIsPaused;
    }

    @Override
    public void setPaused(boolean value) {
        this.myIsPaused = value;
    }

    @Override
    @NotNull
    protected RemoteWorkspaceFile createWorkspaceFile(@NotNull String url) {
        if (url == null) {
            ClangRemoteWorkspaceImpl.$$$reportNull$$$0(9);
        }
        return new RemoteWorkspaceFileImpl(url, this);
    }

    @Override
    public <T> void onChanged(@NotNull String url, @NotNull WorkspaceFile.Key<T> key, T value) {
        if (url == null) {
            ClangRemoteWorkspaceImpl.$$$reportNull$$$0(10);
        }
        if (key == null) {
            ClangRemoteWorkspaceImpl.$$$reportNull$$$0(11);
        }
        if (key == RemoteWorkspaceFile.IS_SAVED) {
            if (Objects.equals(value, Boolean.TRUE)) {
                this.myUnsavedFiles.remove(url);
            } else {
                this.myUnsavedFiles.add(url);
            }
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.myIndexUri = null;
        this.myCpp20ModuleMapping = null;
        this.myLoadedGraphUri = null;
        this.myCompressedCDBs.clear();
    }

    public int getCompressedCDBSize() {
        int size = 0;
        for (CompressedCDBBatch batch : this.myCompressedCDBs) {
            size += batch.data.length;
        }
        return size;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/registry/ClangRemoteWorkspaceImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsavedFiles";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/registry/ClangRemoteWorkspaceImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setLoadedIndexParams";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setLoadedGraphUri";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addOrSetCDB";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isOpenedRemotely";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isClosedRemotely";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isParsed";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getReparseParams";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createWorkspaceFile";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "onChanged";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> new IllegalArgumentException(string);
        };
    }

    private record CompressedCDBBatch(byte @NotNull [] data, boolean isLastBatch) {
        private final byte @NotNull [] data;

        private CompressedCDBBatch(byte @NotNull [] data, boolean isLastBatch) {
            if (data == null) {
                CompressedCDBBatch.$$$reportNull$$$0(0);
            }
        }

        public byte @NotNull [] data() {
            if (this.data == null) {
                CompressedCDBBatch.$$$reportNull$$$0(1);
            }
            return this.data;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/registry/ClangRemoteWorkspaceImpl$CompressedCDBBatch";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/registry/ClangRemoteWorkspaceImpl$CompressedCDBBatch";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "data";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class MappingIterator<F, T>
    implements Iterator<T> {
        @NotNull
        private final Iterator<F> myIterator;
        @NotNull
        private final Function<F, T> myMapping;

        private MappingIterator(@NotNull Iterator<F> origIter, @NotNull Function<F, T> mapping) {
            if (origIter == null) {
                MappingIterator.$$$reportNull$$$0(0);
            }
            if (mapping == null) {
                MappingIterator.$$$reportNull$$$0(1);
            }
            this.myIterator = origIter;
            this.myMapping = mapping;
        }

        @Override
        public boolean hasNext() {
            return this.myIterator.hasNext();
        }

        @Override
        public T next() {
            return this.myMapping.apply(this.myIterator.next());
        }

        @Override
        public void remove() {
            this.myIterator.remove();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "origIter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mapping";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/registry/ClangRemoteWorkspaceImpl$MappingIterator";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

