/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.registry;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangHighlighting;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.DFARawTuple;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ParsingParamsTransformer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Trustworthiness;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.client.ClangClientImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionFixItHint;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteractionPromise;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyRange;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyReplacement;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ClangParseResponse
extends UserDataHolderEx {
    public static final Key<Set<String>> UNSAVED_FILES = new Key("UnsavedFiles");
    public static final Key<Long> MODIFICATION_STAMP = new Key("ModificationStamp");
    public static final Key<Long> MODIFICATION_COUNT = new Key("ModificationCount");
    public static final Key<Long> PSI_GLOBAL_MODIFICATION_COUNTER = new Key("PsiGlobalModificationCounter");
    public static final Key<Long> PROFILE_MODIFICATION_COUNTER = new Key("ProfileModificationCounter");
    public static final Key<ParsingParamsTransformer> PARSING_PARAMS_TRANSFORM = new Key("ParsingParamsTransformer");
    public static final Key<Trustworthiness> TRUSTWORTHINESS = new Key("Trustworthiness");

    @Nullable
    public List<ClangInteractionPromise> attachReparseNotification(@NotNull ClangInteractionPromise var1);

    public boolean isFirstReparseNotification(@Nullable ClangInteractionPromise var1);

    @NotNull
    public String getUrl();

    public int getVersion();

    public int getPreambleVersion();

    public boolean isCancellable();

    @NotNull
    public OpState getOpState();

    public boolean nextOpState(@NotNull OpState var1);

    public boolean nextOpState(@NotNull OpState var1, @Nullable Predicate<List<ClangInteractionPromise>> var2);

    @NotNull
    public CompletableFuture<Supplier<List<ClangDiagnostic>>> getDiagnostics();

    @NotNull
    public CompletableFuture<Supplier<List<ClangHighlighting>>> getHighlightings();

    @NotNull
    public CompletableFuture<Supplier<List<ClangTidyDiagnostic>>> getOurTidyDiagnostics();

    @NotNull
    public CompletableFuture<Supplier<List<ClangTidyDiagnostic>>> getTidyDiagnostics();

    @NotNull
    public CompletableFuture<Supplier<List<ClangDiagnostic>>> getClazyDiagnostics();

    @NotNull
    public CompletableFuture<Supplier<List<DFARawTuple>>> getDFAInput();

    @NotNull
    default public Trustworthiness getTrustworthiness() {
        Trustworthiness trustworthiness = (Trustworthiness)this.getUserData(TRUSTWORTHINESS);
        return trustworthiness != null ? trustworthiness : new Trustworthiness();
    }

    public static CompletableFuture<?>[] getAllAnswers(@NotNull ClangParseResponse file) {
        if (file == null) {
            ClangParseResponse.$$$reportNull$$$0(0);
        }
        return new CompletableFuture[]{file.getDiagnostics(), file.getHighlightings(), file.getDFAInput(), file.getOurTidyDiagnostics(), file.getTidyDiagnostics(), file.getClazyDiagnostics()};
    }

    @NotNull
    public static String showAnswerStates(@NotNull ClangParseResponse response) {
        if (response == null) {
            ClangParseResponse.$$$reportNull$$$0(1);
        }
        String string = "Diagnostics = " + (response.getDiagnostics().isDone() ? "READY" : "WAITING") + "Highlightings = " + (response.getHighlightings().isDone() ? "READY" : "WAITING") + "DFAInput = " + (response.getDFAInput().isDone() ? "READY" : "WAITING") + "OurTidyDiagnostics = " + (response.getOurTidyDiagnostics().isDone() ? "READY" : "WAITING") + "TidyDiagnostics = " + (response.getTidyDiagnostics().isDone() ? "READY" : "WAITING") + "ClazyDiagnostics = " + (response.getClazyDiagnostics().isDone() ? "READY" : "WAITING");
        if (string == null) {
            ClangParseResponse.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static void completeAnswers(@NotNull ClangParseResponse file) {
        if (file == null) {
            ClangParseResponse.$$$reportNull$$$0(3);
        }
        for (CompletableFuture<?> future : ClangParseResponse.getAllAnswers(file)) {
            if (future.isDone()) continue;
            future.complete(null);
        }
    }

    public static void completeAnswersExceptionally(@NotNull ClangParseResponse file, @NotNull Throwable ex) {
        if (file == null) {
            ClangParseResponse.$$$reportNull$$$0(4);
        }
        if (ex == null) {
            ClangParseResponse.$$$reportNull$$$0(5);
        }
        for (CompletableFuture<?> future : ClangParseResponse.getAllAnswers(file)) {
            if (future.isDone()) continue;
            future.completeExceptionally(ex);
        }
    }

    public static boolean didAnswersCome(@NotNull ClangParseResponse file) {
        CompletableFuture<?>[] answers;
        if (file == null) {
            ClangParseResponse.$$$reportNull$$$0(6);
        }
        for (CompletableFuture<?> answer : answers = ClangParseResponse.getAllAnswers(file)) {
            if (answer.isDone() && !answer.isCompletedExceptionally()) continue;
            return false;
        }
        return true;
    }

    public static boolean areAnswersCompleted(@NotNull ClangParseResponse file) {
        CompletableFuture<?>[] answers;
        if (file == null) {
            ClangParseResponse.$$$reportNull$$$0(7);
        }
        for (CompletableFuture<?> answer : answers = ClangParseResponse.getAllAnswers(file)) {
            if (answer.isDone()) continue;
            return false;
        }
        return true;
    }

    public static int getMemoryUsage(@NotNull ClangParseResponse parseResponse) {
        if (parseResponse == null) {
            ClangParseResponse.$$$reportNull$$$0(8);
        }
        return ClangParseResponse.getDiagsMemoryUsage(parseResponse.getDiagnostics()) + ClangParseResponse.getHighlightingsMemoryUsage(parseResponse.getHighlightings()) + ClangParseResponse.getCompressedDFAMemoryUsage(parseResponse.getDFAInput()) + ClangParseResponse.getClangTidyDiagsMemoryUsage(parseResponse.getOurTidyDiagnostics()) + ClangParseResponse.getClangTidyDiagsMemoryUsage(parseResponse.getTidyDiagnostics()) + ClangParseResponse.getDiagsMemoryUsage(parseResponse.getClazyDiagnostics());
    }

    public static int getDiagsMemoryUsage(@NotNull CompletableFuture<Supplier<List<ClangDiagnostic>>> diagnostics) {
        List diags;
        if (diagnostics == null) {
            ClangParseResponse.$$$reportNull$$$0(9);
        }
        Supplier supplier = (Supplier)CidrConcurrentUtilsKt.getIfCompletedNormally(diagnostics);
        int memUsage = 0;
        if (supplier != null && (diags = (List)supplier.get()) != null) {
            for (ClangDiagnostic diag : diags) {
                memUsage += diag.getMessage().length() * 2;
                memUsage += diag.getCode() != null ? diag.getCode().length() * 2 : 0;
                memUsage += diag.getSource() != null ? diag.getSource().length() * 2 : 0;
                memUsage += 16;
                if (diag.getNotes() != null) {
                    for (String string : diag.getNotes()) {
                        memUsage += string.length() * 2;
                    }
                }
                for (ClionFixItHint clionFixItHint : diag.getClionFixits()) {
                    memUsage += ClangParseResponse.geClionFixitMemoryUsage(clionFixItHint);
                }
            }
        }
        return memUsage;
    }

    public static int getCompressedDFAMemoryUsage(@NotNull CompletableFuture<Supplier<List<DFARawTuple>>> dfaInput) {
        Supplier supplier;
        if (dfaInput == null) {
            ClangParseResponse.$$$reportNull$$$0(10);
        }
        if ((supplier = (Supplier)CidrConcurrentUtilsKt.getIfCompletedNormally(dfaInput)) instanceof ClangClientImpl.DFASupplier) {
            return ((ClangClientImpl.DFASupplier)supplier).getCompressedSize();
        }
        return 0;
    }

    public static int getOriginalDFAMemoryUsage(@NotNull CompletableFuture<Supplier<List<DFARawTuple>>> dfaInput) {
        Supplier supplier;
        if (dfaInput == null) {
            ClangParseResponse.$$$reportNull$$$0(11);
        }
        if ((supplier = (Supplier)CidrConcurrentUtilsKt.getIfCompletedNormally(dfaInput)) instanceof ClangClientImpl.DFASupplier) {
            return ((ClangClientImpl.DFASupplier)supplier).getOriginalSize();
        }
        return 0;
    }

    public static int getHighlightingsMemoryUsage(@NotNull CompletableFuture<Supplier<List<ClangHighlighting>>> higlightings) {
        List hls;
        if (higlightings == null) {
            ClangParseResponse.$$$reportNull$$$0(12);
        }
        Supplier supplier = (Supplier)CidrConcurrentUtilsKt.getIfCompletedNormally(higlightings);
        int memUsage = 0;
        if (supplier != null && (hls = (List)supplier.get()) != null) {
            for (ClangHighlighting hl : hls) {
                memUsage += hl.getType().length() * 2;
                memUsage += 16;
            }
        }
        return memUsage;
    }

    public static int getClangTidyDiagsMemoryUsage(@NotNull CompletableFuture<Supplier<List<ClangTidyDiagnostic>>> diagnostics) {
        List diags;
        if (diagnostics == null) {
            ClangParseResponse.$$$reportNull$$$0(13);
        }
        Supplier supplier = (Supplier)CidrConcurrentUtilsKt.getIfCompletedNormally(diagnostics);
        int memUsage = 0;
        if (supplier != null && (diags = (List)supplier.get()) != null) {
            for (ClangTidyDiagnostic diag : diags) {
                memUsage += diag.getMessage().length() * 2;
                memUsage += diag.getDiagnosticName().length() * 2;
                memUsage += diag.getFilePath().length() * 2;
                memUsage += 4;
                memUsage += ClangParseResponse.geClionFixitMemoryUsage(diag.getClionFix());
                for (ClangTidyRange range : diag.getRanges()) {
                    memUsage += 8;
                    memUsage += range.getFilePath().length() * 2;
                }
                for (ClangTidyReplacement replacement : diag.getReplacements()) {
                    memUsage += replacement.getFilePath().length() * 2;
                    memUsage += 8;
                    memUsage += replacement.getReplacementText().length() * 2;
                }
            }
        }
        return memUsage;
    }

    private static int geClionFixitMemoryUsage(@Nullable ClionFixItHint clFix) {
        if (clFix == null) {
            return 0;
        }
        int memUsage = clFix.getId().length() * 2;
        List<String> params = clFix.getParams();
        if (params != null) {
            for (String param : params) {
                memUsage += param.length() * 2;
            }
        }
        return memUsage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/registry/ClangParseResponse";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ex";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parseResponse";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnostics";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaInput";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "higlightings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/registry/ClangParseResponse";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "showAnswerStates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllAnswers";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "showAnswerStates";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "completeAnswers";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "completeAnswersExceptionally";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "didAnswersCome";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "areAnswersCompleted";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getMemoryUsage";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDiagsMemoryUsage";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCompressedDFAMemoryUsage";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalDFAMemoryUsage";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightingsMemoryUsage";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getClangTidyDiagsMemoryUsage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static enum OpState {
        None,
        Sent,
        Fake,
        Failed;


        public boolean isValid() {
            switch (this.ordinal()) {
                case 0: 
                case 1: {
                    return true;
                }
            }
            return false;
        }
    }
}

