/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.registry;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangWorkspace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.WorkspaceFile;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractClangWorkspace<WF extends WorkspaceFile>
implements ClangWorkspace<WF> {
    @NotNull
    private final ConcurrentHashMap<String, FileAndLock> myUrl2FileStateMap = new ConcurrentHashMap();
    @NotNull
    private final TimeStats myTimeStats = new TimeStats();
    @NotNull
    private final TimeStats myAWTTimeStats = new TimeStats();

    @NotNull
    protected abstract WF createWorkspaceFile(@NotNull String var1);

    @Override
    public List<String> getRegisteredUrls() {
        return new ArrayList<String>(this.myUrl2FileStateMap.keySet());
    }

    @Override
    public void modify(@NotNull String url, @NotNull Consumer<WF> consumer) {
        if (url == null) {
            AbstractClangWorkspace.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            AbstractClangWorkspace.$$$reportNull$$$0(1);
        }
        this.modifyImpl(System.nanoTime(), url, consumer);
    }

    @Override
    public void modifyWithRead(@NotNull String url, @NotNull Consumer<WF> consumer) {
        if (url == null) {
            AbstractClangWorkspace.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            AbstractClangWorkspace.$$$reportNull$$$0(3);
        }
        long opStart = System.nanoTime();
        ReadAction.run(() -> this.modifyImpl(opStart, url, consumer));
    }

    /*
     * WARNING - void declaration
     */
    private void modifyImpl(long opStart, @NotNull String url, @NotNull Consumer<WF> consumer) {
        void consumer2;
        if (url == null) {
            AbstractClangWorkspace.$$$reportNull$$$0(4);
        }
        if (consumer == null) {
            AbstractClangWorkspace.$$$reportNull$$$0(5);
        }
        this.applyImpl(opStart, url, arg_0 -> AbstractClangWorkspace.lambda$modifyImpl$1((Consumer)consumer2, arg_0));
    }

    @Override
    public <T> T apply(@NotNull String url, @NotNull Function<WF, T> consumer) {
        if (url == null) {
            AbstractClangWorkspace.$$$reportNull$$$0(6);
        }
        if (consumer == null) {
            AbstractClangWorkspace.$$$reportNull$$$0(7);
        }
        return this.applyImpl(System.nanoTime(), url, consumer);
    }

    @Override
    public <T> T applyWithRead(@NotNull String url, @NotNull Function<WF, T> consumer) {
        if (url == null) {
            AbstractClangWorkspace.$$$reportNull$$$0(8);
        }
        if (consumer == null) {
            AbstractClangWorkspace.$$$reportNull$$$0(9);
        }
        long opStart = System.nanoTime();
        return (T)ReadAction.compute(() -> this.applyImpl(opStart, url, consumer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public <T> T applyImpl(long opStart, @NotNull String url, @NotNull Function<WF, T> function) {
        if (url == null) {
            AbstractClangWorkspace.$$$reportNull$$$0(10);
        }
        if (function == null) {
            AbstractClangWorkspace.$$$reportNull$$$0(11);
        }
        boolean isDispatchThread = ApplicationManager.getApplication().isDispatchThread();
        FileAndLock fileAndLock = this.getOrCreate(url);
        fileAndLock.lock.lock();
        try {
            void consumer;
            this.afterLockEntered(opStart, isDispatchThread);
            Object r = consumer.apply(fileAndLock.workspaceFile);
            return (T)r;
        }
        finally {
            fileAndLock.lock.unlock();
            this.afterOperationCompleted(opStart, isDispatchThread);
        }
    }

    @Override
    public void modify(@NotNull List<String> urls, @NotNull Consumer<Map<String, WF>> consumer) {
        if (urls == null) {
            AbstractClangWorkspace.$$$reportNull$$$0(12);
        }
        if (consumer == null) {
            AbstractClangWorkspace.$$$reportNull$$$0(13);
        }
        this.modifyImpl(System.nanoTime(), urls, consumer);
    }

    @Override
    public void modifyWithRead(@NotNull List<String> urls, @NotNull Consumer<Map<String, WF>> consumer) {
        if (urls == null) {
            AbstractClangWorkspace.$$$reportNull$$$0(14);
        }
        if (consumer == null) {
            AbstractClangWorkspace.$$$reportNull$$$0(15);
        }
        long opStart = System.nanoTime();
        ReadAction.run(() -> this.modifyImpl(opStart, urls, consumer));
    }

    /*
     * WARNING - void declaration
     */
    public void modifyImpl(long opStart, @NotNull List<String> urls, @NotNull Consumer<Map<String, WF>> consumer) {
        void consumer2;
        if (urls == null) {
            AbstractClangWorkspace.$$$reportNull$$$0(16);
        }
        if (consumer == null) {
            AbstractClangWorkspace.$$$reportNull$$$0(17);
        }
        this.applyImpl(opStart, urls, arg_0 -> AbstractClangWorkspace.lambda$modifyImpl$4((Consumer)consumer2, arg_0));
    }

    @Override
    public <T> T apply(@NotNull List<String> urls, @NotNull Function<Map<String, WF>, T> consumer) {
        if (urls == null) {
            AbstractClangWorkspace.$$$reportNull$$$0(18);
        }
        if (consumer == null) {
            AbstractClangWorkspace.$$$reportNull$$$0(19);
        }
        return this.applyImpl(System.nanoTime(), urls, consumer);
    }

    @Override
    public <T> T applyWithRead(@NotNull List<String> urls, @NotNull Function<Map<String, WF>, T> consumer) {
        if (urls == null) {
            AbstractClangWorkspace.$$$reportNull$$$0(20);
        }
        if (consumer == null) {
            AbstractClangWorkspace.$$$reportNull$$$0(21);
        }
        long opStart = System.nanoTime();
        return (T)ReadAction.compute(() -> this.applyImpl(opStart, urls, consumer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public <T> T applyImpl(long opStart, @NotNull List<String> urls, @NotNull Function<Map<String, WF>, T> function) {
        Iterator<Object> iterator;
        if (urls == null) {
            AbstractClangWorkspace.$$$reportNull$$$0(22);
        }
        if (function == null) {
            AbstractClangWorkspace.$$$reportNull$$$0(23);
        }
        boolean isDispatchThread = ApplicationManager.getApplication().isDispatchThread();
        ArrayList<String> sortedUrls = new ArrayList<String>(urls);
        sortedUrls.sort(Comparator.naturalOrder());
        HashMap statesMap = new HashMap();
        ArrayList<FileAndLock> fileAndLocks = new ArrayList<FileAndLock>();
        for (String url : sortedUrls) {
            FileAndLock fileAndLock = this.getOrCreate(url);
            fileAndLocks.add(fileAndLock);
            statesMap.put(url, fileAndLock.workspaceFile);
        }
        for (FileAndLock state : fileAndLocks) {
            state.lock.lock();
        }
        try {
            void consumer;
            this.afterLockEntered(opStart, isDispatchThread);
            iterator = consumer.apply(statesMap);
        }
        catch (Throwable throwable) {
            for (FileAndLock state : fileAndLocks) {
                state.lock.unlock();
            }
            this.afterOperationCompleted(opStart, isDispatchThread);
            throw throwable;
        }
        for (FileAndLock state : fileAndLocks) {
            state.lock.unlock();
        }
        this.afterOperationCompleted(opStart, isDispatchThread);
        return (T)iterator;
    }

    @Override
    public void clear() {
        this.myUrl2FileStateMap.clear();
    }

    @Override
    @NonNls
    @NotNull
    public String printStats(@NonNls @NotNull String linePrefix) {
        if (linePrefix == null) {
            AbstractClangWorkspace.$$$reportNull$$$0(24);
        }
        String string = this.myTimeStats.printStats(linePrefix + "Overall ") + this.myAWTTimeStats.printStats(linePrefix + "AWT ");
        if (string == null) {
            AbstractClangWorkspace.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    private FileAndLock getOrCreate(@NotNull String url) {
        if (url == null) {
            AbstractClangWorkspace.$$$reportNull$$$0(26);
        }
        FileAndLock fileAndLock = this.myUrl2FileStateMap.computeIfAbsent(url, key -> new FileAndLock(this, (String)key));
        if (fileAndLock == null) {
            AbstractClangWorkspace.$$$reportNull$$$0(27);
        }
        return fileAndLock;
    }

    private void afterLockEntered(long opStart, boolean isDispatchThread) {
        this.myTimeStats.afterLockEntered(opStart);
        if (isDispatchThread) {
            this.myAWTTimeStats.afterLockEntered(opStart);
        }
    }

    private void afterOperationCompleted(long opStart, boolean isDispatchThread) {
        this.myTimeStats.afterOperationCompleted(opStart);
        if (isDispatchThread) {
            this.myAWTTimeStats.afterOperationCompleted(opStart);
        }
    }

    private static /* synthetic */ Integer lambda$modifyImpl$4(Consumer consumer, Map wfMap) {
        consumer.accept(wfMap);
        return 0;
    }

    private static /* synthetic */ Integer lambda$modifyImpl$1(Consumer consumer, WorkspaceFile wf) {
        consumer.accept(wf);
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 25, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linePrefix";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/registry/AbstractClangWorkspace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/registry/AbstractClangWorkspace";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "printStats";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "modify";
                break;
            }
            case 2: 
            case 3: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "modifyWithRead";
                break;
            }
            case 4: 
            case 5: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "modifyImpl";
                break;
            }
            case 6: 
            case 7: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 8: 
            case 9: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "applyWithRead";
                break;
            }
            case 10: 
            case 11: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "applyImpl";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "printStats";
                break;
            }
            case 25: 
            case 27: {
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 25, 27 -> new IllegalStateException(string);
        };
    }

    private static class TimeStats {
        private final AtomicLong myTotalWaitTimeMicroSecs = new AtomicLong(0L);
        private final AtomicLong myMaxWaitTimeMicroSecs = new AtomicLong(0L);
        private final AtomicLong myTotalOpTimeMicroSecs = new AtomicLong(0L);
        private final AtomicLong myMaxOpTimeMicroSecs = new AtomicLong(0L);
        private final AtomicInteger myNumOfOps = new AtomicInteger(0);

        private TimeStats() {
        }

        private int getAverageWaitTimeMicroSecs() {
            int numOfOps = this.myNumOfOps.get();
            long totalWaitTime = this.myTotalWaitTimeMicroSecs.get();
            return numOfOps > 0 ? Long.valueOf(totalWaitTime / (long)numOfOps).intValue() : 0;
        }

        private int getAverageOpTimeMicroSecs() {
            int numOfOps = this.myNumOfOps.get();
            long totalOpTime = this.myTotalOpTimeMicroSecs.get();
            return numOfOps > 0 ? Long.valueOf(totalOpTime / (long)numOfOps).intValue() : 0;
        }

        private static String renderTimeValue(long valueMicroSecs) {
            return valueMicroSecs > 1000L ? valueMicroSecs / 1000L + "ms" : valueMicroSecs + "\u00b5s";
        }

        final void afterLockEntered(long opStartTime) {
            long currentMaxWaitTime;
            long waitTimeMicroSecs = (System.nanoTime() - opStartTime) / 1000L;
            this.myNumOfOps.incrementAndGet();
            this.myTotalWaitTimeMicroSecs.addAndGet(waitTimeMicroSecs);
            while ((currentMaxWaitTime = this.myMaxWaitTimeMicroSecs.get()) < waitTimeMicroSecs) {
                this.myMaxWaitTimeMicroSecs.compareAndSet(currentMaxWaitTime, waitTimeMicroSecs);
            }
        }

        final void afterOperationCompleted(long opStartTime) {
            long currentMaxOpTime;
            long opTimeMicroSecs = (System.nanoTime() - opStartTime) / 1000L;
            this.myTotalOpTimeMicroSecs.addAndGet(opTimeMicroSecs);
            while ((currentMaxOpTime = this.myMaxOpTimeMicroSecs.get()) < opTimeMicroSecs) {
                this.myMaxOpTimeMicroSecs.compareAndSet(currentMaxOpTime, opTimeMicroSecs);
            }
        }

        @NonNls
        final String printStats(@NotNull @NonNls String linePrefix) {
            if (linePrefix == null) {
                TimeStats.$$$reportNull$$$0(0);
            }
            return linePrefix + "File registry events: " + this.myNumOfOps.get() + "\n" + linePrefix + "Wait time (avg/max): " + TimeStats.renderTimeValue(this.getAverageWaitTimeMicroSecs()) + " / " + TimeStats.renderTimeValue(this.myMaxWaitTimeMicroSecs.get()) + "\n" + linePrefix + "Operation time (avg/max): " + TimeStats.renderTimeValue(this.getAverageOpTimeMicroSecs()) + " / " + TimeStats.renderTimeValue(this.myMaxOpTimeMicroSecs.get()) + "\n";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linePrefix", "com/jetbrains/cidr/lang/daemon/clang/clangd/registry/AbstractClangWorkspace$TimeStats", "printStats"));
        }
    }

    private final class FileAndLock {
        @NotNull
        final WF workspaceFile;
        @NotNull
        final Lock lock;

        private FileAndLock(@NotNull AbstractClangWorkspace abstractClangWorkspace, String url) {
            if (url == null) {
                FileAndLock.$$$reportNull$$$0(0);
            }
            this.workspaceFile = abstractClangWorkspace.createWorkspaceFile(url);
            this.lock = new ReentrantLock();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/cidr/lang/daemon/clang/clangd/registry/AbstractClangWorkspace$FileAndLock", "<init>"));
        }
    }
}

