/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.daemon.clang.ClangDebugLevel;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdCompilationCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Cpp20ModulesContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ParsingParamsTransformer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Trustworthiness;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionClazyConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangDFAConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangTidyConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionCompileCommandParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionReparseTextDocumentParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionWantDiagnostics;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.UnusedIncludesInspectionMode;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangChangeNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangFileBasedNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangHeavyRequestBuilder;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteractionPromise;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteractionPromiseImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangProperty;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestsHelper;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.RemoteWorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponse;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspace;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.logging.Level;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangReparseNotification
extends ClangFileBasedNotification<ReparseData> {
    @NotNull
    private final ClangParseResponse myResponse;
    @NotNull
    private final String myMacroDefinitions;
    private final boolean myPrepareOnly;

    @NotNull
    public static ClangInteractionPromise createPromise(@NotNull ClangHeavyRequestBuilder builder, @NotNull ClangDaemonContext context, @NotNull VirtualFile virtualFile, @NotNull ClangParseResponse response, boolean prepareOnly) {
        if (builder == null) {
            ClangReparseNotification.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ClangReparseNotification.$$$reportNull$$$0(1);
        }
        if (virtualFile == null) {
            ClangReparseNotification.$$$reportNull$$$0(2);
        }
        if (response == null) {
            ClangReparseNotification.$$$reportNull$$$0(3);
        }
        Ref result = Ref.create();
        File macrosPath = ClangRequestsHelper.getMacrosFilePath(context, response.getUrl());
        CompletableFuture futureRequest = builder.laterAsync(() -> context.getIdeFacade().getCompilationCommandAsync(context.getUrlConverter(), context.getProject(), virtualFile, macrosPath.getPath(), Cpp20ModulesContext.create(context)).thenApply(cc -> ClangReparseNotification.create(context, virtualFile, response, cc, prepareOnly)));
        result.set((Object)new ClangInteractionPromiseImpl.Builder<ClangReparseNotification>(ClangReparseNotification.class, futureRequest).addReadAccessedProperties(response.getUrl(), ClangProperty.Content).addWriteAccessedProperties(response.getUrl(), ClangProperty.Ast).addRejectedHandler(() -> {
            Predicate<List<ClangInteractionPromise>> allReparsesFailed = reparses -> ContainerUtil.all((Collection)reparses, reparse -> ClangReparseNotification.isFailedOrNoResult(reparse.getInteraction()));
            if (response.nextOpState(ClangParseResponse.OpState.Failed, allReparsesFailed)) {
                ClangUtils.warnClangd(LOG, "Parse rejected for file " + response.getUrl() + " of version " + response.getVersion());
                ClangParseResponse.completeAnswers(response);
            }
        }).create());
        ClangInteractionPromise clangInteractionPromise = (ClangInteractionPromise)result.get();
        if (clangInteractionPromise == null) {
            ClangReparseNotification.$$$reportNull$$$0(4);
        }
        return clangInteractionPromise;
    }

    private static boolean isFailedOrNoResult(@NotNull CompletableFuture<?> future) {
        if (future == null) {
            ClangReparseNotification.$$$reportNull$$$0(5);
        }
        return CidrConcurrentUtilsKt.isCompletedExceptionally(future) || CidrConcurrentUtilsKt.isCompletedNormally(future) && CidrConcurrentUtilsKt.getIfCompletedNormally(future) == null;
    }

    @Nullable
    private static ClangReparseNotification create(@NotNull ClangDaemonContext context, @NotNull VirtualFile virtualFile, @NotNull ClangParseResponse response, @Nullable ClangdCompilationCommand compilationCommand, boolean prepareOnly) {
        if (context == null) {
            ClangReparseNotification.$$$reportNull$$$0(6);
        }
        if (virtualFile == null) {
            ClangReparseNotification.$$$reportNull$$$0(7);
        }
        if (response == null) {
            ClangReparseNotification.$$$reportNull$$$0(8);
        }
        if (context.getProject().isDisposed()) {
            return null;
        }
        Project project = context.getProject();
        String url = response.getUrl();
        String targetURI = context.getUrlConverter().toUriFromUrl(url);
        int version = response.getVersion();
        boolean cancellable = response.isCancellable();
        if (ClangRequestsHelper.isAllowedByGuard(context, url)) {
            String macros;
            ClionCompileCommandParams compileParams;
            Trustworthiness trustworthiness;
            if (compilationCommand != null) {
                trustworthiness = compilationCommand.trustworthiness;
                compileParams = compilationCommand.ccParams;
                macros = compilationCommand.ppDefines;
                if (!ContainerUtil.exists(compileParams.getCommandLine(), arg -> arg.startsWith("--target="))) {
                    trustworthiness = trustworthiness.with(4);
                }
            } else {
                List<String> commandLine;
                Trustworthiness trustworthiness2 = trustworthiness = ClangdBridge.isClangdOnlyMode() ? new Trustworthiness() : new Trustworthiness(1);
                if (Registry.is((String)"clion.search.header.paths")) {
                    commandLine = new ArrayList(4);
                    commandLine.add("clang");
                    commandLine.add("--search-header-paths");
                    if (virtualFile.getExtension() == null) {
                        commandLine.add("-xc++-system-header");
                    }
                } else {
                    commandLine = Collections.emptyList();
                }
                compileParams = new ClionCompileCommandParams(targetURI, targetURI, "", commandLine, "/dev/null", true);
                macros = "";
            }
            ClionClangTidyConfigParams clangTidyConfig = context.getIdeFacade().getClangTidyConfig(project, virtualFile);
            UnusedIncludesInspectionMode unusedInspectionMode = context.getIdeFacade().getUnusedIncludesInspectionMode(project, virtualFile);
            CLionClazyConfigParams clazyConfig = context.getIdeFacade().getClazyConfig(project, virtualFile);
            ClionWantDiagnostics WantDiags = cancellable ? ClionWantDiagnostics.Auto : ClionWantDiagnostics.Yes;
            ClionClangDFAConfigParams dfaOptions = context.getIdeFacade().getDFAOptions(project, virtualFile);
            VersionedTextDocumentIdentifier docId = new VersionedTextDocumentIdentifier();
            docId.setUri(targetURI);
            docId.setVersion(Integer.valueOf(version));
            ClionReparseTextDocumentParams params = new ClionReparseTextDocumentParams(docId, compileParams, clangTidyConfig, unusedInspectionMode, clazyConfig, WantDiags, dfaOptions, response.getPreambleVersion());
            ParsingParamsTransformer transform = (ParsingParamsTransformer)response.getUserData(ClangParseResponse.PARSING_PARAMS_TRANSFORM);
            if (transform != null) {
                params = transform.transform(params);
                trustworthiness = transform.transform(trustworthiness);
            }
            response.putUserData(ClangParseResponse.TRUSTWORTHINESS, trustworthiness);
            if (dfaOptions == null) {
                response.getDFAInput().complete(null);
            }
            ReparseData reparseData = new ReparseData(context, url, params);
            return new ClangReparseNotification(context, response, reparseData, StringUtil.notNullize((String)macros), prepareOnly);
        }
        if (ClangDebugLevel.isWarnOrMore()) {
            CidrLogService.logOnce((Level)Level.WARNING, (String)("File [" + url + "] was banned!"), (Throwable)new Exception());
        }
        return null;
    }

    private ClangReparseNotification(@NotNull ClangDaemonContext context, @NotNull ClangParseResponse response, @NotNull ReparseData data, @NotNull String macroDefinitions, boolean prepareOnly) {
        if (context == null) {
            ClangReparseNotification.$$$reportNull$$$0(9);
        }
        if (response == null) {
            ClangReparseNotification.$$$reportNull$$$0(10);
        }
        if (data == null) {
            ClangReparseNotification.$$$reportNull$$$0(11);
        }
        if (macroDefinitions == null) {
            ClangReparseNotification.$$$reportNull$$$0(12);
        }
        super(context, response.getUrl(), response.getVersion(), true, data);
        this.myResponse = response;
        this.myMacroDefinitions = macroDefinitions;
        this.myPrepareOnly = prepareOnly;
    }

    private static void sendArmSveWorkaroundIfRequired(@NotNull ClangDaemonContext context, @NotNull ClangServer server, @NotNull ClangRemoteWorkspace ws) {
        if (context == null) {
            ClangReparseNotification.$$$reportNull$$$0(13);
        }
        if (server == null) {
            ClangReparseNotification.$$$reportNull$$$0(14);
        }
        if (ws == null) {
            ClangReparseNotification.$$$reportNull$$$0(15);
        }
        if (ws.apply(ClangRequestsHelper.getArmSveWorkaroundUrl(), rf -> rf.getContent()) != null) {
            return;
        }
        VersionedTextDocumentIdentifier docId = new VersionedTextDocumentIdentifier();
        docId.setUri(context.getUrlConverter().toUri(new File(ClangRequestsHelper.getArmSveWorkaroundPath()), false));
        docId.setVersion(Integer.valueOf(0));
        TextDocumentContentChangeEvent docChangeEvent = new TextDocumentContentChangeEvent();
        docChangeEvent.setText(ClangRequestsHelper.getArmSveWorkaroundContent());
        ClangChangeNotification.create(context, ClangRequestsHelper.getArmSveWorkaroundUrl(), 0, new DidChangeTextDocumentParams(docId, Collections.singletonList(docChangeEvent)), false).send(server, ws);
    }

    private static void sendQObjectDefsIfRequired(ClangDaemonContext context, @NotNull ClangServer server, @NotNull ClangRemoteWorkspace ws) {
        if (server == null) {
            ClangReparseNotification.$$$reportNull$$$0(16);
        }
        if (ws == null) {
            ClangReparseNotification.$$$reportNull$$$0(17);
        }
        if (ws.apply(ClangRequestsHelper.getQobjectDefsUrl(), rf -> rf.getContent()) != null) {
            return;
        }
        VersionedTextDocumentIdentifier docIdQobject = new VersionedTextDocumentIdentifier();
        docIdQobject.setUri(context.getUrlConverter().toUri(new File(ClangRequestsHelper.getQobjectDefsPath()), false));
        docIdQobject.setVersion(Integer.valueOf(0));
        TextDocumentContentChangeEvent changeEventQobject = new TextDocumentContentChangeEvent();
        changeEventQobject.setText(ClangRequestsHelper.getQobjectDefsContent());
        ClangChangeNotification.create(context, ClangRequestsHelper.getQobjectDefsUrl(), 0, new DidChangeTextDocumentParams(docIdQobject, Collections.singletonList(changeEventQobject)), false).send(server, ws);
    }

    @NotNull
    public ClangParseResponse getResponse() {
        ClangParseResponse clangParseResponse = this.myResponse;
        if (clangParseResponse == null) {
            ClangReparseNotification.$$$reportNull$$$0(18);
        }
        return clangParseResponse;
    }

    @Override
    protected boolean sendNotificationImpl(@NotNull ClangServer server, @NotNull ClangRemoteWorkspace ws) {
        if (server == null) {
            ClangReparseNotification.$$$reportNull$$$0(19);
        }
        if (ws == null) {
            ClangReparseNotification.$$$reportNull$$$0(20);
        }
        assert (ws.isOpenedRemotely(this.myUrl));
        if (!this.myPrepareOnly && this.myResponse.getOpState() != ClangParseResponse.OpState.None) {
            ClangUtils.warnClangd(LOG, "Reparse notification skipped because file " + this.myUrl + " of version " + ((ReparseData)this.myParams).params.getTextDocument().getVersion() + " was already parsed");
            return false;
        }
        if (ClangDebugLevel.isWarnOrMore()) {
            ClangUtils.warnClangd(LOG, (this.myPrepareOnly ? "Preparing" : "Reparsing") + " file " + this.myUrl + " of version " + ((ReparseData)this.myParams).params.getTextDocument().getVersion());
        }
        this.myContext.getTelemetry().getGeneralTelemetry().notifyReparseSent(this);
        ClangReparseNotification.sendMacrosIfRequired(this.myContext, this.myUrl, this.myMacroDefinitions, server, ws);
        if (ClangRequestsHelper.containsArmSveWorkaround(((ReparseData)this.myParams).params.getCompilationCommand().getCommandLine())) {
            ClangReparseNotification.sendArmSveWorkaroundIfRequired(this.myContext, server, ws);
        }
        if (ClangRequestsHelper.containsQtCore(((ReparseData)this.myParams).params.getCompilationCommand().getCommandLine())) {
            ClangReparseNotification.sendQObjectDefsIfRequired(this.myContext, server, ws);
        }
        if (this.myPrepareOnly) {
            this.onRejected();
            return true;
        }
        if (ClangReparseNotification.doSend(server, (ReparseData)this.myParams)) {
            this.myResponse.nextOpState(ClangParseResponse.OpState.Sent);
            return true;
        }
        return false;
    }

    static void sendMacrosIfRequired(@NotNull ClangDaemonContext context, @NotNull String myMainFileUrl, @NotNull String macroDefinitions, @NotNull ClangServer server, @NotNull ClangRemoteWorkspace ws) {
        String macrosUrl;
        String prevMacrosContent;
        if (context == null) {
            ClangReparseNotification.$$$reportNull$$$0(21);
        }
        if (myMainFileUrl == null) {
            ClangReparseNotification.$$$reportNull$$$0(22);
        }
        if (macroDefinitions == null) {
            ClangReparseNotification.$$$reportNull$$$0(23);
        }
        if (server == null) {
            ClangReparseNotification.$$$reportNull$$$0(24);
        }
        if (ws == null) {
            ClangReparseNotification.$$$reportNull$$$0(25);
        }
        if (!Objects.equals(prevMacrosContent = ws.apply(macrosUrl = ClangRequestsHelper.getMacrosFileUrl(context, myMainFileUrl), rf -> rf.getContent()), macroDefinitions)) {
            File macrosPath = ClangRequestsHelper.getMacrosFilePath(context, myMainFileUrl);
            VersionedTextDocumentIdentifier docId = new VersionedTextDocumentIdentifier();
            docId.setUri(context.getUrlConverter().toUri(macrosPath, false));
            docId.setVersion(Integer.valueOf(0));
            TextDocumentContentChangeEvent changeEvent = new TextDocumentContentChangeEvent();
            changeEvent.setText(macroDefinitions);
            ClangChangeNotification.create(context, macrosUrl, docId.getVersion(), new DidChangeTextDocumentParams(docId, Collections.singletonList(changeEvent)), false).send(server, ws);
        }
    }

    @Override
    public void onSkipped(@NotNull ClangRemoteWorkspace ws) {
        if (ws == null) {
            ClangReparseNotification.$$$reportNull$$$0(26);
        }
        super.onSkipped(ws);
        if (this.myResponse.nextOpState(ClangParseResponse.OpState.Failed)) {
            ClangParseResponse.completeAnswers(this.myResponse);
        }
    }

    @Override
    public void onRejected() {
        super.onRejected();
        if (this.myResponse.nextOpState(ClangParseResponse.OpState.Failed)) {
            ClangParseResponse.completeAnswers(this.myResponse);
        }
    }

    @Override
    protected void toNextRemoteState(@NotNull ClangRemoteWorkspace ws, @NotNull ReparseData params) {
        if (ws == null) {
            ClangReparseNotification.$$$reportNull$$$0(27);
        }
        if (params == null) {
            ClangReparseNotification.$$$reportNull$$$0(28);
        }
        super.toNextRemoteState(ws, params);
        this.myResponse.putUserData(ClangParseResponse.UNSAVED_FILES, ws.getUnsavedFiles());
    }

    @Override
    protected void toNextRemoteState(@NotNull RemoteWorkspaceFile wf, @NotNull ReparseData params) {
        if (wf == null) {
            ClangReparseNotification.$$$reportNull$$$0(29);
        }
        if (params == null) {
            ClangReparseNotification.$$$reportNull$$$0(30);
        }
        super.toNextRemoteState(wf, params);
        wf.put(RemoteWorkspaceFile.REMOTE_COMPILATION_COMMAND, params.params);
        wf.put(RemoteWorkspaceFile.IS_PARSED, !this.myPrepareOnly);
    }

    static boolean doSend(@NotNull ClangServer server, @NotNull ReparseData data) {
        if (server == null) {
            ClangReparseNotification.$$$reportNull$$$0(31);
        }
        if (data == null) {
            ClangReparseNotification.$$$reportNull$$$0(32);
        }
        server.clionReparse(data.params);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 4: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangReparseNotification";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
            case 11: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 12: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macroDefinitions";
                break;
            }
            case 14: 
            case 16: 
            case 19: 
            case 24: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 15: 
            case 17: 
            case 20: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ws";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myMainFileUrl";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangReparseNotification";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createPromise";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getResponse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createPromise";
                break;
            }
            case 4: 
            case 18: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isFailedOrNoResult";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "sendArmSveWorkaroundIfRequired";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "sendQObjectDefsIfRequired";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "sendNotificationImpl";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "sendMacrosIfRequired";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "onSkipped";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "toNextRemoteState";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "doSend";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 18 -> new IllegalStateException(string);
        };
    }

    static class ReparseData {
        @NotNull
        public final ClangDaemonContext context;
        @NotNull
        public final String url;
        @NotNull
        public final ClionReparseTextDocumentParams params;

        ReparseData(@NotNull ClangDaemonContext context, @NotNull String url, @NotNull ClionReparseTextDocumentParams params) {
            if (context == null) {
                ReparseData.$$$reportNull$$$0(0);
            }
            if (url == null) {
                ReparseData.$$$reportNull$$$0(1);
            }
            if (params == null) {
                ReparseData.$$$reportNull$$$0(2);
            }
            this.context = context;
            this.url = url;
            this.params = params;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "url";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "params";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangReparseNotification$ReparseData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

