/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ConcurrencyUtil;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.ClangDebugLevel;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangDaemonNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionItem;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionList;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.client.ClangClient;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.client.ClangClientAdapter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionCheckPreprocessedCaseParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionClangPreprocessParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionClangPreprocessResult;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionDocumentRangeFormattingParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionSymbolInformation;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionWorkspaceSymbolParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClangdInlayHint;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionCancelParseParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionDidCloseTextDocumentParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionDidDeleteTextDocumentParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionFileStats;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionMemoryUsageInfo;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionPublishDFAInputTuples;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionPublishDiagnosticsParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionPublishHighlightingsParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionPublishTidyDiagnosticsParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionReparseTextDocumentParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionWantDiagnostics;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.InlayHintsParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.reports.ClangCrashReporter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.reports.ClangCrashReporterImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.CLangdCrashCollector;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangCommandLine;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangCommandLineArgument;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerAdapter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.TextDocumentServiceAdapter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.navigationLight.ClangLightSymbolInfoResponse;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import com.jetbrains.cidr.lang.highlighting.ClangBracketMatchResult;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DocumentOnTypeFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangCrashHandler {
    public static final Key<ClangCrashReporter> CRASH_REPORTER_KEY = Key.create((String)"CLANG_CRASH_REPORTER");
    private static final Logger LOG = Logger.getInstance(ClangCrashHandler.class);
    private static final int FAILURES_THRESHOLD = 2;
    private static final int PENDING_FUTURES_THRESHOLD = 4096;
    private static final long DONT_NOTIFY_CRASH_INTERVAL_MS = 300000L;
    @NotNull
    private static final AtomicBoolean ourCrashReporterRunning = new AtomicBoolean(false);
    @NotNull
    private static final ExecutorService ourCrashReporterService = ConcurrencyUtil.newSingleThreadExecutor((String)"Clang crash reporter");
    @NotNull
    private final Map<ActionType, Long> myCrashReport2Timestamp;
    @NotNull
    private final Map<ActionType, Integer> myCrashReason2Counter;
    @NotNull
    private final ClangDaemonContext myContext;
    @NotNull
    private final ClangCrashReporter myReporter;
    @NotNull
    private final PendingInteractions myPendingInteractions;
    @NotNull
    private final Cache<String, Integer> myTrackedFailures;
    @NotNull
    private final AtomicInteger myCookieGenerator;
    @NotNull
    private final AtomicInteger myNumOfCrashes;
    @NotNull
    private final AtomicInteger myNumOfStops;

    public ClangCrashHandler(@NotNull ClangDaemonContext context) {
        if (context == null) {
            ClangCrashHandler.$$$reportNull$$$0(0);
        }
        this.myCrashReport2Timestamp = new HashMap<ActionType, Long>();
        this.myCrashReason2Counter = new HashMap<ActionType, Integer>();
        this.myReporter = new ClangCrashReporterImpl();
        this.myPendingInteractions = new PendingInteractions();
        this.myTrackedFailures = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();
        this.myCookieGenerator = new AtomicInteger(0);
        this.myNumOfCrashes = new AtomicInteger(0);
        this.myNumOfStops = new AtomicInteger(0);
        this.myContext = context;
    }

    public boolean hadCrashes() {
        return this.myNumOfCrashes.get() > 0;
    }

    public boolean isBanned(@NotNull String url) {
        if (url == null) {
            ClangCrashHandler.$$$reportNull$$$0(1);
        }
        if (ClangCrashHandler.isBlacklistEnabled() && this.myContext.getUrlConverter().isAcceptable(url)) {
            String uri = this.myContext.getUrlConverter().toUriFromUrl(url);
            Integer numOfFailures = (Integer)this.myTrackedFailures.getIfPresent((Object)uri);
            return numOfFailures != null && numOfFailures >= 2;
        }
        return false;
    }

    private static boolean isBlacklistEnabled() {
        return Registry.is((String)"clion.clang.clangd.blacklist");
    }

    public boolean hasPendingInteractions() {
        return !this.myPendingInteractions.empty();
    }

    public void onServerFailure() {
        this.myNumOfCrashes.incrementAndGet();
        ArrayList<PendingParse> pendingParses = new ArrayList<PendingParse>();
        ArrayList<PendingRequest> pendingRequests = new ArrayList<PendingRequest>();
        this.myPendingInteractions.runAndClear((parsesMapping, requestsMapping) -> {
            for (Map.Entry uriAndParses : parsesMapping.entrySet()) {
                SortedMap parses = (SortedMap)uriAndParses.getValue();
                if (parses.isEmpty()) continue;
                pendingParses.add((PendingParse)parses.values().iterator().next());
            }
            HashMap<String, PendingRequest> uriToFirstRequest = new HashMap<String, PendingRequest>();
            for (PendingRequest request : requestsMapping.values()) {
                PendingRequest existing = uriToFirstRequest.computeIfAbsent(request.uri, u -> request);
                if (existing == request || !request.before(existing)) continue;
                uriToFirstRequest.put(request.uri, request);
            }
            pendingRequests.addAll(uriToFirstRequest.values());
        });
        this.reportCrash(pendingParses, pendingRequests);
        List<String> newBannedFiles = this.updatedCrashTracker(pendingParses, pendingRequests);
        if (!newBannedFiles.isEmpty() && ClangCrashHandler.isBlacklistEnabled() && ClangDebugLevel.isWarnOrMore()) {
            Notifications.Bus.notify((Notification)new ClangDaemonNotification(ClangdBundle.message("language.cpp.clangd.blacklist.description", newBannedFiles), NotificationType.INFORMATION), (Project)this.myContext.getProject());
        }
    }

    void reportCrash(@NotNull List<PendingParse> pendingParses, @NotNull List<PendingRequest> pendingRequests) {
        if (pendingParses == null) {
            ClangCrashHandler.$$$reportNull$$$0(2);
        }
        if (pendingRequests == null) {
            ClangCrashHandler.$$$reportNull$$$0(3);
        }
        CLangdCrashCollector.TOTAL.log();
        if (this.myContext.isAnyIndexer()) {
            this.processCrashReason(ActionType.INDEXER);
            return;
        }
        if (!ourCrashReporterRunning.compareAndSet(false, true)) {
            return;
        }
        try {
            ourCrashReporterService.execute(() -> {
                try {
                    BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this.myContext, () -> {
                        String title = this.myContext.isAnyIndexer() ? ClangdBundle.message("language.cpp.clangd.indexer.crash.message.simple", new Object[0]) : ClangdBundle.message("language.cpp.clangd.crash.message.simple", new Object[0]);
                        String message = ClangCrashHandler.getCrashMessage(title, pendingParses, pendingRequests);
                        ClangCrashReporter crashReporter = this.getCrashReporter();
                        if (this.myContext.isAnyIndexer()) {
                            crashReporter.report(this.myContext, message, null);
                        } else {
                            Set<String> filesCausedCrash = ClangCrashHandler.getCandidatesCausedCrash(pendingParses, pendingRequests);
                            this.investigateCrash(pendingParses, pendingRequests);
                            crashReporter.report(this.myContext, message, filesCausedCrash.stream().toList());
                        }
                    });
                }
                finally {
                    ourCrashReporterRunning.set(false);
                }
            });
        }
        catch (Throwable thr) {
            ourCrashReporterRunning.set(false);
        }
    }

    private void investigateCrash(@NotNull List<PendingParse> pendingParses, @NotNull List<PendingRequest> pendingRequests) {
        if (pendingParses == null) {
            ClangCrashHandler.$$$reportNull$$$0(4);
        }
        if (pendingRequests == null) {
            ClangCrashHandler.$$$reportNull$$$0(5);
        }
        if (pendingParses.isEmpty() && pendingRequests.isEmpty()) {
            return;
        }
        EnumSet<ActionType> crashReasons = EnumSet.noneOf(ActionType.class);
        for (PendingParse parse : pendingParses) {
            ActionType crashReason = parse.getWhomToBlame();
            if (crashReason == null) continue;
            crashReasons.add(crashReason);
        }
        for (PendingRequest pendingReq : pendingRequests) {
            if (!pendingReq.type.isDangerous() || pendingReq.type.myActionType == null) continue;
            crashReasons.add(pendingReq.type.myActionType);
        }
        for (ActionType whatCrashed : crashReasons) {
            this.processCrashReason(whatCrashed);
        }
    }

    private void processCrashReason(@NotNull ActionType whatCrashed) {
        ActionDisabler disabler;
        long timeSinceLastReport;
        if (whatCrashed == null) {
            ClangCrashHandler.$$$reportNull$$$0(6);
        }
        int crashCounter = this.myCrashReason2Counter.merge(whatCrashed, 1, Integer::sum);
        switch (whatCrashed.ordinal()) {
            case 5: 
            case 6: {
                CLangdCrashCollector.TIDY.log();
                break;
            }
            case 3: {
                CLangdCrashCollector.NAME_HINTS.log();
            }
        }
        Long lastReportTs = this.myCrashReport2Timestamp.get((Object)whatCrashed);
        long currentTs = System.currentTimeMillis();
        long l = timeSinceLastReport = lastReportTs != null ? currentTs - lastReportTs : Long.MAX_VALUE;
        if (timeSinceLastReport < 300000L) {
            return;
        }
        if (crashCounter >= whatCrashed.beforeDisableCrashCount && whatCrashed.disablerSupplier != null && (disabler = whatCrashed.disablerSupplier.get()).disable(this.myContext.getProject())) {
            ClangCrashHandler.notifyDisabled(ClangdBundle.message(whatCrashed.nameKey, new Object[0]), project -> disabler.enableBack((Project)project));
            this.myCrashReport2Timestamp.put(whatCrashed, currentTs);
            this.myCrashReason2Counter.put(whatCrashed, 0);
        }
    }

    @NotNull
    private ClangCrashReporter getCrashReporter() {
        ClangCrashReporter crashReporter = (ClangCrashReporter)this.myContext.getProject().getUserData(CRASH_REPORTER_KEY);
        ClangCrashReporter clangCrashReporter = crashReporter != null ? crashReporter : this.myReporter;
        if (clangCrashReporter == null) {
            ClangCrashHandler.$$$reportNull$$$0(7);
        }
        return clangCrashReporter;
    }

    private static void notifyDisabled(@Nls @NotNull String what, final @NotNull Consumer<Project> rollback) {
        if (what == null) {
            ClangCrashHandler.$$$reportNull$$$0(8);
        }
        if (rollback == null) {
            ClangCrashHandler.$$$reportNull$$$0(9);
        }
        NotificationAction keepDisabledAction = new NotificationAction(ClangdBundle.message("language.cpp.clangd.disable.keep", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (notification == null) {
                    1.$$$reportNull$$$0(1);
                }
                notification.expire();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$1";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        NotificationAction rollbackAction = new NotificationAction(ClangdBundle.message("language.cpp.clangd.disable.rollback", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (notification == null) {
                    2.$$$reportNull$$$0(1);
                }
                notification.expire();
                Project project = e.getProject();
                if (project != null) {
                    rollback.accept(project);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$2";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        Notification notification = new Notification("Clangd Crashed", ClangdBundle.message("language.cpp.clangd.disable.title", what), ClangdBundle.message("language.cpp.clangd.disable.message", what), NotificationType.INFORMATION);
        notification.addAction((AnAction)keepDisabledAction);
        notification.addAction((AnAction)rollbackAction);
        Notifications.Bus.notify((Notification)notification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private List<String> updatedCrashTracker(@NotNull List<PendingParse> pendingParses, @NotNull List<PendingRequest> pendingRequests) {
        Set<String> filesCausedCrash;
        if (pendingParses == null) {
            ClangCrashHandler.$$$reportNull$$$0(10);
        }
        if (pendingRequests == null) {
            ClangCrashHandler.$$$reportNull$$$0(11);
        }
        if ((filesCausedCrash = ClangCrashHandler.getCandidatesCausedCrash(pendingParses, pendingRequests)).isEmpty()) {
            assert (pendingParses.isEmpty()) : "Why there are no affected files, if there are pending parses?";
            for (PendingRequest pendingRequest : pendingRequests) {
                if (pendingRequest.uri == null) continue;
                filesCausedCrash.add(pendingRequest.uri);
            }
        }
        ArrayList<String> newBannedFiles = new ArrayList<String>();
        Cache<String, Integer> cache = this.myTrackedFailures;
        synchronized (cache) {
            for (String uri : filesCausedCrash) {
                Integer numOfFailures = (Integer)this.myTrackedFailures.getIfPresent((Object)uri);
                numOfFailures = numOfFailures != null ? numOfFailures + 1 : 1;
                this.myTrackedFailures.put((Object)uri, (Object)numOfFailures);
                if (numOfFailures != 2) continue;
                newBannedFiles.add(uri);
            }
        }
        ArrayList<String> arrayList = newBannedFiles;
        if (arrayList == null) {
            ClangCrashHandler.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    public void onServerStop() {
        this.myNumOfStops.incrementAndGet();
        this.myPendingInteractions.clear();
    }

    @NotNull
    private static String getCrashMessage(@NotNull String title, @NotNull List<PendingParse> pendingParses, @NotNull List<PendingRequest> pendingRequests) {
        if (title == null) {
            ClangCrashHandler.$$$reportNull$$$0(13);
        }
        if (pendingParses == null) {
            ClangCrashHandler.$$$reportNull$$$0(14);
        }
        if (pendingRequests == null) {
            ClangCrashHandler.$$$reportNull$$$0(15);
        }
        String pendingParsesText = !pendingParses.isEmpty() ? ClangdBundle.message("language.cpp.clangd.crash.parses.message", pendingParses.stream().map(r -> r.displayText()).collect(Collectors.joining("\n"))) + "\n" : "";
        String pendingRequestsText = !pendingRequests.isEmpty() ? ClangdBundle.message("language.cpp.clangd.crash.requests.message", pendingRequests.stream().map(r -> r.displayText()).collect(Collectors.joining("\n"))) : "";
        String string = title + "\n" + pendingParsesText + pendingRequestsText;
        if (string == null) {
            ClangCrashHandler.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    private static Set<String> getCandidatesCausedCrash(@NotNull List<PendingParse> pendingParses, @NotNull List<PendingRequest> pendingRequests) {
        if (pendingParses == null) {
            ClangCrashHandler.$$$reportNull$$$0(17);
        }
        if (pendingRequests == null) {
            ClangCrashHandler.$$$reportNull$$$0(18);
        }
        HashSet<String> candidates = new HashSet<String>();
        for (PendingParse pendingParse : pendingParses) {
            candidates.add(pendingParse.uri);
        }
        for (PendingRequest pendingRequest : pendingRequests) {
            if (pendingRequest.uri == null || !pendingRequest.type.isDangerous()) continue;
            candidates.add(pendingRequest.uri);
        }
        HashSet<String> hashSet = candidates;
        if (hashSet == null) {
            ClangCrashHandler.$$$reportNull$$$0(19);
        }
        return hashSet;
    }

    @NotNull
    public ClangClient spyOn(@NotNull ClangClient client) {
        if (client == null) {
            ClangCrashHandler.$$$reportNull$$$0(20);
        }
        return new ClangClientSpy(client);
    }

    @NotNull
    public ClangServer spyOn(@NotNull ClangServer server) {
        if (server == null) {
            ClangCrashHandler.$$$reportNull$$$0(21);
        }
        return new ClangServerSpy(server);
    }

    @NonNls
    @NotNull
    public String printStats(@NonNls @NotNull String linePrefix) {
        if (linePrefix == null) {
            ClangCrashHandler.$$$reportNull$$$0(22);
        }
        String string = linePrefix + "num of crashes = " + this.myNumOfCrashes.get() + "\n" + linePrefix + "num of stops = " + this.myNumOfStops.get() + "\n" + this.myPendingInteractions.printStats(linePrefix);
        if (string == null) {
            ClangCrashHandler.$$$reportNull$$$0(23);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 12, 16, 19, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pendingParses";
                break;
            }
            case 3: 
            case 5: 
            case 11: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pendingRequests";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whatCrashed";
                break;
            }
            case 7: 
            case 12: 
            case 16: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rollback";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linePrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCrashReporter";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "updatedCrashTracker";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCrashMessage";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidatesCausedCrash";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "printStats";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isBanned";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reportCrash";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "investigateCrash";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processCrashReason";
                break;
            }
            case 7: 
            case 12: 
            case 16: 
            case 19: 
            case 23: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "notifyDisabled";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updatedCrashTracker";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCrashMessage";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getCandidatesCausedCrash";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "spyOn";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "printStats";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 12, 16, 19, 23 -> new IllegalStateException(string);
        };
    }

    private static class PendingInteractions {
        private static final int MAX_PENDING_SIZE = 1024;
        @NotNull
        private final Object myLock = new Object();
        @NotNull
        private final Map<String, SortedMap<Integer, PendingParse>> myPendingParses = new HashMap<String, SortedMap<Integer, PendingParse>>();
        @NotNull
        private final IdentityHashMap<CompletableFuture<?>, PendingRequest> myPendingRequests = new IdentityHashMap();
        private int myMaxPendingParsesNumber = 0;
        private int myMaxPendingRequestsNumber = 0;
        private int myPendingParsesNumber = 0;

        private PendingInteractions() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addPendingParse(int cookie, @NotNull ClionReparseTextDocumentParams params) {
            if (params == null) {
                PendingInteractions.$$$reportNull$$$0(0);
            }
            String uri = params.getTextDocument().getUri();
            int version = params.getTextDocument().getVersion();
            Object object = this.myLock;
            synchronized (object) {
                Map subMap = this.myPendingParses.computeIfAbsent(uri, u -> new TreeMap());
                if (subMap.size() > 1024) {
                    LOG.warn("Blacklist: too many pending parses to track, clearing now.\nThe first request: " + ((PendingParse)subMap.values().iterator().next()).displayText());
                    subMap.clear();
                    this.myPendingParsesNumber = this.myPendingParses.values().stream().map(versions -> versions.size()).reduce(0, Integer::sum);
                }
                if (subMap.put(version, new PendingParse(cookie, this, params)) == null) {
                    ++this.myPendingParsesNumber;
                }
                this.myMaxPendingParsesNumber = Math.max(this.myMaxPendingParsesNumber, subMap.size());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removePendingParse(@NotNull String uri, int version) {
            if (uri == null) {
                PendingInteractions.$$$reportNull$$$0(1);
            }
            Object object = this.myLock;
            synchronized (object) {
                Map versionsMap = this.myPendingParses.get(uri);
                if (versionsMap != null && versionsMap.remove(version) != null) {
                    --this.myPendingParsesNumber;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removePendingParses(@NotNull String uri, int maxVersion) {
            if (uri == null) {
                PendingInteractions.$$$reportNull$$$0(2);
            }
            Object object = this.myLock;
            synchronized (object) {
                SortedMap<Integer, PendingParse> versionsMap = this.myPendingParses.get(uri);
                if (versionsMap != null) {
                    HashSet<Integer> toDelete = new HashSet<Integer>(versionsMap.headMap(maxVersion).keySet());
                    toDelete.add(maxVersion);
                    for (Integer version : toDelete) {
                        if (versionsMap.remove(version) == null) continue;
                        --this.myPendingParsesNumber;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        PendingParse findPendingParse(@NotNull String uri, int version) {
            if (uri == null) {
                PendingInteractions.$$$reportNull$$$0(3);
            }
            Object object = this.myLock;
            synchronized (object) {
                Map subMap = this.myPendingParses.get(uri);
                return subMap != null ? (PendingParse)subMap.get(version) : null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean empty() {
            Object object = this.myLock;
            synchronized (object) {
                assert (this.myPendingParsesNumber >= 0) : "Pending parses number < 0?";
                return this.myPendingRequests.isEmpty() && this.myPendingParsesNumber == 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void runAndClear(@NotNull BiConsumer<Map<String, SortedMap<Integer, PendingParse>>, Map<CompletableFuture<?>, PendingRequest>> consumer) {
            ArrayList pendingFutures;
            if (consumer == null) {
                PendingInteractions.$$$reportNull$$$0(4);
            }
            Iterator iterator = this.myLock;
            synchronized (iterator) {
                pendingFutures = new ArrayList(this.myPendingRequests.keySet());
                consumer.accept(this.myPendingParses, this.myPendingRequests);
                this.myPendingParses.clear();
                this.myPendingRequests.clear();
                this.myPendingParsesNumber = 0;
            }
            for (CompletableFuture completableFuture : pendingFutures) {
                completableFuture.complete(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            ArrayList pendingFutures;
            Iterator iterator = this.myLock;
            synchronized (iterator) {
                pendingFutures = new ArrayList(this.myPendingRequests.keySet());
                this.myPendingParses.clear();
                this.myPendingRequests.clear();
                this.myPendingParsesNumber = 0;
            }
            for (CompletableFuture completableFuture : pendingFutures) {
                completableFuture.complete(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <T> CompletableFuture<T> trackFuture(@NotNull CompletableFuture<T> response, @NotNull PendingRequest request) {
            if (response == null) {
                PendingInteractions.$$$reportNull$$$0(5);
            }
            if (request == null) {
                PendingInteractions.$$$reportNull$$$0(6);
            }
            boolean warnThresholdExceeded = false;
            Object object = this.myLock;
            synchronized (object) {
                if (this.myPendingRequests.size() >= 4096) {
                    warnThresholdExceeded = true;
                    this.myPendingRequests.clear();
                }
                this.myPendingRequests.put(response, request);
                this.myMaxPendingRequestsNumber = Math.max(this.myMaxPendingRequestsNumber, this.myPendingRequests.size());
            }
            response.whenComplete((res, ex) -> {
                Object object = this.myLock;
                synchronized (object) {
                    this.myPendingRequests.remove(response);
                }
            });
            if (warnThresholdExceeded) {
                LOG.warn("Exceeded amount of tracked requests (4096), clearing pending requests");
            }
            return response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @NonNls
        @NotNull
        String printStats(@NonNls @NotNull String linePrefix) {
            if (linePrefix == null) {
                PendingInteractions.$$$reportNull$$$0(7);
            }
            Object object = this.myLock;
            // MONITORENTER : object
            String string = linePrefix + "seen files number = " + this.myPendingParses.size() + "\n" + linePrefix + "pending files number = " + this.myPendingParses.values().stream().filter(versions -> !versions.isEmpty()).count() + "\n" + linePrefix + "max pending versions number = " + this.myMaxPendingParsesNumber + "\n" + linePrefix + "pending requests number = " + this.myPendingRequests.size() + "\n" + linePrefix + "max pending requests number = " + this.myMaxPendingRequestsNumber + "\n";
            // MONITOREXIT : object
            if (string != null) return string;
            PendingInteractions.$$$reportNull$$$0(8);
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "params";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "uri";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "response";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "linePrefix";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$PendingInteractions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$PendingInteractions";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "printStats";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addPendingParse";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "removePendingParse";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "removePendingParses";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "findPendingParse";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "runAndClear";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "trackFuture";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "printStats";
                    break;
                }
                case 8: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 8 -> new IllegalStateException(string);
            };
        }
    }

    static enum ActionType {
        PARSING("clangd.crash.reason.parsing", Integer.MAX_VALUE, null),
        HIGHLIGHTINGS("clangd.crash.reason.highlightings", Integer.MAX_VALUE, null),
        DFA_INPUT("clangd.crash.reason.dfa", Integer.MAX_VALUE, null),
        INLAY_HINTS("clangd.crash.reason.inlay_hints", 2, () -> new ActionDisabler(){

            @Override
            public boolean disable(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (ClangdBridge.getParameterHints(project)) {
                    ClangdBridge.setParameterHints(project, false);
                    return true;
                }
                return false;
            }

            @Override
            public void enableBack(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                ClangdBridge.setParameterHints(project, true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$ActionType$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "disable";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "enableBack";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }),
        CLAZY("clangd.crash.reason.clazy", 2, () -> new ActionDisabler(){

            @Override
            public boolean disable(@NotNull Project project) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                OCInspectionUtil.setInspectionEnabled((Project)project, ClangdBridge.getClazyInspection(), (boolean)false);
                return true;
            }

            @Override
            public void enableBack(@NotNull Project project) {
                if (project == null) {
                    2.$$$reportNull$$$0(1);
                }
                OCInspectionUtil.setInspectionEnabled((Project)project, ClangdBridge.getClazyInspection(), (boolean)true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$ActionType$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "disable";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "enableBack";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }),
        CLION_CLANG_TIDY("clangd.crash.reason.clion.clang.tidy", 1, () -> new ActionDisabler(){

            @Override
            public boolean disable(@NotNull Project project) {
                if (project == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (ClangdSettings.getInstance(project).isClangTidyViaClangd()) {
                    ClangdSettings.getInstance(project).setClangTidyViaClangd(false);
                    return true;
                }
                return false;
            }

            @Override
            public void enableBack(@NotNull Project project) {
                if (project == null) {
                    3.$$$reportNull$$$0(1);
                }
                ClangdSettings.getInstance(project).setClangTidyViaClangd(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$ActionType$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "disable";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "enableBack";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }),
        CLANG_TIDY("clangd.crash.reason.clang.tidy", 1, () -> new ActionDisabler(){

            @Override
            public boolean disable(@NotNull Project project) {
                if (project == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (ClangdSettings.getInstance(project).isClangTidyViaClangd()) {
                    ClangdSettings.getInstance(project).setClangTidyViaClangd(false);
                    return true;
                }
                return false;
            }

            @Override
            public void enableBack(@NotNull Project project) {
                if (project == null) {
                    4.$$$reportNull$$$0(1);
                }
                ClangdSettings.getInstance(project).setClangTidyViaClangd(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$ActionType$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "disable";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "enableBack";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }),
        INDEXER("clangd.crash.reason.indexer.modules", 2, () -> new ActionDisabler(){

            @Override
            public boolean disable(@NotNull Project project) {
                if (project == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (ClangdSettings.getInstance(project).getIndexerUseModules()) {
                    ClangdSettings.getInstance(project).setIndexerUseModules(false);
                    return true;
                }
                return false;
            }

            @Override
            public void enableBack(@NotNull Project project) {
                if (project == null) {
                    5.$$$reportNull$$$0(1);
                }
                ClangdSettings.getInstance(project).setIndexerUseModules(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$ActionType$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "disable";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "enableBack";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });

        @NonNls
        @NotNull
        final String nameKey;
        final int beforeDisableCrashCount;
        @Nullable
        final Supplier<ActionDisabler> disablerSupplier;

        private ActionType(@Nullable String nameKey, int beforeDisableCrashCount, Supplier<ActionDisabler> disablerSupplier) {
            if (nameKey == null) {
                ActionType.$$$reportNull$$$0(0);
            }
            this.nameKey = nameKey;
            this.beforeDisableCrashCount = beforeDisableCrashCount;
            this.disablerSupplier = disablerSupplier;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameKey", "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$ActionType", "<init>"));
        }
    }

    private static class PendingParse
    extends AbstractPending {
        @NotNull
        public final String uri;
        public final int version;
        @NotNull
        public final CompletableFuture<ResultState> compilerDiagsState;
        @NotNull
        public final CompletableFuture<ResultState> highlightingsState;
        @NotNull
        public final CompletableFuture<ResultState> DFAInputState;
        @NotNull
        public final CompletableFuture<ResultState> CLionClangTidyState;
        @NotNull
        public final CompletableFuture<ResultState> clazyState;
        @NotNull
        public final CompletableFuture<ResultState> clangTidyState;

        PendingParse(int cookie, @NotNull PendingInteractions parses, @NotNull ClionReparseTextDocumentParams params) {
            if (parses == null) {
                PendingParse.$$$reportNull$$$0(0);
            }
            if (params == null) {
                PendingParse.$$$reportNull$$$0(1);
            }
            super(cookie);
            this.compilerDiagsState = new CompletableFuture();
            this.highlightingsState = new CompletableFuture();
            this.DFAInputState = new CompletableFuture();
            this.CLionClangTidyState = new CompletableFuture();
            this.clazyState = new CompletableFuture();
            this.clangTidyState = new CompletableFuture();
            this.uri = params.getTextDocument().getUri();
            this.version = params.getTextDocument().getVersion();
            if (!PendingParse.waitForCompilerDiags(params)) {
                this.compilerDiagsState.complete(ResultState.NOT_REQUESTED);
            }
            if (!PendingParse.waitForHighlightings(params)) {
                this.highlightingsState.complete(ResultState.NOT_REQUESTED);
            }
            if (!PendingParse.waitForDFAInputState(params)) {
                this.DFAInputState.complete(ResultState.NOT_REQUESTED);
            }
            if (!PendingParse.waitForCLionClangTidyState(params)) {
                this.CLionClangTidyState.complete(ResultState.NOT_REQUESTED);
            }
            if (!PendingParse.waitForClazyState(params)) {
                this.clazyState.complete(ResultState.NOT_REQUESTED);
            }
            if (!PendingParse.waitForClangTidyState(params)) {
                this.clangTidyState.complete(ResultState.NOT_REQUESTED);
            }
            CompletableFuture.allOf(this.compilerDiagsState, this.highlightingsState, this.DFAInputState, this.CLionClangTidyState, this.clazyState, this.clangTidyState).whenComplete((res, ex) -> parses.removePendingParse(this.uri, this.version));
        }

        @Nullable
        ActionType getWhomToBlame() {
            ActionType guilty = ActionType.PARSING;
            if (this.compilerDiagsState.isDone()) {
                guilty = ActionType.HIGHLIGHTINGS;
                if (this.highlightingsState.isDone()) {
                    guilty = ActionType.DFA_INPUT;
                    if (this.DFAInputState.isDone()) {
                        guilty = ActionType.CLION_CLANG_TIDY;
                        if (this.CLionClangTidyState.isDone()) {
                            guilty = ActionType.CLAZY;
                            if (this.clazyState.isDone()) {
                                guilty = ActionType.CLANG_TIDY;
                                if (this.clangTidyState.isDone()) {
                                    guilty = null;
                                }
                            }
                        }
                    }
                }
            }
            return guilty;
        }

        @NlsSafe
        @NotNull
        String displayText() {
            String string = this.uri + ", compilerDiags=" + this.stateText(this.compilerDiagsState) + ", highlightings=" + this.stateText(this.highlightingsState) + ", DFAInput=" + this.stateText(this.DFAInputState) + ", CLion-clang-tidy=" + this.stateText(this.CLionClangTidyState) + ", Clazy=" + this.stateText(this.clazyState) + ", clang-tidy=" + this.stateText(this.clangTidyState);
            if (string == null) {
                PendingParse.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NlsSafe
        @NotNull
        String stateText(@NotNull CompletableFuture<ResultState> state) {
            String string;
            if (state == null) {
                PendingParse.$$$reportNull$$$0(3);
            }
            if (!state.isDone()) {
                return "WAITING";
            }
            try {
                string = state.get().name();
            }
            catch (Throwable throwable) {
                return "EXCEPTION?";
            }
            if (string == null) {
                PendingParse.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static boolean waitForCompilerDiags(@NotNull ClionReparseTextDocumentParams params) {
            if (params == null) {
                PendingParse.$$$reportNull$$$0(5);
            }
            return ClionWantDiagnostics.No.value != params.getWantDiagnostics();
        }

        private static boolean waitForHighlightings(@NotNull ClionReparseTextDocumentParams params) {
            if (params == null) {
                PendingParse.$$$reportNull$$$0(6);
            }
            return ClionWantDiagnostics.No.value != params.getWantDiagnostics();
        }

        private static boolean waitForDFAInputState(@NotNull ClionReparseTextDocumentParams params) {
            if (params == null) {
                PendingParse.$$$reportNull$$$0(7);
            }
            return ClionWantDiagnostics.No.value != params.getWantDiagnostics() && params.getDFAOptions() != null;
        }

        private static boolean waitForClazyState(@NotNull ClionReparseTextDocumentParams params) {
            if (params == null) {
                PendingParse.$$$reportNull$$$0(8);
            }
            return ClionWantDiagnostics.No.value != params.getWantDiagnostics() && params.getClazyOptions() != null;
        }

        private static boolean waitForCLionClangTidyState(@NotNull ClionReparseTextDocumentParams params) {
            if (params == null) {
                PendingParse.$$$reportNull$$$0(9);
            }
            return ClionWantDiagnostics.No.value != params.getWantDiagnostics() && params.getClangTidyOptions() != null && params.getClangTidyOptions().getClionConfig() != null;
        }

        private static boolean waitForClangTidyState(@NotNull ClionReparseTextDocumentParams params) {
            if (params == null) {
                PendingParse.$$$reportNull$$$0(10);
            }
            return ClionWantDiagnostics.No.value != params.getWantDiagnostics() && params.getClangTidyOptions() != null && params.getClangTidyOptions().getConfig() != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parses";
                    break;
                }
                case 1: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "params";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$PendingParse";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$PendingParse";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "displayText";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "stateText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "stateText";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "waitForCompilerDiags";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "waitForHighlightings";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "waitForDFAInputState";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "waitForClazyState";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "waitForCLionClangTidyState";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "waitForClangTidyState";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4 -> new IllegalStateException(string);
            };
        }

        static enum ResultState {
            ARRIVED,
            NOT_REQUESTED;

        }
    }

    private static class PendingRequest
    extends AbstractPending {
        @NotNull
        public final RequestType type;
        @Nullable
        public final String uri;
        @Nullable
        public final String description;

        PendingRequest(int cookie, @NotNull RequestType type, @Nullable String uri) {
            if (type == null) {
                PendingRequest.$$$reportNull$$$0(0);
            }
            this(cookie, type, uri, null);
        }

        PendingRequest(int cookie, @NotNull RequestType type, @Nullable String uri, @Nullable String description) {
            if (type == null) {
                PendingRequest.$$$reportNull$$$0(1);
            }
            super(cookie);
            this.type = type;
            this.uri = uri;
            this.description = description;
        }

        @NotNull
        String displayText() {
            StringBuilder sb = new StringBuilder();
            sb.append(StringUtil.notNullize((String)this.uri, (String)"<no URI>"));
            if (this.description != null) {
                sb.append(", ").append(this.description);
            }
            sb.append(", ").append(this.type.name());
            String string = sb.toString();
            if (string == null) {
                PendingRequest.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NonNls
        public String toString() {
            return "PendingRequest{type=" + String.valueOf((Object)this.type) + ", uri='" + this.uri + "', description='" + this.description + "'}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$PendingRequest";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$PendingRequest";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "displayText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static enum RequestType {
        COMPLETION(true),
        INLAY_HINTS(true, ActionType.INLAY_HINTS),
        MATCH_PP(true),
        MATCH_ANGLE_BRACKETS(true),
        DEFINITION(true),
        DUMP_AST(false),
        DUMP_TOKENS(false),
        PARSE_COMMAND_LINE(false),
        CLANGFORMAT_CONFIG(false),
        REQUEST_TIMINGS(false),
        PREPROCESS(false),
        RANGE_FORMAT(true),
        ON_TYPE_FORMAT(false),
        DUMP_MEMORY_STAT(false),
        REQUEST_SERVER_STATE(false),
        CHECK_CRASH(true),
        CLION_SYMBOL(false),
        CLION_LIGHT_INDEX(false);

        final boolean myIsDangerous;
        @Nullable
        final ActionType myActionType;

        private RequestType(boolean isDangerous) {
            this.myIsDangerous = isDangerous;
            this.myActionType = null;
        }

        private RequestType(boolean isDangerous, ActionType actionType) {
            if (actionType == null) {
                RequestType.$$$reportNull$$$0(0);
            }
            this.myIsDangerous = isDangerous;
            this.myActionType = actionType;
        }

        boolean isDangerous() {
            return this.myIsDangerous;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionType", "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$RequestType", "<init>"));
        }
    }

    static interface ActionDisabler {
        public boolean disable(@NotNull Project var1);

        public void enableBack(@NotNull Project var1);
    }

    private class ClangClientSpy
    extends ClangClientAdapter {
        ClangClientSpy(ClangClient delegate) {
            if (delegate == null) {
                ClangClientSpy.$$$reportNull$$$0(0);
            }
            super(delegate);
        }

        @Override
        public void clionPublishDiagnostics(@NotNull ClionPublishDiagnosticsParams diagnostics) {
            PendingParse pendingParse;
            if (diagnostics == null) {
                ClangClientSpy.$$$reportNull$$$0(1);
            }
            if ((pendingParse = ClangCrashHandler.this.myPendingInteractions.findPendingParse(diagnostics.getUri(), diagnostics.getVersion())) != null) {
                pendingParse.compilerDiagsState.complete(PendingParse.ResultState.ARRIVED);
            }
            super.clionPublishDiagnostics(diagnostics);
        }

        @Override
        public void clionPublishHighlightings(@NotNull ClionPublishHighlightingsParams highlightings) {
            PendingParse pendingParse;
            if (highlightings == null) {
                ClangClientSpy.$$$reportNull$$$0(2);
            }
            if ((pendingParse = ClangCrashHandler.this.myPendingInteractions.findPendingParse(highlightings.getUri(), highlightings.getVersion())) != null) {
                pendingParse.highlightingsState.complete(PendingParse.ResultState.ARRIVED);
            }
            super.clionPublishHighlightings(highlightings);
        }

        @Override
        public void clionPublishDFAInputTuples(@NotNull ClionPublishDFAInputTuples input) {
            PendingParse pendingParse;
            if (input == null) {
                ClangClientSpy.$$$reportNull$$$0(3);
            }
            if ((pendingParse = ClangCrashHandler.this.myPendingInteractions.findPendingParse(input.getUri(), input.getVersion())) != null) {
                pendingParse.DFAInputState.complete(PendingParse.ResultState.ARRIVED);
            }
            super.clionPublishDFAInputTuples(input);
        }

        @Override
        public void clionPublishOurTidyDiagnostics(@NotNull ClionPublishTidyDiagnosticsParams diagnostics) {
            PendingParse pendingParse;
            if (diagnostics == null) {
                ClangClientSpy.$$$reportNull$$$0(4);
            }
            if ((pendingParse = ClangCrashHandler.this.myPendingInteractions.findPendingParse(diagnostics.getUri(), diagnostics.getVersion())) != null) {
                pendingParse.CLionClangTidyState.complete(PendingParse.ResultState.ARRIVED);
            }
            super.clionPublishOurTidyDiagnostics(diagnostics);
        }

        @Override
        public void clionPublishTidyDiagnostics(@NotNull ClionPublishTidyDiagnosticsParams diagnostics) {
            PendingParse pendingParse;
            if (diagnostics == null) {
                ClangClientSpy.$$$reportNull$$$0(5);
            }
            if ((pendingParse = ClangCrashHandler.this.myPendingInteractions.findPendingParse(diagnostics.getUri(), diagnostics.getVersion())) != null) {
                pendingParse.clangTidyState.complete(PendingParse.ResultState.ARRIVED);
            }
            super.clionPublishTidyDiagnostics(diagnostics);
        }

        @Override
        public void clionPublishClazyDiagnostics(@NotNull ClionPublishDiagnosticsParams diagnostics) {
            PendingParse pendingParse;
            if (diagnostics == null) {
                ClangClientSpy.$$$reportNull$$$0(6);
            }
            if ((pendingParse = ClangCrashHandler.this.myPendingInteractions.findPendingParse(diagnostics.getUri(), diagnostics.getVersion())) != null) {
                pendingParse.clazyState.complete(PendingParse.ResultState.ARRIVED);
            }
            super.clionPublishClazyDiagnostics(diagnostics);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "diagnostics";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "highlightings";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$ClangClientSpy";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clionPublishDiagnostics";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clionPublishHighlightings";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clionPublishDFAInputTuples";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clionPublishOurTidyDiagnostics";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clionPublishTidyDiagnostics";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clionPublishClazyDiagnostics";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ClangServerSpy
    extends ClangServerAdapter {
        @NotNull
        private final TextDocumentServiceSpy myTextDocumentService;

        ClangServerSpy(ClangServer delegate) {
            if (delegate == null) {
                ClangServerSpy.$$$reportNull$$$0(0);
            }
            super(delegate);
            this.myTextDocumentService = new TextDocumentServiceSpy(delegate.getTextDocumentService());
        }

        @Override
        public void clionReparse(@NotNull ClionReparseTextDocumentParams params) {
            if (params == null) {
                ClangServerSpy.$$$reportNull$$$0(1);
            }
            ClangCrashHandler.this.myPendingInteractions.addPendingParse(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), params);
            super.clionReparse(params);
        }

        @Override
        public void clionDidClose(@NotNull ClionDidCloseTextDocumentParams params) {
            if (params == null) {
                ClangServerSpy.$$$reportNull$$$0(2);
            }
            ClangCrashHandler.this.myPendingInteractions.removePendingParses(params.getTextDocument().getUri(), params.getVersion());
            super.clionDidClose(params);
        }

        @Override
        public void clionDidDelete(@NotNull ClionDidDeleteTextDocumentParams params) {
            if (params == null) {
                ClangServerSpy.$$$reportNull$$$0(3);
            }
            ClangCrashHandler.this.myPendingInteractions.removePendingParses(params.getTextDocument().getUri(), params.getVersion());
            super.clionDidDelete(params);
        }

        @Override
        public void clionCancelParse(ClionCancelParseParams params) {
            assert (params != null);
            String uri = params.getUri();
            int version = params.getVersion();
            ClangCrashHandler.this.myPendingInteractions.removePendingParse(uri, version);
            super.clionCancelParse(params);
        }

        @Override
        @NotNull
        public CompletableFuture<List<? extends SymbolInformation>> clionDefinition(@NotNull TextDocumentPositionParams position) {
            if (position == null) {
                ClangServerSpy.$$$reportNull$$$0(4);
            }
            CompletableFuture<List<? extends SymbolInformation>> completableFuture = ClangCrashHandler.this.myPendingInteractions.trackFuture(super.clionDefinition(position), new PendingDefinitionRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), position));
            if (completableFuture == null) {
                ClangServerSpy.$$$reportNull$$$0(5);
            }
            return completableFuture;
        }

        @Override
        @NotNull
        public CompletableFuture<List<ClangdInlayHint>> clangdInlayHints(@NotNull InlayHintsParams params) {
            if (params == null) {
                ClangServerSpy.$$$reportNull$$$0(6);
            }
            CompletableFuture<List<ClangdInlayHint>> completableFuture = ClangCrashHandler.this.myPendingInteractions.trackFuture(super.clangdInlayHints(params), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.INLAY_HINTS, params.getTextDocument().getUri()));
            if (completableFuture == null) {
                ClangServerSpy.$$$reportNull$$$0(7);
            }
            return completableFuture;
        }

        @Override
        @NotNull
        public CompletableFuture<ClangBracketMatchResult> clionMatchAngleBracket(@NotNull TextDocumentPositionParams position) {
            if (position == null) {
                ClangServerSpy.$$$reportNull$$$0(8);
            }
            CompletableFuture<ClangBracketMatchResult> completableFuture = ClangCrashHandler.this.myPendingInteractions.trackFuture(super.clionMatchAngleBracket(position), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.MATCH_ANGLE_BRACKETS, position.getTextDocument().getUri()));
            if (completableFuture == null) {
                ClangServerSpy.$$$reportNull$$$0(9);
            }
            return completableFuture;
        }

        @Override
        @NotNull
        public CompletableFuture<List<Range>> clionMatchPP(@NotNull TextDocumentPositionParams position) {
            if (position == null) {
                ClangServerSpy.$$$reportNull$$$0(10);
            }
            CompletableFuture<List<Range>> completableFuture = ClangCrashHandler.this.myPendingInteractions.trackFuture(super.clionMatchPP(position), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.MATCH_PP, position.getTextDocument().getUri(), position.getPosition().toString()));
            if (completableFuture == null) {
                ClangServerSpy.$$$reportNull$$$0(11);
            }
            return completableFuture;
        }

        @Override
        @NotNull
        public CompletableFuture<String> clionDumpAST(@NotNull TextDocumentPositionParams position) {
            if (position == null) {
                ClangServerSpy.$$$reportNull$$$0(12);
            }
            CompletableFuture<String> completableFuture = ClangCrashHandler.this.myPendingInteractions.trackFuture(super.clionDumpAST(position), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.DUMP_AST, position.getTextDocument().getUri()));
            if (completableFuture == null) {
                ClangServerSpy.$$$reportNull$$$0(13);
            }
            return completableFuture;
        }

        @Override
        @NotNull
        public CompletableFuture<List<CLionSymbolInformation>> clionWorkspaceSymbol(@Nullable CLionWorkspaceSymbolParams params) {
            CompletableFuture<List<CLionSymbolInformation>> completableFuture = ClangCrashHandler.this.myPendingInteractions.trackFuture(super.clionWorkspaceSymbol(params), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.CLION_SYMBOL, null));
            if (completableFuture == null) {
                ClangServerSpy.$$$reportNull$$$0(14);
            }
            return completableFuture;
        }

        @Override
        @NotNull
        public CompletableFuture<String> clionDumpTokens(@NotNull TextDocumentPositionParams position) {
            if (position == null) {
                ClangServerSpy.$$$reportNull$$$0(15);
            }
            CompletableFuture<String> completableFuture = ClangCrashHandler.this.myPendingInteractions.trackFuture(super.clionDumpTokens(position), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.DUMP_TOKENS, position.getTextDocument().getUri()));
            if (completableFuture == null) {
                ClangServerSpy.$$$reportNull$$$0(16);
            }
            return completableFuture;
        }

        @Override
        @NotNull
        public CompletableFuture<String> clionRequestServerState() {
            CompletableFuture<String> completableFuture = ClangCrashHandler.this.myPendingInteractions.trackFuture(super.clionRequestServerState(), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.REQUEST_SERVER_STATE, null));
            if (completableFuture == null) {
                ClangServerSpy.$$$reportNull$$$0(17);
            }
            return completableFuture;
        }

        @Override
        @NotNull
        public CompletableFuture<ClionMemoryUsageInfo> clionDebugDumpMemoryStat() {
            CompletableFuture<ClionMemoryUsageInfo> completableFuture = ClangCrashHandler.this.myPendingInteractions.trackFuture(super.clionDebugDumpMemoryStat(), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.DUMP_MEMORY_STAT, null));
            if (completableFuture == null) {
                ClangServerSpy.$$$reportNull$$$0(18);
            }
            return completableFuture;
        }

        @Override
        @NotNull
        public CompletableFuture<ClionPublishDiagnosticsParams> clionCheckPreprocessedCase(@Nullable CLionCheckPreprocessedCaseParams params) {
            CompletableFuture<ClionPublishDiagnosticsParams> completableFuture = ClangCrashHandler.this.myPendingInteractions.trackFuture(super.clionCheckPreprocessedCase(params), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.CHECK_CRASH, null));
            if (completableFuture == null) {
                ClangServerSpy.$$$reportNull$$$0(19);
            }
            return completableFuture;
        }

        @Override
        @NotNull
        public CompletableFuture<String> clionClangFormatConfiguration(TextDocumentPositionParams document) {
            CompletableFuture<String> completableFuture = ClangCrashHandler.this.myPendingInteractions.trackFuture(super.clionClangFormatConfiguration(document), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.CLANGFORMAT_CONFIG, document.getTextDocument().getUri()));
            if (completableFuture == null) {
                ClangServerSpy.$$$reportNull$$$0(20);
            }
            return completableFuture;
        }

        @Override
        @NotNull
        public CompletableFuture<ClionFileStats> clionRequestTimingsStat(TextDocumentIdentifier document) {
            CompletableFuture<ClionFileStats> completableFuture = ClangCrashHandler.this.myPendingInteractions.trackFuture(super.clionRequestTimingsStat(document), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.REQUEST_TIMINGS, document.getUri()));
            if (completableFuture == null) {
                ClangServerSpy.$$$reportNull$$$0(21);
            }
            return completableFuture;
        }

        @Override
        @NotNull
        public CompletableFuture<Either<List<CLionCompletionItem>, CLionCompletionList>> clionCompletion(CompletionParams position) {
            CompletableFuture<Either<List<CLionCompletionItem>, CLionCompletionList>> completableFuture = ClangCrashHandler.this.myPendingInteractions.trackFuture(super.clionCompletion(position), new PendingCompletionRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), position));
            if (completableFuture == null) {
                ClangServerSpy.$$$reportNull$$$0(22);
            }
            return completableFuture;
        }

        @Override
        @NotNull
        public CompletableFuture<List<? extends TextEdit>> clionRangeFormatting(@NotNull CLionDocumentRangeFormattingParams params) {
            if (params == null) {
                ClangServerSpy.$$$reportNull$$$0(23);
            }
            CompletableFuture<List<? extends TextEdit>> completableFuture = ClangCrashHandler.this.myPendingInteractions.trackFuture(super.clionRangeFormatting(params), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.RANGE_FORMAT, params.getTextDocument().getUri()));
            if (completableFuture == null) {
                ClangServerSpy.$$$reportNull$$$0(24);
            }
            return completableFuture;
        }

        @Override
        @NotNull
        public CompletableFuture<List<ClangLightSymbolInfoResponse>> clionLightIndex(@NotNull TextDocumentIdentifier params) {
            if (params == null) {
                ClangServerSpy.$$$reportNull$$$0(25);
            }
            CompletableFuture<List<ClangLightSymbolInfoResponse>> completableFuture = ClangCrashHandler.this.myPendingInteractions.trackFuture(super.clionLightIndex(params), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.CLION_LIGHT_INDEX, params.getUri()));
            if (completableFuture == null) {
                ClangServerSpy.$$$reportNull$$$0(26);
            }
            return completableFuture;
        }

        @Override
        @NotNull
        public CompletableFuture<List<ClangCommandLineArgument>> clionParseCommandLine(ClangCommandLine commandLine) {
            CompletableFuture<List<ClangCommandLineArgument>> completableFuture = ClangCrashHandler.this.myPendingInteractions.trackFuture(super.clionParseCommandLine(commandLine), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.PARSE_COMMAND_LINE, null));
            if (completableFuture == null) {
                ClangServerSpy.$$$reportNull$$$0(27);
            }
            return completableFuture;
        }

        @Override
        @NotNull
        public CompletableFuture<CLionClangPreprocessResult> clionPreprocessFile(@NotNull CLionClangPreprocessParams params) {
            if (params == null) {
                ClangServerSpy.$$$reportNull$$$0(28);
            }
            CompletableFuture<CLionClangPreprocessResult> completableFuture = ClangCrashHandler.this.myPendingInteractions.trackFuture(super.clionPreprocessFile(params), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.PREPROCESS, params.getCompilationCommand().getUri()));
            if (completableFuture == null) {
                ClangServerSpy.$$$reportNull$$$0(29);
            }
            return completableFuture;
        }

        @Override
        @NotNull
        public TextDocumentService getTextDocumentService() {
            TextDocumentServiceSpy textDocumentServiceSpy = this.myTextDocumentService;
            if (textDocumentServiceSpy == null) {
                ClangServerSpy.$$$reportNull$$$0(30);
            }
            return textDocumentServiceSpy;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 7, 9, 11, 13, 14, 16, 17, 18, 19, 20, 21, 22, 24, 26, 27, 29, 30 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 23: 
                case 25: 
                case 28: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "params";
                    break;
                }
                case 4: 
                case 8: 
                case 10: 
                case 12: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 13: 
                case 14: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 24: 
                case 26: 
                case 27: 
                case 29: 
                case 30: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$ClangServerSpy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$ClangServerSpy";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clionDefinition";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clangdInlayHints";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clionMatchAngleBracket";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clionMatchPP";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clionDumpAST";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clionWorkspaceSymbol";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clionDumpTokens";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clionRequestServerState";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clionDebugDumpMemoryStat";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clionCheckPreprocessedCase";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clionClangFormatConfiguration";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clionRequestTimingsStat";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clionCompletion";
                    break;
                }
                case 24: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clionRangeFormatting";
                    break;
                }
                case 26: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clionLightIndex";
                    break;
                }
                case 27: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clionParseCommandLine";
                    break;
                }
                case 29: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clionPreprocessFile";
                    break;
                }
                case 30: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextDocumentService";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "clionReparse";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "clionDidClose";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "clionDidDelete";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "clionDefinition";
                    break;
                }
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 13: 
                case 14: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 24: 
                case 26: 
                case 27: 
                case 29: 
                case 30: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "clangdInlayHints";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "clionMatchAngleBracket";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "clionMatchPP";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "clionDumpAST";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "clionDumpTokens";
                    break;
                }
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "clionRangeFormatting";
                    break;
                }
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "clionLightIndex";
                    break;
                }
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "clionPreprocessFile";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 7, 9, 11, 13, 14, 16, 17, 18, 19, 20, 21, 22, 24, 26, 27, 29, 30 -> new IllegalStateException(string);
            };
        }

        private final class TextDocumentServiceSpy
        extends TextDocumentServiceAdapter {
            private TextDocumentServiceSpy(TextDocumentService delegate) {
                if (delegate == null) {
                    TextDocumentServiceSpy.$$$reportNull$$$0(0);
                }
                super(delegate);
            }

            @Override
            public CompletableFuture<List<? extends TextEdit>> rangeFormatting(DocumentRangeFormattingParams params) {
                return ClangCrashHandler.this.myPendingInteractions.trackFuture(super.rangeFormatting(params), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.RANGE_FORMAT, params.getTextDocument().getUri()));
            }

            @Override
            public CompletableFuture<List<? extends TextEdit>> onTypeFormatting(DocumentOnTypeFormattingParams params) {
                return ClangCrashHandler.this.myPendingInteractions.trackFuture(super.onTypeFormatting(params), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.ON_TYPE_FORMAT, params.getTextDocument().getUri()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$ClangServerSpy$TextDocumentServiceSpy", "<init>"));
            }
        }
    }

    private static class AbstractPending {
        public final int cookie;

        private AbstractPending(int cookie) {
            this.cookie = cookie;
        }

        boolean before(@NotNull AbstractPending other) {
            if (other == null) {
                AbstractPending.$$$reportNull$$$0(0);
            }
            return this.cookie < other.cookie;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$AbstractPending", "before"));
        }
    }

    private static final class PendingDefinitionRequest
    extends PendingRequest {
        @NotNull
        private final TextDocumentPositionParams myDocPosition;

        private PendingDefinitionRequest(int cookie, @NotNull TextDocumentPositionParams docPosition) {
            if (docPosition == null) {
                PendingDefinitionRequest.$$$reportNull$$$0(0);
            }
            super(cookie, RequestType.DEFINITION, docPosition.getTextDocument().getUri());
            this.myDocPosition = docPosition;
        }

        @Override
        @NotNull
        String displayText() {
            String string = this.uri + ":" + this.myDocPosition.getPosition().getLine() + ":" + this.myDocPosition.getPosition().getCharacter() + ", " + this.type.name();
            if (string == null) {
                PendingDefinitionRequest.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "docPosition";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$PendingDefinitionRequest";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$PendingDefinitionRequest";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "displayText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class PendingCompletionRequest
    extends PendingRequest {
        @NotNull
        private final CompletionParams myCompletionParams;

        PendingCompletionRequest(int cookie, @NotNull CompletionParams params) {
            if (params == null) {
                PendingCompletionRequest.$$$reportNull$$$0(0);
            }
            super(cookie, RequestType.COMPLETION, params.getTextDocument().getUri());
            this.myCompletionParams = params;
        }

        @Override
        @NotNull
        String displayText() {
            String string = this.uri + ":" + this.myCompletionParams.getPosition().getLine() + ":" + this.myCompletionParams.getPosition().getCharacter() + ", " + this.type.name();
            if (string == null) {
                PendingCompletionRequest.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "params";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$PendingCompletionRequest";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$PendingCompletionRequest";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "displayText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

