/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.reports;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.reports.ClangCrashReporter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.reports.ClangReportUtils;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u000fH\u0016J&\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/reports/ClangInternalCrashReporter;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/reports/ClangCrashReporter;", "myArtifactsPath", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "myCrashId", "Ljava/util/concurrent/atomic/AtomicInteger;", "report", "", "context", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangDaemonContext;", "message", "", "fileUrls", "", "doAdvancedReport", "", "Companion", "intellij.cidr.clangd"})
@SourceDebugExtension(value={"SMAP\nClangInternalCrashReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClangInternalCrashReporter.kt\ncom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/reports/ClangInternalCrashReporter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,47:1\n13#2:48\n*S KotlinDebug\n*F\n+ 1 ClangInternalCrashReporter.kt\ncom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/reports/ClangInternalCrashReporter\n*L\n45#1:48\n*E\n"})
public final class ClangInternalCrashReporter
implements ClangCrashReporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path myArtifactsPath;
    @NotNull
    private final AtomicInteger myCrashId;
    @NotNull
    private static final Logger LOG;

    public ClangInternalCrashReporter(@NotNull Path myArtifactsPath) {
        Intrinsics.checkNotNullParameter((Object)myArtifactsPath, (String)"myArtifactsPath");
        this.myArtifactsPath = myArtifactsPath;
        this.myCrashId = new AtomicInteger(0);
    }

    @Override
    public void report(@NotNull ClangDaemonContext context, @NotNull String message, @Nullable List<String> fileUrls) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        List<String> list = fileUrls;
        LOG.warn("ClangInternalCrashReporter: reporting a crash for " + (list != null ? list.size() : 0) + " files");
        Collection collection = fileUrls;
        if (collection == null || collection.isEmpty() || !this.doAdvancedReport(context, message, fileUrls)) {
            Path crashFile = this.myArtifactsPath.resolve("clangd_crash_" + this.myCrashId.incrementAndGet() + ".txt");
            FileUtil.writeToFile((File)crashFile.toFile(), (String)message);
            LOG.warn("ClangInternalCrashReporter: fallback to a simple crash report: " + crashFile + " was written");
        }
        LOG.error(message);
    }

    private final boolean doAdvancedReport(ClangDaemonContext context, String message, List<String> fileUrls) {
        AtomicBoolean reported = new AtomicBoolean(false);
        ClangReportUtils.withCrashLanguageService(context, arg_0 -> ClangInternalCrashReporter.doAdvancedReport$lambda$1(arg_0 -> ClangInternalCrashReporter.doAdvancedReport$lambda$0(fileUrls, message, this, reported, arg_0), arg_0));
        return reported.get();
    }

    private static final Unit doAdvancedReport$lambda$0(List $fileUrls, String $message, ClangInternalCrashReporter this$0, AtomicBoolean $reported, ClangLanguageService it) {
        Map<String, String> map = ClangReportUtils.prepareAsIsReport(it, $fileUrls);
        Intrinsics.checkNotNullExpressionValue(map, (String)"prepareAsIsReport(...)");
        Map<String, String> file2Content = map;
        if (!file2Content.isEmpty()) {
            file2Content.put("crash_message.txt", $message);
            byte[] zipReport = ClangReportUtils.makeZipArchive(file2Content);
            Path crashFile = this$0.myArtifactsPath.resolve("clangd_crash_" + this$0.myCrashId.incrementAndGet() + ".zip");
            FileUtil.writeToFile((File)crashFile.toFile(), (byte[])zipReport);
            $reported.set(true);
        }
        return Unit.INSTANCE;
    }

    private static final void doAdvancedReport$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ClangInternalCrashReporter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/reports/ClangInternalCrashReporter$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.cidr.clangd"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

