/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionClangPreprocessResult;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;

public class ClangdPreprocessAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile curFile;
        if (e == null) {
            ClangdPreprocessAction.$$$reportNull$$$0(0);
        }
        if (e.getProject() != null && (curFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE)) != null) {
            String fileName = curFile.getName();
            ClangLanguageService service = ClangLanguageServiceProvider.getOrStart(e.getProject());
            if (service == null) {
                ClangUtils.LOG.warn("Failed to getOrStart() ClangLanguageService");
                return;
            }
            try {
                service.preprocess(curFile, result -> {
                    CLionClangPreprocessResult ppRes = (CLionClangPreprocessResult)result.waitForResult();
                    if (ppRes != null) {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (!e.getProject().isDisposed()) {
                                ClangdPreprocessAction.showOutputInEditor(e.getProject(), ppRes.getOutput(), "Preprocessed " + fileName);
                            }
                        });
                    }
                });
            }
            catch (ExecutionException ex) {
                CidrLogService.LOG.error((Throwable)ex);
            }
        }
    }

    private static void showOutputInEditor(@NotNull Project project, @NotNull String text, @NotNull String caption) {
        if (project == null) {
            ClangdPreprocessAction.$$$reportNull$$$0(1);
        }
        if (text == null) {
            ClangdPreprocessAction.$$$reportNull$$$0(2);
        }
        if (caption == null) {
            ClangdPreprocessAction.$$$reportNull$$$0(3);
        }
        if (project.isDisposed()) {
            return;
        }
        FileEditorManager.getInstance((Project)project).openFile((VirtualFile)new LightVirtualFile(caption, (Language)PlainTextLanguage.INSTANCE, (CharSequence)text), true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caption";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClangdPreprocessAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "showOutputInEditor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

