/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class Trustworthiness {
    public static final int NO_COMPILATION_COMMAND = 1;
    public static final int GUESSED_COMPILATION_COMMAND = 2;
    public static final int NO_TARGET = 4;
    private final int myValue;

    public Trustworthiness() {
        this(0);
    }

    public Trustworthiness(int flag) {
        this.myValue = flag;
    }

    @NotNull
    public Trustworthiness with(int flag) {
        return new Trustworthiness(this.myValue | flag);
    }

    public boolean hasNoCompilationCommand() {
        return (this.myValue & 1) != 0;
    }

    public boolean hasNoTarget() {
        return (this.myValue & 4) != 0;
    }

    public boolean isCompilationCommandGuessed() {
        return (this.myValue & 2) != 0;
    }

    public String toString() {
        ArrayList<String> characteristics = new ArrayList<String>(3);
        if (this.hasNoCompilationCommand()) {
            characteristics.add("no command");
        }
        if (this.hasNoTarget()) {
            characteristics.add("no target");
        }
        if (this.isCompilationCommandGuessed()) {
            characteristics.add("guessed");
        }
        if (characteristics.isEmpty()) {
            characteristics.add("good");
        }
        return StringUtil.join(characteristics, (String)",");
    }
}

