/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.io.URLUtil;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangUrlConverter {
    private static final Logger LOG = Logger.getInstance((String)ClangUrlConverter.class.getName());
    @NotNull
    private String myWslMsId = "";
    @NotNull
    private String myWslMntRoot = "/mnt/";

    public boolean isAcceptable(@NotNull String url) {
        if (url == null) {
            ClangUrlConverter.$$$reportNull$$$0(0);
        }
        if (url.startsWith("file://")) {
            return true;
        }
        if (url.equals("mock:///dummy")) {
            return true;
        }
        return url.endsWith("completionHeader.h") || url.endsWith("completionSrc.c") || url.endsWith("completionSrc.cpp") || url.endsWith("_clang_format") || url.endsWith("c_cpp_properties.json") || url.endsWith("CppProperties.json");
    }

    @NotNull
    public String fromUrl(@NotNull String url) {
        if (url == null) {
            ClangUrlConverter.$$$reportNull$$$0(1);
        }
        String string = URLUtil.extractPath((String)url);
        if (string == null) {
            ClangUrlConverter.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String fromUri(@NotNull String uri) {
        if (uri == null) {
            ClangUrlConverter.$$$reportNull$$$0(3);
        }
        String string = (String)this.fromUriImpl((String)uri).first;
        if (string == null) {
            ClangUrlConverter.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String fromUriToUrl(@NotNull String uri) {
        if (uri == null) {
            ClangUrlConverter.$$$reportNull$$$0(5);
        }
        Pair<String, Boolean> pathAndMock = this.fromUriImpl(uri);
        String protocol = (Boolean)pathAndMock.second != false ? "mock" : "file";
        String string = VirtualFileManager.constructUrl((String)protocol, (String)((String)pathAndMock.first));
        if (string == null) {
            ClangUrlConverter.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String toUri(@NotNull File file, boolean isMock) {
        String string;
        if (file == null) {
            ClangUrlConverter.$$$reportNull$$$0(7);
        }
        assert (!file.getPath().contains("://"));
        try {
            if (isMock && !file.getPath().endsWith("_clang_format")) {
                URI uri = file.toURI();
                return ClangUrlConverter.mockPath2Uri(uri, file);
            }
            Object path = this.fixWslPathWhenRequired(FileUtil.toSystemIndependentName((String)file.getPath()));
            if (SystemInfo.isWindows && ((String)path).charAt(0) != '/') {
                path = "/" + (String)path;
            }
            URI uri = new URI("file", "", (String)path, null, null);
            string = uri.toString();
        }
        catch (Error | URISyntaxException ex) {
            LOG.error(ex);
            String string2 = this.fixWslPathWhenRequired(file.getPath());
            if (string2 == null) {
                ClangUrlConverter.$$$reportNull$$$0(9);
            }
            return string2;
        }
        if (string == null) {
            ClangUrlConverter.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String toUri(@NotNull VirtualFile vf) {
        if (vf == null) {
            ClangUrlConverter.$$$reportNull$$$0(10);
        }
        String string = this.toUriFromUrl(vf.getUrl());
        if (string == null) {
            ClangUrlConverter.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public String toUriFromUrl(@NotNull String url) {
        if (url == null) {
            ClangUrlConverter.$$$reportNull$$$0(12);
        }
        String path = this.fromUrl(url);
        String string = this.toUri(new File(path), url.startsWith("mock://"));
        if (string == null) {
            ClangUrlConverter.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public String path2ClangdPath(@NotNull File path, boolean isMock) {
        int driveLetterPos;
        if (path == null) {
            ClangUrlConverter.$$$reportNull$$$0(14);
        }
        if (path.getPath().isEmpty()) {
            return "";
        }
        String convertedPath = URI.create(this.toUri(path, isMock)).getPath();
        if (this.isWslMode()) {
            String string = convertedPath;
            if (string == null) {
                ClangUrlConverter.$$$reportNull$$$0(15);
            }
            return string;
        }
        if (SystemInfo.isWindows && (driveLetterPos = ClangUrlConverter.findDriveLetter(convertedPath)) > 0) {
            convertedPath = convertedPath.substring(driveLetterPos);
        }
        String string = FileUtil.toSystemDependentName((String)convertedPath);
        if (string == null) {
            ClangUrlConverter.$$$reportNull$$$0(16);
        }
        return string;
    }

    public void setWslMsId(@NotNull String wslMsId) {
        if (wslMsId == null) {
            ClangUrlConverter.$$$reportNull$$$0(17);
        }
        this.myWslMsId = wslMsId;
    }

    public void setWslMntRoot(@NotNull String wslMntRoot) {
        if (wslMntRoot == null) {
            ClangUrlConverter.$$$reportNull$$$0(18);
        }
        this.myWslMntRoot = wslMntRoot;
    }

    public boolean isWslMode() {
        return !this.myWslMsId.isEmpty();
    }

    @NotNull
    public String getWslMsId() {
        String string = this.myWslMsId;
        if (string == null) {
            ClangUrlConverter.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    public String getWslMntRoot() {
        String string = this.myWslMntRoot;
        if (string == null) {
            ClangUrlConverter.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    public String fixWslPathWhenRequired(@NotNull String path) {
        if (path == null) {
            ClangUrlConverter.$$$reportNull$$$0(21);
        }
        if (this.getWslMsId().isEmpty()) {
            String string = path;
            if (string == null) {
                ClangUrlConverter.$$$reportNull$$$0(22);
            }
            return string;
        }
        String string = StringUtil.replace((String)this.doFixWSLPath(path), (String)"\\", (String)"/");
        if (string == null) {
            ClangUrlConverter.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    private String doFixWSLPath(@NotNull String path) {
        if (path == null) {
            ClangUrlConverter.$$$reportNull$$$0(24);
        }
        if (((String)(path = FileUtil.toSystemIndependentName((String)path))).startsWith(this.getWslMntRoot()) && ClangUrlConverter.containsDriveLetter((String)path)) {
            String string = path;
            if (string == null) {
                ClangUrlConverter.$$$reportNull$$$0(25);
            }
            return string;
        }
        int schemeIndex = ((String)path).indexOf("://");
        String protocolPrefix = "";
        if (schemeIndex > 0) {
            protocolPrefix = ((String)path).substring(0, schemeIndex);
            path = ((String)path).substring(schemeIndex + "://".length());
        }
        if (ClangUtils.startsWithAnyUNCPrefix((String)path)) {
            path = ClangUtils.pathWithoutUNCPrefix((String)path);
            int indexAfterDistribution = ((String)path).indexOf("/");
            path = ((String)path).substring(indexAfterDistribution);
        } else {
            int driveLetterIndex = ((String)path).charAt(0) == '/' ? 1 : 0;
            path = this.getWslMntRoot() + StringUtil.toLowerCase((char)((String)path).charAt(driveLetterIndex)) + ((String)path).substring(driveLetterIndex + 2);
        }
        if (schemeIndex >= 0) {
            path = protocolPrefix + "://" + (String)path;
        }
        String string = path;
        if (string == null) {
            ClangUrlConverter.$$$reportNull$$$0(26);
        }
        return string;
    }

    private static boolean containsDriveLetter(@NotNull String linuxPath) {
        if (linuxPath == null) {
            ClangUrlConverter.$$$reportNull$$$0(27);
        }
        int slashInd = linuxPath.indexOf(47);
        while (slashInd >= 0) {
            int nextSlashInd = linuxPath.indexOf(47, slashInd + 1);
            if ((nextSlashInd == slashInd + 2 || nextSlashInd == -1 && slashInd + 2 == linuxPath.length()) && OSAgnosticPathUtil.isDriveLetter((char)linuxPath.charAt(slashInd + 1))) {
                return true;
            }
            slashInd = nextSlashInd;
        }
        return false;
    }

    @NotNull
    public String fromWslPath(@NotNull String path) {
        String wslMsId;
        if (path == null) {
            ClangUrlConverter.$$$reportNull$$$0(28);
        }
        if ((wslMsId = this.getWslMsId()).isEmpty() || path.isEmpty()) {
            String string = path;
            if (string == null) {
                ClangUrlConverter.$$$reportNull$$$0(29);
            }
            return string;
        }
        if (path.startsWith(this.getWslMntRoot()) && ClangUrlConverter.containsDriveLetter(path)) {
            int mntLength = this.getWslMntRoot().length();
            String string = path.substring(mntLength, mntLength + 1).toUpperCase(Locale.ROOT) + ":" + path.substring(mntLength + 1);
            if (string == null) {
                ClangUrlConverter.$$$reportNull$$$0(30);
            }
            return string;
        }
        String string = ClangUtils.getSystemIndependentUNCPrefix() + wslMsId + path;
        if (string == null) {
            ClangUrlConverter.$$$reportNull$$$0(31);
        }
        return string;
    }

    protected Pair<String, Boolean> fromUriImpl(@NotNull String uri) {
        if (uri == null) {
            ClangUrlConverter.$$$reportNull$$$0(32);
        }
        try {
            URI javaUri = URI.create(uri);
            String path = javaUri.getPath();
            String mockPath = ClangUrlConverter.mockUri2Path(javaUri, path);
            if (mockPath != null) {
                return Pair.create((Object)mockPath, (Object)true);
            }
            if (this.isWslMode()) {
                path = this.fromWslPath(path);
            } else if (SystemInfo.isWindows && path.startsWith("/") && path.length() > 2 && OSAgnosticPathUtil.startsWithWindowsDrive((String)path.substring(1))) {
                path = path.substring(1);
            }
            return Pair.create((Object)path, (Object)false);
        }
        catch (IllegalArgumentException ex) {
            ClangUtils.warnClangd(LOG, "Failed to decode " + uri, ex);
            return Pair.create((Object)uri, (Object)false);
        }
    }

    @NotNull
    private static String mockPath2Uri(@NotNull URI javaUri, @NotNull File path) {
        if (javaUri == null) {
            ClangUrlConverter.$$$reportNull$$$0(33);
        }
        if (path == null) {
            ClangUrlConverter.$$$reportNull$$$0(34);
        }
        Object rawPath = javaUri.getRawPath();
        if (SystemInfo.isWindows) {
            boolean origHadDrive;
            String origPath = path.getPath();
            boolean bl = origHadDrive = ClangUrlConverter.findDriveLetter(origPath) >= 0;
            if (!origHadDrive) {
                int driveLetterIndex = ClangUrlConverter.findDriveLetter((String)rawPath);
                if (driveLetterIndex >= 0) {
                    rawPath = ((String)rawPath).substring(driveLetterIndex + 2);
                }
            } else if (!((String)(rawPath = ((String)rawPath).replaceFirst(":", ""))).startsWith("/")) {
                rawPath = "/" + (String)rawPath;
            }
            String string = "file://" + ClangUrlConverter.getMockUriRoot(origHadDrive) + (String)rawPath;
            if (string == null) {
                ClangUrlConverter.$$$reportNull$$$0(35);
            }
            return string;
        }
        String string = "file://" + ClangUrlConverter.getMockUriRoot(false) + (String)rawPath;
        if (string == null) {
            ClangUrlConverter.$$$reportNull$$$0(36);
        }
        return string;
    }

    @Nullable
    private static String mockUri2Path(@NotNull URI javaUri, @NotNull String path) {
        if (javaUri == null) {
            ClangUrlConverter.$$$reportNull$$$0(37);
        }
        if (path == null) {
            ClangUrlConverter.$$$reportNull$$$0(38);
        }
        if (SystemInfo.isWindows && ((String)path).startsWith(ClangUrlConverter.getMockUriRoot(true))) {
            path = ((String)path).substring(ClangUrlConverter.getMockUriRoot(true).length());
            char driveLetter = ((String)path).charAt(1);
            path = driveLetter + ":" + ((String)path).substring(2);
            return path;
        }
        if (((String)path).startsWith(ClangUrlConverter.getMockUriRoot(false))) {
            return ((String)path).substring(ClangUrlConverter.getMockUriRoot(false).length());
        }
        return null;
    }

    @NlsSafe
    @NotNull
    private static String getMockUriRoot(boolean hadDriveLetter) {
        if (SystemInfo.isWindows) {
            return hadDriveLetter ? "/X:/cidr_memory_mapped_mock_with_drive" : "/X:/cidr_memory_mapped_mock";
        }
        return "/cidr_memory_mapped_mock";
    }

    public static int findDriveLetter(@NotNull String path) {
        if (path == null) {
            ClangUrlConverter.$$$reportNull$$$0(39);
        }
        if (!SystemInfo.isWindows) {
            return -1;
        }
        if (path.length() > 3 && OSAgnosticPathUtil.isAbsoluteDosPath((String)path)) {
            return 0;
        }
        if (path.length() > 4 && ClangUrlConverter.isAnySeparator(path.charAt(0)) && OSAgnosticPathUtil.isAbsoluteDosPath((String)path.substring(1))) {
            return 1;
        }
        return -1;
    }

    private static boolean isAnySeparator(char c) {
        return c == '/' || c == '\\';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6, 8, 9, 11, 13, 15, 16, 19, 20, 22, 23, 25, 26, 29, 30, 31, 35, 36 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangUrlConverter";
                break;
            }
            case 3: 
            case 5: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vf";
                break;
            }
            case 14: 
            case 21: 
            case 24: 
            case 28: 
            case 34: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wslMsId";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wslMntRoot";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linuxPath";
                break;
            }
            case 33: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaUri";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangUrlConverter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "fromUrl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "fromUri";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "fromUriToUrl";
                break;
            }
            case 8: 
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "toUri";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "toUriFromUrl";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "path2ClangdPath";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getWslMsId";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getWslMntRoot";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "fixWslPathWhenRequired";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "doFixWSLPath";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "fromWslPath";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "mockPath2Uri";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fromUrl";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 35: 
            case 36: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fromUri";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fromUriToUrl";
                break;
            }
            case 7: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "toUri";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "toUriFromUrl";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "path2ClangdPath";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setWslMsId";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setWslMntRoot";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "fixWslPathWhenRequired";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "doFixWSLPath";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "containsDriveLetter";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "fromWslPath";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "fromUriImpl";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "mockPath2Uri";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "mockUri2Path";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "findDriveLetter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 6, 8, 9, 11, 13, 15, 16, 19, 20, 22, 23, 25, 26, 29, 30, 31, 35, 36 -> new IllegalStateException(string);
        };
    }
}

