/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.inspections;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.inspections.ClangdMeasureResolveInspection;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContextImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIndexerCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdIndexerService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangdIndexingTaskId;
import com.jetbrains.cidr.lang.tests.ClangdTestUtilBase;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u001a\u0014\u0010\t\u001a\u00020\u0003*\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"log", "Lcom/intellij/openapi/diagnostic/Logger;", "withTempIndexer", "", "project", "Lcom/intellij/openapi/project/Project;", "consumer", "Ljava/util/function/Consumer;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdIndexerService;", "executeCommandAndWait", "command", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangIndexerCommand;", "intellij.cidr.clangd"})
@SourceDebugExtension(value={"SMAP\nClangdMeasureResolveInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClangdMeasureResolveInspection.kt\ncom/jetbrains/cidr/lang/daemon/clang/clangd/inspections/ClangdMeasureResolveInspectionKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,321:1\n13#2:322\n*S KotlinDebug\n*F\n+ 1 ClangdMeasureResolveInspection.kt\ncom/jetbrains/cidr/lang/daemon/clang/clangd/inspections/ClangdMeasureResolveInspectionKt\n*L\n50#1:322\n*E\n"})
public final class ClangdMeasureResolveInspectionKt {
    @NotNull
    private static final Logger log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void withTempIndexer(Project project, Consumer<ClangdIndexerService> consumer) {
        File file = FileUtilRt.createTempDirectory((String)"MeasureResolveIndexerCache", null);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempDirectory(...)");
        File modulesDir = file;
        ClangDaemonContextImpl clangDaemonContextImpl = new ClangDaemonContextImpl.Builder("MeasureResolve", project).setKind(ClangLanguageService.Kind.Indexer).setClangdModulesPath(modulesDir.getPath()).setIdeFacade(ClangdBridge.createClangIdeFacade("MeasureResolve", ClangLanguageService.Kind.Indexer)).setMemoryWatcherDelay(3000).create();
        Intrinsics.checkNotNullExpressionValue((Object)clangDaemonContextImpl, (String)"create(...)");
        ClangDaemonContextImpl context = clangDaemonContextImpl;
        ClangdIndexerService service = new ClangdIndexerService(context);
        try {
            MessageBus messageBus = service.getMessageBus();
            Disposable disposable = service.getAssociatedDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getAssociatedDisposable(...)");
            MessageBusConnection messageBusConnection = messageBus.connect(disposable);
            Topic<ClangServerListener> topic = ClangServerListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
            messageBusConnection.subscribe(topic, (Object)new ClangServerListener(service){
                private boolean indexStartedCame;
                private int lastReportedPercent;
                final /* synthetic */ ClangdIndexerService $service;
                {
                    this.$service = $service;
                    this.lastReportedPercent = -1;
                }

                public final boolean getIndexStartedCame() {
                    return this.indexStartedCame;
                }

                public final void setIndexStartedCame(boolean bl) {
                    this.indexStartedCame = bl;
                }

                public final int getLastReportedPercent() {
                    return this.lastReportedPercent;
                }

                public final void setLastReportedPercent(int n) {
                    this.lastReportedPercent = n;
                }

                public void onMessage(Message message, boolean incoming) {
                    Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                    if (ClangdMeasureResolveInspectionKt.access$getLog$p().isTraceEnabled()) {
                        String string = message.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                        String contents = string;
                        if (this.$service.getContext().getMessagesFilter().matchesBlockedCommunication(contents)) {
                            return;
                        }
                        ClangdMeasureResolveInspectionKt.access$getLog$p().trace(contents);
                    }
                }

                public void onIndexingStarted(ClangdIndexingTaskId taskId) {
                    Intrinsics.checkNotNullParameter((Object)((Object)taskId), (String)"taskId");
                    this.indexStartedCame = true;
                    this.lastReportedPercent = -1;
                }

                public void onIndexingProgress(int percentage, String message) {
                    Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                    if (this.indexStartedCame) {
                        ClangdMeasureResolveInspectionKt.access$getLog$p().info("Indexing started: " + message);
                        this.indexStartedCame = false;
                    }
                    if (percentage != this.lastReportedPercent) {
                        this.lastReportedPercent = percentage;
                        ClangdMeasureResolveInspectionKt.access$getLog$p().info("Progress: " + percentage + "%");
                    }
                }

                public void onIndexingFinished(List<String> deletedSymbolsPaths, String path) {
                    Intrinsics.checkNotNullParameter(deletedSymbolsPaths, (String)"deletedSymbolsPaths");
                    Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                    ClangdMeasureResolveInspectionKt.access$getLog$p().info("Indexing finished! " + deletedSymbolsPaths.size() + " deleted (" + path + ")");
                }

                public void onIndexingMessage(String message) {
                    Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                    ClangdMeasureResolveInspectionKt.access$getLog$p().info(message);
                }

                public void onServerFailure() {
                    ClangdMeasureResolveInspectionKt.access$getLog$p().error("clangd-indexer crashed!");
                }
            });
            ClangdMeasureResolveInspectionKt.executeCommandAndWait(service, ClangIndexerCommand.Companion.getCLEAR_STATE());
            service.notifySetCDB((Collection<VirtualFile>)ClangLanguageServiceUtils.getProjectRoots(project));
            consumer.accept(service);
        }
        catch (Throwable thr) {
            if (!(thr instanceof ControlFlowException)) {
                log.error(thr);
            }
        }
        finally {
            CompletableFuture<Integer> completableFuture = service.stop().exitCode;
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"exitCode");
            CidrConcurrentUtilsKt.waitCancelAware((Future)completableFuture, (long)Duration.toLong-impl((long)DurationKt.toDuration((int)60, (DurationUnit)DurationUnit.SECONDS), (DurationUnit)DurationUnit.MILLISECONDS), (String)"MeasureResolve indexer to stop");
            modulesDir.delete();
        }
    }

    private static final void executeCommandAndWait(ClangdIndexerService $this$executeCommandAndWait, ClangIndexerCommand command) {
        ClangdTestUtilBase.Companion.executeCommandAndWait($this$executeCommandAndWait, command);
    }

    public static final /* synthetic */ Logger access$getLog$p() {
        return log;
    }

    public static final /* synthetic */ void access$withTempIndexer(Project project, Consumer consumer) {
        ClangdMeasureResolveInspectionKt.withTempIndexer(project, consumer);
    }

    public static final /* synthetic */ void access$executeCommandAndWait(ClangdIndexerService $receiver, ClangIndexerCommand command) {
        ClangdMeasureResolveInspectionKt.executeCommandAndWait($receiver, command);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ClangdMeasureResolveInspection.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }
}

