/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.annotator;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.BackgroundUpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangAnnotatorUtil;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotationApplier;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotationApplierProvider;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class OurClangTidyInspectionsViaClangdAnnotatorPass
extends TextEditorHighlightingPass {
    private static final Logger LOG = Logger.getInstance(OurClangTidyInspectionsViaClangdAnnotatorPass.class);
    private final PsiFile myFile;
    private int myParsedVersion;

    public OurClangTidyInspectionsViaClangdAnnotatorPass(@NotNull PsiFile file, @NotNull Document document) {
        if (file == null) {
            OurClangTidyInspectionsViaClangdAnnotatorPass.$$$reportNull$$$0(0);
        }
        if (document == null) {
            OurClangTidyInspectionsViaClangdAnnotatorPass.$$$reportNull$$$0(1);
        }
        super(file.getProject(), document);
        this.myParsedVersion = -1;
        this.myFile = file;
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            OurClangTidyInspectionsViaClangdAnnotatorPass.$$$reportNull$$$0(2);
        }
        HighlightInfoHolder myHolder = new HighlightInfoHolder(this.myFile, new HighlightInfoFilter[0]);
        this.myParsedVersion = -1;
        VirtualFile virtualFile = this.myFile.getVirtualFile();
        ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted(this.myProject);
        if (this.isAnnotatorPassEnabled() && ClangAnnotatorUtil.shouldAnnotate(this.myProject, this.myFile) && virtualFile != null && service != null) {
            service.runWithParsed(virtualFile, response -> {
                if (response == null) {
                    return;
                }
                this.myParsedVersion = response.getVersion();
                CompletableFuture<Supplier<List<ClangTidyDiagnostic>>> future = response.getOurTidyDiagnostics();
                this.waitForFuture(virtualFile, response.getVersion(), future, myHolder);
            });
        }
        if (this.isAnnotatorPassEnabled()) {
            ClangUtils.traceClangd(LOG, () -> "Applying our clang-tidy inspections for " + virtualFile.getName() + "[" + this.myParsedVersion + "].");
        }
        ArrayList<HighlightInfo> highlights = new ArrayList<HighlightInfo>(myHolder.size());
        for (int j = 0; j < myHolder.size(); ++j) {
            HighlightInfo info = myHolder.get(j);
            highlights.add(info);
        }
        BackgroundUpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (PsiFile)this.myFile, (Document)this.myDocument, (int)0, (int)this.myFile.getTextLength(), highlights, (int)this.getId());
    }

    public void doApplyInformationToEditor() {
    }

    private void waitForFuture(VirtualFile virtualFile, int curFileVersion, Future<Supplier<List<ClangTidyDiagnostic>>> diagnosticsFuture, @NotNull HighlightInfoHolder myHolder) {
        if (myHolder == null) {
            OurClangTidyInspectionsViaClangdAnnotatorPass.$$$reportNull$$$0(3);
        }
        try {
            Supplier supplier = (Supplier)CidrConcurrentUtilsKt.waitCancelAndWriteActionAware(diagnosticsFuture, (long)Long.MAX_VALUE, (String)"our clang-tidy inspections");
            if (supplier != null) {
                ClangUtils.traceClangd(LOG, "Our clang-tidy inspections for " + virtualFile.getName() + "[" + curFileVersion + "] received.");
                List diagnostics = (List)supplier.get();
                if (diagnostics != null) {
                    ClangTidyAnnotationApplier applier = ClangTidyAnnotationApplierProvider.provide();
                    applier.annotateSuccess(this.myFile, diagnostics, myHolder, true);
                }
            } else {
                ClangUtils.traceClangd(LOG, "Our clang-tidy inspections for " + virtualFile.getName() + "[" + curFileVersion + "] are unavailable.");
            }
        }
        catch (ProcessCanceledException ex) {
            ClangUtils.traceClangd(LOG, "Waiting for our clang-tidy inspections for " + virtualFile.getName() + "[" + curFileVersion + "] is cancelled.");
            throw ex;
        }
        catch (ExecutionException ex) {
            ClangUtils.logServerException(LOG, ex.getMessage(), ex);
        }
        catch (TimeoutException ex) {
            ClangUtils.warnClangd(LOG, "", ex);
        }
    }

    private boolean isAnnotatorPassEnabled() {
        return ClangUtils.isClangdOn(this.myProject) && ClangUtils.isClangTidyViaClangdOn(this.myProject);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myHolder";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/annotator/OurClangTidyInspectionsViaClangdAnnotatorPass";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doCollectInformation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "waitForFuture";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

