/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.annotator;

import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class DisableClangWarningIntentionAction
extends SuppressIntentionAction
implements Iconable {
    @NotNull
    private final String myWarning;

    public DisableClangWarningIntentionAction(@NotNull String warning) {
        if (warning == null) {
            DisableClangWarningIntentionAction.$$$reportNull$$$0(0);
        }
        this.myWarning = warning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        ClangdSettings settings;
        if (project == null) {
            DisableClangWarningIntentionAction.$$$reportNull$$$0(1);
        }
        if (element == null) {
            DisableClangWarningIntentionAction.$$$reportNull$$$0(2);
        }
        ClangdSettings clangdSettings = settings = ClangdSettings.getInstance(project);
        synchronized (clangdSettings) {
            settings.setClangFlags(this.modifyConfiguration(settings.getClangFlags()));
        }
        ClangdSettings.rehighlight();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            DisableClangWarningIntentionAction.$$$reportNull$$$0(3);
        }
        if (element == null) {
            DisableClangWarningIntentionAction.$$$reportNull$$$0(4);
        }
        ClangdSettings settings = ClangdSettings.getInstance(project);
        return settings.isClangdShowErrors();
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            DisableClangWarningIntentionAction.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = ClangdBundle.message("language.cpp.clangd.disable.warning.intention", this.myWarning);
        if (string == null) {
            DisableClangWarningIntentionAction.$$$reportNull$$$0(6);
        }
        return string;
    }

    public Icon getIcon(int flags) {
        return AllIcons.Actions.Cancel;
    }

    @NotNull
    private String modifyConfiguration(@NotNull String configuration) {
        if (configuration == null) {
            DisableClangWarningIntentionAction.$$$reportNull$$$0(7);
        }
        ArrayList<Object> options = new ArrayList<Object>(StringUtil.split((String)configuration, (String)","));
        options.replaceAll(String::trim);
        String warning = StringUtil.trimStart((String)this.myWarning, (String)"-W");
        options.removeIf(option -> option.equals("-W" + warning));
        if (!options.contains("-Wno-" + warning)) {
            options.add("-Wno-" + warning);
        }
        String string = StringUtil.join(options, (String)",");
        if (string == null) {
            DisableClangWarningIntentionAction.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warning";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/annotator/DisableClangWarningIntentionAction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/annotator/DisableClangWarningIntentionAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "modifyConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "modifyConfiguration";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 8 -> new IllegalStateException(string);
        };
    }
}

