/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangHighlighting;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangFileFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Trustworthiness;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class ClangDiagnosticUtils {
    private static final IdentityHashMap<HighlightSeverity, Boolean> SUPPRESSED = new IdentityHashMap();
    @NotNull
    public static final String CLANG_UNUSED_INCLUDE_DIAG_ID = "clion_unused_include";

    public static void reportSuppressed(@NotNull PsiFile file, @NotNull ClangDiagnostic diag) {
        if (file == null) {
            ClangDiagnosticUtils.$$$reportNull$$$0(0);
        }
        if (diag == null) {
            ClangDiagnosticUtils.$$$reportNull$$$0(1);
        }
        String path = file.getVirtualFile() != null ? file.getVirtualFile().getPath() : "<no-file>";
        String message = "suppressed [" + diag.getCode() + "] " + path + ": " + diag.getMessage();
        if (ClangDiagnosticUtils.isDriverDiagnostic(diag) || ClangDiagnosticUtils.isTargetRelatedDiagnostic(diag)) {
            ClangUtils.LOG.warn(message);
        } else {
            ClangUtils.warnClangd(ClangUtils.LOG, message);
        }
    }

    @NotNull
    public static @Unmodifiable List<? extends ClangDiagnostic> filterDiagnostics(@NotNull PsiFile file, @NotNull Trustworthiness trustworthiness, @NotNull List<ClangDiagnostic> diags) {
        if (file == null) {
            ClangDiagnosticUtils.$$$reportNull$$$0(2);
        }
        if (trustworthiness == null) {
            ClangDiagnosticUtils.$$$reportNull$$$0(3);
        }
        if (diags == null) {
            ClangDiagnosticUtils.$$$reportNull$$$0(4);
        }
        List afterBasicFiltering = ContainerUtil.filter(diags, diag -> {
            HighlightSeverity severity = ClangDiagnosticUtils.getHighlightSeverity(diag);
            if (SUPPRESSED.containsKey(severity)) {
                return false;
            }
            if (ClangDiagnosticUtils.isIgnoredDiagnostic(diag)) {
                ClangDiagnosticUtils.reportSuppressed(file, diag);
                return false;
            }
            if (trustworthiness.hasNoTarget() && diag.getCode() != null) {
                switch (diag.getCode()) {
                    case "pragma_options_align_mac68k_target_unsupported": 
                    case "tls_var_aligned_over_maximum": 
                    case "seh_try_unsupported": 
                    case "asm_invalid_global_var_reg": 
                    case "asm_unknown_register_name": 
                    case "builtin_target_unsupported": 
                    case "type_unsupported": 
                    case "objc_method_unsupported_param_ret_type": 
                    case "attribute_unsupported": 
                    case "attribute_section_invalid_for_target": 
                    case "atomic_load_store_uses_lib": {
                        ClangDiagnosticUtils.reportSuppressed(file, diag);
                        return false;
                    }
                }
            }
            if (ClangDiagnosticUtils.isUnusedIncludeDirectiveDiagnostic(diag) && !OCInspectionUtil.isInspectionEnabled((Project)file.getProject(), ClangdBridge.getUnusedIncludesInspection())) {
                ClangDiagnosticUtils.reportSuppressed(file, diag);
                return false;
            }
            return true;
        });
        List<ClangDiagnostic> list = ClangdBridge.filterDiagnostics(file, trustworthiness, afterBasicFiltering);
        if (list == null) {
            ClangDiagnosticUtils.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public static HighlightSeverity getHighlightSeverity(@NotNull ClangDiagnostic diag) {
        if (diag == null) {
            ClangDiagnosticUtils.$$$reportNull$$$0(6);
        }
        HighlightSeverity severity = diag.getSeverity() == HighlightSeverity.ERROR ? HighlightSeverity.ERROR : (diag.getSeverity() == HighlightSeverity.WARNING ? HighlightSeverity.WARNING : (diag.getSeverity() == HighlightSeverity.INFORMATION ? HighlightSeverity.WEAK_WARNING : HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING));
        HighlightSeverity highlightSeverity = severity;
        if (highlightSeverity == null) {
            ClangDiagnosticUtils.$$$reportNull$$$0(7);
        }
        return highlightSeverity;
    }

    public static boolean isIgnoredDiagnostic(@NotNull ClangDiagnostic diag) {
        if (diag == null) {
            ClangDiagnosticUtils.$$$reportNull$$$0(8);
        }
        return ClangDiagnosticUtils.isDriverDiagnostic(diag) || ClangDiagnosticUtils.isTargetRelatedDiagnostic(diag) || ClangDiagnosticUtils.isUnwantedWarning(diag) || ClangUtils.isFromIncludedFile(diag);
    }

    public static boolean isUnusedDiagnostic(@NotNull ClangDiagnostic diagnostic) {
        String name;
        if (diagnostic == null) {
            ClangDiagnosticUtils.$$$reportNull$$$0(9);
        }
        if ((name = diagnostic.getCode()) == null) {
            return false;
        }
        if (name.startsWith("warn_unused_result") || name.startsWith("-Wunused-result")) {
            return false;
        }
        return name.startsWith("warn_unused_") || name.startsWith("-Wunused");
    }

    public static boolean isUnusedIncludeDirectiveDiagnostic(@NotNull ClangDiagnostic diagnostic) {
        if (diagnostic == null) {
            ClangDiagnosticUtils.$$$reportNull$$$0(10);
        }
        return StringUtil.equals((CharSequence)CLANG_UNUSED_INCLUDE_DIAG_ID, (CharSequence)diagnostic.getCode());
    }

    @Nullable
    public static TextRange createClangTextRange(@NotNull ClangDiagnostic diag, @NotNull ClangFileFacade helper) {
        if (diag == null) {
            ClangDiagnosticUtils.$$$reportNull$$$0(11);
        }
        if (helper == null) {
            ClangDiagnosticUtils.$$$reportNull$$$0(12);
        }
        CidrConcurrentUtilsKt.checkCanceled();
        return ClangDiagnosticUtils.createClangTextRange(diag.getStartLine(), diag.getStartColumn(), diag.getEndLine(), diag.getEndColumn(), helper);
    }

    @Nullable
    public static TextRange createClangTextRange(@NotNull ClangHighlighting highlighting, @NotNull ClangFileFacade helper) {
        if (highlighting == null) {
            ClangDiagnosticUtils.$$$reportNull$$$0(13);
        }
        if (helper == null) {
            ClangDiagnosticUtils.$$$reportNull$$$0(14);
        }
        CidrConcurrentUtilsKt.checkCanceled();
        return ClangDiagnosticUtils.createClangTextRange(highlighting.getStartLine(), highlighting.getStartColumn(), highlighting.getEndLine(), highlighting.getEndColumn(), helper);
    }

    @Nullable
    private static TextRange createClangTextRange(int startLine, int startColumn, int endLine, int endColumn, @NotNull ClangFileFacade helper) {
        if (helper == null) {
            ClangDiagnosticUtils.$$$reportNull$$$0(15);
        }
        try {
            int startLineOffset = helper.getLineStartOffset(startLine);
            int endLineOffset = helper.getLineStartOffset(endLine);
            if (!TextRange.isProperRange((int)startLineOffset, (int)endLineOffset)) {
                return null;
            }
            return new TextRange(startLineOffset + startColumn, endLineOffset + endColumn);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException ex) {
            ClangUtils.LOG.error((Throwable)ex);
            return null;
        }
    }

    private static boolean isDriverDiagnostic(@NotNull ClangDiagnostic diag) {
        if (diag == null) {
            ClangDiagnosticUtils.$$$reportNull$$$0(16);
        }
        return diag.getCode() != null && diag.getCode().startsWith("drv_");
    }

    private static boolean isTargetRelatedDiagnostic(@NotNull ClangDiagnostic diag) {
        String code;
        if (diag == null) {
            ClangDiagnosticUtils.$$$reportNull$$$0(17);
        }
        if ((code = diag.getCode()) != null) {
            switch (code) {
                case "target_unknown_abi": 
                case "target_unknown_cpu": 
                case "target_unknown_fpmath": {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isUnwantedWarning(@NotNull ClangDiagnostic diag) {
        if (diag == null) {
            ClangDiagnosticUtils.$$$reportNull$$$0(18);
        }
        return Objects.equals(diag.getCode(), "-Wunknown-warning-option") || Objects.equals(diag.getCode(), "-Wexperimental-header-units");
    }

    static {
        SUPPRESSED.put(HighlightSeverity.INFORMATION, true);
        SUPPRESSED.put(HighlightSeverity.WEAK_WARNING, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 11: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diag";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trustworthiness";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diags";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/ClangDiagnosticUtils";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnostic";
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighting";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/ClangDiagnosticUtils";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "filterDiagnostics";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightSeverity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reportSuppressed";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "filterDiagnostics";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightSeverity";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredDiagnostic";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isUnusedDiagnostic";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isUnusedIncludeDirectiveDiagnostic";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createClangTextRange";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isDriverDiagnostic";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isTargetRelatedDiagnostic";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isUnwantedWarning";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7 -> new IllegalStateException(string);
        };
    }
}

