/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.LocalVariablesFilterHandler;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResult;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResultFuture;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J2\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/cidr/execution/debugger/evaluation/ClangLocalVarsFilterHandler;", "Lcom/jetbrains/cidr/execution/debugger/evaluation/LocalVariablesFilterHandler;", "<init>", "()V", "canFilterAtPos", "", "proj", "Lcom/intellij/openapi/project/Project;", "pos", "Lcom/intellij/xdebugger/XSourcePosition;", "filterVars", "Ljava/util/concurrent/CompletableFuture;", "", "Lcom/jetbrains/cidr/execution/debugger/backend/LLValue;", "vars", "intellij.cidr.clangd"})
@SourceDebugExtension(value={"SMAP\nClangLocalVarsFilterHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClangLocalVarsFilterHandler.kt\ncom/jetbrains/cidr/execution/debugger/evaluation/ClangLocalVarsFilterHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,42:1\n1222#2,2:43\n1252#2,4:45\n1563#2:49\n1634#2,3:50\n1056#2:53\n774#2:54\n865#2,2:55\n1563#2:57\n1634#2,3:58\n*S KotlinDebug\n*F\n+ 1 ClangLocalVarsFilterHandler.kt\ncom/jetbrains/cidr/execution/debugger/evaluation/ClangLocalVarsFilterHandler\n*L\n30#1:43,2\n30#1:45,4\n31#1:49\n31#1:50,3\n33#1:53\n34#1:54\n34#1:55,2\n35#1:57\n35#1:58,3\n*E\n"})
public final class ClangLocalVarsFilterHandler
implements LocalVariablesFilterHandler {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canFilterAtPos(@NotNull Project proj, @NotNull XSourcePosition pos) {
        Intrinsics.checkNotNullParameter((Object)proj, (String)"proj");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted(proj);
        if (!Registry.Companion.is("clion.clangd.clangd.debugger.localVarsFilter")) return false;
        if (!ClangUtils.isClangdOn(proj)) return false;
        if (!ClangdBridge.isSupported(proj, pos.getFile())) return false;
        ClangLanguageService clangLanguageService = service;
        if (clangLanguageService == null) return true;
        boolean bl = clangLanguageService.isFileBanned(pos.getFile().getUrl());
        if (bl) return false;
        return true;
    }

    @NotNull
    public CompletableFuture<List<LLValue>> filterVars(@NotNull Project proj, @NotNull XSourcePosition pos, @NotNull List<? extends LLValue> vars) {
        Ref.ObjectRef result;
        block0: {
            Intrinsics.checkNotNullParameter((Object)proj, (String)"proj");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter(vars, (String)"vars");
            result = new Ref.ObjectRef();
            CompletableFuture<List<? extends LLValue>> completableFuture = CompletableFuture.completedFuture(vars);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            result.element = completableFuture;
            ClangLanguageService clangLanguageService = ClangLanguageServiceProvider.getOrStart(proj);
            if (clangLanguageService == null) break block0;
            clangLanguageService.getLocalVariables(pos.getFile(), pos.getLine(), arg_0 -> ClangLocalVarsFilterHandler.filterVars$lambda$0(result, vars, arg_0));
        }
        return (CompletableFuture)result.element;
    }

    private static final void filterVars$lambda$0(Ref.ObjectRef $result, List $vars, ClangResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ClangResultFuture clangResultFuture = it.iWillNotForgetToCancelTheFuture();
        Intrinsics.checkNotNullExpressionValue(clangResultFuture, (String)"iWillNotForgetToCancelTheFuture(...)");
        ClangResultFuture a = clangResultFuture;
        CompletionStage completionStage = ((CompletableFuture)a.asFuture().thenApply(arg_0 -> ClangLocalVarsFilterHandler.filterVars$lambda$0$1(arg_0 -> ClangLocalVarsFilterHandler.filterVars$lambda$0$0($vars, arg_0), arg_0))).whenComplete((arg_0, arg_1) -> ClangLocalVarsFilterHandler.filterVars$lambda$0$3((arg_0, arg_1) -> ClangLocalVarsFilterHandler.filterVars$lambda$0$2(a, arg_0, arg_1), arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"whenComplete(...)");
        $result.element = completionStage;
    }

    /*
     * WARNING - void declaration
     */
    private static final List filterVars$lambda$0$0(List $vars, List clangdLocals) {
        LLValue v;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable $this$sortedBy$iv;
        void $this$mapTo$iv$iv;
        IndexedValue p0;
        Object object;
        IndexedValue indexedValue;
        Iterable $this$associateByTo$iv$iv;
        List list = clangdLocals;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        Iterable $this$associateBy$iv = CollectionsKt.withIndex((Iterable)list);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            indexedValue = (IndexedValue)element$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            p0 = (IndexedValue)element$iv$iv;
            String string = (String)p0.getValue();
            boolean bl2 = false;
            Integer n = p0.getIndex();
            object.put(string, n);
        }
        Map clangdLocalsOrder = destination$iv$iv;
        Iterable $this$map$iv = $vars;
        boolean $i$f$map = false;
        $this$associateByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void v2;
            p0 = (LLValue)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            String string = v2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            object.add(TuplesKt.to((Object)v2, (Object)clangdLocalsOrder.getOrDefault(string, -1)));
        }
        List varsWithDeclOrder = (List)destination$iv$iv;
        $this$map$iv = varsWithDeclOrder;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair pair = (Pair)a;
                boolean bl = false;
                int declOrder = ((Number)pair.component2()).intValue();
                pair = (Pair)b;
                Comparable comparable = Integer.valueOf(declOrder);
                bl = false;
                declOrder = ((Number)pair.component2()).intValue();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(declOrder));
            }
        });
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            indexedValue = (Pair)element$iv$iv;
            boolean bl = false;
            v = (LLValue)indexedValue.component1();
            int declOrder = ((Number)indexedValue.component2()).intValue();
            if (!(declOrder >= 0 || Intrinsics.areEqual((Object)v.getName(), (Object)"this"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            indexedValue = (Pair)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            v = (LLValue)indexedValue.component1();
            object.add(v);
        }
        return (List)destination$iv$iv;
    }

    private static final List filterVars$lambda$0$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final Unit filterVars$lambda$0$2(ClangResultFuture $a, List list, Throwable throwable) {
        $a.release();
        return Unit.INSTANCE;
    }

    private static final void filterVars$lambda$0$3(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }
}

