/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.utils;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JJ\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u00072\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00102\u0006\u0010\n\u001a\u00020\u0007J>\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u00072\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00122\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/utils/EnvironmentUtils;", "", "<init>", "()V", "invalidNameChars", "Lkotlin/text/Regex;", "expandVariables", "", "startSeparator", "endSeparator", "stringToExpand", "variableVisitor", "Lkotlin/Function1;", "removeNullVariables", "", "extractMSBuildVariableNames", "", "environment", "", "msBuild", "intellij.rider.rdclient.dotnet"})
public final class EnvironmentUtils {
    @NotNull
    public static final EnvironmentUtils INSTANCE = new EnvironmentUtils();
    @NotNull
    private static final Regex invalidNameChars = new Regex("[$(]");

    private EnvironmentUtils() {
    }

    @Nullable
    public final String expandVariables(@NotNull String startSeparator, @NotNull String endSeparator, @Nullable String stringToExpand, @NotNull Function1<? super String, String> variableVisitor, boolean removeNullVariables, @Nullable Regex invalidNameChars) {
        int startIndex;
        Intrinsics.checkNotNullParameter((Object)startSeparator, (String)"startSeparator");
        Intrinsics.checkNotNullParameter((Object)endSeparator, (String)"endSeparator");
        Intrinsics.checkNotNullParameter(variableVisitor, (String)"variableVisitor");
        if (stringToExpand == null) {
            return null;
        }
        StringBuilder resultBuilder = new StringBuilder();
        int currentPos = 0;
        while (currentPos < stringToExpand.length() && (startIndex = StringsKt.indexOf$default((CharSequence)stringToExpand, (String)startSeparator, (int)currentPos, (boolean)false, (int)4, null)) >= 0) {
            CharSequence charSequence;
            String name;
            int endIndex;
            if (startIndex > currentPos) {
                String string = stringToExpand.substring(currentPos, startIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                resultBuilder.append(string);
                currentPos = startIndex;
            }
            if ((endIndex = StringsKt.indexOf$default((CharSequence)stringToExpand, (String)endSeparator, (int)(startIndex + startSeparator.length()), (boolean)false, (int)4, null)) < 0) break;
            Intrinsics.checkNotNullExpressionValue((Object)stringToExpand.substring(startIndex + startSeparator.length(), endIndex), (String)"substring(...)");
            if (((CharSequence)name).length() > 0 && (invalidNameChars == null || !invalidNameChars.containsMatchIn(charSequence = (CharSequence)name))) {
                String variableContent = (String)variableVisitor.invoke((Object)name);
                if (variableContent == null && removeNullVariables) {
                    currentPos = endIndex + endSeparator.length();
                    continue;
                }
                if (variableContent != null) {
                    resultBuilder.append(variableContent);
                    currentPos = endIndex + endSeparator.length();
                    continue;
                }
            }
            String string = stringToExpand.substring(currentPos, endIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            resultBuilder.append(string);
            currentPos = endIndex;
        }
        String string = stringToExpand.substring(currentPos);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        resultBuilder.append(string);
        return resultBuilder.toString();
    }

    @NotNull
    public final Set<String> extractMSBuildVariableNames(@NotNull String stringToExpand) {
        Intrinsics.checkNotNullParameter((Object)stringToExpand, (String)"stringToExpand");
        Set variables = new LinkedHashSet();
        this.expandVariables("$(", ")", stringToExpand, (Function1<? super String, String>)((Function1)arg_0 -> EnvironmentUtils.extractMSBuildVariableNames$lambda$0(variables, arg_0)), true, invalidNameChars);
        return variables;
    }

    @Nullable
    public final String expandVariables(@Nullable String stringToExpand, @NotNull Map<String, String> environment, @NotNull Map<String, String> msBuild) {
        Intrinsics.checkNotNullParameter(environment, (String)"environment");
        Intrinsics.checkNotNullParameter(msBuild, (String)"msBuild");
        String envExpansionResult2 = this.expandVariables("%", "%", stringToExpand, (Function1<? super String, String>)((Function1)new Function1<String, String>(environment){

            public final String invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return (String)((Map)this.receiver).get(p0);
            }
        }), false, null);
        return this.expandVariables("$(", ")", envExpansionResult2, (Function1<? super String, String>)((Function1)new Function1<String, String>(msBuild){

            public final String invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return (String)((Map)this.receiver).get(p0);
            }
        }), true, invalidNameChars);
    }

    private static final String extractMSBuildVariableNames$lambda$0(Set $variables, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $variables.add(it);
        return "";
    }
}

