/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ui;

import com.jetbrains.rider.ui.RiderColor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR$\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/ui/RiderProgressBar;", "Ljavax/swing/JComponent;", "topBorder", "", "bottomBorder", "h", "<init>", "(III)V", "getTopBorder", "()I", "getBottomBorder", "getH", "value", "", "fraction", "getFraction", "()D", "setFraction", "(D)V", "paintComponent", "", "g", "Ljava/awt/Graphics;", "Companion", "intellij.rider.rdclient.dotnet"})
public final class RiderProgressBar
extends JComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int topBorder;
    private final int bottomBorder;
    private final int h;
    private double fraction;
    @NotNull
    private static final RiderColor activeColor = new RiderColor(6460126, 6460126);
    @NotNull
    private static final RiderColor backColor = new RiderColor(15001839, 5527127);

    public RiderProgressBar(int topBorder, int bottomBorder, int h) {
        this.topBorder = topBorder;
        this.bottomBorder = bottomBorder;
        this.h = h;
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, this.h + this.topBorder + this.bottomBorder));
        this.updateUI();
    }

    public /* synthetic */ RiderProgressBar(int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 1) != 0) {
            n = 4;
        }
        if ((n4 & 2) != 0) {
            n2 = 4;
        }
        if ((n4 & 4) != 0) {
            n3 = 3;
        }
        this(n, n2, n3);
    }

    public final int getTopBorder() {
        return this.topBorder;
    }

    public final int getBottomBorder() {
        return this.bottomBorder;
    }

    public final int getH() {
        return this.h;
    }

    public final double getFraction() {
        return this.fraction;
    }

    public final void setFraction(double value) {
        this.fraction = Math.max(0.0, Math.min(1.0, value));
        this.repaint();
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paintComponent(g);
        double factor = Math.abs(this.fraction - 1.0) < 1.0E-9 ? 0.0 : this.fraction;
        int d = (int)((double)this.getWidth() * factor);
        g.setColor((Color)((Object)activeColor));
        g.fillRect(0, this.topBorder, d, this.h);
        g.setColor((Color)((Object)backColor));
        g.fillRect(d, this.topBorder, this.getWidth() - d, this.h);
    }

    public RiderProgressBar() {
        this(0, 0, 0, 7, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/ui/RiderProgressBar$Companion;", "", "<init>", "()V", "activeColor", "Lcom/jetbrains/rider/ui/RiderColor;", "getActiveColor", "()Lcom/jetbrains/rider/ui/RiderColor;", "backColor", "getBackColor", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RiderColor getActiveColor() {
            return activeColor;
        }

        @NotNull
        public final RiderColor getBackColor() {
            return backColor;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

