/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.template;

import com.jetbrains.rd.ide.model.LiveTemplateMacroModel;
import com.jetbrains.rd.ide.model.LiveTemplateVariableModel;
import com.jetbrains.rdclient.RiderOnly;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@RiderOnly
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\n\u001a\u00020\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/template/FrontendLiveTemplateExecutionData;", "", "currentText", "", "rolledText", "variables", "", "Lcom/jetbrains/rd/ide/model/LiveTemplateVariableModel;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "toFormattedText", "", "buffer", "Ljava/lang/StringBuffer;", "v", "index", "", "macro", "Lcom/jetbrains/rd/ide/model/LiveTemplateMacroModel;", "intellij.rider.rdclient.dotnet"})
public final class FrontendLiveTemplateExecutionData {
    @NotNull
    private final String currentText;
    @NotNull
    private final String rolledText;
    @NotNull
    private final List<LiveTemplateVariableModel> variables;

    public FrontendLiveTemplateExecutionData(@NotNull String currentText, @NotNull String rolledText, @NotNull List<LiveTemplateVariableModel> variables) {
        Intrinsics.checkNotNullParameter((Object)currentText, (String)"currentText");
        Intrinsics.checkNotNullParameter((Object)rolledText, (String)"rolledText");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        this.currentText = currentText;
        this.rolledText = rolledText;
        this.variables = variables;
    }

    @NotNull
    public final String toFormattedText() {
        StringBuffer buffer = new StringBuffer();
        this.toFormattedText(buffer);
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void toFormattedText(StringBuffer buffer) {
        ((Appendable)buffer).append("##### TemplateExecution #####").append('\n');
        ((Appendable)buffer).append("## CurrentText ##").append('\n');
        ((Appendable)buffer).append(this.currentText).append('\n');
        ((Appendable)buffer).append("## RolledText  ##").append('\n');
        ((Appendable)buffer).append(this.rolledText).append('\n');
        ((Appendable)buffer).append("## Variables   ##").append('\n');
        Iterator iterator2 = ((Iterable)this.variables).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index = n++;
            LiveTemplateVariableModel v = (LiveTemplateVariableModel)iterator2.next();
            this.toFormattedText(buffer, v, index);
        }
        ((Appendable)buffer).append("#############################").append('\n');
    }

    private final void toFormattedText(StringBuffer buffer, LiveTemplateVariableModel v, int index) {
        ((Appendable)buffer).append("[" + index + "] " + v.getName()).append('\n');
        ((Appendable)buffer).append("  CurrentValue = " + v.getCurrentValue()).append('\n');
        this.toFormattedText(buffer, v.getMacro());
    }

    private final void toFormattedText(StringBuffer buffer, LiveTemplateMacroModel macro) {
        String fullName = macro.getName();
        if (!Intrinsics.areEqual((Object)fullName, (Object)"")) {
            char[] cArray = new char[]{'.'};
            String shortName = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)fullName, (char[])cArray, (boolean)false, (int)0, (int)6, null));
            String args = CollectionsKt.joinToString$default((Iterable)macro.getArgs(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            ((Appendable)buffer).append("  Macro:").append('\n');
            ((Appendable)buffer).append("    Name = " + shortName + " (" + fullName + ")").append('\n');
            ((Appendable)buffer).append("    Args = [" + args + "]").append('\n');
        }
    }
}

