/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings.tree.renderers;

import com.intellij.ui.components.JBComboBoxLabel;
import com.jetbrains.rider.model.EnumWithValue;
import com.jetbrains.rider.model.RdColor;
import com.jetbrains.rider.model.Severity;
import com.jetbrains.rider.model.SeverityElement;
import com.jetbrains.rider.settings.RiderSettingsBundle;
import com.jetbrains.rider.settings.util.ColorUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0018\u0010\u0017\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rider/settings/tree/renderers/NodeNotifyRenderer;", "Ljavax/swing/table/TableCellRenderer;", "<init>", "()V", "myEnumRenderer", "Lcom/intellij/ui/components/JBComboBoxLabel;", "myReadonlyRenderer", "myEmptyLabel", "Ljavax/swing/JPanel;", "colorUtil", "Lcom/jetbrains/rider/settings/util/ColorUtil;", "getTableCellRendererComponent", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "value", "", "isSelected", "", "hasFocus", "row", "", "column", "getRendererComponent", "background", "Ljava/awt/Color;", "getSeverityElement", "Lcom/jetbrains/rider/model/SeverityElement;", "severity", "Lcom/jetbrains/rider/model/Severity;", "intellij.rider.rdclient.dotnet"})
public final class NodeNotifyRenderer
implements TableCellRenderer {
    @NotNull
    private final JBComboBoxLabel myEnumRenderer = new JBComboBoxLabel();
    @NotNull
    private final JBComboBoxLabel myReadonlyRenderer = new JBComboBoxLabel();
    @NotNull
    private final JPanel myEmptyLabel = new JPanel();
    @NotNull
    private final ColorUtil colorUtil = new ColorUtil();

    public NodeNotifyRenderer() {
        this.myEnumRenderer.setEnabled(true);
        this.myEnumRenderer.setHorizontalAlignment(0);
        this.myEnumRenderer.setRegularIcon();
        this.myReadonlyRenderer.setEnabled(false);
        this.myReadonlyRenderer.setHorizontalAlignment(0);
        this.myReadonlyRenderer.setSelectionIcon();
        Color color = this.myReadonlyRenderer.getForeground();
        this.myReadonlyRenderer.setForeground(new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)Math.round((double)color.getAlpha() * 0.5)));
    }

    @Override
    @NotNull
    public Component getTableCellRendererComponent(@NotNull JTable table2, @NotNull Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Color color = table2.getBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getBackground(...)");
        Component component2 = this.getRendererComponent(value, color);
        return component2;
    }

    private final Component getRendererComponent(Object value, Color background) {
        if (value instanceof Severity) {
            SeverityElement element = this.getSeverityElement((Severity)((Object)value));
            if (element != null) {
                String text = element.getValue().getPresentation();
                RdColor color = element.getColor();
                Color rendererColor = new Color(color.getR(), color.getG(), color.getB(), color.getA());
                if (((Severity)((Object)value)).isEnabled()) {
                    this.myEnumRenderer.setText(text);
                    this.myEnumRenderer.setBackground(ColorUtil.convertColor$default(this.colorUtil, rendererColor, 0.0, 2, null));
                    return (Component)this.myEnumRenderer;
                }
                this.myReadonlyRenderer.setText(text);
                this.myReadonlyRenderer.setBackground(this.colorUtil.convertColor(rendererColor, 0.5));
                return (Component)this.myReadonlyRenderer;
            }
            this.myReadonlyRenderer.setText(RiderSettingsBundle.Companion.message("label.unknown", new Object[0]));
            return (Component)this.myReadonlyRenderer;
        }
        this.myEmptyLabel.setBackground(background);
        return this.myEmptyLabel;
    }

    private final SeverityElement getSeverityElement(Severity severity) {
        Integer currentValue = (Integer)severity.getValue().getValueOrNull();
        for (SeverityElement severityElement : severity.getPossibleValues()) {
            EnumWithValue value = severityElement.getValue();
            Integer n = currentValue;
            if (n == null || value.getValue() != n.intValue()) continue;
            return severityElement;
        }
        return null;
    }
}

