/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings.search;

import com.intellij.ide.ui.search.SearchableOptionEntry;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.ide.ui.search.TraverseUIHelper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.util.ApplicationKt;
import com.jetbrains.ide.model.loggers.LogEntryBase;
import com.jetbrains.ide.model.loggers.LogEntryType;
import com.jetbrains.ide.model.loggers.LoggerModel_GeneratedKt;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rdclient.util.idea.ExtensionsKt;
import com.jetbrains.rider.RiderEnvironment;
import com.jetbrains.rider.model.OptionsPageInfo;
import com.jetbrains.rider.protocol.IProtocolHostWithBackend;
import com.jetbrains.rider.protocol.ProtocolManager;
import com.jetbrains.rider.protocol.ReSharperProcessBase;
import com.jetbrains.rider.protocol.components.ShellHost;
import com.jetbrains.rider.settings.IRiderViewModelConfigurable;
import com.jetbrains.rider.settings.ReSharperConfigurableUtilKt;
import com.jetbrains.rider.settings.SettingsViewModelHost;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\u0007H\u0016J\u001e\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u001e\u0010\u0012\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/settings/search/RiderTraverseUIHelper;", "Lcom/intellij/ide/ui/search/TraverseUIHelper;", "<init>", "()V", "traversalLifetimeDef", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "log", "", "message", "", "beforeStart", "afterResultsAreSaved", "beforeConfigurable", "configurable", "Lcom/intellij/openapi/options/SearchableConfigurable;", "options", "", "Lcom/intellij/ide/ui/search/SearchableOptionEntry;", "afterConfigurable", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderTraverseUIHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderTraverseUIHelper.kt\ncom/jetbrains/rider/settings/search/RiderTraverseUIHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,106:1\n1#2:107\n1869#3,2:108\n32#4,2:110\n*S KotlinDebug\n*F\n+ 1 RiderTraverseUIHelper.kt\ncom/jetbrains/rider/settings/search/RiderTraverseUIHelper\n*L\n53#1:108,2\n82#1:110,2\n*E\n"})
public final class RiderTraverseUIHelper
implements TraverseUIHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LifetimeDefinition traversalLifetimeDef = new LifetimeDefinition();
    @NotNull
    private static final Logger logger;

    private final void log(String message) {
        logger.trace(message);
        if (RiderEnvironment.INSTANCE.isUnderTeamCity()) {
            System.out.println((Object)message);
        }
    }

    public void beforeStart() {
        Project project = ProjectManager.getInstance().getDefaultProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getDefaultProject(...)");
        Project project2 = project;
        IProtocolHostWithBackend protocolHost = (IProtocolHostWithBackend)CollectionsKt.single((Iterable)((Iterable)ProtocolManager.Companion.getInstance().getProtocolHosts()));
        ShellHost shellHost = ShellHost.Companion.getInstance(protocolHost.getSession());
        Duration duration = Duration.ofMinutes(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(...)");
        if (!ExtensionsKt.pumpMessages(duration, (Function0<Boolean>)((Function0)() -> RiderTraverseUIHelper.beforeStart$lambda$0(shellHost)))) {
            boolean bl = false;
            String string = "Shell host was not ready in 1 minute";
            throw new IllegalArgumentException(string.toString());
        }
        SettingsViewModelHost host = SettingsViewModelHost.Companion.getOrCreate(project2);
        Duration duration2 = Duration.ofMinutes(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMinutes(...)");
        if (!ExtensionsKt.pumpMessages(duration2, (Function0<Boolean>)((Function0)() -> RiderTraverseUIHelper.beforeStart$lambda$2(host)))) {
            boolean bl = false;
            String string = "Host settings dialog was not ready in 1 minute";
            throw new IllegalArgumentException(string.toString());
        }
        LoggerModel_GeneratedKt.getLoggerModel((IProtocol)protocolHost.getProtocol()).getMessage().advise(this.traversalLifetimeDef.getLifetime(), arg_0 -> RiderTraverseUIHelper.beforeStart$lambda$4(this, arg_0));
    }

    public void afterResultsAreSaved() {
        ProtocolManager pm = ProtocolManager.Companion.getInstance();
        boolean bl = false;
        Iterable $this$forEach$iv = (Iterable)pm.getProtocolHosts();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IProtocolHostWithBackend host = (IProtocolHostWithBackend)element$iv;
            boolean bl2 = false;
            ApplicationKt.getApplication().invokeAndWait(() -> RiderTraverseUIHelper.afterResultsAreSaved$lambda$0$0$0(pm, host));
            ReSharperProcessBase reSharperProcessBase = host.getResharperProcess();
            if (reSharperProcessBase == null) continue;
            reSharperProcessBase.waitFor(false, (Function0<Unit>)((Function0)RiderTraverseUIHelper::afterResultsAreSaved$lambda$0$0$1));
        }
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.traversalLifetimeDef, (boolean)false, (int)1, null);
    }

    public void beforeConfigurable(@NotNull SearchableConfigurable configurable, @NotNull Set<SearchableOptionEntry> options) {
        Intrinsics.checkNotNullParameter((Object)configurable, (String)"configurable");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        IRiderViewModelConfigurable iRiderViewModelConfigurable = ReSharperConfigurableUtilKt.unwrapReSharperConfigurable((Configurable)configurable);
        if (iRiderViewModelConfigurable == null) {
            return;
        }
        IRiderViewModelConfigurable unwrapped = iRiderViewModelConfigurable;
        List sourcePages = CollectionsKt.toList(unwrapped.getReSharperPagesId());
        Ref.IntRef havePages = new Ref.IntRef();
        int targetPages = CollectionsKt.count(unwrapped.getReSharperPagesId());
        this.log("Before configurable " + unwrapped.getClass().getName());
        if (targetPages > 0) {
            RiderTraverseUIHelper.beforeConfigurable$doNextPage(sourcePages, havePages, this, targetPages, unwrapped, configurable, options);
        }
        Duration duration = Duration.ofMinutes(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(...)");
        if (!ExtensionsKt.pumpMessages(duration, (Function0<Boolean>)((Function0)() -> RiderTraverseUIHelper.beforeConfigurable$lambda$1(havePages, targetPages)))) {
            boolean bl = false;
            String string = "Timeout while waiting for pages from " + unwrapped.getClass().getSimpleName();
            throw new IllegalArgumentException(string.toString());
        }
        this.log("Configurable " + unwrapped.getClass().getName() + " processed in before, handing off to IDEA");
    }

    public void afterConfigurable(@NotNull SearchableConfigurable configurable, @NotNull Set<SearchableOptionEntry> options) {
        Intrinsics.checkNotNullParameter((Object)configurable, (String)"configurable");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        IRiderViewModelConfigurable iRiderViewModelConfigurable = ReSharperConfigurableUtilKt.unwrapReSharperConfigurable((Configurable)configurable);
        if (iRiderViewModelConfigurable == null) {
            return;
        }
        IRiderViewModelConfigurable unwrapped = iRiderViewModelConfigurable;
        this.log("After configurable " + unwrapped.getClass().getName());
    }

    private static final boolean beforeStart$lambda$0(ShellHost $shellHost) {
        return (Boolean)$shellHost.isReady().getValue();
    }

    private static final boolean beforeStart$lambda$2(SettingsViewModelHost $host) {
        return InterfacesKt.getHasValue((IOptPropertyView)((IOptPropertyView)$host.getCurrentDialog()));
    }

    private static final Unit beforeStart$lambda$4(RiderTraverseUIHelper this$0, LogEntryBase it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.getSeverity() == LogEntryType.WARN || it.getSeverity() == LogEntryType.ERROR) {
            this$0.log("Backend log message: " + it.getSeverity() + " " + it.getLogMessage());
        }
        return Unit.INSTANCE;
    }

    private static final void afterResultsAreSaved$lambda$0$0$0(ProtocolManager $pm, IProtocolHostWithBackend $host) {
        $pm.requestShutdown($host);
    }

    private static final Unit afterResultsAreSaved$lambda$0$0$1() {
        return Unit.INSTANCE;
    }

    private static final void beforeConfigurable$doNextPage(List<String> sourcePages, Ref.IntRef havePages, RiderTraverseUIHelper this$0, int targetPages, IRiderViewModelConfigurable unwrapped, SearchableConfigurable $configurable, Set<SearchableOptionEntry> $options) {
        String string = sourcePages.get(havePages.element);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
        String pageId = string;
        this$0.log("Requesting backend page " + pageId + " (" + (havePages.element + 1) + "/" + targetPages + ")");
        SettingsViewModelHost settingsViewModelHost = SettingsViewModelHost.Companion.getCurrentInstance();
        Intrinsics.checkNotNull((Object)settingsViewModelHost);
        settingsViewModelHost.requestFullPage(pageId, (Function1<? super OptionsPageInfo, Unit>)((Function1)arg_0 -> RiderTraverseUIHelper.beforeConfigurable$doNextPage$lambda$0(this$0, pageId, havePages, targetPages, unwrapped, $configurable, $options, sourcePages, arg_0)));
    }

    private static final Unit beforeConfigurable$doNextPage$lambda$0(RiderTraverseUIHelper this$0, String $pageId, Ref.IntRef $havePages, int $targetPages, IRiderViewModelConfigurable $unwrapped, SearchableConfigurable $configurable, Set $options, List $sourcePages, OptionsPageInfo page) {
        Intrinsics.checkNotNullParameter((Object)((Object)page), (String)"page");
        this$0.log("Got page for id " + $pageId + ": " + page);
        this$0.log("have " + $havePages.element + " pages, target is " + $targetPages);
        SearchableOptionsRegistrar searchableOptionsRegistrar = SearchableOptionsRegistrar.getInstance();
        Intrinsics.checkNotNull((Object)searchableOptionsRegistrar);
        SearchableOptionsRegistrar searchableRegistrar = searchableOptionsRegistrar;
        Iterator<String> keywords = $unwrapped.getPageKeywords(page);
        int keywordsCount = 0;
        Iterator<String> $this$forEach$iv = keywords;
        boolean $i$f$forEach = false;
        Iterator<String> iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            String element$iv;
            String text = element$iv = iterator2.next();
            boolean bl = false;
            ++keywordsCount;
            String string = $configurable.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
            $options.add(new SearchableOptionEntry(string, text));
        }
        this$0.log("Registered " + keywordsCount + " keywords for " + $configurable.getId());
        this$0.log("keyword registration finished for backend page " + $pageId + " (" + ($havePages.element + 1) + "/" + $targetPages + ")");
        int n = $havePages.element;
        $havePages.element = n + 1;
        if ($havePages.element < $targetPages) {
            RiderTraverseUIHelper.beforeConfigurable$doNextPage($sourcePages, $havePages, this$0, $targetPages, $unwrapped, $configurable, $options);
        }
        return Unit.INSTANCE;
    }

    private static final boolean beforeConfigurable$lambda$1(Ref.IntRef $havePages, int $targetPages) {
        return $havePages.element == $targetPages;
    }

    static {
        Logger logger = Logger.getInstance(RiderTraverseUIHelper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RiderTraverseUIHelper.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/settings/search/RiderTraverseUIHelper$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

