/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings.codeStyle;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rider.model.CodeStyleEditorConfigNotification;
import com.jetbrains.rider.model.CodeStylePageContent;
import com.jetbrains.rider.model.NamingPageContentBase;
import com.jetbrains.rider.settings.RiderSettingsBundle;
import com.jetbrains.rider.settings.SettingsViewModelHost;
import com.jetbrains.rider.settings.codeStyle.PreviewFactory;
import com.jetbrains.rider.settings.codeStyle.RiderCodeStyleTabPanel;
import com.jetbrains.rider.settings.naming.NamingChangeTracker;
import com.jetbrains.rider.settings.naming.NamingPageProvider;
import com.jetbrains.rider.settings.naming.NamingPolicyEditor;
import com.jetbrains.rider.settings.naming.NamingPolicyEditorKt;
import com.jetbrains.rider.settings.naming.ViewRefresher;
import com.jetbrains.rider.settings.tree.CodeStyleTreeFactory;
import com.jetbrains.rider.settings.tree.CodeStyleTreeTable;
import com.jetbrains.rider.settings.tree.renderers.Common;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0085\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0002*\u0001\u0013\u0018\u0000 <2\u00020\u0001:\u0001<B3\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020$J\b\u0010%\u001a\u00020\u0007H\u0014J\b\u0010&\u001a\u00020'H\u0014J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0014J\b\u0010,\u001a\u00020\u0005H\u0014J\b\u0010-\u001a\u00020\u0007H\u0014J\u0010\u0010.\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010/\u001a\u0002002\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u00101\u001a\u00020$H\u0016J\u0010\u00102\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\b\u00105\u001a\u000204H\u0002J\u0010\u00106\u001a\u00020$2\u0006\u0010\"\u001a\u00020!H\u0002J\u0010\u00106\u001a\u00020$2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u00107\u001a\u00020\u001f2\u0006\u00108\u001a\u00020$H\u0002J\u0010\u00109\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J\u0010\u0010:\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070;H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0010\u00103\u001a\u0004\u0018\u000104X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/jetbrains/rider/settings/codeStyle/RiderCodeStyleTabPanel;", "Lcom/intellij/application/options/CodeStyleAbstractPanel;", "language", "Lcom/intellij/lang/Language;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "title", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "<init>", "(Lcom/intellij/lang/Language;Lcom/intellij/openapi/fileTypes/FileType;Ljava/lang/String;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/psi/codeStyle/CodeStyleSettings;)V", "getTitle", "()Ljava/lang/String;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "myPanel", "com/jetbrains/rider/settings/codeStyle/RiderCodeStyleTabPanel$myPanel$1", "Lcom/jetbrains/rider/settings/codeStyle/RiderCodeStyleTabPanel$myPanel$1;", "myTreeTable", "Lcom/jetbrains/rider/settings/tree/CodeStyleTreeTable;", "searchString", "searchableKeywords", "", "getSearchableKeywords", "()Ljava/util/List;", "setSearchableKeywords", "(Ljava/util/List;)V", "setContent", "", "codeStylePageContent", "Lcom/jetbrains/rider/model/CodeStylePageContent;", "content", "Lcom/jetbrains/rider/model/NamingPageContentBase;", "Ljavax/swing/JComponent;", "getTabTitle", "getRightMargin", "", "createHighlighter", "Lcom/intellij/openapi/editor/highlighter/EditorHighlighter;", "scheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "getFileType", "getPreviewText", "apply", "isModified", "", "getPanel", "resetImpl", "_viewLifetime", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "createViewLifetime", "createView", "addViewToPanel", "view", "highlightOptions", "processListOptions", "", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderCodeStyleTabPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderCodeStyleTabPanel.kt\ncom/jetbrains/rider/settings/codeStyle/RiderCodeStyleTabPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,311:1\n1#2:312\n*E\n"})
public final class RiderCodeStyleTabPanel
extends CodeStyleAbstractPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Language language;
    @NotNull
    private final FileType fileType;
    @NotNull
    private final String title;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final myPanel.1 myPanel;
    @Nullable
    private CodeStyleTreeTable myTreeTable;
    @Nullable
    private String searchString;
    @NotNull
    private List<String> searchableKeywords;
    @Nullable
    private LifetimeDefinition _viewLifetime;
    @NotNull
    private static final JBDimension panelPreferredSize = new JBDimension(800, 400);

    public RiderCodeStyleTabPanel(@Nullable Language language, @NotNull FileType fileType, @NlsContexts.TabTitle @NotNull String title, @NotNull Lifetime lifetime, @NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        this.language = language;
        this.fileType = fileType;
        this.title = title;
        this.lifetime = lifetime;
        this.myPanel = new JPanel(){

            public Dimension getMinimumSize() {
                return (Dimension)RiderCodeStyleTabPanel.access$getPanelPreferredSize$cp();
            }
        };
        this.searchableKeywords = CollectionsKt.emptyList();
        this.myPanel.setLayout(new GridLayout(0, 1));
        this.myPanel.setBorder((Border)JBUI.Borders.empty());
        JBLoadingPanel myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, 0, 4, null);
        myLoadingPanel.startLoading();
        this.myPanel.add((Component)myLoadingPanel, "Center");
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final List<String> getSearchableKeywords() {
        return this.searchableKeywords;
    }

    public final void setSearchableKeywords(@NotNull List<String> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.searchableKeywords = list2;
    }

    public final void setContent(@NotNull CodeStylePageContent codeStylePageContent) {
        Intrinsics.checkNotNullParameter((Object)((Object)codeStylePageContent), (String)"codeStylePageContent");
        JComponent view = this.createView(codeStylePageContent);
        this.addViewToPanel(view);
    }

    public final void setContent(@NotNull NamingPageContentBase content) {
        Intrinsics.checkNotNullParameter((Object)((Object)content), (String)"content");
        JComponent view = this.createView(content);
        this.addViewToPanel(view);
    }

    public final void setContent(@NotNull JComponent content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.addViewToPanel(content);
    }

    @NotNull
    protected String getTabTitle() {
        return this.title;
    }

    protected int getRightMargin() {
        return 0;
    }

    @NotNull
    protected EditorHighlighter createHighlighter(@NotNull EditorColorsScheme scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        return (EditorHighlighter)new EmptyEditorHighlighter(this.getEditor().getColorsScheme().getAttributes(HighlighterColors.TEXT));
    }

    @NotNull
    protected FileType getFileType() {
        return this.fileType;
    }

    @NotNull
    protected String getPreviewText() {
        return "preview text";
    }

    public void apply(@NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
    }

    public boolean isModified(@Nullable CodeStyleSettings settings) {
        return false;
    }

    @NotNull
    public JComponent getPanel() {
        return this.myPanel;
    }

    protected void resetImpl(@NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
    }

    private final LifetimeDefinition createViewLifetime() {
        LifetimeDefinition lifetimeDefinition = this._viewLifetime;
        if (lifetimeDefinition != null) {
            LifetimeDefinition.terminate$default((LifetimeDefinition)lifetimeDefinition, (boolean)false, (int)1, null);
        }
        LifetimeDefinition lifetimeDefinition2 = this._viewLifetime = this.lifetime.createNested();
        Intrinsics.checkNotNull((Object)lifetimeDefinition2);
        return lifetimeDefinition2;
    }

    private final JComponent createView(CodeStylePageContent content) {
        CodeStyleTreeTable treeTable2;
        LifetimeDefinition viewLifetime = this.createViewLifetime();
        CodeStyleTreeFactory treeFactory = new CodeStyleTreeFactory((Disposable)this);
        this.myTreeTable = treeTable2 = treeFactory.createTree(content, (Lifetime)viewLifetime);
        treeTable2.setTableHeader(null);
        JBScrollPane scrollPanel = new JBScrollPane((Component)((Object)treeTable2));
        scrollPanel.setMinimumSize(new Dimension(JBUIScale.scale((int)10), JBUIScale.scale((int)100)));
        scrollPanel.setBorder(IdeBorderFactory.createBorder());
        JPanel preview = PreviewFactory.Companion.build((Lifetime)viewLifetime, this.language, content.getPreview());
        JSplitPane splitPanel = new JSplitPane(0);
        splitPanel.setBorder((Border)JBUI.Borders.empty());
        splitPanel.setTopComponent((Component)scrollPanel);
        splitPanel.setBottomComponent(preview);
        splitPanel.setResizeWeight(0.66);
        JPanel panel2 = new JPanel();
        panel2.setLayout(new GridLayout(0, 1));
        panel2.setBorder((Border)JBUI.Borders.empty());
        panel2.add(splitPanel);
        GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)splitPanel);
        Color highlightedBackgroundColor = Common.Resources.getHighlightedBackgroundColor();
        HyperlinkLabel editorConfigNotificationPanel = new HyperlinkLabel("", highlightedBackgroundColor);
        editorConfigNotificationPanel.setOpaque(true);
        HyperlinkLabel editorConfigEditPanel = new HyperlinkLabel("", highlightedBackgroundColor);
        editorConfigEditPanel.setOpaque(true);
        JPanel panelWithEditorConfigNotification = new JPanel();
        panelWithEditorConfigNotification.setBorder((Border)JBUI.Borders.empty());
        panelWithEditorConfigNotification.setLayout((LayoutManager)new MigLayout("insets 3 5 3 5", "[]push[]"));
        panelWithEditorConfigNotification.setBackground(highlightedBackgroundColor);
        panelWithEditorConfigNotification.setOpaque(true);
        panelWithEditorConfigNotification.add((Component)editorConfigNotificationPanel);
        panelWithEditorConfigNotification.add((Component)editorConfigEditPanel);
        content.getEditorConfigNotification().advise((Lifetime)viewLifetime, arg_0 -> RiderCodeStyleTabPanel.createView$lambda$0(editorConfigNotificationPanel, highlightedBackgroundColor, panelWithEditorConfigNotification, editorConfigEditPanel, arg_0));
        JBColor jBColor = JBColor.namedColor((String)"Notification.ToolWindow.informativeForeground", (Color)UIUtil.getToolTipForeground());
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
        JBColor tipsFgColor = jBColor;
        JBColor jBColor2 = JBColor.namedColor((String)"Notification.ToolWindow.informativeBackground", (Color)((Color)new JBColor(0xBAEEBA, 3359022)));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor2, (String)"namedColor(...)");
        JBColor tipsBgColor = jBColor2;
        JBLabel tipLabel = new JBLabel("");
        tipLabel.setBackground((Color)tipsBgColor);
        tipLabel.setOpaque(true);
        tipLabel.setForeground((Color)tipsFgColor);
        HyperlinkLabel learnMoreLink = new HyperlinkLabel("", (Color)tipsBgColor);
        learnMoreLink.setOpaque(true);
        HyperlinkLabel closeTipsLink = new HyperlinkLabel("", (Color)tipsBgColor);
        closeTipsLink.setOpaque(true);
        JPanel panelWithTips = new JPanel();
        panelWithTips.setBorder((Border)JBUI.Borders.empty());
        panelWithTips.setLayout((LayoutManager)new MigLayout("insets 3 5 0 5", "[]push[][]", "[]"));
        panelWithTips.setBackground((Color)tipsBgColor);
        panelWithTips.setOpaque(true);
        panelWithTips.add((Component)tipLabel, "grow");
        panelWithTips.add((Component)learnMoreLink, "aligny top");
        panelWithTips.add((Component)closeTipsLink, "wrap, aligny top");
        content.getShouldShowAutoDetectAndConfigureFormattingTip().advise((Lifetime)viewLifetime, arg_0 -> RiderCodeStyleTabPanel.createView$lambda$1(tipLabel, content, closeTipsLink, learnMoreLink, panelWithTips, arg_0));
        JPanel resPanel = new JPanel();
        resPanel.setLayout((LayoutManager)new MigLayout("insets 0, fill"));
        resPanel.setBorder((Border)JBUI.Borders.empty());
        resPanel.add((Component)panelWithTips, "north, hidemode 3");
        resPanel.add((Component)panelWithEditorConfigNotification, "north, hidemode 3");
        resPanel.add((Component)panel2, "center, grow");
        return resPanel;
    }

    private final JComponent createView(NamingPageContentBase content) {
        CodeStyleTreeTable treeTable2;
        LifetimeDefinition viewLifetime = this.createViewLifetime();
        JPanel panel2 = new JPanel();
        ViewRefresher viewRefresher = new ViewRefresher(panel2);
        NamingChangeTracker namingChangeTracker = new NamingChangeTracker(viewRefresher);
        NamingPolicyEditor policyEditor = new NamingPolicyEditor(namingChangeTracker);
        this.myTreeTable = treeTable2 = NamingPolicyEditorKt.buildNamingRuleItemsTree((Lifetime)viewLifetime, content, namingChangeTracker);
        JBScrollPane scrollPanel = new JBScrollPane((Component)((Object)treeTable2));
        scrollPanel.setBorder(IdeBorderFactory.createBorder());
        JSplitPane splitPanel = new JSplitPane(1);
        splitPanel.setBorder((Border)JBUI.Borders.empty());
        splitPanel.setTopComponent((Component)scrollPanel);
        splitPanel.setBottomComponent(policyEditor);
        panel2.setLayout(new GridLayout(0, 1));
        panel2.setBorder((Border)JBUI.Borders.empty());
        panel2.add(splitPanel);
        GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)splitPanel);
        for (NamingPageProvider provider2 : (NamingPageProvider[])NamingPageProvider.Companion.getEP_NAME().getExtensions()) {
            if (!Intrinsics.areEqual((Object)provider2.getLanguage(), (Object)this.language)) continue;
            return provider2.createPage((Lifetime)viewLifetime, viewRefresher, panel2, content);
        }
        return panel2;
    }

    private final void addViewToPanel(JComponent view) {
        block0: {
            this.myPanel.removeAll();
            this.myPanel.add((Component)view, "North");
            this.myPanel.validate();
            this.myPanel.repaint();
            String string = this.searchString;
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            this.highlightOptions(it);
        }
    }

    public void highlightOptions(@NotNull String searchString) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)searchString, (String)"searchString");
            this.searchString = searchString;
            CodeStyleTreeTable codeStyleTreeTable = this.myTreeTable;
            if (codeStyleTreeTable == null || (codeStyleTreeTable = codeStyleTreeTable.getSearchHelper()) == null) break block0;
            codeStyleTreeTable.find(searchString);
        }
    }

    @NotNull
    public Set<String> processListOptions() {
        return new HashSet(this.searchableKeywords);
    }

    private static final String createView$getLinkHtml(String label) {
        String string = new HtmlBuilder().append(label).wrapWith("a").toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final Unit createView$lambda$0(HyperlinkLabel $editorConfigNotificationPanel, Color $highlightedBackgroundColor, JPanel $panelWithEditorConfigNotification, HyperlinkLabel $editorConfigEditPanel, CodeStyleEditorConfigNotification it) {
        if (it != null) {
            $editorConfigNotificationPanel.setHtmlText(it.getMessage());
            $editorConfigNotificationPanel.setBackground($highlightedBackgroundColor);
            $panelWithEditorConfigNotification.setVisible(true);
            CodeStyleEditorConfigNotification params = it;
            $editorConfigNotificationPanel.addHyperlinkListener(arg_0 -> RiderCodeStyleTabPanel.createView$lambda$0$0(params, arg_0));
            if (it.getShouldShowEditorConfigEditLink()) {
                $editorConfigEditPanel.setHtmlText(RiderCodeStyleTabPanel.createView$getLinkHtml(RiderSettingsBundle.Companion.message("link.label.edit", new Object[0])));
                $editorConfigEditPanel.setBackground($highlightedBackgroundColor);
                $editorConfigEditPanel.addHyperlinkListener(arg_0 -> RiderCodeStyleTabPanel.createView$lambda$0$1(params, arg_0));
            } else {
                $editorConfigEditPanel.setHtmlText("");
            }
        } else {
            $editorConfigNotificationPanel.setHtmlText("");
            $panelWithEditorConfigNotification.setVisible(false);
        }
        return Unit.INSTANCE;
    }

    private static final void createView$lambda$0$0(CodeStyleEditorConfigNotification $params, HyperlinkEvent it) {
        InterfacesKt.fire($params.getNavigateToHelp());
    }

    private static final void createView$lambda$0$1(CodeStyleEditorConfigNotification $params, HyperlinkEvent it) {
        block0: {
            InterfacesKt.fire($params.getEditEditorConfig());
            SettingsViewModelHost settingsViewModelHost = SettingsViewModelHost.Companion.getCurrentInstance();
            if (settingsViewModelHost == null) break block0;
            settingsViewModelHost.cancel();
        }
    }

    private static final Unit createView$lambda$1(JBLabel $tipLabel, CodeStylePageContent $content, HyperlinkLabel $closeTipsLink, HyperlinkLabel $learnMoreLink, JPanel $panelWithTips, boolean it) {
        if (it) {
            $tipLabel.setText(new HtmlBuilder().appendRaw($content.getAutoDetectAndConfigureFormattingTip()).wrapWith(HtmlChunk.body().style("white-space:normal")).wrapWith("html").toString());
            $closeTipsLink.setHtmlText(RiderCodeStyleTabPanel.createView$getLinkHtml(RiderSettingsBundle.Companion.message("link.label.close", new Object[0])));
            $closeTipsLink.addHyperlinkListener(arg_0 -> RiderCodeStyleTabPanel.createView$lambda$1$0($content, arg_0));
            $learnMoreLink.setHtmlText(RiderCodeStyleTabPanel.createView$getLinkHtml(RiderSettingsBundle.Companion.message("RiderCodeStyleTabPanel.link.label.learn.more", new Object[0])));
            $learnMoreLink.addHyperlinkListener(arg_0 -> RiderCodeStyleTabPanel.createView$lambda$1$1($content, arg_0));
            $panelWithTips.setVisible(true);
        } else {
            $panelWithTips.setVisible(false);
        }
        return Unit.INSTANCE;
    }

    private static final void createView$lambda$1$0(CodeStylePageContent $content, HyperlinkEvent it) {
        $content.getShouldShowAutoDetectAndConfigureFormattingTip().set((Object)false);
    }

    private static final void createView$lambda$1$1(CodeStylePageContent $content, HyperlinkEvent it) {
        InterfacesKt.fire($content.getConfigureFormattingHelp());
    }

    public static final /* synthetic */ JBDimension access$getPanelPreferredSize$cp() {
        return panelPreferredSize;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/settings/codeStyle/RiderCodeStyleTabPanel$Companion;", "", "<init>", "()V", "panelPreferredSize", "Lcom/intellij/util/ui/JBDimension;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

