/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.services.popups.nova.layouter;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u000b\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\f\u001a\u00020\r\u001a\u001a\u0010\u000b\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0001\u001a\u0012\u0010\u0010\u001a\u00020\u0011*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u0012\u0010\u0012\u001a\u00020\u0011*\u00020\u00022\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u0012\u0010\u0013\u001a\u00020\u0011*\u00020\u00022\u0006\u0010\t\u001a\u00020\u0001\u001a\u0012\u0010\u0014\u001a\u00020\u0011*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0001\u001a\n\u0010\u0015\u001a\u00020\u0016*\u00020\u0002\u001a&\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001\u001a&\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001\u001a\u0012\u0010\u0019\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0002\u001a\u0012\u0010\u001b\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0002\u001a\u0012\u0010\u001c\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0002\u001a \u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u0001H\u0002\u001a\"\u0010 \u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0014\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00020\"\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\"\u0015\u0010\u0007\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0004\"\u0015\u0010\t\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0004\u00a8\u0006#"}, d2={"left", "", "Ljava/awt/Rectangle;", "getLeft", "(Ljava/awt/Rectangle;)I", "right", "getRight", "top", "getTop", "bottom", "getBottom", "inflate", "size", "Ljava/awt/Dimension;", "w", "h", "setRight", "", "setLeft", "setBottom", "setTop", "getCenter", "Ljava/awt/Point;", "rectangleFromLTRB", "rectangleFromLTRBNonNegative", "smartClip", "bounds", "horizontalSmartClip", "verticalSmartClip", "a", "a1", "a2", "map", "delegate", "Lkotlin/Function1;", "intellij.rider.rdclient.dotnet"})
public final class RectangleUtilsKt {
    public static final int getLeft(@NotNull Rectangle $this$left) {
        Intrinsics.checkNotNullParameter((Object)$this$left, (String)"<this>");
        return $this$left.x;
    }

    public static final int getRight(@NotNull Rectangle $this$right) {
        Intrinsics.checkNotNullParameter((Object)$this$right, (String)"<this>");
        return $this$right.x + $this$right.width;
    }

    public static final int getTop(@NotNull Rectangle $this$top) {
        Intrinsics.checkNotNullParameter((Object)$this$top, (String)"<this>");
        return $this$top.y;
    }

    public static final int getBottom(@NotNull Rectangle $this$bottom) {
        Intrinsics.checkNotNullParameter((Object)$this$bottom, (String)"<this>");
        return $this$bottom.y + $this$bottom.height;
    }

    @NotNull
    public static final Rectangle inflate(@NotNull Rectangle $this$inflate, @NotNull Dimension size) {
        Intrinsics.checkNotNullParameter((Object)$this$inflate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        return RectangleUtilsKt.inflate($this$inflate, size.width, size.height);
    }

    @NotNull
    public static final Rectangle inflate(@NotNull Rectangle $this$inflate, int w, int h) {
        Rectangle rectangle;
        Intrinsics.checkNotNullParameter((Object)$this$inflate, (String)"<this>");
        Rectangle $this$inflate_u24lambda_u240 = rectangle = new Rectangle($this$inflate);
        boolean bl = false;
        $this$inflate_u24lambda_u240.x -= w;
        $this$inflate_u24lambda_u240.y -= h;
        $this$inflate_u24lambda_u240.width += 2 * w;
        $this$inflate_u24lambda_u240.height += 2 * h;
        return rectangle;
    }

    public static final void setRight(@NotNull Rectangle $this$setRight, int right) {
        Intrinsics.checkNotNullParameter((Object)$this$setRight, (String)"<this>");
        $this$setRight.width += right - RectangleUtilsKt.getRight($this$setRight);
    }

    public static final void setLeft(@NotNull Rectangle $this$setLeft, int left) {
        Intrinsics.checkNotNullParameter((Object)$this$setLeft, (String)"<this>");
        $this$setLeft.width -= left - RectangleUtilsKt.getLeft($this$setLeft);
        $this$setLeft.x = left;
    }

    public static final void setBottom(@NotNull Rectangle $this$setBottom, int bottom) {
        Intrinsics.checkNotNullParameter((Object)$this$setBottom, (String)"<this>");
        $this$setBottom.height += bottom - RectangleUtilsKt.getBottom($this$setBottom);
    }

    public static final void setTop(@NotNull Rectangle $this$setTop, int top) {
        Intrinsics.checkNotNullParameter((Object)$this$setTop, (String)"<this>");
        $this$setTop.height -= top - RectangleUtilsKt.getTop($this$setTop);
        $this$setTop.y = top;
    }

    @NotNull
    public static final Point getCenter(@NotNull Rectangle $this$getCenter) {
        Intrinsics.checkNotNullParameter((Object)$this$getCenter, (String)"<this>");
        return new Point((RectangleUtilsKt.getLeft($this$getCenter) + RectangleUtilsKt.getRight($this$getCenter)) / 2, (RectangleUtilsKt.getTop($this$getCenter) + RectangleUtilsKt.getBottom($this$getCenter)) / 2);
    }

    @NotNull
    public static final Rectangle rectangleFromLTRB(int left, int top, int right, int bottom) {
        return new Rectangle(left, top, right - left, bottom - top);
    }

    @NotNull
    public static final Rectangle rectangleFromLTRBNonNegative(int left, int top, int right, int bottom) {
        int l = left;
        int r = right;
        int t = top;
        int b = bottom;
        if (l > r) {
            r = l = (l + r) / 2;
        }
        if (t > b) {
            b = t = (t + b) / 2;
        }
        return RectangleUtilsKt.rectangleFromLTRB(l, t, r, b);
    }

    @NotNull
    public static final Rectangle smartClip(@NotNull Rectangle $this$smartClip, @NotNull Rectangle bounds) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$smartClip, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        boolean bl2 = bl = $this$smartClip.width >= 0 && $this$smartClip.height >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        boolean bl3 = bl = bounds.width >= 0 && bounds.height >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        int r = RectangleUtilsKt.smartClip(RectangleUtilsKt.getRight($this$smartClip), RectangleUtilsKt.getLeft(bounds), RectangleUtilsKt.getRight(bounds));
        int l = RectangleUtilsKt.smartClip(RectangleUtilsKt.getLeft($this$smartClip), RectangleUtilsKt.getLeft(bounds), RectangleUtilsKt.getRight(bounds));
        int t = RectangleUtilsKt.smartClip(RectangleUtilsKt.getTop($this$smartClip), RectangleUtilsKt.getTop(bounds), RectangleUtilsKt.getBottom(bounds));
        int b = RectangleUtilsKt.smartClip(RectangleUtilsKt.getBottom($this$smartClip), RectangleUtilsKt.getTop(bounds), RectangleUtilsKt.getBottom(bounds));
        return RectangleUtilsKt.rectangleFromLTRBNonNegative(l, t, r, b);
    }

    @NotNull
    public static final Rectangle horizontalSmartClip(@NotNull Rectangle $this$horizontalSmartClip, @NotNull Rectangle bounds) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$horizontalSmartClip, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        boolean bl2 = bl = $this$horizontalSmartClip.width >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        boolean bl3 = bl = bounds.width >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        int r = RectangleUtilsKt.smartClip(RectangleUtilsKt.getRight($this$horizontalSmartClip), RectangleUtilsKt.getLeft(bounds), RectangleUtilsKt.getRight(bounds));
        int l = RectangleUtilsKt.smartClip(RectangleUtilsKt.getLeft($this$horizontalSmartClip), RectangleUtilsKt.getLeft(bounds), RectangleUtilsKt.getRight(bounds));
        return RectangleUtilsKt.rectangleFromLTRBNonNegative(l, RectangleUtilsKt.getTop($this$horizontalSmartClip), r, RectangleUtilsKt.getBottom($this$horizontalSmartClip));
    }

    @NotNull
    public static final Rectangle verticalSmartClip(@NotNull Rectangle $this$verticalSmartClip, @NotNull Rectangle bounds) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$verticalSmartClip, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        boolean bl2 = bl = $this$verticalSmartClip.width >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        boolean bl3 = bl = bounds.width >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        int t = RectangleUtilsKt.smartClip(RectangleUtilsKt.getTop($this$verticalSmartClip), RectangleUtilsKt.getTop(bounds), RectangleUtilsKt.getBottom(bounds));
        int b = RectangleUtilsKt.smartClip(RectangleUtilsKt.getBottom($this$verticalSmartClip), RectangleUtilsKt.getTop(bounds), RectangleUtilsKt.getBottom(bounds));
        return RectangleUtilsKt.rectangleFromLTRBNonNegative(RectangleUtilsKt.getLeft($this$verticalSmartClip), t, RectangleUtilsKt.getRight($this$verticalSmartClip), b);
    }

    private static final int smartClip(int a, int a1, int a2) {
        return a > a1 ? (a < a2 ? a : a2) : a1;
    }

    @Nullable
    public static final Rectangle map(@NotNull Rectangle $this$map, @NotNull Function1<? super Rectangle, ? extends Rectangle> delegate) {
        Intrinsics.checkNotNullParameter((Object)$this$map, (String)"<this>");
        Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
        return (Rectangle)delegate.invoke((Object)$this$map);
    }
}

