/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.services;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.platform.util.progress.RawProgressReporter;
import com.intellij.util.ApplicationKt;
import com.intellij.util.messages.Topic;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rider.model.GlobalProgressModel;
import com.jetbrains.rider.model.GlobalProgressModel_PregeneratedKt;
import com.jetbrains.rider.model.RdCancelableProgress;
import com.jetbrains.rider.protocol.ApplicationProtocolKt;
import com.jetbrains.rider.services.RiderGlobalProgressHostKt;
import java.util.Map;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00192\u00020\u0001:\u0002\u0018\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002JA\u0010\u000e\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u0002H\u000f0\u0015H\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rider/services/RiderGlobalProgressHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "showModalProgress", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "progressModel", "Lcom/jetbrains/rider/model/RdCancelableProgress;", "runWithSupplyingProgressToBackend", "T", "title", "", "isCancelable", "", "action", "Lkotlin/Function2;", "runWithSupplyingProgressToBackend$intellij_rider_rdclient_dotnet", "(Ljava/lang/String;ZLkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "RiderGlobalBackendProgressListener", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderGlobalProgressHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderGlobalProgressHost.kt\ncom/jetbrains/rider/services/RiderGlobalProgressHost\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 RLifetime.kt\ncom/jetbrains/rd/util/lifetime/Lifetime\n+ 5 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n*L\n1#1,185:1\n67#2,4:186\n13#2:198\n1#3:190\n155#4,6:191\n13#5:197\n*S KotlinDebug\n*F\n+ 1 RiderGlobalProgressHost.kt\ncom/jetbrains/rider/services/RiderGlobalProgressHost\n*L\n68#1:186,4\n44#1:198\n87#1:191,6\n44#1:197\n*E\n"})
public final class RiderGlobalProgressHost
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger LOG;

    public RiderGlobalProgressHost(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        InterfacesKt.viewNotNull((IViewable)((IViewable)GlobalProgressModel_PregeneratedKt.getGlobalProgressModel(ApplicationProtocolKt.getProtocol(this.project)).getProgressState()), (Lifetime)this.getServiceLifetime(), (arg_0, arg_1) -> RiderGlobalProgressHost._init_$lambda$0(this, arg_0, arg_1));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final void showModalProgress(Lifetime lifetime, RdCancelableProgress progressModel) {
        block5: {
            try {
                ApplicationKt.getApplication().assertIsDispatchThread();
                ((RiderGlobalBackendProgressListener)this.project.getMessageBus().syncPublisher(RiderGlobalBackendProgressListener.TOPIC)).taskStarted(progressModel);
                RiderGlobalProgressHostKt.showModalProgress(this.project, lifetime, progressModel.getTaskName(), progressModel.isCancelable(), (Function1<? super RawProgressReporter, Unit>)((Function1)arg_0 -> RiderGlobalProgressHost.showModalProgress$lambda$0(lifetime, progressModel, arg_0)));
                ((RiderGlobalBackendProgressListener)this.project.getMessageBus().syncPublisher(RiderGlobalBackendProgressListener.TOPIC)).taskFinished(progressModel, false);
            }
            catch (Throwable ce) {
                if (ce instanceof CancellationException || ce instanceof ProcessCanceledException) {
                    Logger $this$trace$iv = LOG;
                    boolean $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        Logger logger = $this$trace$iv;
                        boolean bl = false;
                        logger.trace("Progress task " + progressModel.getTaskName() + " was cancelled");
                    }
                } else {
                    LOG.warn("Progress task " + progressModel.getTaskName() + " was interrupted by exception " + ce.getClass());
                }
                InterfacesKt.fire((ISignal)((ISignal)progressModel.getCancel()));
                ((RiderGlobalBackendProgressListener)this.project.getMessageBus().syncPublisher(RiderGlobalBackendProgressListener.TOPIC)).taskFinished(progressModel, true);
                if (ce instanceof CancellationException || ce instanceof ProcessCanceledException) break block5;
                throw ce;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T runWithSupplyingProgressToBackend$intellij_rider_rdclient_dotnet(@NlsContexts.ProgressTitle @NotNull String title, boolean isCancelable, @NotNull Function2<? super Lifetime, ? super RdCancelableProgress, ? extends T> action2) {
        Object object;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        GlobalProgressModel progressModel = GlobalProgressModel_PregeneratedKt.getGlobalProgressModel(ApplicationProtocolKt.getProtocol(this.project));
        boolean bl2 = bl = progressModel.getCurrentFrontendProgress().getValue() == null;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-RiderGlobalProgressHost$runWithSupplyingProgressToBackend$32 = false;
            String $i$a$-assert-RiderGlobalProgressHost$runWithSupplyingProgressToBackend$32 = "Frontend progress model already exists";
            throw new AssertionError((Object)$i$a$-assert-RiderGlobalProgressHost$runWithSupplyingProgressToBackend$32);
        }
        bl = progressModel.getProgressState().isEmpty();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-RiderGlobalProgressHost$runWithSupplyingProgressToBackend$42 = false;
            String $i$a$-assert-RiderGlobalProgressHost$runWithSupplyingProgressToBackend$42 = "Backend progress model already exists";
            throw new AssertionError((Object)$i$a$-assert-RiderGlobalProgressHost$runWithSupplyingProgressToBackend$42);
        }
        RdCancelableProgress progress = new RdCancelableProgress(title, isCancelable, false, 4, null);
        Lifetime this_$iv = this.getServiceLifetime();
        boolean $i$f$usingNested = false;
        LifetimeDefinition nested$iv = this_$iv.createNested();
        try {
            Lifetime lt = nested$iv.getLifetime();
            boolean bl3 = false;
            InterfacesKt.setValue(progressModel.getCurrentFrontendProgress(), (Lifetime)lt, (Object)((Object)progress));
            object = action2.invoke((Object)lt, (Object)progress);
        }
        finally {
            LifetimeDefinition.terminate$default((LifetimeDefinition)nested$iv, (boolean)false, (int)1, null);
        }
        return (T)object;
    }

    private static final Unit _init_$lambda$0(RiderGlobalProgressHost this$0, Lifetime lt, Map.Entry entry2) {
        Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
        Intrinsics.checkNotNullParameter((Object)entry2, (String)"<destruct>");
        RdCancelableProgress progressModel = (RdCancelableProgress)((Object)entry2.getValue());
        this$0.showModalProgress(lt, progressModel);
        return Unit.INSTANCE;
    }

    private static final Unit showModalProgress$lambda$0(Lifetime $lifetime, RdCancelableProgress $progressModel, RawProgressReporter progressSink) {
        Intrinsics.checkNotNullParameter((Object)progressSink, (String)"progressSink");
        RiderGlobalProgressHostKt.access$bindModelProgress($lifetime, $progressModel, progressSink);
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RiderGlobalProgressHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/services/RiderGlobalProgressHost$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG$intellij_rider_rdclient_dotnet", "()Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/rider/services/RiderGlobalProgressHost;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nRiderGlobalProgressHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderGlobalProgressHost.kt\ncom/jetbrains/rider/services/RiderGlobalProgressHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,185:1\n30#2,2:186\n*S KotlinDebug\n*F\n+ 1 RiderGlobalProgressHost.kt\ncom/jetbrains/rider/services/RiderGlobalProgressHost$Companion\n*L\n45#1:186,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG$intellij_rider_rdclient_dotnet() {
            return LOG;
        }

        @NotNull
        public final RiderGlobalProgressHost getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<RiderGlobalProgressHost> serviceClass$iv = RiderGlobalProgressHost.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (RiderGlobalProgressHost)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\bf\u0018\u0000 \t2\u00020\u0001:\u0001\tJ\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rider/services/RiderGlobalProgressHost$RiderGlobalBackendProgressListener;", "", "taskStarted", "", "progressModel", "Lcom/jetbrains/rider/model/RdCancelableProgress;", "taskFinished", "wasCancelled", "", "Companion", "intellij.rider.rdclient.dotnet"})
    public static interface RiderGlobalBackendProgressListener {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;
        @JvmField
        @NotNull
        public static final Topic<RiderGlobalBackendProgressListener> TOPIC = new Topic(RiderGlobalBackendProgressListener.class);

        default public void taskStarted(@NotNull RdCancelableProgress progressModel) {
            Intrinsics.checkNotNullParameter((Object)((Object)progressModel), (String)"progressModel");
        }

        default public void taskFinished(@NotNull RdCancelableProgress progressModel, boolean wasCancelled) {
            Intrinsics.checkNotNullParameter((Object)((Object)progressModel), (String)"progressModel");
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/services/RiderGlobalProgressHost$RiderGlobalBackendProgressListener$Companion;", "", "<init>", "()V", "TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/jetbrains/rider/services/RiderGlobalProgressHost$RiderGlobalBackendProgressListener;", "intellij.rider.rdclient.dotnet"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            static {
                $$INSTANCE = new Companion();
            }
        }
    }
}

