/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.requests;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.rd.ide.model.RdRetryResponse;
import com.jetbrains.rdclient.actions.cwm.FrontendCallActionRequest;
import com.jetbrains.rdclient.editorActions.cwm.FrontendCallEditorActionRequest;
import com.jetbrains.rdclient.editorActions.cwm.PhantomCallEditorActionRequest;
import com.jetbrains.rdclient.editors.FrontendTextControlHostKt;
import com.jetbrains.rdclient.requests.FrontendAsyncRequest;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestExecutor;
import com.jetbrains.rider.settings.RdClientDotnetBundle;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u00112\u00020\u0001:\u0003\u0011\u0012\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0003R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/requests/RiderRetryCustomizer;", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequestExecutor$RetryCustomizer;", "<init>", "()V", "currentHint", "Lcom/jetbrains/rider/requests/RiderRetryCustomizer$CurrentHintInfo;", "retry", "", "request", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequest;", "response", "Lcom/jetbrains/rd/ide/model/RdRetryResponse;", "getInfo", "Lcom/jetbrains/rider/requests/RiderRetryCustomizer$Info;", "getTooltipMessage", "", "actionId", "Companion", "Info", "CurrentHintInfo", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderRetryCustomizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderRetryCustomizer.kt\ncom/jetbrains/rider/requests/RiderRetryCustomizer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,84:1\n1#2:85\n13#3:86\n*S KotlinDebug\n*F\n+ 1 RiderRetryCustomizer.kt\ncom/jetbrains/rider/requests/RiderRetryCustomizer\n*L\n23#1:86\n*E\n"})
public final class RiderRetryCustomizer
extends FrontendAsyncRequestExecutor.RetryCustomizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private CurrentHintInfo currentHint;
    @NotNull
    private static final Logger logger;

    @Override
    public boolean retry(@NotNull FrontendAsyncRequest request, @NotNull RdRetryResponse response) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        ThreadingAssertions.assertEventDispatchThread();
        if (Intrinsics.areEqual((Object)response.getMetadata(), (Object)"REQUIREMENT_NOT_READY")) {
            CurrentHintInfo currentHintInfo;
            Info info = this.getInfo(request);
            if (info == null) {
                return false;
            }
            Info info2 = info;
            CurrentHintInfo currentHint = this.currentHint;
            if (currentHint != null && currentHint.getRequestId() == response.getRequestId()) {
                if (currentHint.isCancelled()) {
                    logger.trace("Cancel request " + response.getRequestId());
                    return false;
                }
                logger.trace("Repeat request " + response.getRequestId() + " after little delay, tooltip is still visible...");
                return true;
            }
            logger.trace("Show tooltip for request " + response.getRequestId());
            CurrentHintInfo it = currentHintInfo = new CurrentHintInfo(response.getRequestId());
            boolean bl = false;
            this.currentHint = it;
            CurrentHintInfo nextHint = currentHintInfo;
            HintManager.getInstance().showInformationHint(info2.getEditor(), (JComponent)new JBLabel(this.getTooltipMessage(info2.getActionId())), () -> RiderRetryCustomizer.retry$lambda$1(nextHint));
            return true;
        }
        return super.retry(request, response);
    }

    @Nullable
    public final Info getInfo(@NotNull FrontendAsyncRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (request instanceof FrontendCallActionRequest) {
            Project project = ((FrontendCallActionRequest)request).getProject();
            if (project == null) {
                return null;
            }
            Project project2 = project;
            Editor editor = FileEditorManager.getInstance((Project)project2).getSelectedTextEditor();
            if (editor == null) {
                return null;
            }
            Editor editor2 = editor;
            return new Info(editor2, ((FrontendCallActionRequest)request).getFrontendActionId());
        }
        if (request instanceof FrontendCallEditorActionRequest) {
            Editor editor = FrontendTextControlHostKt.toEditorOrNull(((FrontendCallEditorActionRequest)request).getEditorId());
            if (editor == null) {
                return null;
            }
            Editor editor3 = editor;
            return new Info(editor3, ((FrontendCallEditorActionRequest)request).getFrontendActionId());
        }
        if (request instanceof PhantomCallEditorActionRequest) {
            Editor editor = FrontendTextControlHostKt.toEditorOrNull(((PhantomCallEditorActionRequest)request).getEditorId());
            if (editor == null) {
                return null;
            }
            Editor editor4 = editor;
            return new Info(editor4, ((PhantomCallEditorActionRequest)request).getFrontendActionId());
        }
        return null;
    }

    @Nls
    private final String getTooltipMessage(String actionId) {
        String string;
        block3: {
            block2: {
                AnAction action2 = ActionManager.getInstance().getAction(actionId);
                AnAction anAction = action2;
                String actionName = anAction != null && (anAction = anAction.getTemplatePresentation()) != null ? anAction.getText() : null;
                string = actionName;
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                Object[] objectArray = new Object[]{it};
                String string2 = RdClientDotnetBundle.INSTANCE.message("hint.text.getting.action.ready.press.esc.to.cancel", objectArray);
                string = string2;
                if (string2 != null) break block3;
            }
            string = RdClientDotnetBundle.INSTANCE.message("hint.text.getting.action.ready.press.esc.to.cancel.default", new Object[0]);
        }
        return string;
    }

    private static final void retry$lambda$1(CurrentHintInfo $nextHint) {
        $nextHint.setCancelled(true);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RiderRetryCustomizer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RiderRetryCustomizer.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/requests/RiderRetryCustomizer$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/requests/RiderRetryCustomizer$CurrentHintInfo;", "", "requestId", "", "<init>", "(J)V", "getRequestId", "()J", "isCancelled", "", "()Z", "setCancelled", "(Z)V", "intellij.rider.rdclient.dotnet"})
    public static final class CurrentHintInfo {
        private final long requestId;
        private boolean isCancelled;

        public CurrentHintInfo(long requestId) {
            this.requestId = requestId;
        }

        public final long getRequestId() {
            return this.requestId;
        }

        public final boolean isCancelled() {
            return this.isCancelled;
        }

        public final void setCancelled(boolean bl) {
            this.isCancelled = bl;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/requests/RiderRetryCustomizer$Info;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "actionId", "", "<init>", "(Lcom/intellij/openapi/editor/Editor;Ljava/lang/String;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getActionId", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.rider.rdclient.dotnet"})
    public static final class Info {
        @NotNull
        private final Editor editor;
        @NotNull
        private final String actionId;

        public Info(@NotNull Editor editor, @NotNull String actionId) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
            this.editor = editor;
            this.actionId = actionId;
        }

        @NotNull
        public final Editor getEditor() {
            return this.editor;
        }

        @NotNull
        public final String getActionId() {
            return this.actionId;
        }

        @NotNull
        public final Editor component1() {
            return this.editor;
        }

        @NotNull
        public final String component2() {
            return this.actionId;
        }

        @NotNull
        public final Info copy(@NotNull Editor editor, @NotNull String actionId) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
            return new Info(editor, actionId);
        }

        public static /* synthetic */ Info copy$default(Info info, Editor editor, String string, int n, Object object) {
            if ((n & 1) != 0) {
                editor = info.editor;
            }
            if ((n & 2) != 0) {
                string = info.actionId;
            }
            return info.copy(editor, string);
        }

        @NotNull
        public String toString() {
            return "Info(editor=" + this.editor + ", actionId=" + this.actionId + ")";
        }

        public int hashCode() {
            int result2 = this.editor.hashCode();
            result2 = result2 * 31 + this.actionId.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Info)) {
                return false;
            }
            Info info = (Info)other;
            if (!Intrinsics.areEqual((Object)this.editor, (Object)info.editor)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.actionId, (Object)info.actionId);
        }
    }
}

