/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.protocol;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.AppMode;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ArchivedCompilationContextUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.RiderEnvironment;
import com.jetbrains.rider.protocol.ReSharperProcessBase;
import com.jetbrains.rider.protocol.RiderBackendEnvProvider;
import com.jetbrains.rider.protocol.RuntimeSpecificAssemblyResolver;
import com.jetbrains.rider.utils.XMLStreamHelpers;
import java.io.File;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.path.PathWalkOption;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0015\u001a\u00020\u000eH\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0017H\u0016J\u0014\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rider/protocol/ReSharperProcess;", "Lcom/jetbrains/rider/protocol/ReSharperProcessBase;", "application", "Lcom/intellij/openapi/application/Application;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "serverPort", "", "killedEbs", "", "isLightweight", "", "allExtraEnvVars", "", "", "<init>", "(Lcom/intellij/openapi/application/Application;Lcom/jetbrains/rd/util/lifetime/Lifetime;ILjava/lang/Long;ZLjava/util/Map;)V", "getDotNetPluginsXmlDescriptor", "isInternal", "()Z", "isUnitTesting", "getDotNetPluginsExtraDirs", "getExtraFlags", "", "getExtraEnvVars", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nReSharperProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReSharperProcess.kt\ncom/jetbrains/rider/protocol/ReSharperProcess\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,329:1\n1#2:330\n13#3:331\n13#4:332\n*S KotlinDebug\n*F\n+ 1 ReSharperProcess.kt\ncom/jetbrains/rider/protocol/ReSharperProcess\n*L\n41#1:331\n41#1:332\n*E\n"})
public final class ReSharperProcess
extends ReSharperProcessBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Application application;
    @NotNull
    private final Map<String, String> allExtraEnvVars;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Lazy<Companion.AdditionalInfo> additionalInfo$delegate;

    public ReSharperProcess(@NotNull Application application, @NotNull Lifetime lifetime, int serverPort, @Nullable Long killedEbs, boolean isLightweight, @NotNull Map<String, String> allExtraEnvVars) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(allExtraEnvVars, (String)"allExtraEnvVars");
        super(lifetime, serverPort, isLightweight, killedEbs);
        this.application = application;
        this.allExtraEnvVars = allExtraEnvVars;
        this.start();
    }

    @Override
    @NotNull
    public String getDotNetPluginsXmlDescriptor() {
        return Companion.getAdditionalInfo().isEmpty() ? "" : Companion.getDotNetPluginsXmlDescriptor(Companion.getAdditionalInfo());
    }

    @Override
    public boolean isInternal() {
        return this.application.isInternal();
    }

    @Override
    public boolean isUnitTesting() {
        return this.application.isUnitTestMode();
    }

    @Override
    @NotNull
    public String getDotNetPluginsExtraDirs() {
        return Companion.getAdditionalInfo().isEmpty() ? "" : Companion.getAllDotNetBinDirectoriesAsSortedString(Companion.getAdditionalInfo());
    }

    @Override
    @NotNull
    public List<String> getExtraFlags() {
        return Companion.getAdditionalInfo().getExtraFlags();
    }

    @Override
    @NotNull
    public Map<String, String> getExtraEnvVars() {
        return this.allExtraEnvVars;
    }

    private static final Companion.AdditionalInfo additionalInfo_delegate$lambda$0() {
        List nugetPackages = new ArrayList();
        List dirsAdHoc = new ArrayList();
        List dirsAdHocV2 = new ArrayList();
        List debuggerDirs = new ArrayList();
        List dirsExpanded = new ArrayList();
        List projectTemplateDirs = new ArrayList();
        Map envVars = new LinkedHashMap();
        MapsKt.putAll((Map)envVars, RiderBackendEnvProvider.Companion.getNonDynamicEnvironment());
        Path dirBackend = RiderEnvironment.INSTANCE.getRiderBackendDirectory().toPath();
        Intrinsics.checkNotNull((Object)dirBackend);
        dirsExpanded.add(dirBackend);
        logger.info("* adding directory with expanded DLLs for the main backend dir: " + dirBackend + ".");
        List flags = new ArrayList();
        IdeaPluginDescriptor[] ideaPluginDescriptorArray = PluginManager.getPlugins();
        Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptorArray, (String)"getPlugins(...)");
        for (IdeaPluginDescriptor plugin : ideaPluginDescriptorArray) {
            Object object;
            logger.info("Start analyzing IntelliJ Plugin: " + plugin.getPluginId().getIdString() + " (\"" + plugin.getPluginPath() + "\")");
            if (Intrinsics.areEqual((Object)plugin.getPluginId().getIdString(), (Object)"com.jetbrains.rider-cpp")) {
                PluginId pluginId = plugin.getPluginId();
                Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getPluginId(...)");
                if (!PluginManagerCore.isDisabled((PluginId)pluginId)) {
                    flags.add("--enablecpp");
                }
            }
            if (Intrinsics.areEqual((Object)plugin.getPluginId().getIdString(), (Object)"com.intellij.ml.llm")) {
                PluginId pluginId = plugin.getPluginId();
                Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getPluginId(...)");
                if (!PluginManagerCore.isDisabled((PluginId)pluginId)) {
                    envVars.put("AIAssistantPlugin", "true");
                }
            }
            Path path = plugin.getPluginPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPluginPath(...)");
            if (Intrinsics.areEqual((Object)PathsKt.getExtension((Path)path), (Object)"jar")) {
                object = plugin.getPluginPath().getParent().getParent();
            } else if (ArchivedCompilationContextUtil.getArchivedCompiledClassesLocation() != null && AppMode.isRunningFromDevBuild()) {
                String string = PathManager.getHomePath();
                var15_16 = new String[7];
                var15_16[0] = "..";
                var15_16[1] = "..";
                var15_16[2] = "..";
                var15_16[3] = "out";
                var15_16[4] = "rider";
                var15_16[5] = "plugins-backend-parts";
                Path path2 = plugin.getPluginPath();
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getPluginPath(...)");
                var15_16[6] = "intellij.rider.plugins." + PathsKt.getName((Path)path2);
                it = var15_16 = Paths.get(string, var15_16);
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                object = Files.isDirectory((Path)it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? var15_16 : null;
                if (object == null) {
                    object = plugin.getPluginPath();
                }
            } else if (ArchivedCompilationContextUtil.getArchivedCompiledClassesLocation() != null) {
                String string = PathManager.getHomePath();
                var15_16 = new String[4];
                var15_16[0] = "out";
                var15_16[1] = "rider";
                var15_16[2] = "plugins-backend-parts";
                Path path3 = plugin.getPluginPath();
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"getPluginPath(...)");
                var15_16[3] = PathsKt.getName((Path)path3);
                it = var15_16 = Paths.get(string, var15_16);
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                object = Files.isDirectory((Path)it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? var15_16 : null;
                if (object == null) {
                    object = plugin.getPluginPath();
                }
            } else if (AppMode.isRunningFromDevBuild()) {
                String string = PathManager.getHomePath();
                var15_16 = new String[8];
                var15_16[0] = "..";
                var15_16[1] = "..";
                var15_16[2] = "..";
                var15_16[3] = "out";
                var15_16[4] = "rider";
                var15_16[5] = "classes";
                var15_16[6] = "production";
                Path path4 = plugin.getPluginPath();
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"getPluginPath(...)");
                var15_16[7] = "intellij.rider.plugins." + PathsKt.getName((Path)path4);
                it = var15_16 = Paths.get(string, var15_16);
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                object = Files.isDirectory((Path)it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? var15_16 : null;
                if (object == null) {
                    object = plugin.getPluginPath();
                }
            } else {
                object = plugin.getPluginPath();
            }
            String[] path5 = object;
            logger.info("Idea Plugin: " + plugin.getPluginId().getIdString() + " (" + (Path)path5 + ")");
            PluginId pluginId = plugin.getPluginId();
            Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getPluginId(...)");
            if (PluginManagerCore.isDisabled((PluginId)pluginId)) {
                logger.info("- " + plugin.getPluginId().getIdString() + " is disabled, skipping");
                continue;
            }
            Path dotnetDirectoryPart = path5.resolve("dotnet");
            Intrinsics.checkNotNull((Object)dotnetDirectoryPart);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.isDirectory(dotnetDirectoryPart, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                logger.info("* adding directory with ad-hoc DLLs for a simplified Rider.Backend plugin: " + dotnetDirectoryPart + ".");
                dirsAdHoc.add(new Pair((Object)plugin, (Object)dotnetDirectoryPart));
            }
            Path netV2DirectoryPart = path5.resolve("net-v2");
            Intrinsics.checkNotNull((Object)netV2DirectoryPart);
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.isDirectory(netV2DirectoryPart, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                logger.info("* adding directory with ad-hoc DLLs for a simplified Rider.Backend plugin version 2: " + netV2DirectoryPart + ".");
                dirsAdHocV2.add(new Pair((Object)plugin, (Object)netV2DirectoryPart));
            }
            Path dotnetDebuggerDirectoryPart = path5.resolve("dotnetDebuggerWorker");
            Intrinsics.checkNotNull((Object)dotnetDebuggerDirectoryPart);
            LinkOption[] linkOptionArray3 = new LinkOption[]{};
            if (Files.isDirectory(dotnetDebuggerDirectoryPart, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length))) {
                logger.info("* adding directory with DLLs for a debugger plugin: " + dotnetDebuggerDirectoryPart + ".");
                debuggerDirs.add(new Pair((Object)plugin, (Object)dotnetDebuggerDirectoryPart));
            }
            Path dotFilesDirectoryPart = path5.resolve("DotFiles");
            Intrinsics.checkNotNull((Object)dotFilesDirectoryPart);
            LinkOption[] linkOptionArray4 = new LinkOption[]{};
            if (Files.isDirectory(dotFilesDirectoryPart, Arrays.copyOf(linkOptionArray4, linkOptionArray4.length))) {
                if (Intrinsics.areEqual((Object)dotFilesDirectoryPart, (Object)dirBackend)) {
                    logger.info("* skipping directory with expanded DLLs for a set of full Rider.Backend plugins (reason: duplicates the main backend dir): " + dotFilesDirectoryPart + ".");
                } else {
                    logger.info("* adding directory with expanded DLLs for a set of full Rider.Backend plugins: " + dotFilesDirectoryPart + ".");
                    dirsExpanded.add(dotFilesDirectoryPart);
                }
            }
            Path projectTemplatesDirCandidate = path5.resolve("projectTemplates");
            Intrinsics.checkNotNull((Object)projectTemplatesDirCandidate);
            LinkOption[] linkOptionArray5 = new LinkOption[]{};
            if (Files.isDirectory(projectTemplatesDirCandidate, Arrays.copyOf(linkOptionArray5, linkOptionArray5.length))) {
                logger.info("* adding project templates directory: " + projectTemplatesDirCandidate);
                projectTemplateDirs.add(projectTemplatesDirCandidate);
            }
            Intrinsics.checkNotNull((Object)path5);
            List dotnetNugets = PathsKt.listDirectoryEntries((Path)path5, (String)"*.nupkg");
            for (Path nuget : dotnetNugets) {
                logger.info("* adding a nupkg file for a Rider.Backend plugin: " + nuget);
                nugetPackages.add(nuget);
            }
        }
        if (ArchivedCompilationContextUtil.getArchivedCompiledClassesLocation() != null) {
            String[] stringArray = new String[]{"rider", "plugins", "cpp", "resources", "projectTemplates"};
            Path path = Paths.get(PathManager.getHomePath(), stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            projectTemplateDirs.add(path);
        }
        return new Companion.AdditionalInfo(nugetPackages, dirsAdHoc, dirsAdHocV2, debuggerDirs, dirsExpanded, projectTemplateDirs, flags, envVars);
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ReSharperProcess.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ReSharperProcess.logger = logger;
        additionalInfo$delegate = LazyKt.lazy(ReSharperProcess::additionalInfo_delegate$lambda$0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0017B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/protocol/ReSharperProcess$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getCompanyName", "", "plugin", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "getSubPlatformName", "getDotNetPluginsXmlDescriptor", "info", "Lcom/jetbrains/rider/protocol/ReSharperProcess$Companion$AdditionalInfo;", "getAllDotNetBinDirectoriesSorted", "Ljava/util/SortedSet;", "Ljava/io/File;", "getAllDotNetBinDirectoriesAsSortedString", "additionalInfo", "getAdditionalInfo", "()Lcom/jetbrains/rider/protocol/ReSharperProcess$Companion$AdditionalInfo;", "additionalInfo$delegate", "Lkotlin/Lazy;", "AdditionalInfo", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nReSharperProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReSharperProcess.kt\ncom/jetbrains/rider/protocol/ReSharperProcess$Companion\n+ 2 XMLStreamHelpers.kt\ncom/jetbrains/rider/utils/XMLStreamHelpers\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,329:1\n7#2:330\n11#2,2:331\n11#2,4:334\n11#2,4:340\n11#2,2:351\n11#2,4:354\n13#2,2:359\n11#2,2:371\n11#2,4:374\n13#2,2:379\n13#2,2:382\n8#2:384\n1869#3:333\n1870#3:338\n1869#3:339\n1870#3:344\n1056#3:345\n1869#3:346\n1563#3:347\n1634#3,3:348\n1869#3:353\n1870#3:358\n1870#3:361\n1056#3:362\n1869#3:363\n774#3:364\n865#3,2:365\n1563#3:367\n1634#3,3:368\n1869#3:373\n1870#3:378\n1870#3:381\n1563#3:389\n1634#3,3:390\n1563#3:393\n1634#3,3:394\n67#4,4:385\n*S KotlinDebug\n*F\n+ 1 ReSharperProcess.kt\ncom/jetbrains/rider/protocol/ReSharperProcess$Companion\n*L\n83#1:330\n84#1:331,2\n104#1:334,4\n110#1:340,4\n129#1:351,2\n137#1:354,4\n129#1:359,2\n167#1:371,2\n175#1:374,4\n167#1:379,2\n84#1:382,2\n83#1:384\n103#1:333\n103#1:338\n109#1:339\n109#1:344\n115#1:345\n115#1:346\n126#1:347\n126#1:348,3\n136#1:353\n136#1:358\n115#1:361\n147#1:362\n147#1:363\n158#1:364\n158#1:365,2\n164#1:367\n164#1:368,3\n174#1:373\n174#1:378\n147#1:381\n198#1:389\n198#1:390,3\n199#1:393\n199#1:394,3\n192#1:385,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final String getCompanyName(IdeaPluginDescriptor plugin) {
            int lastDotIndex = StringsKt.lastIndexOf$default((CharSequence)plugin.getPluginId().getIdString(), (char)'.', (int)0, (boolean)false, (int)6, null);
            if (lastDotIndex == -1) {
                String string = plugin.getVendor();
                if (string == null) {
                    throw new IllegalStateException("Company name not found".toString());
                }
                return string;
            }
            String string = plugin.getPluginId().getIdString().substring(0, lastDotIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }

        private final String getSubPlatformName(IdeaPluginDescriptor plugin) {
            int lastDotIndex = StringsKt.lastIndexOf$default((CharSequence)plugin.getPluginId().getIdString(), (char)'.', (int)0, (boolean)false, (int)6, null);
            if (lastDotIndex == -1) {
                return plugin.getPluginId().getIdString();
            }
            String string = plugin.getPluginId().getIdString().substring(lastDotIndex + 1, plugin.getPluginId().getIdString().length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final String getDotNetPluginsXmlDescriptor(@NotNull AdditionalInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Regex jetSemanticVersionRegex = new Regex("^(\\d+(\\s*\\.\\s*\\d+){0,3})(-(([-a-zA-Z0-9])([-a-zA-Z0-9\\\\.](?<!\\.{2}))*(?<!\\.)))?(\\+(?<Build>[0-9a-z\\-\\\\.]*))?$", RegexOption.IGNORE_CASE);
            StringWriter sw = new StringWriter();
            XMLStreamWriter xMLStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(sw);
            Intrinsics.checkNotNullExpressionValue((Object)xMLStreamWriter, (String)"createXMLStreamWriter(...)");
            try (XMLStreamWriter xml = xMLStreamWriter;){
                Object name$iv;
                Iterable iterable;
                String version;
                Path baseDir;
                IdeaPluginDescriptor plugin;
                Pair pair;
                void $this$element$iv;
                boolean $i$f$element;
                String name$iv2;
                Path it;
                void name$iv3;
                void $this$element$iv2;
                XMLStreamHelpers xMLStreamHelpers = XMLStreamHelpers.INSTANCE;
                XMLStreamWriter writer$iv = xml;
                boolean $i$f$xmlSteamWriter = false;
                XMLStreamWriter $this$getDotNetPluginsXmlDescriptor_u24lambda_u240 = writer$iv;
                boolean bl = false;
                XMLStreamHelpers xMLStreamHelpers2 = XMLStreamHelpers.INSTANCE;
                XMLStreamWriter xMLStreamWriter2 = $this$getDotNetPluginsXmlDescriptor_u24lambda_u240;
                String string = "Packages";
                boolean $i$f$element2 = false;
                $this$element$iv2.writeStartElement((String)name$iv3);
                void $this$getDotNetPluginsXmlDescriptor_u24lambda_u240_u240 = $this$element$iv2;
                boolean bl2 = false;
                Iterable $this$forEach$iv = CollectionsKt.sorted((Iterable)info.getNugetPackages());
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (Path)element$iv;
                    boolean bl3 = false;
                    XMLStreamHelpers xMLStreamHelpers3 = XMLStreamHelpers.INSTANCE;
                    void var23_25 = $this$getDotNetPluginsXmlDescriptor_u24lambda_u240_u240;
                    name$iv2 = "File";
                    $i$f$element = false;
                    $this$element$iv.writeStartElement(name$iv2);
                    void $this$getDotNetPluginsXmlDescriptor_u24lambda_u240_u240_u240_u240 = $this$element$iv;
                    boolean bl4 = false;
                    XMLStreamHelpers.INSTANCE.attribute((XMLStreamWriter)$this$getDotNetPluginsXmlDescriptor_u24lambda_u240_u240_u240_u240, "Path", ((Object)it).toString());
                    $this$element$iv.writeEndElement();
                }
                $this$forEach$iv = CollectionsKt.sorted((Iterable)info.getDirsExpanded());
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (Path)element$iv;
                    boolean bl5 = false;
                    XMLStreamHelpers this_$iv = XMLStreamHelpers.INSTANCE;
                    $this$element$iv = $this$getDotNetPluginsXmlDescriptor_u24lambda_u240_u240;
                    name$iv2 = "Folder";
                    $i$f$element = false;
                    $this$element$iv.writeStartElement(name$iv2);
                    void $this$getDotNetPluginsXmlDescriptor_u24lambda_u240_u240_u241_u240 = $this$element$iv;
                    boolean bl6 = false;
                    XMLStreamHelpers.INSTANCE.attribute((XMLStreamWriter)$this$getDotNetPluginsXmlDescriptor_u24lambda_u240_u240_u241_u240, "Path", ((Object)it).toString());
                    $this$element$iv.writeEndElement();
                }
                Iterable $this$sortedBy$iv = info.getDirsAdHoc();
                boolean $i$f$sortedBy = false;
                $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Pair it = (Pair)a;
                        boolean bl = false;
                        Comparable comparable = (Path)it.getSecond();
                        it = (Pair)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Path)it.getSecond()));
                    }
                });
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    void $this$element$iv3;
                    Instant maxMtime;
                    void $this$mapTo$iv$iv;
                    pair = (Pair)element$iv;
                    boolean bl7 = false;
                    plugin = (IdeaPluginDescriptor)pair.component1();
                    baseDir = (Path)pair.component2();
                    String string2 = plugin.getVersion();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getVersion(...)");
                    version = jetSemanticVersionRegex.matches((CharSequence)string2) ? plugin.getVersion() : "999.999.999";
                    List files = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)PathsKt.walk((Path)baseDir, (PathWalkOption[])new PathWalkOption[0]), Companion::getDotNetPluginsXmlDescriptor$lambda$0$0$3$0));
                    String id = plugin.getPluginId().getIdString();
                    if (files.isEmpty()) {
                        logger.warn("Backend/ReSharper dotnet part of plugin " + id + " was skipped since plugin folder does not contain any dlls: " + baseDir);
                        continue;
                    }
                    Object $this$map$iv = files;
                    boolean $i$f$map22 = false;
                    iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it2;
                        Path path = (Path)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl8 = false;
                        LinkOption[] linkOptionArray = new LinkOption[]{};
                        FileTime fileTime = Files.getLastModifiedTime((Path)it2, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"getLastModifiedTime(...)");
                        collection.add(fileTime.toInstant());
                    }
                    if ((Instant)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv)) == null) continue;
                    String builtOn = ZonedDateTime.ofInstant(maxMtime, ZoneId.systemDefault()).format(DateTimeFormatter.ISO_INSTANT);
                    $this$map$iv = XMLStreamHelpers.INSTANCE;
                    void $i$f$map22 = $this$getDotNetPluginsXmlDescriptor_u24lambda_u240_u240;
                    String name$iv4 = "AdHocMetadata";
                    boolean $i$f$element3 = false;
                    $this$element$iv3.writeStartElement(name$iv4);
                    void $this$getDotNetPluginsXmlDescriptor_u24lambda_u240_u240_u243_u242 = $this$element$iv3;
                    boolean bl9 = false;
                    XMLStreamHelpers.INSTANCE.attribute((XMLStreamWriter)$this$getDotNetPluginsXmlDescriptor_u24lambda_u240_u240_u243_u242, "BaseDir", ((Object)baseDir.toAbsolutePath()).toString());
                    Intrinsics.checkNotNull((Object)version);
                    XMLStreamHelpers.INSTANCE.attribute((XMLStreamWriter)$this$getDotNetPluginsXmlDescriptor_u24lambda_u240_u240_u243_u242, "Version", version);
                    Intrinsics.checkNotNull((Object)builtOn);
                    XMLStreamHelpers.INSTANCE.attribute((XMLStreamWriter)$this$getDotNetPluginsXmlDescriptor_u24lambda_u240_u240_u243_u242, "BuiltOn", builtOn);
                    XMLStreamHelpers.INSTANCE.attribute((XMLStreamWriter)$this$getDotNetPluginsXmlDescriptor_u24lambda_u240_u240_u243_u242, "CompanyNameHuman", Companion.getCompanyName(plugin));
                    XMLStreamHelpers.INSTANCE.attribute((XMLStreamWriter)$this$getDotNetPluginsXmlDescriptor_u24lambda_u240_u240_u243_u242, "SubplatformName", Companion.getSubPlatformName(plugin));
                    Iterable $this$forEach$iv2 = CollectionsKt.sorted((Iterable)files);
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        void $this$element$iv4;
                        Path file = (Path)element$iv2;
                        boolean bl10 = false;
                        XMLStreamHelpers xMLStreamHelpers4 = XMLStreamHelpers.INSTANCE;
                        void var43_77 = $this$getDotNetPluginsXmlDescriptor_u24lambda_u240_u240_u243_u242;
                        name$iv = "PackageFile";
                        boolean $i$f$element4 = false;
                        $this$element$iv4.writeStartElement((String)name$iv);
                        void $this$getDotNetPluginsXmlDescriptor_u24lambda_u240_u240_u243_u242_u240_u240 = $this$element$iv4;
                        boolean bl11 = false;
                        XMLStreamHelpers.INSTANCE.attribute((XMLStreamWriter)$this$getDotNetPluginsXmlDescriptor_u24lambda_u240_u240_u243_u242_u240_u240, "RelativePath", ((Object)PathsKt.relativeTo((Path)file, (Path)baseDir)).toString());
                        if (StringsKt.endsWith((String)PathsKt.getName((Path)file), (String)".dll", (boolean)true)) {
                            XMLStreamHelpers.INSTANCE.attribute((XMLStreamWriter)$this$getDotNetPluginsXmlDescriptor_u24lambda_u240_u240_u243_u242_u240_u240, "AssemblyName", "*");
                        }
                        $this$element$iv4.writeEndElement();
                    }
                    $this$element$iv3.writeEndElement();
                }
                $this$sortedBy$iv = info.getDirsAdHocV2();
                $i$f$sortedBy = false;
                $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Pair it = (Pair)a;
                        boolean bl = false;
                        Comparable comparable = (Path)it.getSecond();
                        it = (Pair)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Path)it.getSecond()));
                    }
                });
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    void $this$element$iv5;
                    Instant maxMtime;
                    void $this$mapTo$iv$iv;
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    pair = (Pair)element$iv;
                    boolean bl12 = false;
                    plugin = (IdeaPluginDescriptor)pair.component1();
                    baseDir = (Path)pair.component2();
                    String string3 = plugin.getVersion();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getVersion(...)");
                    version = jetSemanticVersionRegex.matches((CharSequence)string3) ? plugin.getVersion() : "999.999.999";
                    Set managedDlls = new LinkedHashSet();
                    List files = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)PathsKt.walk((Path)baseDir, (PathWalkOption[])new PathWalkOption[0]), Companion::getDotNetPluginsXmlDescriptor$lambda$0$0$5$0));
                    String id = plugin.getPluginId().getIdString();
                    if (files.isEmpty()) {
                        logger.warn("Backend/ReSharper net-v2 part of plugin " + id + " was skipped since plugin folder does not contain any dlls: " + baseDir);
                        continue;
                    }
                    Iterable $this$element$iv3 = PathsKt.listDirectoryEntries$default((Path)baseDir, null, (int)1, null);
                    iterable = managedDlls;
                    boolean $i$f$filter = false;
                    void $this$getDotNetPluginsXmlDescriptor_u24lambda_u240_u240_u243_u242 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        Path it3 = (Path)element$iv$iv;
                        boolean bl13 = false;
                        LinkOption[] linkOptionArray = new LinkOption[]{};
                        if (!(Files.isRegularFile(it3, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && StringsKt.equals((String)PathsKt.getExtension((Path)it3), (String)"dll", (boolean)true))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    iterable.addAll((List)destination$iv$iv);
                    Path runtimesDir = baseDir.resolve("runtimes");
                    Intrinsics.checkNotNull((Object)runtimesDir);
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (Files.isDirectory(runtimesDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                        managedDlls.addAll((Collection)RuntimeSpecificAssemblyResolver.INSTANCE.enumerateRuntimeSpecificAssemblies(runtimesDir));
                    }
                    Object $this$map$iv = files;
                    boolean $i$f$map32 = false;
                    Object $i$f$forEach2 = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it4;
                        Path element$iv2 = (Path)item$iv$iv;
                        iterable = destination$iv$iv2;
                        boolean bl14 = false;
                        LinkOption[] linkOptionArray2 = new LinkOption[]{};
                        FileTime fileTime = Files.getLastModifiedTime((Path)it4, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length));
                        Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"getLastModifiedTime(...)");
                        iterable.add(fileTime.toInstant());
                    }
                    if ((Instant)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv2)) == null) continue;
                    String builtOn = ZonedDateTime.ofInstant(maxMtime, ZoneId.systemDefault()).format(DateTimeFormatter.ISO_INSTANT);
                    $this$map$iv = XMLStreamHelpers.INSTANCE;
                    void $i$f$map32 = $this$getDotNetPluginsXmlDescriptor_u24lambda_u240_u240;
                    String name$iv5 = "AdHocMetadata";
                    boolean $i$f$element5 = false;
                    $this$element$iv5.writeStartElement(name$iv5);
                    void $this$getDotNetPluginsXmlDescriptor_u24lambda_u240_u240_u245_u243 = $this$element$iv5;
                    boolean bl15 = false;
                    XMLStreamHelpers.INSTANCE.attribute((XMLStreamWriter)$this$getDotNetPluginsXmlDescriptor_u24lambda_u240_u240_u245_u243, "BaseDir", ((Object)baseDir.toAbsolutePath()).toString());
                    Intrinsics.checkNotNull((Object)version);
                    XMLStreamHelpers.INSTANCE.attribute((XMLStreamWriter)$this$getDotNetPluginsXmlDescriptor_u24lambda_u240_u240_u245_u243, "Version", version);
                    Intrinsics.checkNotNull((Object)builtOn);
                    XMLStreamHelpers.INSTANCE.attribute((XMLStreamWriter)$this$getDotNetPluginsXmlDescriptor_u24lambda_u240_u240_u245_u243, "BuiltOn", builtOn);
                    XMLStreamHelpers.INSTANCE.attribute((XMLStreamWriter)$this$getDotNetPluginsXmlDescriptor_u24lambda_u240_u240_u245_u243, "CompanyNameHuman", Companion.getCompanyName(plugin));
                    XMLStreamHelpers.INSTANCE.attribute((XMLStreamWriter)$this$getDotNetPluginsXmlDescriptor_u24lambda_u240_u240_u245_u243, "SubplatformName", Companion.getSubPlatformName(plugin));
                    Iterable $this$forEach$iv3 = CollectionsKt.sorted((Iterable)files);
                    boolean $i$f$forEach3 = false;
                    for (Object element$iv3 : $this$forEach$iv3) {
                        void $this$element$iv6;
                        Path file = (Path)element$iv3;
                        boolean bl16 = false;
                        name$iv = XMLStreamHelpers.INSTANCE;
                        void $i$f$element4 = $this$getDotNetPluginsXmlDescriptor_u24lambda_u240_u240_u245_u243;
                        String name$iv6 = "PackageFile";
                        boolean $i$f$element6 = false;
                        $this$element$iv6.writeStartElement(name$iv6);
                        void $this$getDotNetPluginsXmlDescriptor_u24lambda_u240_u240_u245_u243_u240_u240 = $this$element$iv6;
                        boolean bl17 = false;
                        Path relativeFile = PathsKt.relativeTo((Path)file, (Path)baseDir);
                        XMLStreamHelpers.INSTANCE.attribute((XMLStreamWriter)$this$getDotNetPluginsXmlDescriptor_u24lambda_u240_u240_u245_u243_u240_u240, "RelativePath", ((Object)relativeFile).toString());
                        if (managedDlls.contains(file)) {
                            XMLStreamHelpers.INSTANCE.attribute((XMLStreamWriter)$this$getDotNetPluginsXmlDescriptor_u24lambda_u240_u240_u245_u243_u240_u240, "AssemblyName", "*");
                        }
                        $this$element$iv6.writeEndElement();
                    }
                    $this$element$iv5.writeEndElement();
                }
                $this$element$iv2.writeEndElement();
            }
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Additional packages: " + sw);
            }
            String string = sw.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final SortedSet<File> getAllDotNetBinDirectoriesSorted(AdditionalInfo info) {
            Path it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Iterable iterable = info.getDirsAdHoc();
            Collection collection2 = CollectionsKt.listOf((Object)RiderEnvironment.INSTANCE.getRiderBackendDirectory());
            boolean $i$f$map = false;
            void var5_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair = (Pair)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Path)it.getSecond()).toFile());
            }
            $this$map$iv = info.getDirsExpanded();
            collection2 = CollectionsKt.plus((Collection)collection2, (Iterable)((List)destination$iv$iv));
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Path)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toFile());
            }
            List files = CollectionsKt.plus((Collection)collection2, (Iterable)((List)destination$iv$iv));
            return CollectionsKt.toSortedSet((Iterable)files, (arg_0, arg_1) -> Companion.getAllDotNetBinDirectoriesSorted$lambda$3(Companion::getAllDotNetBinDirectoriesSorted$lambda$2, arg_0, arg_1));
        }

        @NotNull
        public final String getAllDotNetBinDirectoriesAsSortedString(@NotNull AdditionalInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            return CollectionsKt.joinToString$default((Iterable)this.getAllDotNetBinDirectoriesSorted(info), (CharSequence)";", null, null, (int)0, null, null, (int)62, null);
        }

        @NotNull
        public final AdditionalInfo getAdditionalInfo() {
            Lazy lazy = additionalInfo$delegate;
            return (AdditionalInfo)lazy.getValue();
        }

        private static final boolean getDotNetPluginsXmlDescriptor$lambda$0$0$3$0(Path it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            return Files.isRegularFile(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && !StringsKt.equals((String)PathsKt.getExtension((Path)it), (String)"pdb", (boolean)true);
        }

        private static final boolean getDotNetPluginsXmlDescriptor$lambda$0$0$5$0(Path it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            return Files.isRegularFile(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        }

        private static final int getAllDotNetBinDirectoriesSorted$lambda$2(File f1, File f2) {
            return FileUtil.compareFiles((File)f1, (File)f2);
        }

        private static final int getAllDotNetBinDirectoriesSorted$lambda$3(Function2 $tmp0, Object p0, Object p1) {
            return ((Number)$tmp0.invoke(p0, p1)).intValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u00a1\u0001\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00060\u0003\u0012\u0018\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00060\u0003\u0012\u0018\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00060\u0003\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u001b\u0010\"\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00060\u0003H\u00c6\u0003J\u001b\u0010#\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00060\u0003H\u00c6\u0003J\u001b\u0010$\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00060\u0003H\u00c6\u0003J\u000f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010'\u001a\b\u0012\u0004\u0012\u00020\r0\u0003H\u00c6\u0003J\u0015\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u000fH\u00c6\u0003J\u00b3\u0001\u0010)\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u001a\b\u0002\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00060\u00032\u001a\b\u0002\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00060\u00032\u001a\b\u0002\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00060\u00032\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00032\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u000fH\u00c6\u0001J\u0013\u0010*\u001a\u00020\u001d2\b\u0010+\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010,\u001a\u00020-H\u00d6\u0001J\t\u0010.\u001a\u00020\rH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R#\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R#\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R#\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013R\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001eR\u001d\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u000f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001b\u00a8\u0006/"}, d2={"Lcom/jetbrains/rider/protocol/ReSharperProcess$Companion$AdditionalInfo;", "", "nugetPackages", "", "Ljava/nio/file/Path;", "dirsAdHoc", "Lkotlin/Pair;", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "dirsAdHocV2", "debuggerDirs", "dirsExpanded", "projectTemplateDirs", "extraFlags", "", "nonDynamicEnvVars", "", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/Map;)V", "getNugetPackages", "()Ljava/util/List;", "getDirsAdHoc", "getDirsAdHocV2", "getDebuggerDirs", "getDirsExpanded", "getProjectTemplateDirs", "getExtraFlags", "getNonDynamicEnvVars", "()Ljava/util/Map;", "isEmpty", "", "()Z", "extraEnvVars", "getExtraEnvVars", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "hashCode", "", "toString", "intellij.rider.rdclient.dotnet"})
        public static final class AdditionalInfo {
            @NotNull
            private final List<Path> nugetPackages;
            @NotNull
            private final List<Pair<IdeaPluginDescriptor, Path>> dirsAdHoc;
            @NotNull
            private final List<Pair<IdeaPluginDescriptor, Path>> dirsAdHocV2;
            @NotNull
            private final List<Pair<IdeaPluginDescriptor, Path>> debuggerDirs;
            @NotNull
            private final List<Path> dirsExpanded;
            @NotNull
            private final List<Path> projectTemplateDirs;
            @NotNull
            private final List<String> extraFlags;
            @NotNull
            private final Map<String, String> nonDynamicEnvVars;

            public AdditionalInfo(@NotNull List<? extends Path> nugetPackages, @NotNull List<? extends Pair<? extends IdeaPluginDescriptor, ? extends Path>> dirsAdHoc, @NotNull List<? extends Pair<? extends IdeaPluginDescriptor, ? extends Path>> dirsAdHocV2, @NotNull List<? extends Pair<? extends IdeaPluginDescriptor, ? extends Path>> debuggerDirs, @NotNull List<? extends Path> dirsExpanded, @NotNull List<? extends Path> projectTemplateDirs, @NotNull List<String> extraFlags, @NotNull Map<String, String> nonDynamicEnvVars) {
                Intrinsics.checkNotNullParameter(nugetPackages, (String)"nugetPackages");
                Intrinsics.checkNotNullParameter(dirsAdHoc, (String)"dirsAdHoc");
                Intrinsics.checkNotNullParameter(dirsAdHocV2, (String)"dirsAdHocV2");
                Intrinsics.checkNotNullParameter(debuggerDirs, (String)"debuggerDirs");
                Intrinsics.checkNotNullParameter(dirsExpanded, (String)"dirsExpanded");
                Intrinsics.checkNotNullParameter(projectTemplateDirs, (String)"projectTemplateDirs");
                Intrinsics.checkNotNullParameter(extraFlags, (String)"extraFlags");
                Intrinsics.checkNotNullParameter(nonDynamicEnvVars, (String)"nonDynamicEnvVars");
                this.nugetPackages = nugetPackages;
                this.dirsAdHoc = dirsAdHoc;
                this.dirsAdHocV2 = dirsAdHocV2;
                this.debuggerDirs = debuggerDirs;
                this.dirsExpanded = dirsExpanded;
                this.projectTemplateDirs = projectTemplateDirs;
                this.extraFlags = extraFlags;
                this.nonDynamicEnvVars = nonDynamicEnvVars;
            }

            @NotNull
            public final List<Path> getNugetPackages() {
                return this.nugetPackages;
            }

            @NotNull
            public final List<Pair<IdeaPluginDescriptor, Path>> getDirsAdHoc() {
                return this.dirsAdHoc;
            }

            @NotNull
            public final List<Pair<IdeaPluginDescriptor, Path>> getDirsAdHocV2() {
                return this.dirsAdHocV2;
            }

            @NotNull
            public final List<Pair<IdeaPluginDescriptor, Path>> getDebuggerDirs() {
                return this.debuggerDirs;
            }

            @NotNull
            public final List<Path> getDirsExpanded() {
                return this.dirsExpanded;
            }

            @NotNull
            public final List<Path> getProjectTemplateDirs() {
                return this.projectTemplateDirs;
            }

            @NotNull
            public final List<String> getExtraFlags() {
                return this.extraFlags;
            }

            @NotNull
            public final Map<String, String> getNonDynamicEnvVars() {
                return this.nonDynamicEnvVars;
            }

            public final boolean isEmpty() {
                return this.nugetPackages.isEmpty() && this.dirsAdHoc.isEmpty() && this.dirsExpanded.isEmpty() && this.projectTemplateDirs.isEmpty();
            }

            @NotNull
            public final Map<String, String> getExtraEnvVars() {
                Iterable<Pair<String, String>> dynamicVars = RiderBackendEnvProvider.Companion.getDynamicEnvironment();
                return MapsKt.plus(this.nonDynamicEnvVars, dynamicVars);
            }

            @NotNull
            public final List<Path> component1() {
                return this.nugetPackages;
            }

            @NotNull
            public final List<Pair<IdeaPluginDescriptor, Path>> component2() {
                return this.dirsAdHoc;
            }

            @NotNull
            public final List<Pair<IdeaPluginDescriptor, Path>> component3() {
                return this.dirsAdHocV2;
            }

            @NotNull
            public final List<Pair<IdeaPluginDescriptor, Path>> component4() {
                return this.debuggerDirs;
            }

            @NotNull
            public final List<Path> component5() {
                return this.dirsExpanded;
            }

            @NotNull
            public final List<Path> component6() {
                return this.projectTemplateDirs;
            }

            @NotNull
            public final List<String> component7() {
                return this.extraFlags;
            }

            @NotNull
            public final Map<String, String> component8() {
                return this.nonDynamicEnvVars;
            }

            @NotNull
            public final AdditionalInfo copy(@NotNull List<? extends Path> nugetPackages, @NotNull List<? extends Pair<? extends IdeaPluginDescriptor, ? extends Path>> dirsAdHoc, @NotNull List<? extends Pair<? extends IdeaPluginDescriptor, ? extends Path>> dirsAdHocV2, @NotNull List<? extends Pair<? extends IdeaPluginDescriptor, ? extends Path>> debuggerDirs, @NotNull List<? extends Path> dirsExpanded, @NotNull List<? extends Path> projectTemplateDirs, @NotNull List<String> extraFlags, @NotNull Map<String, String> nonDynamicEnvVars) {
                Intrinsics.checkNotNullParameter(nugetPackages, (String)"nugetPackages");
                Intrinsics.checkNotNullParameter(dirsAdHoc, (String)"dirsAdHoc");
                Intrinsics.checkNotNullParameter(dirsAdHocV2, (String)"dirsAdHocV2");
                Intrinsics.checkNotNullParameter(debuggerDirs, (String)"debuggerDirs");
                Intrinsics.checkNotNullParameter(dirsExpanded, (String)"dirsExpanded");
                Intrinsics.checkNotNullParameter(projectTemplateDirs, (String)"projectTemplateDirs");
                Intrinsics.checkNotNullParameter(extraFlags, (String)"extraFlags");
                Intrinsics.checkNotNullParameter(nonDynamicEnvVars, (String)"nonDynamicEnvVars");
                return new AdditionalInfo(nugetPackages, dirsAdHoc, dirsAdHocV2, debuggerDirs, dirsExpanded, projectTemplateDirs, extraFlags, nonDynamicEnvVars);
            }

            public static /* synthetic */ AdditionalInfo copy$default(AdditionalInfo additionalInfo, List list2, List list3, List list4, List list5, List list6, List list7, List list8, Map map, int n, Object object) {
                if ((n & 1) != 0) {
                    list2 = additionalInfo.nugetPackages;
                }
                if ((n & 2) != 0) {
                    list3 = additionalInfo.dirsAdHoc;
                }
                if ((n & 4) != 0) {
                    list4 = additionalInfo.dirsAdHocV2;
                }
                if ((n & 8) != 0) {
                    list5 = additionalInfo.debuggerDirs;
                }
                if ((n & 0x10) != 0) {
                    list6 = additionalInfo.dirsExpanded;
                }
                if ((n & 0x20) != 0) {
                    list7 = additionalInfo.projectTemplateDirs;
                }
                if ((n & 0x40) != 0) {
                    list8 = additionalInfo.extraFlags;
                }
                if ((n & 0x80) != 0) {
                    map = additionalInfo.nonDynamicEnvVars;
                }
                return additionalInfo.copy(list2, list3, list4, list5, list6, list7, list8, map);
            }

            @NotNull
            public String toString() {
                return "AdditionalInfo(nugetPackages=" + this.nugetPackages + ", dirsAdHoc=" + this.dirsAdHoc + ", dirsAdHocV2=" + this.dirsAdHocV2 + ", debuggerDirs=" + this.debuggerDirs + ", dirsExpanded=" + this.dirsExpanded + ", projectTemplateDirs=" + this.projectTemplateDirs + ", extraFlags=" + this.extraFlags + ", nonDynamicEnvVars=" + this.nonDynamicEnvVars + ")";
            }

            public int hashCode() {
                int result2 = ((Object)this.nugetPackages).hashCode();
                result2 = result2 * 31 + ((Object)this.dirsAdHoc).hashCode();
                result2 = result2 * 31 + ((Object)this.dirsAdHocV2).hashCode();
                result2 = result2 * 31 + ((Object)this.debuggerDirs).hashCode();
                result2 = result2 * 31 + ((Object)this.dirsExpanded).hashCode();
                result2 = result2 * 31 + ((Object)this.projectTemplateDirs).hashCode();
                result2 = result2 * 31 + ((Object)this.extraFlags).hashCode();
                result2 = result2 * 31 + ((Object)this.nonDynamicEnvVars).hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AdditionalInfo)) {
                    return false;
                }
                AdditionalInfo additionalInfo = (AdditionalInfo)other;
                if (!Intrinsics.areEqual(this.nugetPackages, additionalInfo.nugetPackages)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.dirsAdHoc, additionalInfo.dirsAdHoc)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.dirsAdHocV2, additionalInfo.dirsAdHocV2)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.debuggerDirs, additionalInfo.debuggerDirs)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.dirsExpanded, additionalInfo.dirsExpanded)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.projectTemplateDirs, additionalInfo.projectTemplateDirs)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.extraFlags, additionalInfo.extraFlags)) {
                    return false;
                }
                return Intrinsics.areEqual(this.nonDynamicEnvVars, additionalInfo.nonDynamicEnvVars);
            }
        }
    }
}

