/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.protocol;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.jetbrains.rd.framework.IWire;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.IPropertyView;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.reactive.ViewableSet;
import com.jetbrains.rider.protocol.DelayedServerWire;
import com.jetbrains.rider.protocol.IProtocolHostWithBackend;
import com.jetbrains.rider.protocol.ProjectSessionFlowHolder;
import java.lang.invoke.MethodHandles;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\f\u0010\u000f\u001a\u00020\u0003*\u00020\bH\u0002\u001a\"\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0016*\b\u0012\u0004\u0012\u00020\u00170\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u001d\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\f*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"\u0019\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001b"}, d2={"riderBackendProtocolPrefix", "", "assertDelayedWire", "", "wire", "Lcom/jetbrains/rd/framework/IWire;", "projectSessionOrNull", "Lcom/intellij/openapi/client/ClientProjectSession;", "Lcom/intellij/openapi/client/ClientAppSession;", "getProjectSessionOrNull", "(Lcom/intellij/openapi/client/ClientAppSession;)Lcom/intellij/openapi/client/ClientProjectSession;", "projectSessionFlow", "Lkotlinx/coroutines/flow/StateFlow;", "getProjectSessionFlow", "(Lcom/intellij/openapi/client/ClientAppSession;)Lkotlinx/coroutines/flow/StateFlow;", "assertFrontendSession", "BackendPidKey", "Lcom/intellij/openapi/util/Key;", "", "getBackendPidKey", "()Lcom/intellij/openapi/util/Key;", "firstAliveProtocolHostProperty", "Lcom/jetbrains/rd/util/reactive/IPropertyView;", "Lcom/jetbrains/rider/protocol/IProtocolHostWithBackend;", "Lcom/jetbrains/rd/util/reactive/ViewableSet;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nProtocolManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocolManager.kt\ncom/jetbrains/rider/protocol/ProtocolManagerKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,678:1\n57#2:679\n35#2,2:680\n1#3:682\n295#4,2:683\n*S KotlinDebug\n*F\n+ 1 ProtocolManager.kt\ncom/jetbrains/rider/protocol/ProtocolManagerKt\n*L\n140#1:679\n140#1:680,2\n666#1:683,2\n*E\n"})
public final class ProtocolManagerKt {
    @NotNull
    private static final String riderBackendProtocolPrefix = "RiderBackend";
    @NotNull
    private static final Key<Long> BackendPidKey = new Key("backend.process.pid.key");

    private static final void assertDelayedWire(IWire wire) {
        boolean $i$f$fileLogger = false;
        boolean $i$f$currentClassLogger = false;
        Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
        Logger logger = Logger.getInstance(clazz$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.assertTrue(wire instanceof DelayedServerWire, (Object)("Must be used: " + Reflection.getOrCreateKotlinClass(DelayedServerWire.class).getQualifiedName()));
    }

    @Nullable
    public static final ClientProjectSession getProjectSessionOrNull(@NotNull ClientAppSession $this$projectSessionOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$projectSessionOrNull, (String)"<this>");
        ProtocolManagerKt.assertFrontendSession($this$projectSessionOrNull);
        return (ClientProjectSession)CollectionsKt.singleOrNull((List)$this$projectSessionOrNull.getProjectSessions());
    }

    @NotNull
    public static final StateFlow<ClientProjectSession> getProjectSessionFlow(@NotNull ClientAppSession $this$projectSessionFlow) {
        Intrinsics.checkNotNullParameter((Object)$this$projectSessionFlow, (String)"<this>");
        ProtocolManagerKt.assertFrontendSession($this$projectSessionFlow);
        return ProjectSessionFlowHolder.Companion.getInstance($this$projectSessionFlow).getFlow();
    }

    private static final void assertFrontendSession(ClientAppSession $this$assertFrontendSession) {
        boolean bl;
        boolean bl2 = bl = $this$assertFrontendSession.getType() == ClientType.FRONTEND;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Must be used only for frontend sessions";
            throw new AssertionError((Object)string);
        }
    }

    @NotNull
    public static final Key<Long> getBackendPidKey() {
        return BackendPidKey;
    }

    private static final IPropertyView<IProtocolHostWithBackend> firstAliveProtocolHostProperty(ViewableSet<IProtocolHostWithBackend> $this$firstAliveProtocolHostProperty, Lifetime lifetime) {
        Property property = new Property(null);
        $this$firstAliveProtocolHostProperty.view(lifetime, (arg_0, arg_1) -> ProtocolManagerKt.firstAliveProtocolHostProperty$lambda$0(property, $this$firstAliveProtocolHostProperty, arg_0, arg_1));
        return (IPropertyView)property;
    }

    private static final Unit firstAliveProtocolHostProperty$lambda$0(Property $property, ViewableSet $this_firstAliveProtocolHostProperty, Lifetime lifetime, IProtocolHostWithBackend protocolHost) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)protocolHost, (String)"protocolHost");
        protocolHost.getLifetime().bracketOrThrow(() -> ProtocolManagerKt.firstAliveProtocolHostProperty$lambda$0$1($property, $this_firstAliveProtocolHostProperty), () -> ProtocolManagerKt.firstAliveProtocolHostProperty$lambda$0$2($property, $this_firstAliveProtocolHostProperty));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final void firstAliveProtocolHostProperty$lambda$0$updateIfNeeded(Property<IProtocolHostWithBackend> property, ViewableSet<IProtocolHostWithBackend> $this_firstAliveProtocolHostProperty) {
        IProtocolHostWithBackend current = (IProtocolHostWithBackend)property.getValue();
        if (current == null || RLifetimeKt.isNotAlive((Lifetime)current.getLifetime())) {
            Object v0;
            Property<IProtocolHostWithBackend> property2;
            block2: {
                void $this$firstOrNull$iv;
                Iterable iterable = (Iterable)$this_firstAliveProtocolHostProperty;
                property2 = property;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    IProtocolHostWithBackend it = (IProtocolHostWithBackend)element$iv;
                    boolean bl = false;
                    if (!RLifetimeKt.isAlive((Lifetime)it.getLifetime())) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            property2.set(v0);
        }
    }

    private static final Unit firstAliveProtocolHostProperty$lambda$0$1(Property $property, ViewableSet $this_firstAliveProtocolHostProperty) {
        ProtocolManagerKt.firstAliveProtocolHostProperty$lambda$0$updateIfNeeded((Property<IProtocolHostWithBackend>)$property, (ViewableSet<IProtocolHostWithBackend>)$this_firstAliveProtocolHostProperty);
        return Unit.INSTANCE;
    }

    private static final Unit firstAliveProtocolHostProperty$lambda$0$2(Property $property, ViewableSet $this_firstAliveProtocolHostProperty) {
        ProtocolManagerKt.firstAliveProtocolHostProperty$lambda$0$updateIfNeeded((Property<IProtocolHostWithBackend>)$property, (ViewableSet<IProtocolHostWithBackend>)$this_firstAliveProtocolHostProperty);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$assertDelayedWire(IWire wire) {
        ProtocolManagerKt.assertDelayedWire(wire);
    }

    public static final /* synthetic */ IPropertyView access$firstAliveProtocolHostProperty(ViewableSet $receiver, Lifetime lifetime) {
        return ProtocolManagerKt.firstAliveProtocolHostProperty((ViewableSet<IProtocolHostWithBackend>)$receiver, lifetime);
    }
}

