/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.workspace.impl;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ExternalEntityMapping;
import com.intellij.platform.workspace.storage.ExternalMappingKey;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.MutableExternalEntityMapping;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.workspaceModel.ide.impl.WorkspaceModelImpl;
import com.jetbrains.rd.framework.IRdCall;
import com.jetbrains.rd.framework.impl.RdCall;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rider.model.ProjectModelView_PregeneratedKt;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import com.jetbrains.rider.util.idea.ExtensionsKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\tH\u0007J\u0016\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0010\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityExpandSupport;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "canPerformExpand", "", "onNodeAddedOrUpdated", "", "storage", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "entity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "requestExpandAll", "expandCompleted", "expandIfNeeded", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nWorkspaceEntityExpandSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkspaceEntityExpandSupport.kt\ncom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityExpandSupport\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,121:1\n13#2:122\n13#3:123\n*S KotlinDebug\n*F\n+ 1 WorkspaceEntityExpandSupport.kt\ncom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityExpandSupport\n*L\n35#1:122\n35#1:123\n*E\n"})
public final class WorkspaceEntityExpandSupport
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private boolean canPerformExpand;
    @NotNull
    private static final ExternalMappingKey<Companion.ExpandState> SOLUTION_EXPAND_STATE = ExternalMappingKey.Companion.create("RiderSolutionExpandStateMapping");
    @NotNull
    private static final Logger logger;

    public WorkspaceEntityExpandSupport(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.canPerformExpand = true;
    }

    public final void onNodeAddedOrUpdated(@NotNull MutableEntityStorage storage, @NotNull ProjectModelEntity entity) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (Companion.supportExpand(entity)) {
            storage.getMutableExternalMapping(SOLUTION_EXPAND_STATE).addIfAbsent((WorkspaceEntity)entity, (Object)Companion.ExpandState.Possible);
        }
    }

    @RequiresBackgroundThread
    public final void requestExpandAll() {
        WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(this.project);
        Intrinsics.checkNotNull((Object)workspaceModel, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.ide.impl.WorkspaceModelImpl");
        WorkspaceModelImpl workspaceModel2 = (WorkspaceModelImpl)workspaceModel;
        ExternalEntityMapping expandStates = workspaceModel2.getCurrentSnapshot().getExternalMapping(SOLUTION_EXPAND_STATE);
        if (expandStates.getFirstEntity((Object)Companion.ExpandState.Possible) == null) {
            return;
        }
        List ids = new ArrayList();
        workspaceModel2.updateProjectModelSilent("Update SOLUTION_EXPAND_STATE", arg_0 -> WorkspaceEntityExpandSupport.requestExpandAll$lambda$0(ids, arg_0));
        logger.trace("Expanding all lazy nodes in background schedule (" + ids.size() + ")");
        ApplicationKt.getApplication().invokeLater(() -> WorkspaceEntityExpandSupport.requestExpandAll$lambda$1(this, ids));
    }

    public final void expandCompleted(@NotNull MutableEntityStorage storage, @NotNull ProjectModelEntity entity) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        MutableExternalEntityMapping mutableMapping = storage.getMutableExternalMapping(SOLUTION_EXPAND_STATE);
        mutableMapping.addMapping((WorkspaceEntity)entity, (Object)Companion.ExpandState.Expanded);
    }

    public final void expandIfNeeded(@NotNull ProjectModelEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (!Companion.supportExpand(entity) || !this.canPerformExpand) {
            return;
        }
        Integer n = ProjectModelEntityExtensionsKt.getId(entity, this.project);
        if (n == null) {
            return;
        }
        int id = n;
        WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(this.project);
        Intrinsics.checkNotNull((Object)workspaceModel, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.ide.impl.WorkspaceModelImpl");
        WorkspaceModelImpl workspaceModel2 = (WorkspaceModelImpl)workspaceModel;
        ExternalEntityMapping expandStates = workspaceModel2.getCurrentSnapshot().getExternalMapping(SOLUTION_EXPAND_STATE);
        Companion.ExpandState nodeState = (Companion.ExpandState)((Object)expandStates.getDataByEntity((WorkspaceEntity)entity));
        if (nodeState == Companion.ExpandState.Expanded) {
            return;
        }
        if (nodeState == Companion.ExpandState.Expanding) {
            logger.trace("Still waiting for expand result for " + id + ". Throwing cancellation exception");
            throw new ProcessCanceledException();
        }
        workspaceModel2.updateProjectModelSilent("Update SOLUTION_EXPAND_STATE", arg_0 -> WorkspaceEntityExpandSupport.expandIfNeeded$lambda$0(entity, arg_0));
        RdCall<Integer, Boolean> expand = ProjectModelView_PregeneratedKt.getProjectModelView(SolutionHostExtensionsKt.getSolution(this.project)).getExpand();
        if (!ApplicationKt.getApplication().isDispatchThread()) {
            logger.trace("Expanding in background schedule: " + id + ". Throwing cancellation exception");
            ApplicationKt.getApplication().invokeLater(() -> WorkspaceEntityExpandSupport.expandIfNeeded$lambda$1(this, id, expand));
            throw new ProcessCanceledException();
        }
        logger.trace("Expanding in EDT: " + id);
        Boolean cfr_ignored_0 = (Boolean)ExtensionsKt.syncFromBackend$default((IRdCall)expand, id, this.project, null, null, 12, null);
    }

    private static final Unit requestExpandAll$lambda$0(List $ids, MutableEntityStorage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        MutableExternalEntityMapping expandStates = it.getMutableExternalMapping(SOLUTION_EXPAND_STATE);
        Sequence entities = expandStates.getEntities((Object)Companion.ExpandState.Possible);
        for (WorkspaceEntity entity : entities) {
            EntityStorage entityStorage = (EntityStorage)it;
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type com.jetbrains.rider.projectView.workspace.ProjectModelEntity");
            Integer n = WorkspaceModelExtensionsKt.getProjectModelId(entityStorage, (ProjectModelEntity)entity);
            if (n == null) {
                throw new IllegalStateException(("Cannot find id for entity: " + entity).toString());
            }
            int id = n;
            $ids.add(id);
            expandStates.addMapping(entity, (Object)Companion.ExpandState.Expanding);
        }
        return Unit.INSTANCE;
    }

    private static final void requestExpandAll$lambda$1(WorkspaceEntityExpandSupport this$0, List $ids) {
        if (this$0.project.isDisposed()) {
            return;
        }
        logger.trace("Expanding all lazy nodes in background execute (" + $ids.size() + ")");
        for (Object e : $ids) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            int id = ((Number)e).intValue();
            ProjectModelView_PregeneratedKt.getProjectModelView(SolutionHostExtensionsKt.getSolution(this$0.project)).getExpand().start(this$0.getServiceLifetime(), (Object)id);
        }
    }

    private static final Unit expandIfNeeded$lambda$0(ProjectModelEntity $entity, MutableEntityStorage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        MutableExternalEntityMapping mutableMapping = it.getMutableExternalMapping(SOLUTION_EXPAND_STATE);
        mutableMapping.addMapping((WorkspaceEntity)$entity, (Object)Companion.ExpandState.Expanding);
        return Unit.INSTANCE;
    }

    private static final void expandIfNeeded$lambda$1(WorkspaceEntityExpandSupport this$0, int $id, RdCall $expand) {
        if (this$0.project.isDisposed()) {
            return;
        }
        logger.trace("Expanding in background execute: " + $id);
        $expand.start(this$0.getServiceLifetime(), (Object)$id);
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WorkspaceEntityExpandSupport.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        WorkspaceEntityExpandSupport.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0013B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityExpandSupport$Companion;", "", "<init>", "()V", "SOLUTION_EXPAND_STATE", "Lcom/intellij/platform/workspace/storage/ExternalMappingKey;", "Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityExpandSupport$Companion$ExpandState;", "getInstance", "Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityExpandSupport;", "project", "Lcom/intellij/openapi/project/Project;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "supportExpand", "", "entity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "ExpandState", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WorkspaceEntityExpandSupport getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(WorkspaceEntityExpandSupport.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (WorkspaceEntityExpandSupport)((Object)object);
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public final boolean supportExpand(@NotNull ProjectModelEntity entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            return entity.getDescriptor().getLoadChildrenLazily();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityExpandSupport$Companion$ExpandState;", "", "<init>", "(Ljava/lang/String;I)V", "Possible", "Expanding", "Expanded", "intellij.rider.rdclient.dotnet"})
        public static final class ExpandState
        extends Enum<ExpandState> {
            public static final /* enum */ ExpandState Possible = new ExpandState();
            public static final /* enum */ ExpandState Expanding = new ExpandState();
            public static final /* enum */ ExpandState Expanded = new ExpandState();
            private static final /* synthetic */ ExpandState[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static ExpandState[] values() {
                return (ExpandState[])$VALUES.clone();
            }

            public static ExpandState valueOf(String value) {
                return Enum.valueOf(ExpandState.class, value);
            }

            @NotNull
            public static EnumEntries<ExpandState> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = expandStateArray = new ExpandState[]{ExpandState.Possible, ExpandState.Expanding, ExpandState.Expanded};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }
}

