/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.workspace.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.backend.workspace.WorkspaceModelChangeListener;
import com.intellij.platform.backend.workspace.WorkspaceModelTopics;
import com.intellij.platform.workspace.storage.EntityChange;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.util.ApplicationKt;
import com.intellij.util.SingleAlarm;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rider.projectView.ProjectModelViewUpdaterAsync;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityReference;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import com.jetbrains.rider.projectView.workspace.impl.WorkspaceModelUpdater;
import com.jetbrains.rider.solutionAnalysis.SolutionAnalysisHost;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u0000 !2\u00020\u0001:\u0004!\"#$B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\u0019H\u0002J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010 \u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014\u00a8\u0006%"}, d2={"Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityErrorsSupport;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "errors", "Ljava/util/HashMap;", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntityReference;", "Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityErrorsSupport$EntityErrorData;", "Lkotlin/collections/HashMap;", "workspaceModel", "Lcom/intellij/platform/backend/workspace/WorkspaceModel;", "queue", "", "Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityErrorsSupport$Event;", "alarm", "Lcom/intellij/util/SingleAlarm;", "isReady", "", "()Z", "hasErrors", "entity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "forceUpdate", "", "performUpdate", "addErrorMark", "addErrorMarkForParents", "count", "", "removeErrorMark", "removeErrorMarkForParents", "Companion", "Event", "EventType", "EntityErrorData", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nWorkspaceEntityErrorsSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkspaceEntityErrorsSupport.kt\ncom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityErrorsSupport\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,182:1\n382#2,7:183\n382#2,7:190\n67#3,4:197\n67#3,4:201\n67#3,4:205\n67#3,4:209\n13#3:213\n*S KotlinDebug\n*F\n+ 1 WorkspaceEntityErrorsSupport.kt\ncom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityErrorsSupport\n*L\n141#1:183,7\n151#1:190,7\n62#1:197,4\n68#1:201,4\n125#1:205,4\n135#1:209,4\n25#1:213\n*E\n"})
public final class WorkspaceEntityErrorsSupport
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final HashMap<ProjectModelEntityReference, EntityErrorData> errors;
    @NotNull
    private final WorkspaceModel workspaceModel;
    @NotNull
    private final List<Event> queue;
    @NotNull
    private final SingleAlarm alarm;
    @NotNull
    private static final Logger logger;

    public WorkspaceEntityErrorsSupport(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.errors = new HashMap();
        this.workspaceModel = WorkspaceModel.Companion.getInstance(this.project);
        this.queue = new ArrayList();
        SingleAlarm.Companion companion = SingleAlarm.Companion;
        Runnable runnable = () -> WorkspaceEntityErrorsSupport.alarm$lambda$0(this);
        this.alarm = companion.singleEdtAlarm(100, (Disposable)this, runnable);
        ApplicationKt.getApplication().invokeLater(() -> WorkspaceEntityErrorsSupport._init_$lambda$0(this));
    }

    public final boolean isReady() {
        ApplicationKt.getApplication().assertIsDispatchThread();
        return this.queue.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasErrors(@NotNull ProjectModelEntity entity) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        HashMap<ProjectModelEntityReference, EntityErrorData> hashMap = this.errors;
        synchronized (hashMap) {
            boolean bl2 = false;
            EntityErrorData data2 = this.errors.get(ProjectModelEntityExtensionsKt.toReference(entity));
            bl = data2 != null && (data2.getHasErrors() || data2.getChildrenErrors() > 0);
        }
        return bl;
    }

    public final void forceUpdate() {
        this.alarm.cancelAndRequest(true);
    }

    private final void performUpdate() {
        ApplicationKt.getApplication().assertIsDispatchThread();
        WorkspaceModelUpdater updater = WorkspaceModelUpdater.Companion.getInstance(this.project);
        updater.doWhenReady((Function0<Unit>)((Function0)() -> WorkspaceEntityErrorsSupport.performUpdate$lambda$0(this)));
    }

    /*
     * WARNING - void declaration
     */
    private final void addErrorMark(ProjectModelEntity entity) {
        EntityErrorData errorData;
        Object object;
        void $this$getOrPut$iv;
        Map map = this.errors;
        ProjectModelEntityReference key$iv = ProjectModelEntityExtensionsKt.toReference(entity);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            EntityErrorData answer$iv = new EntityErrorData();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        if ((errorData = (EntityErrorData)object).getHasErrors()) {
            return;
        }
        errorData.setHasErrors(true);
        this.addErrorMarkForParents(entity, 1);
    }

    /*
     * WARNING - void declaration
     */
    private final void addErrorMarkForParents(ProjectModelEntity entity, int count) {
        for (ProjectModelEntity parent = entity.getParentEntity(); parent != null; parent = parent.getParentEntity()) {
            Object object;
            void $this$getOrPut$iv;
            Map map = this.errors;
            ProjectModelEntityReference key$iv = ProjectModelEntityExtensionsKt.toReference(parent);
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                EntityErrorData answer$iv = new EntityErrorData();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            EntityErrorData errorData = (EntityErrorData)object;
            errorData.setChildrenErrors(errorData.getChildrenErrors() + count);
        }
    }

    private final void removeErrorMark(ProjectModelEntity entity) {
        EntityErrorData entityErrorData = this.errors.remove(ProjectModelEntityExtensionsKt.toReference(entity));
        if (entityErrorData == null) {
            return;
        }
        EntityErrorData errorData = entityErrorData;
        int count = errorData.getTotalErrors();
        if (count == 0) {
            return;
        }
        this.removeErrorMarkForParents(entity, count);
    }

    private final void removeErrorMarkForParents(ProjectModelEntity entity, int count) {
        for (ProjectModelEntity parent = entity.getParentEntity(); parent != null; parent = parent.getParentEntity()) {
            EntityErrorData errorData = this.errors.get(ProjectModelEntityExtensionsKt.toReference(parent));
            if (errorData == null) continue;
            EntityErrorData entityErrorData = errorData;
            entityErrorData.setChildrenErrors(entityErrorData.getChildrenErrors() - count);
        }
    }

    private static final void alarm$lambda$0(WorkspaceEntityErrorsSupport this$0) {
        this$0.performUpdate();
    }

    private static final void _init_$lambda$0(WorkspaceEntityErrorsSupport this$0) {
        if (this$0.project.isDisposed()) {
            return;
        }
        SolutionAnalysisHost solutionAnalysisHost = SolutionAnalysisHost.Companion.getInstance(this$0.project);
        solutionAnalysisHost.getErrorsRegistered().advise(this$0.getServiceLifetime(), arg_0 -> WorkspaceEntityErrorsSupport.lambda$0$0(this$0, arg_0));
        solutionAnalysisHost.getErrorsUnregistered().advise(this$0.getServiceLifetime(), arg_0 -> WorkspaceEntityErrorsSupport.lambda$0$1(this$0, arg_0));
        WorkspaceModelChangeListener listener2 = new WorkspaceModelChangeListener(this$0){
            final /* synthetic */ WorkspaceEntityErrorsSupport this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void changed(VersionedStorageChange event) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                HashMap hashMap = WorkspaceEntityErrorsSupport.access$getErrors$p(this.this$0);
                Object object2 = this.this$0;
                Object object3 = hashMap;
                synchronized (object3) {
                    boolean bl = false;
                    if (WorkspaceEntityErrorsSupport.access$getErrors$p(object2).isEmpty()) {
                        return;
                    }
                    object = Unit.INSTANCE;
                }
                List changes = event.getChanges(ProjectModelEntity.class);
                if (!CollectionsKt.any((Iterable)changes)) {
                    return;
                }
                object2 = WorkspaceEntityErrorsSupport.access$getErrors$p(this.this$0);
                object3 = this.this$0;
                object = object2;
                synchronized (object) {
                    boolean bl = false;
                    for (EntityChange change : changes) {
                        if (change instanceof EntityChange.Removed) {
                            WorkspaceEntityErrorsSupport.access$removeErrorMark((WorkspaceEntityErrorsSupport)((Object)object3), (ProjectModelEntity)((EntityChange.Removed)change).getOldEntity());
                        }
                        if (!(change instanceof EntityChange.Replaced)) continue;
                        ProjectModelEntityReference reference = ProjectModelEntityExtensionsKt.toReference((ProjectModelEntity)((EntityChange.Replaced)change).getOldEntity());
                        EntityErrorData errorData = (EntityErrorData)WorkspaceEntityErrorsSupport.access$getErrors$p((WorkspaceEntityErrorsSupport)((Object)object3)).get(reference);
                        if (errorData == null || errorData.getTotalErrors() <= 0) continue;
                        WorkspaceEntityErrorsSupport.access$removeErrorMarkForParents((WorkspaceEntityErrorsSupport)((Object)object3), (ProjectModelEntity)((EntityChange.Replaced)change).getOldEntity(), errorData.getTotalErrors());
                        WorkspaceEntityErrorsSupport.access$addErrorMarkForParents((WorkspaceEntityErrorsSupport)((Object)object3), (ProjectModelEntity)((EntityChange.Replaced)change).getNewEntity(), errorData.getTotalErrors());
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
        };
        this$0.project.getMessageBus().connect((Disposable)this$0).subscribe(WorkspaceModelTopics.CHANGED, (Object)listener2);
    }

    private static final Unit lambda$0$0(WorkspaceEntityErrorsSupport this$0, int it) {
        ApplicationKt.getApplication().assertIsDispatchThread();
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Register error for " + it + "...");
        }
        this$0.queue.add(new Event(it, EventType.Add));
        SingleAlarm.cancelAndRequest$default((SingleAlarm)this$0.alarm, (boolean)false, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$1(WorkspaceEntityErrorsSupport this$0, int it) {
        ApplicationKt.getApplication().assertIsDispatchThread();
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Unregister error for " + it + "...");
        }
        this$0.queue.add(new Event(it, EventType.Remove));
        SingleAlarm.cancelAndRequest$default((SingleAlarm)this$0.alarm, (boolean)false, (int)1, null);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit performUpdate$lambda$0(WorkspaceEntityErrorsSupport this$0) {
        if (this$0.queue.isEmpty()) {
            return Unit.INSTANCE;
        }
        HashMap<ProjectModelEntityReference, EntityErrorData> hashMap = this$0.errors;
        synchronized (hashMap) {
            boolean $i$a$-synchronized-WorkspaceEntityErrorsSupport$performUpdate$1$22 = false;
            block7: for (Event event : this$0.queue) {
                ProjectModelEntity entity;
                if (WorkspaceModelExtensionsKt.getProjectModelEntity(this$0.workspaceModel, event.getId()) == null) continue;
                Logger $this$trace$iv = logger;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("Update " + event.getId() + " " + entity.getName());
                }
                switch (WhenMappings.$EnumSwitchMapping$0[event.getEventType().ordinal()]) {
                    case 1: {
                        this$0.addErrorMark(entity);
                        continue block7;
                    }
                    case 2: {
                        this$0.removeErrorMark(entity);
                        continue block7;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            this$0.queue.clear();
            Unit $i$a$-synchronized-WorkspaceEntityErrorsSupport$performUpdate$1$22 = Unit.INSTANCE;
        }
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Errors were updated");
        }
        ProjectModelViewUpdaterAsync.Companion.getInstance(this$0.project).requestUpdatePresentation();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ HashMap access$getErrors$p(WorkspaceEntityErrorsSupport $this) {
        return $this.errors;
    }

    public static final /* synthetic */ void access$removeErrorMark(WorkspaceEntityErrorsSupport $this, ProjectModelEntity entity) {
        $this.removeErrorMark(entity);
    }

    public static final /* synthetic */ void access$removeErrorMarkForParents(WorkspaceEntityErrorsSupport $this, ProjectModelEntity entity, int count) {
        $this.removeErrorMarkForParents(entity, count);
    }

    public static final /* synthetic */ void access$addErrorMarkForParents(WorkspaceEntityErrorsSupport $this, ProjectModelEntity entity, int count) {
        $this.addErrorMarkForParents(entity, count);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WorkspaceEntityErrorsSupport.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        WorkspaceEntityErrorsSupport.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityErrorsSupport$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityErrorsSupport;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WorkspaceEntityErrorsSupport getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(WorkspaceEntityErrorsSupport.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (WorkspaceEntityErrorsSupport)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\r\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityErrorsSupport$EntityErrorData;", "", "<init>", "()V", "hasErrors", "", "getHasErrors", "()Z", "setHasErrors", "(Z)V", "childrenErrors", "", "getChildrenErrors", "()I", "setChildrenErrors", "(I)V", "totalErrors", "getTotalErrors", "intellij.rider.rdclient.dotnet"})
    private static final class EntityErrorData {
        private boolean hasErrors;
        private int childrenErrors;

        public final boolean getHasErrors() {
            return this.hasErrors;
        }

        public final void setHasErrors(boolean bl) {
            this.hasErrors = bl;
        }

        public final int getChildrenErrors() {
            return this.childrenErrors;
        }

        public final void setChildrenErrors(int n) {
            this.childrenErrors = n;
        }

        public final int getTotalErrors() {
            return this.childrenErrors + (this.hasErrors ? 1 : 0);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityErrorsSupport$Event;", "", "id", "", "eventType", "Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityErrorsSupport$EventType;", "<init>", "(ILcom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityErrorsSupport$EventType;)V", "getId", "()I", "getEventType", "()Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityErrorsSupport$EventType;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.rider.rdclient.dotnet"})
    private static final class Event {
        private final int id;
        @NotNull
        private final EventType eventType;

        public Event(int id, @NotNull EventType eventType) {
            Intrinsics.checkNotNullParameter((Object)((Object)eventType), (String)"eventType");
            this.id = id;
            this.eventType = eventType;
        }

        public final int getId() {
            return this.id;
        }

        @NotNull
        public final EventType getEventType() {
            return this.eventType;
        }

        public final int component1() {
            return this.id;
        }

        @NotNull
        public final EventType component2() {
            return this.eventType;
        }

        @NotNull
        public final Event copy(int id, @NotNull EventType eventType) {
            Intrinsics.checkNotNullParameter((Object)((Object)eventType), (String)"eventType");
            return new Event(id, eventType);
        }

        public static /* synthetic */ Event copy$default(Event event, int n, EventType eventType, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = event.id;
            }
            if ((n2 & 2) != 0) {
                eventType = event.eventType;
            }
            return event.copy(n, eventType);
        }

        @NotNull
        public String toString() {
            return "Event(id=" + this.id + ", eventType=" + this.eventType + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.id);
            result2 = result2 * 31 + this.eventType.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Event)) {
                return false;
            }
            Event event = (Event)other;
            if (this.id != event.id) {
                return false;
            }
            return this.eventType == event.eventType;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceEntityErrorsSupport$EventType;", "", "<init>", "(Ljava/lang/String;I)V", "Add", "Remove", "intellij.rider.rdclient.dotnet"})
    private static final class EventType
    extends Enum<EventType> {
        public static final /* enum */ EventType Add = new EventType();
        public static final /* enum */ EventType Remove = new EventType();
        private static final /* synthetic */ EventType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static EventType[] values() {
            return (EventType[])$VALUES.clone();
        }

        public static EventType valueOf(String value) {
            return Enum.valueOf(EventType.class, value);
        }

        @NotNull
        public static EnumEntries<EventType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = eventTypeArray = new EventType[]{EventType.Add, EventType.Remove};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EventType.values().length];
            try {
                nArray[EventType.Add.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventType.Remove.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

