/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.workspace;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.EntityPointer;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.workspaceModel.ide.VirtualFileUrlManagerUtil;
import com.jetbrains.rd.platform.util.DataContextKt;
import com.jetbrains.rider.editors.TextControlUtilsKt;
import com.jetbrains.rider.model.RdAnalyzerReferenceDescriptor;
import com.jetbrains.rider.model.RdArtifactReferenceDescriptor;
import com.jetbrains.rider.model.RdAssemblyReferenceDescriptor;
import com.jetbrains.rider.model.RdCustomLocation;
import com.jetbrains.rider.model.RdDependencyDescriptor;
import com.jetbrains.rider.model.RdDependencyFolderDescriptor;
import com.jetbrains.rider.model.RdDependencyFolderDescriptorType;
import com.jetbrains.rider.model.RdDependencyType;
import com.jetbrains.rider.model.RdImportDescriptor;
import com.jetbrains.rider.model.RdImportFolderDescriptor;
import com.jetbrains.rider.model.RdProjectDescriptor;
import com.jetbrains.rider.model.RdProjectFileDescriptor;
import com.jetbrains.rider.model.RdProjectFolderDescriptor;
import com.jetbrains.rider.model.RdProjectModelItemDescriptor;
import com.jetbrains.rider.model.RdProjectReferenceDescriptor;
import com.jetbrains.rider.model.RdProjectType;
import com.jetbrains.rider.model.RdRoslynAnalyzerDiagnosticDescriptor;
import com.jetbrains.rider.model.RdSolutionDescriptor;
import com.jetbrains.rider.model.RdSolutionFolderDescriptor;
import com.jetbrains.rider.model.RdSourceGeneratorFileDescriptor;
import com.jetbrains.rider.model.RdSourceGeneratorFolderDescriptor;
import com.jetbrains.rider.model.RdSqlCmdVariableDescriptor;
import com.jetbrains.rider.model.RdTargetFrameworkFolderDescriptor;
import com.jetbrains.rider.model.RdUnloadProjectDescriptor;
import com.jetbrains.rider.model.RdUnloadProjectState;
import com.jetbrains.rider.model.RdUnresolvedReferenceDescriptor;
import com.jetbrains.rider.model.RdWebReferenceDescriptor;
import com.jetbrains.rider.model.RdWebReferenceDescriptorType;
import com.jetbrains.rider.projectView.ProjectModelDataKeys;
import com.jetbrains.rider.projectView.nodes.ProjectModelNodeExtensionKt;
import com.jetbrains.rider.projectView.workspace.ListNodeData;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityReference;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import com.jetbrains.rider.util.idea.DataContextExKt;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u009c\u0001\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u001a\u001a\u0019\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u001a\u0012\u0010\u0006\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\b\u001a\u00020\t*\u00020\u0002\u001a\f\u0010\n\u001a\u0004\u0018\u00010\u0002*\u00020\u0002\u001a\f\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\u0002\u001a\u0014\u0010\r\u001a\u0004\u0018\u00010\u0002*\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u000f\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0002\u001a\u0010\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012*\u00020\u0002\u001a\u0010\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012*\u00020\u0002\u001a2\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00022\u0016\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0018j\b\u0012\u0004\u0012\u00020\u0002`\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u0007H\u0002\u001a\f\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u0002\u001a\n\u0010\u001d\u001a\u00020\u0007*\u00020\u0002\u001a\f\u0010\u001e\u001a\u0004\u0018\u00010\u000e*\u00020\u0002\u001a\u0014\u0010\u001f\u001a\u0004\u0018\u00010 *\u00020\u00022\u0006\u0010!\u001a\u00020\"\u001a\u0012\u0010#\u001a\u00020\u0007*\u00020\u00022\u0006\u0010$\u001a\u00020 \u001a\u0011\u0010%\u001a\u0004\u0018\u00010\u0007*\u00020\u0002\u00a2\u0006\u0002\u0010&\u001a\f\u0010'\u001a\u0004\u0018\u00010\u000e*\u00020\u0002\u001a\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u0012*\b\u0012\u0004\u0012\u00020)0*\u001a\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012*\b\u0012\u0004\u0012\u00020\u000e0*\u001a\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012*\b\u0012\u0004\u0012\u00020\u00020*\u001a4\u0010-\u001a\b\u0012\u0004\u0012\u0002H.0\u0012\"\u0004\b\u0000\u0010.*\b\u0012\u0004\u0012\u0002H.0*2\u0014\u0010/\u001a\u0010\u0012\u0004\u0012\u0002H.\u0012\u0006\u0012\u0004\u0018\u0001H.00H\u0002\u001a\u001a\u00101\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\u0018j\b\u0012\u0004\u0012\u00020\u000e`\u0019*\u00020\u0002\u001a*\u00102\u001a\u00020\u0015*\u00020\u00022\u0016\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\u0018j\b\u0012\u0004\u0012\u00020\u000e`\u00192\u0006\u00103\u001a\u00020\u0007\u001a\f\u00104\u001a\u0004\u0018\u00010\u0002*\u000205\u001a\u001a\u00106\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012*\u0002072\b\b\u0002\u00108\u001a\u00020\u0007\u001a\u0016\u00109\u001a\u0004\u0018\u00010\u0002*\u0002072\b\b\u0002\u00108\u001a\u00020\u0007\u001a\u0012\u0010:\u001a\u00020\u0007*\u00020;2\u0006\u0010<\u001a\u00020\u0001\u001a\n\u0010:\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010=\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010>\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010?\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010@\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010A\u001a\u00020\u0007*\u00020\u0002\u001a$\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\f0C*\b\u0012\u0004\u0012\u00020\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010D\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010E\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010F\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010G\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010H\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010I\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010J\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010K\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010L\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010M\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010N\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010O\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010P\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010Q\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010R\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010S\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010T\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010U\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010V\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010W\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010X\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010Y\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010Z\u001a\u00020\u0007*\u00020\u0002\u001a\f\u0010[\u001a\u0004\u0018\u00010\\*\u00020\u0002\u001a\n\u0010]\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010^\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010_\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010`\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010a\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010b\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010c\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010d\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010e\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010f\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010g\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010h\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010i\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010j\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010k\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010l\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010m\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010n\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010o\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010p\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010q\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010r\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010s\u001a\u00020\u0007*\u00020\u0002\u001a\"\u0010t\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0014\u0010u\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u000700\u00a8\u0006v"}, d2={"getId", "", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;Lcom/intellij/openapi/project/Project;)Ljava/lang/Integer;", "isConnectedToBackend", "", "toReference", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntityReference;", "containingProjectEntity", "containingTargetFrameworkId", "", "containingEntity", "Lcom/intellij/openapi/vfs/VirtualFile;", "isParentOf", "child", "getAllChildrenAndThis", "", "getAllNestedFilesAndThis", "collectAllChildrenAndThis", "", "entity", "set", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "onlyNestedFiles", "getFile", "Ljava/io/File;", "isDirectory", "getVirtualFileAsContentRoot", "getContentRootUrl", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "manager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "isLinkedFolderOutsideProjectFolder", "url", "isDirectoryAwareEntity", "(Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;)Ljava/lang/Boolean;", "getVirtualFileAsParent", "getRootPaths", "Ljava/nio/file/Path;", "", "getRootVirtualFiles", "getRootEntities", "getRootsInternal", "T", "getParent", "Lkotlin/Function1;", "getAffectedVirtualFiles", "fillAffectedVirtualFilesRecursive", "withInternalItems", "findProjectModelEntity", "Lcom/intellij/psi/PsiDirectory;", "getProjectModelEntities", "Lcom/intellij/openapi/actionSystem/DataContext;", "takeNodeFromEditor", "getProjectModelEntity", "isFromSharedProject", "Lcom/intellij/platform/backend/workspace/WorkspaceModel;", "id", "isFromVcxProject", "isFromSqlProject", "isLinkedProjectFile", "isLinkedProjectFolder", "isLinkedItem", "withUniqueNames", "", "isSolution", "isExistingSolution", "isVirtualSolution", "isSolutionFolder", "isProject", "isUnloadedProject", "isFilteredProject", "isProjectFile", "isProjectFolder", "isProjectReference", "isAssemblyReference", "isReference", "isWebReference", "isWebReferenceItem", "isUnresolvedReference", "isAnalyzerReference", "isArtifactReference", "isImportFolder", "isImportItem", "isSourceGeneratorFolder", "isSourceGeneratorFile", "isTargetFrameworkFolder", "isRoslynAnalyzerDiagnostic", "asRoslynAnalyzerDiagnostic", "Lcom/jetbrains/rider/model/RdRoslynAnalyzerDiagnosticDescriptor;", "isSqlCmdVariable", "isDependency", "isDependencyReference", "isDependencyPackage", "isDependencyProjectReference", "isAnyDependencyFolder", "isDependenciesFolder", "isWebReferenceFolder", "isFrameworkReferencesFolder", "isAssembliesFolder", "isImplicitAssembliesFolder", "isProjectsFolder", "isDatabasesFolder", "isSqlCmdVariablesFolder", "isSDKFolder", "isAnalyzersFolder", "isSourceGeneratorsFolder", "isPackagesFolder", "isXcAssetsFolder", "isXcAssetItemFolder", "isHiddenInSolutionFilter", "isSqlProject", "isLegacySqlProject", "findParent", "condition", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nProjectModelEntityExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectModelEntityExtensions.kt\ncom/jetbrains/rider/projectView/workspace/ProjectModelEntityExtensionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,458:1\n827#2:459\n855#2,2:460\n1740#2,3:481\n382#3,7:462\n382#3,7:469\n126#4:476\n153#4,3:477\n1#5:480\n*S KotlinDebug\n*F\n+ 1 ProjectModelEntityExtensions.kt\ncom/jetbrains/rider/projectView/workspace/ProjectModelEntityExtensionsKt\n*L\n200#1:459\n200#1:460,2\n434#1:481,3\n279#1:462,7\n301#1:469,7\n313#1:476\n313#1:477,3\n*E\n"})
public final class ProjectModelEntityExtensionsKt {
    @Nullable
    public static final Integer getId(@NotNull ProjectModelEntity $this$getId, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$getId, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return WorkspaceModelExtensionsKt.getProjectModelId(WorkspaceModel.Companion.getInstance(project), $this$getId);
    }

    public static final boolean isConnectedToBackend(@NotNull ProjectModelEntity $this$isConnectedToBackend, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$isConnectedToBackend, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Integer id = ProjectModelEntityExtensionsKt.getId($this$isConnectedToBackend, project);
        return id != null && id > 0;
    }

    @NotNull
    public static final ProjectModelEntityReference toReference(@NotNull ProjectModelEntity $this$toReference) {
        Intrinsics.checkNotNullParameter((Object)$this$toReference, (String)"<this>");
        return new ProjectModelEntityReference((EntityPointer<? extends ProjectModelEntity>)$this$toReference.createPointer());
    }

    @Nullable
    public static final ProjectModelEntity containingProjectEntity(@NotNull ProjectModelEntity $this$containingProjectEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$containingProjectEntity, (String)"<this>");
        if (ProjectModelEntityExtensionsKt.isProject($this$containingProjectEntity) || ProjectModelEntityExtensionsKt.isUnloadedProject($this$containingProjectEntity)) {
            return $this$containingProjectEntity;
        }
        ProjectModelEntity projectModelEntity = $this$containingProjectEntity.getParentEntity();
        if (projectModelEntity == null) {
            return null;
        }
        ProjectModelEntity parent = projectModelEntity;
        return ProjectModelEntityExtensionsKt.containingProjectEntity(parent);
    }

    @Nullable
    public static final String containingTargetFrameworkId(@NotNull ProjectModelEntity $this$containingTargetFrameworkId) {
        Intrinsics.checkNotNullParameter((Object)$this$containingTargetFrameworkId, (String)"<this>");
        RdProjectModelItemDescriptor descriptor = $this$containingTargetFrameworkId.getDescriptor();
        if (descriptor instanceof RdTargetFrameworkFolderDescriptor) {
            return ((RdTargetFrameworkFolderDescriptor)descriptor).getTargetFrameworkId();
        }
        if (ProjectModelEntityExtensionsKt.isProject($this$containingTargetFrameworkId) || ProjectModelEntityExtensionsKt.isUnloadedProject($this$containingTargetFrameworkId)) {
            return null;
        }
        ProjectModelEntity projectModelEntity = $this$containingTargetFrameworkId.getParentEntity();
        if (projectModelEntity == null) {
            return null;
        }
        ProjectModelEntity parent = projectModelEntity;
        return ProjectModelEntityExtensionsKt.containingTargetFrameworkId(parent);
    }

    @Nullable
    public static final ProjectModelEntity containingEntity(@NotNull VirtualFile $this$containingEntity, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$containingEntity, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(project);
        VirtualFile currentVirtualFile = $this$containingEntity;
        while (currentVirtualFile.getParent() != null) {
            List<ProjectModelEntity> entities = WorkspaceModelExtensionsKt.getProjectModelEntities(workspaceModel, currentVirtualFile, project);
            if (CollectionsKt.any((Iterable)entities)) {
                return ProjectModelEntityExtensionsKt.containingProjectEntity((ProjectModelEntity)CollectionsKt.first(entities));
            }
            Intrinsics.checkNotNullExpressionValue((Object)currentVirtualFile.getParent(), (String)"getParent(...)");
        }
        return null;
    }

    public static final boolean isParentOf(@NotNull ProjectModelEntity $this$isParentOf, @NotNull ProjectModelEntity child) {
        Intrinsics.checkNotNullParameter((Object)$this$isParentOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        ProjectModelEntity childParent = child.getParentEntity();
        if (Intrinsics.areEqual((Object)childParent, (Object)$this$isParentOf)) {
            return true;
        }
        if (childParent == null) {
            return false;
        }
        return ProjectModelEntityExtensionsKt.isParentOf($this$isParentOf, childParent);
    }

    @NotNull
    public static final List<ProjectModelEntity> getAllChildrenAndThis(@NotNull ProjectModelEntity $this$getAllChildrenAndThis) {
        Intrinsics.checkNotNullParameter((Object)$this$getAllChildrenAndThis, (String)"<this>");
        HashSet set = new HashSet();
        ProjectModelEntityExtensionsKt.collectAllChildrenAndThis$default($this$getAllChildrenAndThis, set, false, 4, null);
        return CollectionsKt.toList((Iterable)set);
    }

    @NotNull
    public static final List<ProjectModelEntity> getAllNestedFilesAndThis(@NotNull ProjectModelEntity $this$getAllNestedFilesAndThis) {
        Intrinsics.checkNotNullParameter((Object)$this$getAllNestedFilesAndThis, (String)"<this>");
        HashSet<ProjectModelEntity> set = new HashSet<ProjectModelEntity>();
        ProjectModelEntityExtensionsKt.collectAllChildrenAndThis($this$getAllNestedFilesAndThis, set, true);
        return CollectionsKt.toList((Iterable)set);
    }

    private static final void collectAllChildrenAndThis(ProjectModelEntity entity, HashSet<ProjectModelEntity> set, boolean onlyNestedFiles) {
        set.add(entity);
        if (!onlyNestedFiles || ProjectModelEntityExtensionsKt.isProjectFile(entity)) {
            for (ProjectModelEntity child : entity.getChildrenEntities()) {
                ProjectModelEntityExtensionsKt.collectAllChildrenAndThis(child, set, onlyNestedFiles);
            }
        }
    }

    static /* synthetic */ void collectAllChildrenAndThis$default(ProjectModelEntity projectModelEntity, HashSet hashSet, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        ProjectModelEntityExtensionsKt.collectAllChildrenAndThis(projectModelEntity, hashSet, bl);
    }

    @Nullable
    public static final File getFile(@NotNull ProjectModelEntity $this$getFile) {
        Intrinsics.checkNotNullParameter((Object)$this$getFile, (String)"<this>");
        Object object = $this$getFile.getUrl();
        return object != null && (object = VirtualFileUrlManagerUtil.toPath((VirtualFileUrl)object)) != null ? object.toFile() : null;
    }

    public static final boolean isDirectory(@NotNull ProjectModelEntity $this$isDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$isDirectory, (String)"<this>");
        RdProjectModelItemDescriptor descriptor = $this$isDirectory.getDescriptor();
        return descriptor instanceof RdProjectFolderDescriptor ? true : (descriptor instanceof RdSolutionFolderDescriptor ? true : (descriptor instanceof RdWebReferenceDescriptor ? true : (descriptor instanceof RdProjectDescriptor ? ((RdProjectDescriptor)descriptor).getDirectoryBased() : (descriptor instanceof RdUnloadProjectDescriptor ? ((RdUnloadProjectDescriptor)descriptor).getDirectoryBased() : (descriptor instanceof RdSolutionDescriptor ? ((RdSolutionDescriptor)descriptor).isVirtual() : false)))));
    }

    @Nullable
    public static final VirtualFile getVirtualFileAsContentRoot(@NotNull ProjectModelEntity $this$getVirtualFileAsContentRoot) {
        VirtualFile virtualFile;
        String baseDirectory;
        Intrinsics.checkNotNullParameter((Object)$this$getVirtualFileAsContentRoot, (String)"<this>");
        VirtualFileUrl virtualFileUrl = $this$getVirtualFileAsContentRoot.getUrl();
        if (virtualFileUrl == null || (virtualFileUrl = VirtualFileUrls.getVirtualFile((VirtualFileUrl)virtualFileUrl)) == null) {
            return null;
        }
        VirtualFileUrl virtualFile2 = virtualFileUrl;
        RdProjectModelItemDescriptor descriptor = $this$getVirtualFileAsContentRoot.getDescriptor();
        if (descriptor instanceof RdProjectDescriptor && (baseDirectory = ((RdProjectDescriptor)descriptor).getBaseDirectory()) != null) {
            return VfsUtil.findFileByIoFile((File)new File(baseDirectory), (boolean)false);
        }
        Boolean bl = ProjectModelEntityExtensionsKt.isDirectoryAwareEntity($this$getVirtualFileAsContentRoot);
        if (Intrinsics.areEqual((Object)bl, (Object)true)) {
            virtualFile = virtualFile2.getParent();
        } else if (Intrinsics.areEqual((Object)bl, (Object)false)) {
            virtualFile = virtualFile2;
        } else if (bl == null) {
            virtualFile = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return virtualFile;
    }

    @Nullable
    public static final VirtualFileUrl getContentRootUrl(@NotNull ProjectModelEntity $this$getContentRootUrl, @NotNull VirtualFileUrlManager manager) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$getContentRootUrl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        VirtualFileUrl virtualFileUrl = $this$getContentRootUrl.getUrl();
        if (virtualFileUrl == null) {
            return null;
        }
        VirtualFileUrl url2 = virtualFileUrl;
        RdProjectModelItemDescriptor descriptor = $this$getContentRootUrl.getDescriptor();
        if (descriptor instanceof RdSolutionDescriptor) {
            object = ((RdSolutionDescriptor)descriptor).isVirtual() ? url2 : url2.getParent();
        } else if (descriptor instanceof RdProjectDescriptor) {
            String baseDirectory;
            String string = baseDirectory = ((RdProjectDescriptor)descriptor).getBaseDirectory();
            object = string != null ? manager.getOrCreateFromUrl(string) : (((RdProjectDescriptor)descriptor).getDirectoryBased() ? url2 : url2.getParent());
        } else {
            object = descriptor instanceof RdUnloadProjectDescriptor ? (((RdUnloadProjectDescriptor)descriptor).getDirectoryBased() ? url2 : url2.getParent()) : (descriptor instanceof RdProjectFolderDescriptor ? (ProjectModelEntityExtensionsKt.isLinkedFolderOutsideProjectFolder($this$getContentRootUrl, url2) ? url2 : null) : null);
        }
        return object;
    }

    public static final boolean isLinkedFolderOutsideProjectFolder(@NotNull ProjectModelEntity $this$isLinkedFolderOutsideProjectFolder, @NotNull VirtualFileUrl url2) {
        Intrinsics.checkNotNullParameter((Object)$this$isLinkedFolderOutsideProjectFolder, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        if (!ProjectModelEntityExtensionsKt.isLinkedItem($this$isLinkedFolderOutsideProjectFolder)) {
            return false;
        }
        ProjectModelEntity projectModelEntity = ProjectModelEntityExtensionsKt.containingProjectEntity($this$isLinkedFolderOutsideProjectFolder);
        if (projectModelEntity == null) {
            return false;
        }
        ProjectModelEntity projectDescriptorEntity = projectModelEntity;
        VirtualFile virtualFile = ProjectModelEntityExtensionsKt.getVirtualFileAsParent(projectDescriptorEntity);
        if (virtualFile == null) {
            return false;
        }
        VirtualFile projectDirectory = virtualFile;
        VirtualFile virtualFile2 = VirtualFileUrls.getVirtualFile((VirtualFileUrl)url2);
        if (virtualFile2 == null) {
            return false;
        }
        VirtualFile virtualFile3 = virtualFile2;
        return !VfsUtil.isAncestor((VirtualFile)projectDirectory, (VirtualFile)virtualFile3, (boolean)true);
    }

    @Nullable
    public static final Boolean isDirectoryAwareEntity(@NotNull ProjectModelEntity $this$isDirectoryAwareEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$isDirectoryAwareEntity, (String)"<this>");
        return ProjectModelNodeExtensionKt.isDirectoryAware($this$isDirectoryAwareEntity.getDescriptor());
    }

    @Nullable
    public static final VirtualFile getVirtualFileAsParent(@NotNull ProjectModelEntity $this$getVirtualFileAsParent) {
        Intrinsics.checkNotNullParameter((Object)$this$getVirtualFileAsParent, (String)"<this>");
        VirtualFile virtualFile = ProjectModelEntityExtensionsKt.getVirtualFileAsContentRoot($this$getVirtualFileAsParent);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        if (virtualFile2.isDirectory()) {
            return virtualFile2;
        }
        return virtualFile2.getParent();
    }

    @NotNull
    public static final List<Path> getRootPaths(@NotNull Collection<? extends Path> $this$getRootPaths) {
        Intrinsics.checkNotNullParameter($this$getRootPaths, (String)"<this>");
        return ProjectModelEntityExtensionsKt.getRootsInternal($this$getRootPaths, ProjectModelEntityExtensionsKt::getRootPaths$lambda$0);
    }

    @NotNull
    public static final List<VirtualFile> getRootVirtualFiles(@NotNull Collection<? extends VirtualFile> $this$getRootVirtualFiles) {
        Intrinsics.checkNotNullParameter($this$getRootVirtualFiles, (String)"<this>");
        return ProjectModelEntityExtensionsKt.getRootsInternal($this$getRootVirtualFiles, ProjectModelEntityExtensionsKt::getRootVirtualFiles$lambda$0);
    }

    @NotNull
    public static final List<ProjectModelEntity> getRootEntities(@NotNull Collection<? extends ProjectModelEntity> $this$getRootEntities) {
        Intrinsics.checkNotNullParameter($this$getRootEntities, (String)"<this>");
        return ProjectModelEntityExtensionsKt.getRootsInternal($this$getRootEntities, ProjectModelEntityExtensionsKt::getRootEntities$lambda$0);
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> List<T> getRootsInternal(Collection<? extends T> $this$getRootsInternal, Function1<? super T, ? extends T> getParent) {
        void $this$filterNotTo$iv$iv;
        Object currentItem;
        HashSet<T> toRemove = new HashSet<T>();
        HashSet hashSet = CollectionsKt.toHashSet((Iterable)$this$getRootsInternal);
        block0: for (T thisItem : $this$getRootsInternal) {
            currentItem = getParent.invoke(thisItem);
            while (currentItem != null) {
                if (hashSet.contains(currentItem)) {
                    toRemove.add(thisItem);
                    continue block0;
                }
                currentItem = getParent.invoke(currentItem);
            }
        }
        Iterable $this$filterNot$iv = $this$getRootsInternal;
        boolean $i$f$filterNot = false;
        currentItem = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        Iterator iterator2 = $this$filterNotTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv;
            Object it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (toRemove.contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final HashSet<VirtualFile> getAffectedVirtualFiles(@NotNull ProjectModelEntity $this$getAffectedVirtualFiles) {
        Intrinsics.checkNotNullParameter((Object)$this$getAffectedVirtualFiles, (String)"<this>");
        VirtualFileUrl virtualFileUrl = $this$getAffectedVirtualFiles.getUrl();
        if (virtualFileUrl == null || (virtualFileUrl = VirtualFileUrls.getVirtualFile((VirtualFileUrl)virtualFileUrl)) == null) {
            return new HashSet<VirtualFile>();
        }
        VirtualFileUrl virtualFile = virtualFileUrl;
        if (Intrinsics.areEqual((Object)ProjectModelEntityExtensionsKt.isDirectoryAwareEntity($this$getAffectedVirtualFiles), (Object)true)) {
            Object[] objectArray = new VirtualFile[2];
            objectArray[0] = virtualFile;
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile.getParent(), (String)"getParent(...)");
            return SetsKt.hashSetOf((Object[])objectArray);
        }
        Object[] objectArray = new VirtualFile[]{virtualFile};
        return SetsKt.hashSetOf((Object[])objectArray);
    }

    public static final void fillAffectedVirtualFilesRecursive(@NotNull ProjectModelEntity $this$fillAffectedVirtualFilesRecursive, @NotNull HashSet<VirtualFile> set, boolean withInternalItems) {
        Intrinsics.checkNotNullParameter((Object)$this$fillAffectedVirtualFilesRecursive, (String)"<this>");
        Intrinsics.checkNotNullParameter(set, (String)"set");
        set.addAll((Collection<VirtualFile>)ProjectModelEntityExtensionsKt.getAffectedVirtualFiles($this$fillAffectedVirtualFilesRecursive));
        if (ProjectModelEntityExtensionsKt.isProjectFile($this$fillAffectedVirtualFilesRecursive)) {
            for (ProjectModelEntity child : $this$fillAffectedVirtualFilesRecursive.getChildrenEntities()) {
                ProjectModelEntityExtensionsKt.fillAffectedVirtualFilesRecursive(child, set, withInternalItems);
            }
        }
    }

    @Nullable
    public static final ProjectModelEntity findProjectModelEntity(@NotNull PsiDirectory $this$findProjectModelEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$findProjectModelEntity, (String)"<this>");
        Project project = $this$findProjectModelEntity.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(project);
        VirtualFile virtualFile = $this$findProjectModelEntity.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        Project project2 = $this$findProjectModelEntity.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        ProjectModelEntity entity = (ProjectModelEntity)CollectionsKt.singleOrNull(WorkspaceModelExtensionsKt.getProjectModelEntities(workspaceModel, virtualFile, project2));
        if (entity != null && ProjectModelEntityExtensionsKt.isVirtualSolution(entity)) {
            return null;
        }
        return entity;
    }

    @NotNull
    public static final List<ProjectModelEntity> getProjectModelEntities(@NotNull DataContext $this$getProjectModelEntities, boolean takeNodeFromEditor) {
        Object[] entities;
        Intrinsics.checkNotNullParameter((Object)$this$getProjectModelEntities, (String)"<this>");
        Object[] objectArray = (ProjectModelEntity[])ProjectModelDataKeys.INSTANCE.getPROJECT_MODEL_ENTITY_ARRAY().getData($this$getProjectModelEntities);
        if (objectArray == null) {
            objectArray = new ProjectModelEntity[]{};
        }
        if ((entities = objectArray).length == 0 && takeNodeFromEditor) {
            Integer entityId;
            Project project = DataContextKt.getProject((DataContext)$this$getProjectModelEntities);
            if (project == null) {
                return CollectionsKt.emptyList();
            }
            Project project2 = project;
            Editor editor = DataContextExKt.getEditor($this$getProjectModelEntities);
            Integer n = entityId = editor != null ? Integer.valueOf(TextControlUtilsKt.getProjectModelId(editor)) : null;
            if (entityId == null) {
                FileEditor fileEditor = (FileEditor)PlatformCoreDataKeys.FILE_EDITOR.getData($this$getProjectModelEntities);
                if (fileEditor == null) {
                    return CollectionsKt.emptyList();
                }
                FileEditor editor2 = fileEditor;
                WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(project2);
                VirtualFile virtualFile = editor2.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
                return WorkspaceModelExtensionsKt.getProjectModelEntities(workspaceModel, virtualFile, project2);
            }
            ProjectModelEntity projectModelEntity = WorkspaceModelExtensionsKt.getProjectModelEntity(WorkspaceModel.Companion.getInstance(project2), entityId);
            if (projectModelEntity == null) {
                return CollectionsKt.emptyList();
            }
            ProjectModelEntity entityFromEditor = projectModelEntity;
            return CollectionsKt.listOf((Object)entityFromEditor);
        }
        return ArraysKt.toList((Object[])entities);
    }

    public static /* synthetic */ List getProjectModelEntities$default(DataContext dataContext, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return ProjectModelEntityExtensionsKt.getProjectModelEntities(dataContext, bl);
    }

    @Nullable
    public static final ProjectModelEntity getProjectModelEntity(@NotNull DataContext $this$getProjectModelEntity, boolean takeNodeFromEditor) {
        Intrinsics.checkNotNullParameter((Object)$this$getProjectModelEntity, (String)"<this>");
        return (ProjectModelEntity)CollectionsKt.singleOrNull(ProjectModelEntityExtensionsKt.getProjectModelEntities($this$getProjectModelEntity, takeNodeFromEditor));
    }

    public static /* synthetic */ ProjectModelEntity getProjectModelEntity$default(DataContext dataContext, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return ProjectModelEntityExtensionsKt.getProjectModelEntity(dataContext, bl);
    }

    public static final boolean isFromSharedProject(@NotNull WorkspaceModel $this$isFromSharedProject, int id) {
        Intrinsics.checkNotNullParameter((Object)$this$isFromSharedProject, (String)"<this>");
        ProjectModelEntity projectModelEntity = WorkspaceModelExtensionsKt.getProjectModelEntity($this$isFromSharedProject, id);
        return projectModelEntity != null ? ProjectModelEntityExtensionsKt.isFromSharedProject(projectModelEntity) : false;
    }

    public static final boolean isFromSharedProject(@NotNull ProjectModelEntity $this$isFromSharedProject) {
        Intrinsics.checkNotNullParameter((Object)$this$isFromSharedProject, (String)"<this>");
        Object object = ProjectModelEntityExtensionsKt.containingProjectEntity($this$isFromSharedProject);
        return object != null && (object = object.getUrl()) != null && (object = VirtualFileUrls.getVirtualFile((VirtualFileUrl)object)) != null && (object = object.getExtension()) != null ? StringsKt.equals((String)object, (String)"shproj", (boolean)true) : false;
    }

    public static final boolean isFromVcxProject(@NotNull ProjectModelEntity $this$isFromVcxProject) {
        Intrinsics.checkNotNullParameter((Object)$this$isFromVcxProject, (String)"<this>");
        Object object = ProjectModelEntityExtensionsKt.containingProjectEntity($this$isFromVcxProject);
        return object != null && (object = object.getUrl()) != null && (object = VirtualFileUrls.getVirtualFile((VirtualFileUrl)object)) != null && (object = object.getExtension()) != null ? StringsKt.equals((String)object, (String)"vcxproj", (boolean)true) : false;
    }

    public static final boolean isFromSqlProject(@NotNull ProjectModelEntity $this$isFromSqlProject) {
        Intrinsics.checkNotNullParameter((Object)$this$isFromSqlProject, (String)"<this>");
        ProjectModelEntity projectModelEntity = ProjectModelEntityExtensionsKt.containingProjectEntity($this$isFromSqlProject);
        return projectModelEntity != null ? ProjectModelEntityExtensionsKt.isSqlProject(projectModelEntity) : false;
    }

    public static final boolean isLinkedProjectFile(@NotNull ProjectModelEntity $this$isLinkedProjectFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isLinkedProjectFile, (String)"<this>");
        return ProjectModelEntityExtensionsKt.isProjectFile($this$isLinkedProjectFile) && ProjectModelEntityExtensionsKt.isLinkedItem($this$isLinkedProjectFile);
    }

    public static final boolean isLinkedProjectFolder(@NotNull ProjectModelEntity $this$isLinkedProjectFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$isLinkedProjectFolder, (String)"<this>");
        return ProjectModelEntityExtensionsKt.isProjectFolder($this$isLinkedProjectFolder) && ProjectModelEntityExtensionsKt.isLinkedItem($this$isLinkedProjectFolder);
    }

    public static final boolean isLinkedItem(@NotNull ProjectModelEntity $this$isLinkedItem) {
        Intrinsics.checkNotNullParameter((Object)$this$isLinkedItem, (String)"<this>");
        return $this$isLinkedItem.getDescriptor().getLocation() instanceof RdCustomLocation;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<ProjectModelEntity, String> withUniqueNames(@NotNull List<? extends ProjectModelEntity> $this$withUniqueNames, @NotNull Project project) {
        void $this$mapTo$iv$iv;
        Map namesToAdd;
        boolean hasDuplicates;
        Map.Entry answer$iv;
        Iterator<Map.Entry<String, List>> $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter($this$withUniqueNames, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        HashMap result2 = new HashMap();
        for (ProjectModelEntity projectModelEntity : $this$withUniqueNames) {
            Object object;
            Map map = result2;
            String string = projectModelEntity.getName();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(string);
            if (value$iv == null) {
                boolean bl = false;
                answer$iv = new ArrayList();
                $this$getOrPut$iv.put(string, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            List list2 = (List)object;
            list2.add(new ListNodeData(projectModelEntity, projectModelEntity));
        }
        do {
            hasDuplicates = false;
            HashSet<String> hashSet = new HashSet<String>();
            namesToAdd = new HashMap();
            for (Map.Entry entry2 : ((Map)result2).entrySet()) {
                String name = (String)entry2.getKey();
                List nodes = (List)entry2.getValue();
                if (((Collection)nodes).size() == 1) continue;
                hasDuplicates = true;
                hashSet.add(name);
                for (ListNodeData listNodeData : nodes) {
                    Object object;
                    void $this$getOrPut$iv2;
                    Object object2;
                    ProjectModelEntity current = listNodeData.component1();
                    ProjectModelEntity original = listNodeData.component2();
                    ProjectModelEntity next = current.getParentEntity();
                    if (next != null) {
                        object2 = next.getName() + "/" + name;
                    } else {
                        object2 = ProjectModelEntityExtensionsKt.getId(original, project);
                        if (object2 == null || (object2 = String.valueOf((Integer)object2)) == null) {
                            object2 = "NULL/" + name;
                        }
                    }
                    Object nextName = object2;
                    Map map = namesToAdd;
                    Object key$iv2 = nextName;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv2.get(key$iv2);
                    if (value$iv == null) {
                        boolean bl = false;
                        List answer$iv2 = new ArrayList();
                        $this$getOrPut$iv2.put(key$iv2, answer$iv2);
                        object = answer$iv2;
                    } else {
                        object = value$iv;
                    }
                    List list3 = (List)object;
                    ProjectModelEntity projectModelEntity = next;
                    if (projectModelEntity == null) {
                        projectModelEntity = current;
                    }
                    list3.add(new ListNodeData(projectModelEntity, original));
                }
            }
            Iterator iterator2 = hashSet.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            $this$getOrPut$iv = iterator2;
            while ($this$getOrPut$iv.hasNext()) {
                Map.Entry entry3 = $this$getOrPut$iv.next();
                Intrinsics.checkNotNullExpressionValue(entry3, (String)"next(...)");
                String string = (String)((Object)entry3);
                result2.remove(string);
            }
            result2.putAll(namesToAdd);
        } while (hasDuplicates);
        Map $this$map$iv = result2;
        boolean bl = false;
        namesToAdd = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean bl2 = false;
        Iterator iterator3 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator3.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            answer$iv = item$iv$iv = iterator3.next();
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(new Pair((Object)((ListNodeData)CollectionsKt.single((List)((List)it.getValue()))).getOriginal(), it.getKey()));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    public static final boolean isSolution(@NotNull ProjectModelEntity $this$isSolution) {
        Intrinsics.checkNotNullParameter((Object)$this$isSolution, (String)"<this>");
        return $this$isSolution.getDescriptor() instanceof RdSolutionDescriptor;
    }

    public static final boolean isExistingSolution(@NotNull ProjectModelEntity $this$isExistingSolution) {
        Intrinsics.checkNotNullParameter((Object)$this$isExistingSolution, (String)"<this>");
        RdProjectModelItemDescriptor it = $this$isExistingSolution.getDescriptor();
        boolean bl = false;
        return it instanceof RdSolutionDescriptor && !((RdSolutionDescriptor)it).isVirtual();
    }

    public static final boolean isVirtualSolution(@NotNull ProjectModelEntity $this$isVirtualSolution) {
        Intrinsics.checkNotNullParameter((Object)$this$isVirtualSolution, (String)"<this>");
        RdProjectModelItemDescriptor it = $this$isVirtualSolution.getDescriptor();
        boolean bl = false;
        return it instanceof RdSolutionDescriptor && ((RdSolutionDescriptor)it).isVirtual();
    }

    public static final boolean isSolutionFolder(@NotNull ProjectModelEntity $this$isSolutionFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$isSolutionFolder, (String)"<this>");
        return $this$isSolutionFolder.getDescriptor() instanceof RdSolutionFolderDescriptor;
    }

    public static final boolean isProject(@NotNull ProjectModelEntity $this$isProject) {
        Intrinsics.checkNotNullParameter((Object)$this$isProject, (String)"<this>");
        return $this$isProject.getDescriptor() instanceof RdProjectDescriptor;
    }

    public static final boolean isUnloadedProject(@NotNull ProjectModelEntity $this$isUnloadedProject) {
        Intrinsics.checkNotNullParameter((Object)$this$isUnloadedProject, (String)"<this>");
        return $this$isUnloadedProject.getDescriptor() instanceof RdUnloadProjectDescriptor;
    }

    public static final boolean isFilteredProject(@NotNull ProjectModelEntity $this$isFilteredProject) {
        Intrinsics.checkNotNullParameter((Object)$this$isFilteredProject, (String)"<this>");
        RdProjectModelItemDescriptor it = $this$isFilteredProject.getDescriptor();
        boolean bl = false;
        return it instanceof RdUnloadProjectDescriptor && ((RdUnloadProjectDescriptor)it).getState() == RdUnloadProjectState.Filtered;
    }

    public static final boolean isProjectFile(@NotNull ProjectModelEntity $this$isProjectFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isProjectFile, (String)"<this>");
        return $this$isProjectFile.getDescriptor() instanceof RdProjectFileDescriptor;
    }

    public static final boolean isProjectFolder(@NotNull ProjectModelEntity $this$isProjectFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$isProjectFolder, (String)"<this>");
        return $this$isProjectFolder.getDescriptor() instanceof RdProjectFolderDescriptor;
    }

    public static final boolean isProjectReference(@NotNull ProjectModelEntity $this$isProjectReference) {
        Intrinsics.checkNotNullParameter((Object)$this$isProjectReference, (String)"<this>");
        return $this$isProjectReference.getDescriptor() instanceof RdProjectReferenceDescriptor;
    }

    public static final boolean isAssemblyReference(@NotNull ProjectModelEntity $this$isAssemblyReference) {
        Intrinsics.checkNotNullParameter((Object)$this$isAssemblyReference, (String)"<this>");
        return $this$isAssemblyReference.getDescriptor() instanceof RdAssemblyReferenceDescriptor;
    }

    public static final boolean isReference(@NotNull ProjectModelEntity $this$isReference) {
        Intrinsics.checkNotNullParameter((Object)$this$isReference, (String)"<this>");
        return ProjectModelEntityExtensionsKt.isProjectReference($this$isReference) || ProjectModelEntityExtensionsKt.isAssemblyReference($this$isReference);
    }

    public static final boolean isWebReference(@NotNull ProjectModelEntity $this$isWebReference) {
        Intrinsics.checkNotNullParameter((Object)$this$isWebReference, (String)"<this>");
        RdProjectModelItemDescriptor it = $this$isWebReference.getDescriptor();
        boolean bl = false;
        return it instanceof RdWebReferenceDescriptor && ((RdWebReferenceDescriptor)it).getType() == RdWebReferenceDescriptorType.Reference;
    }

    public static final boolean isWebReferenceItem(@NotNull ProjectModelEntity $this$isWebReferenceItem) {
        Intrinsics.checkNotNullParameter((Object)$this$isWebReferenceItem, (String)"<this>");
        RdProjectModelItemDescriptor it = $this$isWebReferenceItem.getDescriptor();
        boolean bl = false;
        return it instanceof RdWebReferenceDescriptor && ((RdWebReferenceDescriptor)it).getType() != RdWebReferenceDescriptorType.Reference;
    }

    public static final boolean isUnresolvedReference(@NotNull ProjectModelEntity $this$isUnresolvedReference) {
        Intrinsics.checkNotNullParameter((Object)$this$isUnresolvedReference, (String)"<this>");
        return $this$isUnresolvedReference.getDescriptor() instanceof RdUnresolvedReferenceDescriptor;
    }

    public static final boolean isAnalyzerReference(@NotNull ProjectModelEntity $this$isAnalyzerReference) {
        Intrinsics.checkNotNullParameter((Object)$this$isAnalyzerReference, (String)"<this>");
        return $this$isAnalyzerReference.getDescriptor() instanceof RdAnalyzerReferenceDescriptor;
    }

    public static final boolean isArtifactReference(@NotNull ProjectModelEntity $this$isArtifactReference) {
        Intrinsics.checkNotNullParameter((Object)$this$isArtifactReference, (String)"<this>");
        return $this$isArtifactReference.getDescriptor() instanceof RdArtifactReferenceDescriptor;
    }

    public static final boolean isImportFolder(@NotNull ProjectModelEntity $this$isImportFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$isImportFolder, (String)"<this>");
        return $this$isImportFolder.getDescriptor() instanceof RdImportFolderDescriptor;
    }

    public static final boolean isImportItem(@NotNull ProjectModelEntity $this$isImportItem) {
        Intrinsics.checkNotNullParameter((Object)$this$isImportItem, (String)"<this>");
        return $this$isImportItem.getDescriptor() instanceof RdImportDescriptor;
    }

    public static final boolean isSourceGeneratorFolder(@NotNull ProjectModelEntity $this$isSourceGeneratorFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$isSourceGeneratorFolder, (String)"<this>");
        return $this$isSourceGeneratorFolder.getDescriptor() instanceof RdSourceGeneratorFolderDescriptor;
    }

    public static final boolean isSourceGeneratorFile(@NotNull ProjectModelEntity $this$isSourceGeneratorFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isSourceGeneratorFile, (String)"<this>");
        return $this$isSourceGeneratorFile.getDescriptor() instanceof RdSourceGeneratorFileDescriptor;
    }

    public static final boolean isTargetFrameworkFolder(@NotNull ProjectModelEntity $this$isTargetFrameworkFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$isTargetFrameworkFolder, (String)"<this>");
        return $this$isTargetFrameworkFolder.getDescriptor() instanceof RdTargetFrameworkFolderDescriptor;
    }

    public static final boolean isRoslynAnalyzerDiagnostic(@NotNull ProjectModelEntity $this$isRoslynAnalyzerDiagnostic) {
        Intrinsics.checkNotNullParameter((Object)$this$isRoslynAnalyzerDiagnostic, (String)"<this>");
        return ProjectModelEntityExtensionsKt.asRoslynAnalyzerDiagnostic($this$isRoslynAnalyzerDiagnostic) != null;
    }

    @Nullable
    public static final RdRoslynAnalyzerDiagnosticDescriptor asRoslynAnalyzerDiagnostic(@NotNull ProjectModelEntity $this$asRoslynAnalyzerDiagnostic) {
        Intrinsics.checkNotNullParameter((Object)$this$asRoslynAnalyzerDiagnostic, (String)"<this>");
        RdProjectModelItemDescriptor it = $this$asRoslynAnalyzerDiagnostic.getDescriptor();
        boolean bl = false;
        return it instanceof RdRoslynAnalyzerDiagnosticDescriptor ? (RdRoslynAnalyzerDiagnosticDescriptor)it : null;
    }

    public static final boolean isSqlCmdVariable(@NotNull ProjectModelEntity $this$isSqlCmdVariable) {
        Intrinsics.checkNotNullParameter((Object)$this$isSqlCmdVariable, (String)"<this>");
        RdProjectModelItemDescriptor it = $this$isSqlCmdVariable.getDescriptor();
        boolean bl = false;
        return it instanceof RdSqlCmdVariableDescriptor;
    }

    public static final boolean isDependency(@NotNull ProjectModelEntity $this$isDependency) {
        Intrinsics.checkNotNullParameter((Object)$this$isDependency, (String)"<this>");
        return $this$isDependency.getDescriptor() instanceof RdDependencyDescriptor;
    }

    public static final boolean isDependencyReference(@NotNull ProjectModelEntity $this$isDependencyReference) {
        Intrinsics.checkNotNullParameter((Object)$this$isDependencyReference, (String)"<this>");
        RdProjectModelItemDescriptor it = $this$isDependencyReference.getDescriptor();
        boolean bl = false;
        return it instanceof RdDependencyDescriptor && ((RdDependencyDescriptor)it).getType() == RdDependencyType.Reference;
    }

    public static final boolean isDependencyPackage(@NotNull ProjectModelEntity $this$isDependencyPackage) {
        Intrinsics.checkNotNullParameter((Object)$this$isDependencyPackage, (String)"<this>");
        RdProjectModelItemDescriptor it = $this$isDependencyPackage.getDescriptor();
        boolean bl = false;
        return it instanceof RdDependencyDescriptor && ((RdDependencyDescriptor)it).getType() == RdDependencyType.Package;
    }

    public static final boolean isDependencyProjectReference(@NotNull ProjectModelEntity $this$isDependencyProjectReference) {
        Intrinsics.checkNotNullParameter((Object)$this$isDependencyProjectReference, (String)"<this>");
        RdProjectModelItemDescriptor it = $this$isDependencyProjectReference.getDescriptor();
        boolean bl = false;
        return it instanceof RdDependencyDescriptor && ((RdDependencyDescriptor)it).getType() == RdDependencyType.Project;
    }

    public static final boolean isAnyDependencyFolder(@NotNull ProjectModelEntity $this$isAnyDependencyFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$isAnyDependencyFolder, (String)"<this>");
        return $this$isAnyDependencyFolder.getDescriptor() instanceof RdDependencyFolderDescriptor;
    }

    public static final boolean isDependenciesFolder(@NotNull ProjectModelEntity $this$isDependenciesFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$isDependenciesFolder, (String)"<this>");
        RdProjectModelItemDescriptor it = $this$isDependenciesFolder.getDescriptor();
        boolean bl = false;
        return it instanceof RdDependencyFolderDescriptor && ((RdDependencyFolderDescriptor)it).getType() == RdDependencyFolderDescriptorType.Dependencies;
    }

    public static final boolean isWebReferenceFolder(@NotNull ProjectModelEntity $this$isWebReferenceFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$isWebReferenceFolder, (String)"<this>");
        RdProjectModelItemDescriptor it = $this$isWebReferenceFolder.getDescriptor();
        boolean bl = false;
        return it instanceof RdDependencyFolderDescriptor && ((RdDependencyFolderDescriptor)it).getType() == RdDependencyFolderDescriptorType.WebReference;
    }

    public static final boolean isFrameworkReferencesFolder(@NotNull ProjectModelEntity $this$isFrameworkReferencesFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$isFrameworkReferencesFolder, (String)"<this>");
        RdProjectModelItemDescriptor it = $this$isFrameworkReferencesFolder.getDescriptor();
        boolean bl = false;
        return it instanceof RdDependencyFolderDescriptor && ((RdDependencyFolderDescriptor)it).getType() == RdDependencyFolderDescriptorType.FrameworkReferences;
    }

    public static final boolean isAssembliesFolder(@NotNull ProjectModelEntity $this$isAssembliesFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$isAssembliesFolder, (String)"<this>");
        RdProjectModelItemDescriptor it = $this$isAssembliesFolder.getDescriptor();
        boolean bl = false;
        return it instanceof RdDependencyFolderDescriptor && ((RdDependencyFolderDescriptor)it).getType() == RdDependencyFolderDescriptorType.Assemblies;
    }

    public static final boolean isImplicitAssembliesFolder(@NotNull ProjectModelEntity $this$isImplicitAssembliesFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$isImplicitAssembliesFolder, (String)"<this>");
        RdProjectModelItemDescriptor it = $this$isImplicitAssembliesFolder.getDescriptor();
        boolean bl = false;
        return it instanceof RdDependencyFolderDescriptor && ((RdDependencyFolderDescriptor)it).getType() == RdDependencyFolderDescriptorType.ImplicitAssemblies;
    }

    public static final boolean isProjectsFolder(@NotNull ProjectModelEntity $this$isProjectsFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$isProjectsFolder, (String)"<this>");
        RdProjectModelItemDescriptor it = $this$isProjectsFolder.getDescriptor();
        boolean bl = false;
        return it instanceof RdDependencyFolderDescriptor && ((RdDependencyFolderDescriptor)it).getType() == RdDependencyFolderDescriptorType.Projects;
    }

    public static final boolean isDatabasesFolder(@NotNull ProjectModelEntity $this$isDatabasesFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$isDatabasesFolder, (String)"<this>");
        RdProjectModelItemDescriptor it = $this$isDatabasesFolder.getDescriptor();
        boolean bl = false;
        return it instanceof RdDependencyFolderDescriptor && ((RdDependencyFolderDescriptor)it).getType() == RdDependencyFolderDescriptorType.Databases;
    }

    public static final boolean isSqlCmdVariablesFolder(@NotNull ProjectModelEntity $this$isSqlCmdVariablesFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$isSqlCmdVariablesFolder, (String)"<this>");
        RdProjectModelItemDescriptor it = $this$isSqlCmdVariablesFolder.getDescriptor();
        boolean bl = false;
        return it instanceof RdDependencyFolderDescriptor && ((RdDependencyFolderDescriptor)it).getType() == RdDependencyFolderDescriptorType.SqlCmdVariables;
    }

    public static final boolean isSDKFolder(@NotNull ProjectModelEntity $this$isSDKFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$isSDKFolder, (String)"<this>");
        RdProjectModelItemDescriptor it = $this$isSDKFolder.getDescriptor();
        boolean bl = false;
        return it instanceof RdDependencyFolderDescriptor && ((RdDependencyFolderDescriptor)it).getType() == RdDependencyFolderDescriptorType.SDK;
    }

    public static final boolean isAnalyzersFolder(@NotNull ProjectModelEntity $this$isAnalyzersFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$isAnalyzersFolder, (String)"<this>");
        RdProjectModelItemDescriptor it = $this$isAnalyzersFolder.getDescriptor();
        boolean bl = false;
        return it instanceof RdDependencyFolderDescriptor && ((RdDependencyFolderDescriptor)it).getType() == RdDependencyFolderDescriptorType.Analyzers;
    }

    public static final boolean isSourceGeneratorsFolder(@NotNull ProjectModelEntity $this$isSourceGeneratorsFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$isSourceGeneratorsFolder, (String)"<this>");
        RdProjectModelItemDescriptor it = $this$isSourceGeneratorsFolder.getDescriptor();
        boolean bl = false;
        return it instanceof RdDependencyFolderDescriptor && ((RdDependencyFolderDescriptor)it).getType() == RdDependencyFolderDescriptorType.SourceGenerator;
    }

    public static final boolean isPackagesFolder(@NotNull ProjectModelEntity $this$isPackagesFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$isPackagesFolder, (String)"<this>");
        RdProjectModelItemDescriptor it = $this$isPackagesFolder.getDescriptor();
        boolean bl = false;
        return it instanceof RdDependencyFolderDescriptor && ((RdDependencyFolderDescriptor)it).getType() == RdDependencyFolderDescriptorType.Packages;
    }

    public static final boolean isXcAssetsFolder(@NotNull ProjectModelEntity $this$isXcAssetsFolder) {
        Intrinsics.checkNotNullParameter((Object)$this$isXcAssetsFolder, (String)"<this>");
        if (!ProjectModelEntityExtensionsKt.isProjectFolder($this$isXcAssetsFolder)) {
            return false;
        }
        if (!StringsKt.endsWith((String)$this$isXcAssetsFolder.getName(), (String)".xcassets", (boolean)true)) {
            return false;
        }
        ProjectModelEntity projectModelEntity = ProjectModelEntityExtensionsKt.containingProjectEntity($this$isXcAssetsFolder);
        if (projectModelEntity == null) {
            return false;
        }
        ProjectModelEntity project = projectModelEntity;
        RdProjectModelItemDescriptor descriptor = project.getDescriptor();
        if (descriptor instanceof RdProjectDescriptor) {
            return ((RdProjectDescriptor)descriptor).getSpecificType() == RdProjectType.Macios;
        }
        return false;
    }

    public static final boolean isXcAssetItemFolder(@NotNull ProjectModelEntity $this$isXcAssetItemFolder) {
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)$this$isXcAssetItemFolder, (String)"<this>");
                if (!ProjectModelEntityExtensionsKt.isProjectFolder($this$isXcAssetItemFolder)) break block3;
                ProjectModelEntity projectModelEntity = $this$isXcAssetItemFolder.getParentEntity();
                if (projectModelEntity != null ? ProjectModelEntityExtensionsKt.isXcAssetsFolder(projectModelEntity) : false) break block4;
            }
            return false;
        }
        String extension = StringsKt.substringAfterLast((String)$this$isXcAssetItemFolder.getName(), (String)".", (String)"");
        return StringsKt.equals((String)extension, (String)"appiconset", (boolean)true) || StringsKt.equals((String)extension, (String)"colorset", (boolean)true) || StringsKt.equals((String)extension, (String)"imageset", (boolean)true);
    }

    public static final boolean isHiddenInSolutionFilter(@NotNull ProjectModelEntity $this$isHiddenInSolutionFilter) {
        Intrinsics.checkNotNullParameter((Object)$this$isHiddenInSolutionFilter, (String)"<this>");
        if (ProjectModelEntityExtensionsKt.isSolutionFolder($this$isHiddenInSolutionFilter)) {
            boolean bl;
            block5: {
                List children = CollectionsKt.toList((Iterable)$this$isHiddenInSolutionFilter.getChildrenEntities());
                if (children.isEmpty()) {
                    return false;
                }
                Iterable $this$all$iv = children;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        ProjectModelEntity it = (ProjectModelEntity)element$iv;
                        boolean bl2 = false;
                        if (ProjectModelEntityExtensionsKt.isHiddenInSolutionFilter(it)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            return bl;
        }
        return ProjectModelEntityExtensionsKt.isFilteredProject($this$isHiddenInSolutionFilter);
    }

    public static final boolean isSqlProject(@NotNull ProjectModelEntity $this$isSqlProject) {
        Intrinsics.checkNotNullParameter((Object)$this$isSqlProject, (String)"<this>");
        if (!ProjectModelEntityExtensionsKt.isProject($this$isSqlProject)) {
            return false;
        }
        String sqlProjectType = ProjectModelNodeExtensionKt.getUserData($this$isSqlProject.getDescriptor(), "SqlProj.Type");
        return sqlProjectType != null;
    }

    public static final boolean isLegacySqlProject(@NotNull ProjectModelEntity $this$isLegacySqlProject) {
        Intrinsics.checkNotNullParameter((Object)$this$isLegacySqlProject, (String)"<this>");
        if (!ProjectModelEntityExtensionsKt.isProject($this$isLegacySqlProject)) {
            return false;
        }
        String sqlProjectType = ProjectModelNodeExtensionKt.getUserData($this$isLegacySqlProject.getDescriptor(), "SqlProj.Type");
        return Intrinsics.areEqual((Object)sqlProjectType, (Object)"Legacy");
    }

    @Nullable
    public static final ProjectModelEntity findParent(@NotNull ProjectModelEntity $this$findParent, @NotNull Function1<? super ProjectModelEntity, Boolean> condition) {
        ProjectModelEntity projectModelEntity;
        Intrinsics.checkNotNullParameter((Object)$this$findParent, (String)"<this>");
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        ProjectModelEntity projectModelEntity2 = $this$findParent.getParentEntity();
        if (projectModelEntity2 == null) {
            return null;
        }
        ProjectModelEntity parent = projectModelEntity2;
        Boolean bl = (Boolean)condition.invoke((Object)parent);
        if (Intrinsics.areEqual((Object)bl, (Object)false)) {
            projectModelEntity = ProjectModelEntityExtensionsKt.findParent(parent, condition);
        } else if (Intrinsics.areEqual((Object)bl, (Object)true)) {
            projectModelEntity = parent;
        } else if (bl == null) {
            projectModelEntity = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return projectModelEntity;
    }

    private static final Path getRootPaths$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParent();
    }

    private static final VirtualFile getRootVirtualFiles$lambda$0(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParent();
    }

    private static final ProjectModelEntity getRootEntities$lambda$0(ProjectModelEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParentEntity();
    }
}

