/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.solutionStructure.definitions;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.ExtensionsKt;
import com.intellij.openapi.util.Pair;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.UriUtil;
import com.jetbrains.rider.projectView.solutionStructure.definitions.CompositeDefinitionItem;
import com.jetbrains.rider.projectView.solutionStructure.definitions.DefinitionItem;
import com.jetbrains.rider.projectView.solutionStructure.definitions.SectionDefinition;
import com.jetbrains.rider.projectView.solutionStructure.definitions.SectionDefinitionType;
import com.jetbrains.rider.projectView.solutionStructure.definitions.SolutionDefinition;
import com.jetbrains.rider.utils.EnvironmentUtils;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B7\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\n\u0010\u001e\u001a\u0004\u0018\u00010\u001aH\u0002J\b\u0010\u001f\u001a\u00020\u0003H&J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002J\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u001b\u0010\u0013\u001a\u00020\u00148FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006$"}, d2={"Lcom/jetbrains/rider/projectView/solutionStructure/definitions/ProjectDefinition;", "Lcom/jetbrains/rider/projectView/solutionStructure/definitions/CompositeDefinitionItem;", "name", "", "pathString", "projectGuid", "Ljava/util/UUID;", "projectTypeGuid", "items", "", "Lcom/jetbrains/rider/projectView/solutionStructure/definitions/DefinitionItem;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/UUID;Ljava/util/UUID;Ljava/util/List;)V", "getName", "()Ljava/lang/String;", "getPathString", "getProjectGuid", "()Ljava/util/UUID;", "getProjectTypeGuid", "solutionDefinition", "Lcom/jetbrains/rider/projectView/solutionStructure/definitions/SolutionDefinition;", "getSolutionDefinition", "()Lcom/jetbrains/rider/projectView/solutionStructure/definitions/SolutionDefinition;", "solutionDefinition$delegate", "Lkotlin/Lazy;", "calculatedPath", "Ljava/nio/file/Path;", "path", "getPath", "()Ljava/nio/file/Path;", "calculatePath", "getActualProjectName", "getProjectSections", "", "Lcom/jetbrains/rider/projectView/solutionStructure/definitions/SectionDefinition;", "sectionName", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nProjectDefinition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectDefinition.kt\ncom/jetbrains/rider/projectView/solutionStructure/definitions/ProjectDefinition\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n808#2,11:78\n774#2:89\n865#2,2:90\n774#2:92\n865#2,2:93\n*S KotlinDebug\n*F\n+ 1 ProjectDefinition.kt\ncom/jetbrains/rider/projectView/solutionStructure/definitions/ProjectDefinition\n*L\n55#1:78,11\n55#1:89\n55#1:90,2\n57#1:92\n57#1:93,2\n*E\n"})
public abstract class ProjectDefinition
extends CompositeDefinitionItem {
    @NotNull
    private final String name;
    @NotNull
    private final String pathString;
    @NotNull
    private final UUID projectGuid;
    @NotNull
    private final UUID projectTypeGuid;
    @NotNull
    private final Lazy solutionDefinition$delegate;
    @Nullable
    private Path calculatedPath;

    protected ProjectDefinition(@NotNull String name, @NotNull String pathString, @NotNull UUID projectGuid, @NotNull UUID projectTypeGuid, @NotNull List<DefinitionItem> items) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)pathString, (String)"pathString");
        Intrinsics.checkNotNullParameter((Object)projectGuid, (String)"projectGuid");
        Intrinsics.checkNotNullParameter((Object)projectTypeGuid, (String)"projectTypeGuid");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        super(items);
        this.name = name;
        this.pathString = pathString;
        this.projectGuid = projectGuid;
        this.projectTypeGuid = projectTypeGuid;
        this.solutionDefinition$delegate = LazyKt.lazy(() -> ProjectDefinition.solutionDefinition_delegate$lambda$0(this));
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getPathString() {
        return this.pathString;
    }

    @NotNull
    public final UUID getProjectGuid() {
        return this.projectGuid;
    }

    @NotNull
    public final UUID getProjectTypeGuid() {
        return this.projectTypeGuid;
    }

    @NotNull
    public final SolutionDefinition getSolutionDefinition() {
        Lazy lazy = this.solutionDefinition$delegate;
        return (SolutionDefinition)lazy.getValue();
    }

    @Nullable
    public final Path getPath() {
        Path path = this.calculatedPath;
        if (path == null) {
            path = this.calculatePath();
        }
        this.calculatedPath = path;
        return this.calculatedPath;
    }

    private final Path calculatePath() {
        Path solutionDirectoryPath = this.getSolutionDefinition().getLocation().getParent();
        Map map = EnvironmentUtil.getEnvironmentMap();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnvironmentMap(...)");
        Map envMap = map;
        String string = EnvironmentUtils.INSTANCE.expandVariables(this.pathString, envMap, MapsKt.emptyMap());
        Intrinsics.checkNotNull((Object)string);
        String expandedPath = string;
        Couple couple = UriUtil.splitScheme((String)expandedPath);
        Intrinsics.checkNotNullExpressionValue((Object)couple, (String)"splitScheme(...)");
        Couple couple2 = couple;
        String scheme = (String)ExtensionsKt.component1((Pair)((Pair)couple2));
        String url2 = (String)ExtensionsKt.component2((Pair)((Pair)couple2));
        if (StringsKt.equals((String)scheme, (String)"http", (boolean)true) || StringsKt.equals((String)scheme, (String)"https", (boolean)true)) {
            return null;
        }
        if (StringsKt.equals((String)scheme, (String)"file", (boolean)true)) {
            return solutionDirectoryPath.resolve(url2);
        }
        String separator = Intrinsics.areEqual((Object)File.separator, (Object)"/") ? "/" : "\\\\";
        Intrinsics.checkNotNull((Object)url2);
        CharSequence charSequence = url2;
        String normalizedPath = new Regex("[/\\\\]").replace(charSequence, separator);
        Path path = Path.of(normalizedPath, new String[0]);
        return !path.isAbsolute() ? solutionDirectoryPath.resolve(path) : path;
    }

    @NotNull
    public abstract String getActualProjectName();

    /*
     * WARNING - void declaration
     */
    private final List<SectionDefinition> getProjectSections() {
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = this.getItems();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof SectionDefinition)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SectionDefinition it = (SectionDefinition)element$iv$iv;
            boolean bl = false;
            if (!(it.getType() == SectionDefinitionType.Project)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SectionDefinition> getProjectSections(@NotNull String sectionName) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)sectionName, (String)"sectionName");
        Iterable $this$filter$iv = this.getProjectSections();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SectionDefinition it = (SectionDefinition)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getSectionName(), (Object)sectionName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final SolutionDefinition solutionDefinition_delegate$lambda$0(ProjectDefinition this$0) {
        DefinitionItem definitionItem = this$0.getParent$intellij_rider_rdclient_dotnet();
        Intrinsics.checkNotNull((Object)definitionItem, (String)"null cannot be cast to non-null type com.jetbrains.rider.projectView.solutionStructure.definitions.SolutionDefinition");
        return (SolutionDefinition)definitionItem;
    }
}

