/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.client.ClientKind;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSessionsManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.ide.model.RdConfigurationAndPlatform;
import com.jetbrains.rd.ide.model.RdSolutionOpenStrategy;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rd.platform.protocol.IRdDispatcher;
import com.jetbrains.rd.platform.util.ComponentsKt;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.projectView.SolutionOpenStrategyProvider;
import com.jetbrains.rider.protocol.ApplicationProtocolKt;
import com.jetbrains.rider.protocol.IProtocolHost;
import com.jetbrains.rider.protocol.IProtocolHostWithBackend;
import com.jetbrains.rider.protocol.ProtocolKeys;
import com.jetbrains.rider.protocol.ProtocolManager;
import com.jetbrains.rider.protocol.components.SolutionHost;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 \u001c2\u00020\u0001:\u0003\u001c\u001d\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016JH\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000eJ,\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J<\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000eH\u0002J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0014\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rider/projectView/SolutionInitializerService;", "", "<init>", "()V", "finishInitialization", "", "project", "Lcom/intellij/openapi/project/Project;", "initSolution", "strategy", "Lcom/jetbrains/rd/ide/model/RdSolutionOpenStrategy;", "protocolManager", "Lcom/jetbrains/rider/protocol/ProtocolManager;", "solutionInitializationLifetimeKey", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "solutionKey", "Lcom/jetbrains/rider/projectView/SolutionInitializerService$SolutionKey;", "protocolHostKey", "Lcom/jetbrains/rider/protocol/IProtocolHost;", "getSolutionAndProjectSession", "Lkotlin/Pair;", "Lcom/jetbrains/rd/ide/model/Solution;", "Lcom/intellij/openapi/client/ClientProjectSession;", "protocolHost", "Lcom/jetbrains/rider/protocol/IProtocolHostWithBackend;", "session", "releaseProtocolHost", "Companion", "Service", "SolutionKey", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nSolutionInitializerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolutionInitializerService.kt\ncom/jetbrains/rider/projectView/SolutionInitializerService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,155:1\n295#2,2:156\n13#3:158\n13#4:159\n13#4:160\n*S KotlinDebug\n*F\n+ 1 SolutionInitializerService.kt\ncom/jetbrains/rider/projectView/SolutionInitializerService\n*L\n60#1:156,2\n82#1:158\n82#1:159\n36#1:160\n*E\n"})
public class SolutionInitializerService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<SolutionKey> solutionKey = new Key("SolutionKey");
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Key<LifetimeDefinition> solutionInitializationLifetimeKey;

    public void finishInitialization(@NotNull Project project) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            logger.info("Finish initialization");
            LifetimeDefinition lifetimeDefinition = (LifetimeDefinition)project.getUserData(solutionInitializationLifetimeKey);
            if (lifetimeDefinition == null) break block0;
            LifetimeDefinition.terminate$default((LifetimeDefinition)lifetimeDefinition, (boolean)false, (int)1, null);
        }
    }

    public void initSolution(@NotNull Project project, @NotNull RdSolutionOpenStrategy strategy2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)strategy2, (String)"strategy");
        this.initSolution(project, strategy2, ApplicationProtocolKt.getProtocolManager(ApplicationKt.getApplication()), solutionInitializationLifetimeKey, solutionKey, ProtocolKeys.Companion.getProtocolHostKey());
    }

    public final void initSolution(@NotNull Project project, @NotNull RdSolutionOpenStrategy strategy2, @NotNull ProtocolManager protocolManager, @NotNull Key<LifetimeDefinition> solutionInitializationLifetimeKey, @NotNull Key<SolutionKey> solutionKey, @NotNull Key<IProtocolHost> protocolHostKey) {
        IProtocolHostWithBackend iProtocolHostWithBackend;
        Object v0;
        block6: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)strategy2, (String)"strategy");
            Intrinsics.checkNotNullParameter((Object)protocolManager, (String)"protocolManager");
            Intrinsics.checkNotNullParameter(solutionInitializationLifetimeKey, (String)"solutionInitializationLifetimeKey");
            Intrinsics.checkNotNullParameter(solutionKey, (String)"solutionKey");
            Intrinsics.checkNotNullParameter(protocolHostKey, (String)"protocolHostKey");
            if (project.isDefault()) {
                return;
            }
            logger.info("Create protocol solution...");
            Iterable $this$firstOrNull$iv = (Iterable)protocolManager.getProtocolHosts();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IProtocolHostWithBackend it = (IProtocolHostWithBackend)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getProject().getValue(), (Object)project)) continue;
                v0 = element$iv;
                break block6;
            }
            v0 = null;
        }
        if ((iProtocolHostWithBackend = (IProtocolHostWithBackend)v0) == null) {
            iProtocolHostWithBackend = protocolManager.getOrCreate(project);
        }
        IProtocolHostWithBackend protocolHost = iProtocolHostWithBackend;
        IScheduler iScheduler = protocolHost.getProtocol().getScheduler();
        Intrinsics.checkNotNull((Object)iScheduler, (String)"null cannot be cast to non-null type com.jetbrains.rd.platform.protocol.IRdDispatcher");
        IRdDispatcher dispatcher = (IRdDispatcher)iScheduler;
        LifetimeDefinition initializationLifetimeDef = LifetimeDisposableExKt.defineNestedLifetime((Disposable)((Disposable)project));
        dispatcher.allowAllBackgroundThreadsAndSuppressPumping(initializationLifetimeDef.getLifetime());
        initializationLifetimeDef.getLifetime().onTermination(() -> SolutionInitializerService.initSolution$lambda$1(project, this, protocolHost));
        project.putUserData(solutionInitializationLifetimeKey, (Object)initializationLifetimeDef);
        try {
            this.initSolution(project, strategy2, protocolHost, solutionKey, protocolHostKey);
            logger.info("Protocol solution created, initialize protocol components...");
        }
        catch (Exception ex) {
            boolean $i$f$getLogger = false;
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(SolutionInitializerService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error((Throwable)ex);
            if (protocolHost.isProjectAttached()) {
                protocolManager.release(protocolHost);
            }
            project.putUserData(solutionKey, (Object)new SolutionKey(null));
            throw ex;
        }
    }

    @NotNull
    protected Pair<Solution, ClientProjectSession> getSolutionAndProjectSession(@NotNull IProtocolHostWithBackend protocolHost, @NotNull ClientProjectSession session2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)protocolHost, (String)"protocolHost");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new Pair((Object)SolutionHostExtensionsKt.getSolution(project), (Object)session2);
    }

    private final void initSolution(Project project, RdSolutionOpenStrategy strategy2, IProtocolHostWithBackend protocolHost, Key<SolutionKey> solutionKey, Key<IProtocolHost> protocolHostKey) {
        SolutionHost solutionHost = SolutionHost.Companion.getInstance(protocolHost.getSession());
        solutionHost.assertReadyForSolution();
        Solution solution = new Solution(ProjectUtilKt.getOrCreateRdProjectId((Project)project), strategy2);
        RdConfigurationAndPlatform activeConfig = SolutionOpenStrategyProvider.Companion.getInstance().getActiveConfigurationAndPlatform(solution);
        if (activeConfig != null) {
            solution.getSolutionProperties().getActiveConfigurationPlatform().set((Object)activeConfig);
        }
        solutionHost.set(solution);
        project.putUserData(solutionKey, (Object)new SolutionKey(solution));
        project.putUserData(protocolHostKey, (Object)protocolHost);
        ComponentsKt.getLifetime((UserDataHolder)((UserDataHolder)project)).onTermination(() -> SolutionInitializerService.initSolution$lambda$2(solutionHost, solution, this, protocolHost));
    }

    protected void releaseProtocolHost(@NotNull IProtocolHostWithBackend protocolHost) {
        Intrinsics.checkNotNullParameter((Object)protocolHost, (String)"protocolHost");
        ApplicationProtocolKt.getProtocolManager(ApplicationKt.getApplication()).release(protocolHost);
    }

    private static final Unit initSolution$lambda$1(Project $project, SolutionInitializerService this$0, IProtocolHostWithBackend $protocolHost) {
        ClientProjectSession clientProjectSession = (ClientProjectSession)CollectionsKt.singleOrNull((List)ClientSessionsManager.Companion.getProjectSessions($project, ClientKind.FRONTEND));
        if (clientProjectSession == null) {
            return Unit.INSTANCE;
        }
        ClientProjectSession session2 = clientProjectSession;
        Pair<Solution, ClientProjectSession> pair = this$0.getSolutionAndProjectSession($protocolHost, session2, $project);
        Solution solution = (Solution)pair.component1();
        ClientProjectSession projectSession = (ClientProjectSession)pair.component2();
        $protocolHost.getProtocolExtListenerManager().startDeliveringMessages(projectSession, solution);
        return Unit.INSTANCE;
    }

    private static final Unit initSolution$lambda$2(SolutionHost $solutionHost, Solution $solution, SolutionInitializerService this$0, IProtocolHostWithBackend $protocolHost) {
        $solutionHost.remove($solution);
        this$0.releaseProtocolHost($protocolHost);
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SolutionInitializerService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        SolutionInitializerService.logger = logger;
        solutionInitializationLifetimeKey = new Key("SolutionInitializationLifetimeKey");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/projectView/SolutionInitializerService$Companion;", "", "<init>", "()V", "solutionKey", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/rider/projectView/SolutionInitializerService$SolutionKey;", "getSolutionKey", "()Lcom/intellij/openapi/util/Key;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "solutionInitializationLifetimeKey", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<SolutionKey> getSolutionKey() {
            return solutionKey;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0014\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/projectView/SolutionInitializerService$Service;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "initSolutionIfNeeded", "", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nSolutionInitializerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolutionInitializerService.kt\ncom/jetbrains/rider/projectView/SolutionInitializerService$Service\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,155:1\n1#2:156\n30#3,2:157\n*S KotlinDebug\n*F\n+ 1 SolutionInitializerService.kt\ncom/jetbrains/rider/projectView/SolutionInitializerService$Service\n*L\n150#1:157,2\n*E\n"})
    public static class Service {
        public Service(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.initSolutionIfNeeded(project);
        }

        protected void initSolutionIfNeeded(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (project.isDefault()) {
                return;
            }
            if (project.getUserData(Companion.getSolutionKey()) != null) {
                return;
            }
            RdSolutionOpenStrategy strategy2 = SolutionOpenStrategyProvider.Companion.getInstance().getOpenStrategy(project);
            if (strategy2 == null) {
                project.putUserData(Companion.getSolutionKey(), (Object)new SolutionKey(null));
                return;
            }
            Path path = (Path)project.getUserData(ProjectImpl.PROJECT_PATH);
            if (path != null) {
                Path it = path;
                boolean bl = false;
                project.putUserData(ProjectUtilKt.getRdEarlyProjectDir(), (Object)((Object)it).toString());
            }
            ComponentManager $this$service$iv = (ComponentManager)ApplicationKt.getApplication();
            boolean $i$f$service = false;
            Class<SolutionInitializerService> serviceClass$iv = SolutionInitializerService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((SolutionInitializerService)object).initSolution(project, strategy2);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\t\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/projectView/SolutionInitializerService$SolutionKey;", "", "solution", "Lcom/jetbrains/rd/ide/model/Solution;", "<init>", "(Lcom/jetbrains/rd/ide/model/Solution;)V", "getSolution", "()Lcom/jetbrains/rd/ide/model/Solution;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.rider.rdclient.dotnet"})
    public static final class SolutionKey {
        @Nullable
        private final Solution solution;

        public SolutionKey(@Nullable Solution solution) {
            this.solution = solution;
        }

        @Nullable
        public final Solution getSolution() {
            return this.solution;
        }

        @Nullable
        public final Solution component1() {
            return this.solution;
        }

        @NotNull
        public final SolutionKey copy(@Nullable Solution solution) {
            return new SolutionKey(solution);
        }

        public static /* synthetic */ SolutionKey copy$default(SolutionKey solutionKey, Solution solution, int n, Object object) {
            if ((n & 1) != 0) {
                solution = solutionKey.solution;
            }
            return solutionKey.copy(solution);
        }

        @NotNull
        public String toString() {
            return "SolutionKey(solution=" + this.solution + ")";
        }

        public int hashCode() {
            return this.solution == null ? 0 : this.solution.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SolutionKey)) {
                return false;
            }
            SolutionKey solutionKey = (SolutionKey)other;
            return Intrinsics.areEqual((Object)this.solution, (Object)solutionKey.solution);
        }
    }
}

