/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.ide.model.RdCLionSolution;
import com.jetbrains.rd.ide.model.RdExistingSolution;
import com.jetbrains.rd.ide.model.RdSolutionDescription;
import com.jetbrains.rd.ide.model.RdSolutionOpenStrategy;
import com.jetbrains.rd.ide.model.RdTemporarySolution;
import com.jetbrains.rd.ide.model.RdVirtualSolution;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rider.projectView.SolutionInitializerService;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\u001a\u0012\u0010\t\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\u0002H\u0002\u001a\u0016\u0010)\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u0011\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\u000b\u001a\u00020\f*\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\"\u0015\u0010\u0010\u001a\u00020\u0011*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\"\u0015\u0010\u0014\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\b\"\u0015\u0010\u0015\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\b\"\u0015\u0010\u0016\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\b\"\u0015\u0010\u000b\u001a\u00020\f*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0017\"\u0015\u0010\u0018\u001a\u00020\f*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\"\u0015\u0010\u001b\u001a\u00020\u001c*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\"\u0015\u0010\u001f\u001a\u00020\u001c*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001e\"\u0015\u0010!\u001a\u00020\"*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\"\u0015\u0010%\u001a\u00020\f*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u001a\"\u0017\u0010'\u001a\u0004\u0018\u00010\"*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b(\u0010$\u00a8\u0006,"}, d2={"solution", "Lcom/jetbrains/rd/ide/model/Solution;", "Lcom/intellij/openapi/project/Project;", "getSolution", "(Lcom/intellij/openapi/project/Project;)Lcom/jetbrains/rd/ide/model/Solution;", "hasSolution", "", "getHasSolution", "(Lcom/intellij/openapi/project/Project;)Z", "getProtocolSolution", "project", "path", "", "Lcom/jetbrains/rd/ide/model/RdSolutionOpenStrategy;", "getPath", "(Lcom/jetbrains/rd/ide/model/RdSolutionOpenStrategy;)Ljava/lang/String;", "solutionDescription", "Lcom/jetbrains/rd/ide/model/RdSolutionDescription;", "getSolutionDescription", "(Lcom/intellij/openapi/project/Project;)Lcom/jetbrains/rd/ide/model/RdSolutionDescription;", "isExistingSolution", "isDirectorySolution", "isTemporarySolution", "(Lcom/jetbrains/rd/ide/model/Solution;)Ljava/lang/String;", "solutionPath", "getSolutionPath", "(Lcom/intellij/openapi/project/Project;)Ljava/lang/String;", "solutionFile", "Ljava/io/File;", "getSolutionFile", "(Lcom/intellij/openapi/project/Project;)Ljava/io/File;", "solutionDirectory", "getSolutionDirectory", "solutionDirectoryPath", "Ljava/nio/file/Path;", "getSolutionDirectoryPath", "(Lcom/intellij/openapi/project/Project;)Ljava/nio/file/Path;", "solutionName", "getSolutionName", "solutionFilterPath", "getSolutionFilterPath", "isSolutionDescriptionsEqual", "x", "y", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nSolutionHostExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolutionHostExtensions.kt\ncom/jetbrains/rider/projectView/SolutionHostExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ComponentContainerUtil.kt\ncom/jetbrains/rider/util/idea/ComponentContainerUtilKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,133:1\n1#2:134\n17#3,2:135\n1740#4,3:137\n*S KotlinDebug\n*F\n+ 1 SolutionHostExtensions.kt\ncom/jetbrains/rider/projectView/SolutionHostExtensionsKt\n*L\n22#1:135,2\n104#1:137,3\n*E\n"})
public final class SolutionHostExtensionsKt {
    @NotNull
    public static final Solution getSolution(@NotNull Project $this$solution) {
        Intrinsics.checkNotNullParameter((Object)$this$solution, (String)"<this>");
        Solution solution = SolutionHostExtensionsKt.getProtocolSolution($this$solution);
        if (solution == null) {
            boolean bl = false;
            String string = "solution can't be null";
            throw new IllegalArgumentException(string.toString());
        }
        return solution;
    }

    public static final boolean getHasSolution(@NotNull Project $this$hasSolution) {
        Intrinsics.checkNotNullParameter((Object)$this$hasSolution, (String)"<this>");
        return SolutionHostExtensionsKt.getProtocolSolution($this$hasSolution) != null;
    }

    private static final Solution getProtocolSolution(Project project) {
        SolutionInitializerService.SolutionKey solutionKey = (SolutionInitializerService.SolutionKey)project.getUserData(SolutionInitializerService.Companion.getSolutionKey());
        if (solutionKey != null) {
            return solutionKey.getSolution();
        }
        ComponentManager $this$getService$iv = (ComponentManager)project;
        boolean $i$f$getService = false;
        if ($this$getService$iv.getService(SolutionInitializerService.Service.class) == null) {
            throw new IllegalStateException("Service " + SolutionInitializerService.Service.class + " not found in container " + $this$getService$iv);
        }
        SolutionInitializerService.SolutionKey solutionKey2 = (SolutionInitializerService.SolutionKey)project.getUserData(SolutionInitializerService.Companion.getSolutionKey());
        return solutionKey2 != null ? solutionKey2.getSolution() : null;
    }

    @NotNull
    public static final String getPath(@NotNull RdSolutionOpenStrategy $this$path) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$path, (String)"<this>");
        RdSolutionDescription description2 = $this$path.getDescription();
        if (description2 instanceof RdExistingSolution) {
            string = ((Object)Path.of(((RdExistingSolution)description2).getSolutionDirectory(), new String[0]).resolve((String)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)((RdExistingSolution)description2).getSolutionFileName())))).toString();
        } else if (description2 instanceof RdVirtualSolution) {
            string = (String)CollectionsKt.singleOrNull((List)((RdVirtualSolution)description2).getProjectFilePaths());
            if (string == null) {
                string = ((RdVirtualSolution)description2).getSolutionDirectory();
            }
        } else if (description2 instanceof RdTemporarySolution) {
            string = ((RdTemporarySolution)description2).getSolutionTempDirectory();
        } else if (description2 instanceof RdCLionSolution) {
            string = ((RdCLionSolution)description2).getRootDirectory();
        } else {
            throw new Exception("Unknown description");
        }
        return string;
    }

    @NotNull
    public static final RdSolutionDescription getSolutionDescription(@NotNull Project $this$solutionDescription) {
        Intrinsics.checkNotNullParameter((Object)$this$solutionDescription, (String)"<this>");
        return SolutionHostExtensionsKt.getSolution($this$solutionDescription).getSolutionOpenStrategy().getDescription();
    }

    public static final boolean isExistingSolution(@NotNull Project $this$isExistingSolution) {
        Intrinsics.checkNotNullParameter((Object)$this$isExistingSolution, (String)"<this>");
        RdSolutionDescription solutionDescription = SolutionHostExtensionsKt.getSolutionDescription($this$isExistingSolution);
        return solutionDescription instanceof RdExistingSolution;
    }

    public static final boolean isDirectorySolution(@NotNull Project $this$isDirectorySolution) {
        Intrinsics.checkNotNullParameter((Object)$this$isDirectorySolution, (String)"<this>");
        RdSolutionDescription solutionDescription = SolutionHostExtensionsKt.getSolutionDescription($this$isDirectorySolution);
        return solutionDescription instanceof RdVirtualSolution && ((RdVirtualSolution)solutionDescription).getProjectFilePaths().isEmpty();
    }

    public static final boolean isTemporarySolution(@NotNull Project $this$isTemporarySolution) {
        Intrinsics.checkNotNullParameter((Object)$this$isTemporarySolution, (String)"<this>");
        RdSolutionDescription solutionDescription = SolutionHostExtensionsKt.getSolutionDescription($this$isTemporarySolution);
        return solutionDescription instanceof RdTemporarySolution;
    }

    @NotNull
    public static final String getPath(@NotNull Solution $this$path) {
        Intrinsics.checkNotNullParameter((Object)$this$path, (String)"<this>");
        return SolutionHostExtensionsKt.getPath($this$path.getSolutionOpenStrategy());
    }

    @NotNull
    public static final String getSolutionPath(@NotNull Project $this$solutionPath) {
        Intrinsics.checkNotNullParameter((Object)$this$solutionPath, (String)"<this>");
        return SolutionHostExtensionsKt.getPath(SolutionHostExtensionsKt.getSolution($this$solutionPath));
    }

    @NotNull
    public static final File getSolutionFile(@NotNull Project $this$solutionFile) {
        Intrinsics.checkNotNullParameter((Object)$this$solutionFile, (String)"<this>");
        return new File(SolutionHostExtensionsKt.getSolutionPath($this$solutionFile));
    }

    @NotNull
    public static final File getSolutionDirectory(@NotNull Project $this$solutionDirectory) {
        File file;
        Intrinsics.checkNotNullParameter((Object)$this$solutionDirectory, (String)"<this>");
        File file2 = SolutionHostExtensionsKt.getSolutionFile($this$solutionDirectory);
        if (file2.isDirectory()) {
            file = file2;
        } else {
            File file3 = file2.getParentFile();
            file = file3;
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"getParentFile(...)");
        }
        return file;
    }

    @NotNull
    public static final Path getSolutionDirectoryPath(@NotNull Project $this$solutionDirectoryPath) {
        Intrinsics.checkNotNullParameter((Object)$this$solutionDirectoryPath, (String)"<this>");
        Path path = SolutionHostExtensionsKt.getSolutionDirectory($this$solutionDirectoryPath).toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        return path;
    }

    @NotNull
    public static final String getSolutionName(@NotNull Project $this$solutionName) {
        Intrinsics.checkNotNullParameter((Object)$this$solutionName, (String)"<this>");
        return FilesKt.getNameWithoutExtension((File)SolutionHostExtensionsKt.getSolutionFile($this$solutionName));
    }

    @Nullable
    public static final Path getSolutionFilterPath(@NotNull Project $this$solutionFilterPath) {
        Intrinsics.checkNotNullParameter((Object)$this$solutionFilterPath, (String)"<this>");
        RdSolutionDescription solutionDescription = SolutionHostExtensionsKt.getSolutionDescription($this$solutionFilterPath);
        if (solutionDescription instanceof RdExistingSolution && StringsKt.endsWith((String)((String)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)((RdExistingSolution)solutionDescription).getSolutionFileName()))), (String)".slnf", (boolean)true)) {
            return Path.of(((RdExistingSolution)solutionDescription).getSolutionDirectory(), new String[0]).resolve((String)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)((RdExistingSolution)solutionDescription).getSolutionFileName())));
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isSolutionDescriptionsEqual(@NotNull RdSolutionDescription x, @NotNull RdSolutionDescription y) {
        IndexedValue it;
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        if (Intrinsics.areEqual((Object)x, (Object)y)) {
            return true;
        }
        if (x instanceof RdExistingSolution && y instanceof RdExistingSolution) {
            if (!Intrinsics.areEqual((Object)((RdExistingSolution)x).getSolutionDirectory(), (Object)((RdExistingSolution)y).getSolutionDirectory())) return false;
            if (!Intrinsics.areEqual((Object)((RdExistingSolution)x).getSolutionFileName().getValueOrNull(), (Object)((RdExistingSolution)y).getSolutionFileName().getValueOrNull())) return false;
            return true;
        }
        if (!(x instanceof RdVirtualSolution)) return false;
        if (!(y instanceof RdVirtualSolution)) return false;
        if (!Intrinsics.areEqual((Object)((RdVirtualSolution)x).getSolutionDirectory(), (Object)((RdVirtualSolution)y).getSolutionDirectory())) return false;
        if (!Intrinsics.areEqual((Object)((RdVirtualSolution)x).getSolutionName(), (Object)((RdVirtualSolution)y).getSolutionName())) return false;
        if (((Collection)((RdVirtualSolution)x).getProjectFilePaths()).size() != ((Collection)((RdVirtualSolution)y).getProjectFilePaths()).size()) return false;
        Iterable $this$all$iv = CollectionsKt.withIndex((Iterable)((RdVirtualSolution)x).getProjectFilePaths());
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            it = (IndexedValue)element$iv;
            boolean bl = false;
        } while (Intrinsics.areEqual(((RdVirtualSolution)y).getProjectFilePaths().get(it.getIndex()), (Object)it.getValue()));
        return false;
    }
}

