/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ideaInterop.vfs;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.jetbrains.rd.platform.util.ApplicationKt;
import com.jetbrains.rider.ideaInterop.vfs.VfsWatchRootFilter;
import com.jetbrains.rider.ideaInterop.vfs.VfsWatchRootHost;
import com.jetbrains.rider.model.RdWatchRootInfo;
import com.jetbrains.rider.util.idea.TimeLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u00172\u00020\u0001:\u0004\u0017\u0018\u0019\u001aB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fJ\u0006\u0010\u0013\u001a\u00020\u0011J\u0006\u0010\u0014\u001a\u00020\u0011J\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootManager;", "", "localFileSystem", "Lcom/intellij/openapi/vfs/LocalFileSystem;", "filter", "Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootFilter;", "<init>", "(Lcom/intellij/openapi/vfs/LocalFileSystem;Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootFilter;)V", "watchRequests", "Ljava/util/HashMap;", "Ljava/io/File;", "Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootManager$WatchRequestInfo;", "Lkotlin/collections/HashMap;", "queue", "Lkotlin/collections/ArrayDeque;", "Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootManager$QueueItem;", "register", "", "queueItem", "cleanup", "update", "dump", "", "Companion", "QueueItem", "QueueFileItem", "WatchRequestInfo", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nVfsWatchRootManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VfsWatchRootManager.kt\ncom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootManager\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,164:1\n136#2,9:165\n216#2:174\n217#2:176\n145#2:177\n1#3:175\n1056#4:178\n13#5:179\n13#6:180\n*S KotlinDebug\n*F\n+ 1 VfsWatchRootManager.kt\ncom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootManager\n*L\n32#1:165,9\n32#1:174\n32#1:176\n32#1:177\n32#1:175\n135#1:178\n16#1:179\n16#1:180\n*E\n"})
public final class VfsWatchRootManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LocalFileSystem localFileSystem;
    @Nullable
    private final VfsWatchRootFilter filter;
    @NotNull
    private final HashMap<File, WatchRequestInfo> watchRequests;
    @NotNull
    private final ArrayDeque<QueueItem> queue;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final StringBuilder eventLog;

    public VfsWatchRootManager(@NotNull LocalFileSystem localFileSystem, @Nullable VfsWatchRootFilter filter2) {
        Intrinsics.checkNotNullParameter((Object)localFileSystem, (String)"localFileSystem");
        this.localFileSystem = localFileSystem;
        this.filter = filter2;
        this.watchRequests = new HashMap();
        this.queue = new ArrayDeque(20);
    }

    public final void register(@NotNull QueueItem queueItem) {
        Intrinsics.checkNotNullParameter((Object)queueItem, (String)"queueItem");
        Application application = ApplicationKt.getApplicationOrNull();
        if (application != null) {
            application.assertIsDispatchThread();
        }
        this.queue.addLast((Object)queueItem);
    }

    /*
     * WARNING - void declaration
     */
    public final void cleanup() {
        void $this$mapNotNullTo$iv$iv;
        Application application = ApplicationKt.getApplicationOrNull();
        if (application != null) {
            application.assertIsDispatchThread();
        }
        Map $this$mapNotNull$iv = this.watchRequests;
        boolean $i$f$mapNotNull = false;
        Map map = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            LocalFileSystem.WatchRequest it$iv$iv;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Map.Entry it = element$iv$iv;
            boolean bl2 = false;
            if (((WatchRequestInfo)it.getValue()).getRequest() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List requests = (List)destination$iv$iv;
        this.localFileSystem.removeWatchedRoots((Collection)requests);
        this.queue.clear();
        this.watchRequests.clear();
    }

    public final void update() {
        String string;
        logger.trace("update(): start");
        Application application = ApplicationKt.getApplicationOrNull();
        if (application != null) {
            application.assertIsDispatchThread();
        }
        if (this.queue.isEmpty()) {
            logger.trace("update(): return because queue.isEmpty");
            return;
        }
        TimeLogger timeLogger = new TimeLogger();
        ArrayList oldWatchRequests = new ArrayList();
        ArrayList recursiveRoots = new ArrayList();
        ArrayList flatRoots = new ArrayList();
        Function2 addWatchRoot = (arg_0, arg_1) -> VfsWatchRootManager.update$lambda$0(this, recursiveRoots, flatRoots, arg_0, arg_1);
        Function1 removeWatchRoot = arg_0 -> VfsWatchRootManager.update$lambda$1(oldWatchRequests, arg_0);
        logger.trace("update(): Prepare watch requests / START");
        timeLogger.section("Prepare watch requests", () -> VfsWatchRootManager.update$lambda$2(this, removeWatchRoot, addWatchRoot));
        logger.trace("update(): Prepare watch requests / FINISH");
        logger.trace("update(): Replace watched roots in VFS / START");
        timeLogger.section("Replace watched roots in VFS", () -> VfsWatchRootManager.update$lambda$3(this, oldWatchRequests, recursiveRoots, flatRoots));
        logger.trace("update(): Replace watched roots in VFS / FINISH");
        String $this$update_u24lambda_u244 = string = timeLogger.complete(recursiveRoots.size() + " recursive and " + flatRoots.size() + " flat roots updated");
        boolean bl = false;
        logger.trace($this$update_u24lambda_u244);
        Application application2 = ApplicationKt.getApplicationOrNull();
        boolean bl2 = application2 != null ? application2.isInternal() : false;
        if (bl2) {
            eventLog.append($this$update_u24lambda_u244).append('\n');
        }
        logger.trace("update(): finish");
    }

    @NotNull
    public final String dump() {
        StringBuilder result2 = new StringBuilder();
        result2.append("External roots: ").append('\n');
        Iterable $this$sortedBy$iv = ((Map)this.watchRequests).entrySet();
        boolean $i$f$sortedBy = false;
        for (Map.Entry entry2 : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (File)it.getKey();
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((File)it.getKey()));
            }
        })) {
            File path = (File)entry2.getKey();
            WatchRequestInfo request = (WatchRequestInfo)entry2.getValue();
            result2.append(path + " Recursive: " + request.isRecursive()).append('\n');
        }
        result2.append('\n');
        result2.append("Log: ").append('\n');
        result2.append((CharSequence)eventLog);
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final Unit update$lambda$0(VfsWatchRootManager this$0, ArrayList $recursiveRoots, ArrayList $flatRoots, File file, boolean isRecursive) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (this$0.filter == null || this$0.filter.shouldWatch(file)) {
            boolean bl = isRecursive ? $recursiveRoots.add(file.getPath()) : $flatRoots.add(file.getPath());
        }
        return Unit.INSTANCE;
    }

    private static final Unit update$lambda$1(ArrayList $oldWatchRequests, LocalFileSystem.WatchRequest request) {
        if (request != null) {
            $oldWatchRequests.add(request);
        }
        return Unit.INSTANCE;
    }

    private static final Unit update$lambda$2(VfsWatchRootManager this$0, Function1 $removeWatchRoot, Function2 $addWatchRoot) {
        while (!this$0.queue.isEmpty()) {
            boolean oldIsRecursive;
            WatchRequestInfo existingRequest;
            QueueItem item = (QueueItem)this$0.queue.removeFirst();
            File requestedFile = item.getRequestedFile();
            if (item.getOld() != null && (existingRequest = this$0.watchRequests.get(item.getOld().getFile())) != null) {
                oldIsRecursive = existingRequest.isRecursive();
                existingRequest.getRequestedFiles().remove(requestedFile);
                if (existingRequest.getRequestedFiles().isEmpty()) {
                    $removeWatchRoot.invoke((Object)existingRequest.getRequest());
                    this$0.watchRequests.remove(item.getOld().getFile());
                } else if (oldIsRecursive != existingRequest.isRecursive()) {
                    $removeWatchRoot.invoke((Object)existingRequest.getRequest());
                    $addWatchRoot.invoke((Object)item.getOld().getFile(), (Object)existingRequest.isRecursive());
                }
            }
            if (item.getNew() == null) continue;
            existingRequest = this$0.watchRequests.get(item.getNew().getFile());
            if (existingRequest != null) {
                oldIsRecursive = existingRequest.isRecursive();
                ((Map)existingRequest.getRequestedFiles()).put(requestedFile, item.getNew().isRecursive());
                if (oldIsRecursive == existingRequest.isRecursive()) continue;
                $removeWatchRoot.invoke((Object)existingRequest.getRequest());
                $addWatchRoot.invoke((Object)item.getNew().getFile(), (Object)existingRequest.isRecursive());
                continue;
            }
            Pair[] pairArray = new Pair[]{new Pair((Object)requestedFile, (Object)item.getNew().isRecursive())};
            WatchRequestInfo newRequest = new WatchRequestInfo(MapsKt.hashMapOf((Pair[])pairArray), null, 2, null);
            ((Map)this$0.watchRequests).put(item.getNew().getFile(), newRequest);
            $addWatchRoot.invoke((Object)item.getNew().getFile(), (Object)newRequest.isRecursive());
        }
        return Unit.INSTANCE;
    }

    private static final Unit update$lambda$3(VfsWatchRootManager this$0, ArrayList $oldWatchRequests, ArrayList $recursiveRoots, ArrayList $flatRoots) {
        Set set = this$0.localFileSystem.replaceWatchedRoots((Collection)$oldWatchRequests, (Collection)$recursiveRoots, (Collection)$flatRoots);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"replaceWatchedRoots(...)");
        Set newWatchRequests = set;
        for (LocalFileSystem.WatchRequest request : CollectionsKt.filterNotNull((Iterable)newWatchRequests)) {
            WatchRequestInfo watchRequestInfo = this$0.watchRequests.get(new File(request.getRootPath()));
            if (watchRequestInfo == null) continue;
            watchRequestInfo.setRequest(request);
        }
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(VfsWatchRootHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        VfsWatchRootManager.logger = logger;
        eventLog = new StringBuilder();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootManager$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "eventLog", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\n\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootManager$QueueFileItem;", "", "file", "Ljava/io/File;", "isRecursive", "", "<init>", "(Ljava/io/File;Z)V", "getFile", "()Ljava/io/File;", "()Z", "Companion", "intellij.rider.rdclient.dotnet"})
    public static final class QueueFileItem {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final File file;
        private final boolean isRecursive;

        private QueueFileItem(File file, boolean isRecursive) {
            this.file = file;
            this.isRecursive = isRecursive;
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        public final boolean isRecursive() {
            return this.isRecursive;
        }

        public /* synthetic */ QueueFileItem(File file, boolean isRecursive, DefaultConstructorMarker $constructor_marker) {
            this(file, isRecursive);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootManager$QueueFileItem$Companion;", "", "<init>", "()V", "create", "Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootManager$QueueFileItem;", "file", "Ljava/io/File;", "info", "Lcom/jetbrains/rider/model/RdWatchRootInfo;", "intellij.rider.rdclient.dotnet"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final QueueFileItem create(@NotNull File file, @NotNull RdWatchRootInfo info) {
                QueueFileItem queueFileItem;
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                if (info.isDirectory()) {
                    queueFileItem = new QueueFileItem(file, info.isRecursive(), null);
                } else if (file.getParentFile() != null) {
                    File file2 = file.getParentFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getParentFile(...)");
                    queueFileItem = new QueueFileItem(file2, false, null);
                } else {
                    queueFileItem = null;
                }
                return queueFileItem;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootManager$QueueItem;", "", "requestedFile", "Ljava/io/File;", "old", "Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootManager$QueueFileItem;", "new", "<init>", "(Ljava/io/File;Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootManager$QueueFileItem;Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootManager$QueueFileItem;)V", "getRequestedFile", "()Ljava/io/File;", "getOld", "()Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootManager$QueueFileItem;", "getNew", "intellij.rider.rdclient.dotnet"})
    public static final class QueueItem {
        @NotNull
        private final File requestedFile;
        @Nullable
        private final QueueFileItem old;
        @Nullable
        private final QueueFileItem new;

        public QueueItem(@NotNull File requestedFile, @Nullable QueueFileItem old, @Nullable QueueFileItem queueFileItem) {
            Intrinsics.checkNotNullParameter((Object)requestedFile, (String)"requestedFile");
            this.requestedFile = requestedFile;
            this.old = old;
            this.new = queueFileItem;
        }

        @NotNull
        public final File getRequestedFile() {
            return this.requestedFile;
        }

        @Nullable
        public final QueueFileItem getOld() {
            return this.old;
        }

        @Nullable
        public final QueueFileItem getNew() {
            return this.new;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B7\u0012\"\u0010\u0002\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005`\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nR-\u0010\u0002\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootManager$WatchRequestInfo;", "", "requestedFiles", "Ljava/util/HashMap;", "Ljava/io/File;", "", "Lkotlin/collections/HashMap;", "request", "Lcom/intellij/openapi/vfs/LocalFileSystem$WatchRequest;", "<init>", "(Ljava/util/HashMap;Lcom/intellij/openapi/vfs/LocalFileSystem$WatchRequest;)V", "getRequestedFiles", "()Ljava/util/HashMap;", "getRequest", "()Lcom/intellij/openapi/vfs/LocalFileSystem$WatchRequest;", "setRequest", "(Lcom/intellij/openapi/vfs/LocalFileSystem$WatchRequest;)V", "isRecursive", "()Z", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nVfsWatchRootManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VfsWatchRootManager.kt\ncom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootManager$WatchRequestInfo\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,164:1\n188#2,3:165\n*S KotlinDebug\n*F\n+ 1 VfsWatchRootManager.kt\ncom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootManager$WatchRequestInfo\n*L\n162#1:165,3\n*E\n"})
    public static final class WatchRequestInfo {
        @NotNull
        private final HashMap<File, Boolean> requestedFiles;
        @Nullable
        private LocalFileSystem.WatchRequest request;
        private final boolean isRecursive;

        /*
         * WARNING - void declaration
         */
        public WatchRequestInfo(@NotNull HashMap<File, Boolean> requestedFiles, @Nullable LocalFileSystem.WatchRequest request) {
            boolean bl;
            boolean bl2;
            block3: {
                void $this$any$iv;
                Intrinsics.checkNotNullParameter(requestedFiles, (String)"requestedFiles");
                this.requestedFiles = requestedFiles;
                this.request = request;
                Map map = this.requestedFiles;
                WatchRequestInfo watchRequestInfo = this;
                boolean $i$f$any = false;
                if ($this$any$iv.isEmpty()) {
                    bl2 = false;
                } else {
                    Iterator iterator2 = $this$any$iv.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry element$iv;
                        Map.Entry it = element$iv = iterator2.next();
                        boolean bl3 = false;
                        if (!((Boolean)it.getValue()).booleanValue()) continue;
                        bl2 = true;
                        break block3;
                    }
                    bl2 = false;
                }
            }
            watchRequestInfo.isRecursive = bl = bl2;
        }

        public /* synthetic */ WatchRequestInfo(HashMap hashMap, LocalFileSystem.WatchRequest watchRequest, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                watchRequest = null;
            }
            this(hashMap, watchRequest);
        }

        @NotNull
        public final HashMap<File, Boolean> getRequestedFiles() {
            return this.requestedFiles;
        }

        @Nullable
        public final LocalFileSystem.WatchRequest getRequest() {
            return this.request;
        }

        public final void setRequest(@Nullable LocalFileSystem.WatchRequest watchRequest) {
            this.request = watchRequest;
        }

        public final boolean isRecursive() {
            return this.isRecursive;
        }
    }
}

