/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ideaInterop.vfs;

import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rider.ideaInterop.vfs.VfsWatchRootEntry;
import com.jetbrains.rider.ideaInterop.vfs.VfsWatchRootType;
import com.jetbrains.rider.ideaInterop.vfs.structure.FilePathTree;
import com.jetbrains.rider.ideaInterop.vfs.structure.FilePathTreeOperationsKt;
import com.jetbrains.rider.ideaInterop.vfs.structure.FilePathTreeVisitor;
import com.jetbrains.rider.ideaInterop.vfs.structure.VisitResult;
import java.io.File;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0018\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u0013J\u0018\u0010\u001c\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u0006J\u0006\u0010\u001f\u001a\u00020\u0006R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchPathTree;", "", "<init>", "()V", "requestedFiles", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "tree", "Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree;", "Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootEntry;", "addRequestedFile", "", "file", "Ljava/io/File;", "removeRequestedFile", "containsRequestedFile", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "findWatchRoot", "getNameById", "id", "", "setWatchRoot", "type", "Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootType;", "getEntry", "getChildEntry", "entry", "childName", "dump", "intellij.rider.rdclient.dotnet"})
public final class VfsWatchPathTree {
    @NotNull
    private final HashSet<String> requestedFiles = new HashSet();
    @NotNull
    private final FilePathTree<VfsWatchRootEntry> tree = new FilePathTree(VfsWatchPathTree::tree$lambda$0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addRequestedFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        HashSet<String> hashSet = this.requestedFiles;
        synchronized (hashSet) {
            boolean bl = false;
            boolean bl2 = this.requestedFiles.add(FileUtilKt.getSystemIndependentPath((File)file));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeRequestedFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        HashSet<String> hashSet = this.requestedFiles;
        synchronized (hashSet) {
            boolean bl = false;
            boolean bl2 = this.requestedFiles.remove(FileUtilKt.getSystemIndependentPath((File)file));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean containsRequestedFile(@NotNull VirtualFile virtualFile) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        HashSet<String> hashSet = this.requestedFiles;
        synchronized (hashSet) {
            boolean bl2 = false;
            bl = this.requestedFiles.contains(virtualFile.getPath());
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final VfsWatchRootEntry findWatchRoot(@NotNull VirtualFile virtualFile) {
        VfsWatchRootEntry vfsWatchRootEntry;
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        FilePathTree<VfsWatchRootEntry> filePathTree = this.tree;
        synchronized (filePathTree) {
            boolean bl = false;
            File file = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"virtualToIoFile(...)");
            File file2 = file;
            Pair<VfsWatchRootEntry, File> pair = FilePathTreeOperationsKt.findRecursiveToRoot(this.tree, file2, VfsWatchPathTree::findWatchRoot$lambda$0$0);
            vfsWatchRootEntry = pair != null ? (VfsWatchRootEntry)pair.getFirst() : null;
        }
        return vfsWatchRootEntry;
    }

    @Nullable
    public final String getNameById(int id) {
        return this.tree.getNameById(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setWatchRoot(@NotNull File file, @NotNull VfsWatchRootType type) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        FilePathTree<VfsWatchRootEntry> filePathTree = this.tree;
        synchronized (filePathTree) {
            boolean bl = false;
            VfsWatchRootEntry entry2 = this.tree.getOrCreate(file);
            entry2.setType(type);
            this.tree.removeIfEmpty((VfsWatchRootEntry)((FilePathTree.Entry)entry2), file);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final VfsWatchRootEntry getEntry(@NotNull VirtualFile file) {
        VfsWatchRootEntry vfsWatchRootEntry;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FilePathTree<VfsWatchRootEntry> filePathTree = this.tree;
        synchronized (filePathTree) {
            boolean bl = false;
            vfsWatchRootEntry = this.tree.get(file);
        }
        return vfsWatchRootEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final VfsWatchRootEntry getChildEntry(@NotNull VfsWatchRootEntry entry2, @NotNull String childName) {
        VfsWatchRootEntry vfsWatchRootEntry;
        Intrinsics.checkNotNullParameter((Object)entry2, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)childName, (String)"childName");
        FilePathTree<VfsWatchRootEntry> filePathTree = this.tree;
        synchronized (filePathTree) {
            boolean bl = false;
            vfsWatchRootEntry = this.tree.getChild((VfsWatchRootEntry)((FilePathTree.Entry)entry2), childName);
        }
        return vfsWatchRootEntry;
    }

    @NotNull
    public final String dump() {
        var visitor2 = new FilePathTreeVisitor<VfsWatchRootEntry>(){
            private final StringBuilder builder;
            {
                this.builder = new StringBuilder();
            }

            public final StringBuilder getBuilder() {
                return this.builder;
            }

            public Pair<VisitResult, Object> visitEntry(File file, VfsWatchRootEntry entry2, Object context) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)entry2, (String)"entry");
                String name = !Intrinsics.areEqual((Object)file.getName(), (Object)"") ? file.getName() : file.getPath();
                Integer n = context instanceof Integer ? (Integer)context : null;
                int tab = n != null ? n : 1;
                Intrinsics.checkNotNull((Object)name);
                this.write(name, entry2, tab);
                return new Pair((Object)((Object)VisitResult.Continue), (Object)(tab + 1));
            }

            private final void write(String name, VfsWatchRootEntry entry2, int tab) {
                int t = 1;
                if (t <= tab) {
                    while (true) {
                        this.builder.append(" ");
                        if (t == tab) break;
                        ++t;
                    }
                }
                this.builder.append(name);
                if (entry2.getType() == VfsWatchRootType.Recursive) {
                    this.builder.append(" [Recursive]");
                }
                if (entry2.getType() == VfsWatchRootType.Flat) {
                    this.builder.append(" [Flat]");
                }
                this.builder.append('\n');
            }
        };
        FilePathTree.visit$default(this.tree, visitor2, null, 2, null);
        String string = visitor2.getBuilder().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final VfsWatchRootEntry tree$lambda$0(int id, int parentId) {
        return new VfsWatchRootEntry(id, parentId);
    }

    private static final boolean findWatchRoot$lambda$0$0(VfsWatchRootEntry entry2, int distance) {
        Intrinsics.checkNotNullParameter((Object)entry2, (String)"entry");
        if (entry2.getType() == VfsWatchRootType.Flat) {
            Object[] objectArray = new Integer[]{0, 1};
            if (ArraysKt.contains((Object[])objectArray, (Object)distance)) {
                return true;
            }
        }
        return entry2.getType() == VfsWatchRootType.Recursive;
    }
}

