/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editors.virtualFormat;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Disposer;
import com.jetbrains.rider.editors.virtualFormat.DisjointIntervalNonUpdatingArraySet;
import com.jetbrains.rider.editors.virtualFormat.FoldingArgs;
import com.jetbrains.rider.editors.virtualFormat.InlayArgs;
import com.jetbrains.rider.editors.virtualFormat.RiderVirtualFormatterListenerAggregatorKt;
import com.jetbrains.rider.editors.virtualFormat.RiderVirtualFormatting;
import com.jetbrains.rider.editors.virtualFormat.RiderVirtualFormattingService;
import com.jetbrains.rider.editors.virtualFormat.RiderVirtualWhitespaceRenderer;
import com.jetbrains.rider.editors.virtualFormat.VirtualFormattingApplicationStrategy;
import com.jetbrains.rider.editors.virtualFormat.VirtualWhitespace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/editors/virtualFormat/RiderVirtualFormattingServiceImpl;", "Lcom/jetbrains/rider/editors/virtualFormat/RiderVirtualFormattingService;", "<init>", "()V", "applyVirtualFormattingToEditor", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "strategy", "Lcom/jetbrains/rider/editors/virtualFormat/VirtualFormattingApplicationStrategy;", "dropAllVirtualFormatting", "Lcom/intellij/openapi/editor/Editor;", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nriderVirtualFormattingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 riderVirtualFormattingService.kt\ncom/jetbrains/rider/editors/virtualFormat/RiderVirtualFormattingServiceImpl\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,234:1\n1321#2:235\n1322#2:237\n1#3:236\n1869#4,2:238\n1869#4,2:240\n1869#4,2:242\n1869#4,2:244\n*S KotlinDebug\n*F\n+ 1 riderVirtualFormattingService.kt\ncom/jetbrains/rider/editors/virtualFormat/RiderVirtualFormattingServiceImpl\n*L\n201#1:235\n201#1:237\n166#1:238,2\n175#1:240,2\n217#1:242,2\n226#1:244,2\n*E\n"})
public class RiderVirtualFormattingServiceImpl
implements RiderVirtualFormattingService {
    @Override
    public void applyVirtualFormattingToEditor(@NotNull EditorImpl editor, @NotNull VirtualFormattingApplicationStrategy strategy2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)strategy2, (String)"strategy");
        if (strategy2.getStamp() != editor.getDocument().getModificationStamp()) {
            return;
        }
        if (editor.getProject() == null) {
            throw new IllegalArgumentException("Cannot calculate virtual formatting for a non-project editor!");
        }
        Pair pair = RiderVirtualFormatting.access$getVirtualFormatterRangeMarkerSet((Editor)editor);
        if (pair == null) {
            pair = new Pair(null, null);
        }
        Pair pair2 = pair;
        Long stamp = (Long)pair2.component1();
        Object cachedSet = null;
        cachedSet = pair2.component2();
        if (stamp == null || cachedSet == null) {
            stamp = editor.getDocument().getModificationStamp();
            cachedSet = new DisjointIntervalNonUpdatingArraySet();
            RiderVirtualFormatting.access$setVirtualFormatterRangeMarkerSet((Editor)editor, new Pair((Object)stamp, cachedSet));
        }
        long l = editor.getDocument().getModificationStamp();
        if (stamp != l) {
            ((DisjointIntervalNonUpdatingArraySet)cachedSet).clear();
            this.dropAllVirtualFormatting((Editor)editor);
        }
        List materializedInlays = new ArrayList();
        List materializedFoldings = new ArrayList();
        editor.getFoldingModel().runBatchFoldingOperation(() -> RiderVirtualFormattingServiceImpl.applyVirtualFormattingToEditor$lambda$0(strategy2, editor, materializedFoldings));
        editor.getInlayModel().execute(true, () -> RiderVirtualFormattingServiceImpl.applyVirtualFormattingToEditor$lambda$1(strategy2, editor, materializedInlays));
        boolean bl2 = bl = materializedInlays.size() == materializedFoldings.size() && materializedFoldings.size() == strategy2.getHighlighters().size();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-RiderVirtualFormattingServiceImpl$applyVirtualFormattingToEditor$42 = false;
            String $i$a$-assert-RiderVirtualFormattingServiceImpl$applyVirtualFormattingToEditor$42 = "Inlays, foldings, and highlighters are zipable";
            throw new AssertionError((Object)$i$a$-assert-RiderVirtualFormattingServiceImpl$applyVirtualFormattingToEditor$42);
        }
        Sequence vwsSeq = SequencesKt.map((Sequence)SequencesKt.zip((Sequence)CollectionsKt.asSequence((Iterable)materializedInlays), (Sequence)CollectionsKt.asSequence((Iterable)materializedFoldings)), RiderVirtualFormattingServiceImpl::applyVirtualFormattingToEditor$lambda$3);
        List<VirtualWhitespace> virtualWhitespaces = RiderVirtualFormatting.getVirtualWhitespaces((Editor)editor);
        if (virtualWhitespaces == null) {
            List list2;
            List it = list2 = SequencesKt.toMutableList((Sequence)vwsSeq);
            boolean bl3 = false;
            ((DisjointIntervalNonUpdatingArraySet)cachedSet).reinitFromSeq((Sequence<Pair<Integer, Integer>>)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)it), RiderVirtualFormattingServiceImpl::applyVirtualFormattingToEditor$lambda$4$0));
            RiderVirtualFormatting.setVirtualWhitespaces((Editor)editor, it);
        } else {
            Sequence $this$forEach$iv = vwsSeq;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VirtualWhitespace vws = (VirtualWhitespace)element$iv;
                boolean bl4 = false;
                if (vws.getObscuringFoldRegion() != null) {
                    FoldRegion fold;
                    boolean bl5 = false;
                    ((DisjointIntervalNonUpdatingArraySet)cachedSet).add(fold.getStartOffset(), fold.getEndOffset());
                }
                virtualWhitespaces.add(vws);
            }
        }
    }

    @Override
    public void dropAllVirtualFormatting(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (editor.getProject() == null) {
            throw new IllegalArgumentException("Cannot calculate virtual formatting for a non-project editor!");
        }
        List<VirtualWhitespace> virtualWhitespaces = RiderVirtualFormatting.getVirtualWhitespaces(editor);
        Collection collection = virtualWhitespaces;
        if (collection == null || collection.isEmpty()) {
            return;
        }
        editor.getInlayModel().execute(true, () -> RiderVirtualFormattingServiceImpl.dropAllVirtualFormatting$lambda$0(virtualWhitespaces));
        FoldingModel foldingModel = editor.getFoldingModel();
        Intrinsics.checkNotNullExpressionValue((Object)foldingModel, (String)"getFoldingModel(...)");
        FoldingModel fm = foldingModel;
        fm.runBatchFoldingOperation(() -> RiderVirtualFormattingServiceImpl.dropAllVirtualFormatting$lambda$1(virtualWhitespaces, fm));
        RiderVirtualFormatting.setVirtualWhitespaces(editor, null);
    }

    private static final void applyVirtualFormattingToEditor$lambda$0(VirtualFormattingApplicationStrategy $strategy, EditorImpl $editor, List $materializedFoldings) {
        Iterable $this$forEach$iv = $strategy.getFoldingCreationArgs();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FoldRegion foldRegion;
            FoldingArgs it = (FoldingArgs)element$iv;
            boolean bl = false;
            if ($editor.getFoldingModel().createFoldRegion(it.getStart(), it.getEnd(), "", null, true) != null) {
                FoldRegion foldRegion2;
                FoldRegion $this$applyVirtualFormattingToEditor_u24lambda_u240_u240_u240 = foldRegion2;
                boolean bl2 = false;
                RiderVirtualFormatterListenerAggregatorKt.setVirtualWhitespaceFolding($this$applyVirtualFormattingToEditor_u24lambda_u240_u240_u240, true);
                foldRegion = foldRegion2;
            } else {
                foldRegion = null;
            }
            FoldRegion foldRegion3 = foldRegion;
            $materializedFoldings.add(foldRegion3);
        }
    }

    private static final void applyVirtualFormattingToEditor$lambda$1(VirtualFormattingApplicationStrategy $strategy, EditorImpl $editor, List $materializedInlays) {
        Iterable $this$forEach$iv = $strategy.getInlayCreationArgs();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InlayArgs it = (InlayArgs)element$iv;
            boolean bl = false;
            Inlay inlay = $editor.getInlayModel().addInlineElement(it.getPosition(), true, 10000, (EditorCustomElementRenderer)it.getRenderer());
            $materializedInlays.add(inlay);
        }
    }

    private static final VirtualWhitespace applyVirtualFormattingToEditor$lambda$3(Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        Inlay inlay = (Inlay)pair.component1();
        FoldRegion folding = (FoldRegion)pair.component2();
        return new VirtualWhitespace(folding, (Inlay<RiderVirtualWhitespaceRenderer>)inlay);
    }

    private static final Pair applyVirtualFormattingToEditor$lambda$4$0(VirtualWhitespace vws) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)vws, (String)"vws");
        FoldRegion foldRegion = vws.getObscuringFoldRegion();
        if (foldRegion != null) {
            FoldRegion fold = foldRegion;
            boolean bl = false;
            pair = new Pair((Object)fold.getStartOffset(), (Object)fold.getEndOffset());
        } else {
            pair = null;
        }
        return pair;
    }

    private static final void dropAllVirtualFormatting$lambda$0(List $virtualWhitespaces) {
        Iterable $this$forEach$iv = $virtualWhitespaces;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Inlay<RiderVirtualWhitespaceRenderer> it;
            VirtualWhitespace vws = (VirtualWhitespace)element$iv;
            boolean bl = false;
            if (vws.getPaddingInlay() == null) continue;
            boolean bl2 = false;
            Disposer.dispose((Disposable)((Disposable)it));
        }
    }

    private static final void dropAllVirtualFormatting$lambda$1(List $virtualWhitespaces, FoldingModel $fm) {
        Iterable $this$forEach$iv = $virtualWhitespaces;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FoldRegion it;
            VirtualWhitespace vws = (VirtualWhitespace)element$iv;
            boolean bl = false;
            if (vws.getObscuringFoldRegion() == null) continue;
            boolean bl2 = false;
            $fm.removeFoldRegion(it);
        }
    }
}

