/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editors.stickyLines;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.stickyLines.StickyLine;
import com.intellij.openapi.editor.impl.stickyLines.StickyLinesModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.Key;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.rd.ide.model.RdMarkupModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.daemon.FrontendMarkupAdapterListener;
import com.jetbrains.rdclient.daemon.IProtocolHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.IProtocolHighlighterModelSupport;
import com.jetbrains.rdclient.daemon.highlighters.MarkupListenerAggregator;
import com.jetbrains.rdclient.daemon.highlighters.MarkupListenerManager;
import com.jetbrains.rider.daemon.util.HighlightersUtilKt;
import com.jetbrains.rider.editors.stickyLines.RiderStickyLineInfo;
import com.jetbrains.rider.editors.stickyLines.RiderStickyLinesModelHandler;
import com.jetbrains.rider.editors.stickyLines.RiderStickyLinesModelSupport;
import com.jetbrains.rider.editors.stickyLines.RiderStickyLinesModelSupportKt;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0012\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J2\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/editors/stickyLines/RiderStickyLinesModelSupport;", "Lcom/jetbrains/rdclient/daemon/IProtocolHighlighterModelSupport;", "<init>", "()V", "createHandler", "Lcom/jetbrains/rdclient/daemon/IProtocolHighlighterModelHandler;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "markupModel", "Lcom/jetbrains/rd/ide/model/RdMarkupModel;", "editor", "Lcom/intellij/openapi/editor/Editor;", "document", "Lcom/intellij/openapi/editor/Document;", "RiderStickyModelListenerAggregator", "RiderStickyModelAdapter", "intellij.rider.rdclient.dotnet"})
public final class RiderStickyLinesModelSupport
implements IProtocolHighlighterModelSupport {
    @Override
    @Nullable
    public IProtocolHighlighterModelHandler createHandler(@NotNull Lifetime lifetime, @Nullable Project project, @NotNull ClientAppSession session2, @NotNull RdMarkupModel markupModel, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)markupModel, (String)"markupModel");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return null;
    }

    @Override
    @NotNull
    public IProtocolHighlighterModelHandler createHandler(@NotNull Lifetime lifetime, @Nullable Project project, @NotNull ClientAppSession session2, @NotNull RdMarkupModel markupModel, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)markupModel, (String)"markupModel");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        MarkupListenerManager.Companion.getInstance().attachAggregator(lifetime, new RiderStickyModelListenerAggregator(project, document));
        return new RiderStickyLinesModelHandler();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007*\u0001\u001d\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\fH\u0016J\u0010\u0010\"\u001a\u00020 2\u0006\u0010!\u001a\u00020\fH\u0016J\u0010\u0010#\u001a\u00020 2\u0006\u0010!\u001a\u00020\fH\u0016J\b\u0010$\u001a\u00020 H\u0002J\u0010\u0010%\u001a\u00020 2\u0006\u0010!\u001a\u00020\fH\u0002J\u0010\u0010&\u001a\u00020 2\u0006\u0010!\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\u00020\u000b*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\rR\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0015\u0010\u0012\u001a\t\u0018\u00010\u0013\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0015\u001a\u0015\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00170\u00170\u0016\u00a2\u0006\u0002\b\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001e\u00a8\u0006'"}, d2={"Lcom/jetbrains/rider/editors/stickyLines/RiderStickyLinesModelSupport$RiderStickyModelAdapter;", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapterListener;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Document;)V", "isStickyLine", "", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "(Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;)Z", "debugText", "", "getDebugText", "(Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;)Ljava/lang/String;", "stickyLinesModel", "Lcom/intellij/openapi/editor/impl/stickyLines/StickyLinesModel;", "Lorg/jetbrains/annotations/Nullable;", "associatedStickyModelKey", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/editor/impl/stickyLines/StickyLine;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "myStickyModelAlarm", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "updateStickyLines", "com/jetbrains/rider/editors/stickyLines/RiderStickyLinesModelSupport$RiderStickyModelAdapter$updateStickyLines$1", "Lcom/jetbrains/rider/editors/stickyLines/RiderStickyLinesModelSupport$RiderStickyModelAdapter$updateStickyLines$1;", "afterAdded", "", "highlighter", "afterUpdated", "afterRemoved", "notifyModelWithDebounce", "onStickyLineAdded", "onStickyLineRemoved", "intellij.rider.rdclient.dotnet"})
    private static final class RiderStickyModelAdapter
    implements FrontendMarkupAdapterListener {
        @NotNull
        private final Project project;
        @NotNull
        private final Document document;
        @Nullable
        private final StickyLinesModel stickyLinesModel;
        @NotNull
        private final Key<StickyLine> associatedStickyModelKey;
        @NotNull
        private final MergingUpdateQueue myStickyModelAlarm;
        @NotNull
        private final updateStickyLines.1 updateStickyLines;

        public RiderStickyModelAdapter(@NotNull Lifetime lifetime, @NotNull Project project, @NotNull Document document) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            this.project = project;
            this.document = document;
            this.stickyLinesModel = StickyLinesModel.getModel((Project)this.project, (Document)this.document);
            Key key = Key.create((String)"rider.editor.sticky.line");
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
            this.associatedStickyModelKey = key;
            this.myStickyModelAlarm = new MergingUpdateQueue("RiderStickyModelAdapterUpdates", 50, true, MergingUpdateQueue.ANY_COMPONENT, LifetimeDisposableExKt.createNestedDisposable((Lifetime)lifetime, (String)"RiderStickyModelAdapterQueue"), null, Alarm.ThreadToUse.SWING_THREAD, null, 128, null);
            this.updateStickyLines = new Update(this){
                final /* synthetic */ RiderStickyModelAdapter this$0;
                {
                    this.this$0 = $receiver;
                    super((Object)"RiderStickyModelUpdates", false, 0, 6, null);
                }

                public void run() {
                    block0: {
                        ThreadingAssertions.assertEventDispatchThread();
                        StickyLinesModel stickyLinesModel = StickyLinesModel.getModel((Project)RiderStickyModelAdapter.access$getProject$p(this.this$0), (Document)RiderStickyModelAdapter.access$getDocument$p(this.this$0));
                        if (stickyLinesModel == null) break block0;
                        stickyLinesModel.notifyLinesUpdate();
                    }
                }
            };
        }

        private final boolean isStickyLine(RangeHighlighterEx $this$isStickyLine) {
            return $this$isStickyLine.getUserData(RiderStickyLinesModelHandler.Companion.getBACKEND_STICKY_SCROLL_KEY()) != null;
        }

        private final String getDebugText(RangeHighlighterEx $this$debugText) {
            RiderStickyLineInfo riderStickyLineInfo = (RiderStickyLineInfo)$this$debugText.getUserData(RiderStickyLinesModelHandler.Companion.getBACKEND_STICKY_SCROLL_KEY());
            return riderStickyLineInfo != null ? riderStickyLineInfo.getDebugText() : null;
        }

        @Override
        public void afterAdded(@NotNull RangeHighlighterEx highlighter) {
            Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
            if (!this.isStickyLine(highlighter)) {
                return;
            }
            this.onStickyLineAdded(highlighter);
            this.notifyModelWithDebounce();
        }

        @Override
        public void afterUpdated(@NotNull RangeHighlighterEx highlighter) {
            Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
            if (!this.isStickyLine(highlighter)) {
                return;
            }
            this.notifyModelWithDebounce();
        }

        public void afterRemoved(@NotNull RangeHighlighterEx highlighter) {
            Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
            if (!this.isStickyLine(highlighter)) {
                return;
            }
            this.onStickyLineRemoved(highlighter);
            this.notifyModelWithDebounce();
        }

        private final void notifyModelWithDebounce() {
            this.myStickyModelAlarm.queue((Update)this.updateStickyLines);
        }

        private final void onStickyLineAdded(RangeHighlighterEx highlighter) {
            boolean bl = this.isStickyLine(highlighter);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            if (this.stickyLinesModel == null) {
                RiderStickyLinesModelSupportKt.access$getLogger$p().error("No sticky lines model for " + this.document);
                return;
            }
            if (highlighter.getUserData(this.associatedStickyModelKey) != null) {
                RiderStickyLinesModelSupportKt.access$getLogger$p().error("Trying to add another sticky line for " + highlighter);
                return;
            }
            StickyLine stickyLine = this.stickyLinesModel.addStickyLine(StickyLinesModel.SourceID.RIDER, highlighter.getStartOffset(), highlighter.getEndOffset(), this.getDebugText(highlighter));
            Intrinsics.checkNotNullExpressionValue((Object)stickyLine, (String)"addStickyLine(...)");
            StickyLine addedStickyLine = stickyLine;
            highlighter.putUserData(this.associatedStickyModelKey, (Object)addedStickyLine);
        }

        private final void onStickyLineRemoved(RangeHighlighterEx highlighter) {
            boolean bl = this.isStickyLine(highlighter);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            if (this.stickyLinesModel == null) {
                RiderStickyLinesModelSupportKt.access$getLogger$p().error("No sticky lines model for " + this.document);
                return;
            }
            StickyLine stickyLineToRemove = (StickyLine)highlighter.getUserData(this.associatedStickyModelKey);
            if (stickyLineToRemove == null) {
                RiderStickyLinesModelSupportKt.access$getLogger$p().warn("No associated sticky model for " + this.document + ", highlighter: " + highlighter);
                return;
            }
            this.stickyLinesModel.removeStickyLine(stickyLineToRemove);
        }

        public static final /* synthetic */ Project access$getProject$p(RiderStickyModelAdapter $this) {
            return $this.project;
        }

        public static final /* synthetic */ Document access$getDocument$p(RiderStickyModelAdapter $this) {
            return $this.document;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/editors/stickyLines/RiderStickyLinesModelSupport$RiderStickyModelListenerAggregator;", "Lcom/jetbrains/rdclient/daemon/highlighters/MarkupListenerAggregator;", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Document;)V", "createListener", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapterListener;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "canHandleEditor", "", "intellij.rider.rdclient.dotnet"})
    private static final class RiderStickyModelListenerAggregator
    extends MarkupListenerAggregator {
        public RiderStickyModelListenerAggregator(@Nullable Project project, @NotNull Document document) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            super(project, document);
        }

        @Override
        @NotNull
        protected FrontendMarkupAdapterListener createListener(@NotNull Lifetime lifetime, @NotNull EditorImpl editor) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Project project = editor.getProject();
            Intrinsics.checkNotNull((Object)project);
            DocumentEx documentEx = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
            return new RiderStickyModelAdapter(lifetime, project, (Document)documentEx);
        }

        @Override
        public boolean canHandleEditor(@NotNull EditorImpl editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return HighlightersUtilKt.canHandleComplexMarkup(editor);
        }
    }
}

